/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.dimension;

import galaxyspace.core.world.GSBiomeGenBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;

public abstract class ChunkProviderSpaceLakes
extends ChunkProviderGenerate {
    private Gradient noiseGen8;
    private List<MapGenBaseMeta> worldGenerators;

    public ChunkProviderSpaceLakes(World world, long seed, boolean flag) {
        super(world, seed, flag);
        this.field_73231_z = this.getBiomesForGeneration();
        this.noiseGen8 = new Gradient(this.field_73220_k.nextLong(), 2, 0.25f);
    }

    public Chunk func_73154_d(int x, int z) {
        this.field_73220_k.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        Block[] blockStorage = new Block[65536];
        byte[] metaStorage = new byte[65536];
        this.generateTerrain(x, z, blockStorage, metaStorage);
        this.field_73231_z = this.field_73230_p.func_72959_q().func_76933_b(this.field_73231_z, x * 16, z * 16, 16, 16);
        this.func_147422_a(x, z, blockStorage, metaStorage, this.field_73231_z);
        this.onChunkProvider(x, z, blockStorage, metaStorage);
        Chunk chunk = new Chunk(this.field_73230_p, blockStorage, metaStorage, x, z);
        byte[] chunkBiomes = chunk.func_76605_m();
        if (this.worldGenerators == null) {
            this.worldGenerators = this.getWorldGenerators();
        }
        for (MapGenBaseMeta generator : this.worldGenerators) {
            generator.generate((IChunkProvider)this, this.field_73230_p, x, z, blockStorage, metaStorage);
        }
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)this.field_73231_z[i].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] blockStorage, byte[] metaStorage) {
        int seaLevel = this.getWaterLevel();
        this.field_73231_z = this.field_73230_p.func_72959_q().func_76933_b(this.field_73231_z, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.makeLandPerBiome2(chunkX * 4, 0, chunkZ * 4);
        for (int k = 0; k < 4; ++k) {
            int l = k * 5;
            int i1 = (k + 1) * 5;
            for (int j1 = 0; j1 < 4; ++j1) {
                int k2 = (l + j1) * 33;
                int l2 = (l + j1 + 1) * 33;
                int i2 = (i1 + j1) * 33;
                int j2 = (i1 + j1 + 1) * 33;
                for (int k3 = 0; k3 < 32; ++k3) {
                    double d0 = 0.125;
                    double d2 = this.field_147434_q[k2 + k3];
                    double d3 = this.field_147434_q[l2 + k3];
                    double d4 = this.field_147434_q[i2 + k3];
                    double d5 = this.field_147434_q[j2 + k3];
                    double d6 = (this.field_147434_q[k2 + k3 + 1] - d2) * d0;
                    double d7 = (this.field_147434_q[l2 + k3 + 1] - d3) * d0;
                    double d8 = (this.field_147434_q[i2 + k3 + 1] - d4) * d0;
                    double d9 = (this.field_147434_q[j2 + k3 + 1] - d5) * d0;
                    for (int l3 = 0; l3 < 8; ++l3) {
                        double d10 = 0.25;
                        double d11 = d2;
                        double d12 = d3;
                        double d13 = (d4 - d2) * d10;
                        double d14 = (d5 - d3) * d10;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            int j3 = i3 + k * 4 << 12 | 0 + j1 * 4 << 8 | k3 * 8 + l3;
                            int short1 = 256;
                            j3 -= short1;
                            double d15 = 0.25;
                            double d16 = (d12 - d11) * d15;
                            double d17 = d11 - d16;
                            for (int k4 = 0; k4 < 4; ++k4) {
                                blockStorage[j3 += short1] = (d17 += d16) > 0.0 ? this.getStoneBlock().getBlock() : (k3 * 8 + l3 < seaLevel && this.canGenerateWaterBlock() ? this.getWaterBlock().getBlock() : null);
                            }
                            d11 += d13;
                            d12 += d14;
                        }
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                        d5 += d9;
                    }
                }
            }
        }
    }

    private void makeLandPerBiome2(int x, int y, int z) {
        this.field_147426_g = this.field_73212_b.func_76305_a(this.field_147426_g, x, z, 5, 5, 200.0, 200.0, 0.5);
        this.field_147427_d = this.field_147429_l.func_76304_a(this.field_147427_d, x, y, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.field_147428_e = this.field_147431_j.func_76304_a(this.field_147428_e, x, y, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.field_147425_f = this.field_147432_k.func_76304_a(this.field_147425_f, x, y, z, 5, 33, 5, 684.412, 684.412, 684.412);
        int terrainIndex = 0;
        int noiseIndex = 0;
        for (int ax = 0; ax < 5; ++ax) {
            for (int az = 0; az < 5; ++az) {
                float totalVariation = 0.0f;
                float totalHeight = 0.0f;
                float totalFactor = 0.0f;
                int two = 2;
                BiomeGenBase biomegenbase = this.field_73231_z[ax + 2 + (az + 2) * 10];
                for (int ox = -two; ox <= two; ++ox) {
                    for (int oz = -two; oz <= two; ++oz) {
                        BiomeGenBase biomegenbase2 = this.field_73231_z[ax + ox + 2 + (az + oz + 2) * 10];
                        float rootHeight = biomegenbase2.field_76748_D;
                        float heightVariation = biomegenbase2.field_76749_E;
                        float heightFactor = this.field_147433_r[ox + 2 + (oz + 2) * 5] / (rootHeight + 2.0f);
                        if (biomegenbase2.field_76748_D > biomegenbase.field_76748_D) {
                            heightFactor /= 2.0f;
                        }
                        totalVariation += heightVariation * heightFactor;
                        totalHeight += rootHeight * heightFactor;
                        totalFactor += heightFactor;
                    }
                }
                totalVariation /= totalFactor;
                totalHeight /= totalFactor;
                totalVariation = totalVariation * 0.9f + 0.1f;
                totalHeight = (totalHeight * 4.0f - 1.0f) / 8.0f;
                double terrainNoise = this.field_147426_g[noiseIndex] / 8000.0;
                if (terrainNoise < 0.0) {
                    terrainNoise = -terrainNoise * 0.3;
                }
                if ((terrainNoise = terrainNoise * 3.0 - 2.0) < 0.0) {
                    if ((terrainNoise /= 2.0) < -1.0) {
                        terrainNoise = -1.0;
                    }
                    terrainNoise /= 1.4;
                    terrainNoise /= 2.0;
                } else {
                    if (terrainNoise > 1.0) {
                        terrainNoise = 1.0;
                    }
                    terrainNoise /= 8.0;
                }
                ++noiseIndex;
                double heightCalc = totalHeight;
                double variationCalc = (double)totalVariation * this.getHeightModifier() / 10.0;
                heightCalc += terrainNoise * 0.2;
                heightCalc = heightCalc * 8.5 / 8.0;
                double d5 = 8.5 + heightCalc * 4.0;
                for (int ay = 0; ay < 33; ++ay) {
                    double d6 = ((double)ay - d5) * 12.0 * 128.0 / 256.0 / variationCalc;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.field_147428_e[terrainIndex] / 512.0;
                    double d8 = this.field_147425_f[terrainIndex] / 512.0;
                    double d9 = (this.field_147427_d[terrainIndex] / 10.0 + 1.0) / 2.0;
                    double terrainCalc = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (ay > 29) {
                        double d10 = (float)(ay - 29) / 3.0f;
                        terrainCalc = terrainCalc * (1.0 - d10) + -10.0 * d10;
                    }
                    this.field_147434_q[terrainIndex] = terrainCalc;
                    ++terrainIndex;
                }
            }
        }
    }

    public void func_147422_a(int chunkX, int chunkZ, Block[] blocks, byte[] meta, BiomeGenBase[] biomes) {
        this.noiseGen8.setFrequency(0.0625f);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                GSBiomeGenBase biomegenbase = (GSBiomeGenBase)biomes[x + z * 16];
                int noise = (int)((double)this.noiseGen8.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) / 3.0 + 3.0 + this.field_73220_k.nextDouble() * 0.25);
                int var10 = -1;
                Block topBlock = this.enableBiomeGenBaseBlock() ? biomegenbase.field_76752_A : this.getGrassBlock().getBlock();
                byte topMeta = this.enableBiomeGenBaseBlock() ? biomegenbase.topMeta : this.getGrassBlock().getMetadata();
                Block fillerBlock = this.enableBiomeGenBaseBlock() ? biomegenbase.field_76753_B : this.getDirtBlock().getBlock();
                byte fillerMeta = this.enableBiomeGenBaseBlock() ? biomegenbase.fillerMeta : this.getDirtBlock().getMetadata();
                for (int y = 255; y >= 0; --y) {
                    int index = this.getIndex(x, y, z);
                    if (y <= 0 + this.field_73220_k.nextInt(5)) {
                        blocks[index] = Blocks.field_150357_h;
                    }
                    if (y == 5 || y == 6 + this.field_73220_k.nextInt(3)) {
                        blocks[index] = this.canGenerateIceBlock() ? Blocks.field_150403_cj : Blocks.field_150357_h;
                        continue;
                    }
                    Block block = blocks[index];
                    if (Blocks.field_150350_a == block) {
                        var10 = -1;
                        continue;
                    }
                    if (block == this.getStoneBlock().getBlock() && !this.enableBiomeGenBaseBlock()) {
                        meta[index] = this.getStoneBlock().getMetadata();
                        if (var10 == -1) {
                            if (noise <= 0) {
                                topBlock = Blocks.field_150350_a;
                                topMeta = 0;
                                fillerBlock = this.getStoneBlock().getBlock();
                                fillerMeta = this.getStoneBlock().getMetadata();
                            } else if (y >= 36 && y <= 21) {
                                if (this.enableBiomeGenBaseBlock()) {
                                    topBlock = biomegenbase.field_76752_A;
                                    topMeta = biomegenbase.topMeta;
                                    topBlock = biomegenbase.field_76753_B;
                                    topMeta = biomegenbase.fillerMeta;
                                } else {
                                    topBlock = this.getGrassBlock().getBlock();
                                    topMeta = this.getGrassBlock().getMetadata();
                                    topBlock = this.getDirtBlock().getBlock();
                                    topMeta = this.getDirtBlock().getMetadata();
                                }
                            }
                            var10 = noise;
                            if (y >= 19) {
                                blocks[index] = topBlock;
                                meta[index] = topMeta;
                                continue;
                            }
                            blocks[index] = fillerBlock;
                            meta[index] = fillerMeta;
                            continue;
                        }
                        if (var10 <= 0) continue;
                        --var10;
                        blocks[index] = fillerBlock;
                        meta[index] = fillerMeta;
                        continue;
                    }
                    if (block != biomegenbase.stoneBlock) continue;
                    meta[index] = biomegenbase.stoneMeta;
                    if (var10 == -1) {
                        if (noise <= 0) {
                            topBlock = Blocks.field_150350_a;
                            topMeta = 0;
                            if (this.enableBiomeGenBaseBlock()) {
                                fillerBlock = biomegenbase.stoneBlock;
                                fillerMeta = biomegenbase.stoneMeta;
                            } else {
                                fillerBlock = this.getStoneBlock().getBlock();
                                fillerMeta = this.getStoneBlock().getMetadata();
                            }
                        } else if (y >= 36 && y <= 21) {
                            if (this.enableBiomeGenBaseBlock()) {
                                topBlock = biomegenbase.field_76752_A;
                                topMeta = biomegenbase.topMeta;
                                topBlock = biomegenbase.field_76753_B;
                                topMeta = biomegenbase.fillerMeta;
                            } else {
                                topBlock = this.getGrassBlock().getBlock();
                                topMeta = this.getGrassBlock().getMetadata();
                                topBlock = this.getDirtBlock().getBlock();
                                topMeta = this.getDirtBlock().getMetadata();
                            }
                        }
                        var10 = noise;
                        if (y >= 19) {
                            blocks[index] = topBlock;
                            meta[index] = topMeta;
                            continue;
                        }
                        blocks[index] = fillerBlock;
                        meta[index] = fillerMeta;
                        continue;
                    }
                    if (var10 <= 0) continue;
                    --var10;
                    blocks[index] = fillerBlock;
                    meta[index] = fillerMeta;
                }
            }
        }
    }

    private int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }

    public void func_73153_a(IChunkProvider chunk, int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BiomeGenBase biomeGen = this.field_73230_p.func_72807_a(x + 16, z + 16);
        this.field_73230_p.func_72807_a(x + 16, z + 16);
        this.field_73220_k.setSeed(this.field_73230_p.func_72905_C());
        long seedX = this.field_73220_k.nextLong() + 1L;
        long seedZ = this.field_73220_k.nextLong() + 1L;
        this.field_73220_k.setSeed((long)chunkX * seedX + (long)chunkZ * seedZ ^ this.field_73230_p.func_72905_C());
        biomeGen.func_76728_a(this.field_73230_p, this.field_73220_k, x, z);
        this.decoratePlanet(this.field_73230_p, this.field_73220_k, x, z);
        SpawnerAnimals.func_77191_a((World)this.field_73230_p, (BiomeGenBase)biomeGen, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.field_73220_k);
        this.onPopulate(chunk, chunkX, chunkZ);
        BlockFalling.field_149832_M = false;
    }

    public void decoratePlanet(World world, Random rand_, int x, int z) {
        this.getBiomeGenerator().decorate(world, rand_, x, z);
    }

    public abstract String func_73148_d();

    public List<BiomeGenBase.SpawnListEntry> func_73155_a(EnumCreatureType creatureType, int x, int y, int z) {
        if (creatureType == EnumCreatureType.monster) {
            ArrayList<BiomeGenBase.SpawnListEntry> monsters = new ArrayList<BiomeGenBase.SpawnListEntry>();
            Collections.addAll(monsters, this.getMonsters());
            return monsters;
        }
        if (creatureType == EnumCreatureType.creature) {
            ArrayList<BiomeGenBase.SpawnListEntry> creatures = new ArrayList<BiomeGenBase.SpawnListEntry>();
            Collections.addAll(creatures, this.getCreatures());
            return creatures;
        }
        if (creatureType == EnumCreatureType.waterCreature) {
            ArrayList<BiomeGenBase.SpawnListEntry> watercreatures = new ArrayList<BiomeGenBase.SpawnListEntry>();
            Collections.addAll(watercreatures, this.getWaterCreatures());
            return watercreatures;
        }
        return null;
    }

    public void func_82695_e(int x, int z) {
    }

    public ChunkPosition func_147416_a(World world, String string, int x, int y, int z) {
        return null;
    }

    protected abstract BiomeDecoratorSpace getBiomeGenerator();

    protected abstract BiomeGenBase[] getBiomesForGeneration();

    public abstract void onChunkProvider(int var1, int var2, Block[] var3, byte[] var4);

    public abstract void onPopulate(IChunkProvider var1, int var2, int var3);

    protected abstract BiomeGenBase.SpawnListEntry[] getMonsters();

    protected abstract BiomeGenBase.SpawnListEntry[] getCreatures();

    protected abstract BiomeGenBase.SpawnListEntry[] getWaterCreatures();

    protected abstract List<MapGenBaseMeta> getWorldGenerators();

    public abstract double getHeightModifier();

    public abstract int getWaterLevel();

    public abstract boolean canGenerateWaterBlock();

    public abstract boolean canGenerateIceBlock();

    protected abstract BlockMetaPair getWaterBlock();

    protected abstract BlockMetaPair getGrassBlock();

    protected abstract BlockMetaPair getDirtBlock();

    protected abstract BlockMetaPair getStoneBlock();

    protected abstract boolean enableBiomeGenBaseBlock();
}

