/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCircuitFabricator;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCoalGenerator;
import micdoodle8.mods.galacticraft.core.tile.TileEntityElectricIngotCompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenStorageModule;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMachine2
extends BlockTileGC
implements ItemBlockDesc.IBlockShiftDesc {
    public static final int ELECTRIC_COMPRESSOR_METADATA = 0;
    public static final int CIRCUIT_FABRICATOR_METADATA = 4;
    public static final int OXYGEN_STORAGE_MODULE_METADATA = 8;
    private IIcon iconMachineSide;
    private IIcon iconInput;
    private IIcon iconOxygenInput;
    private IIcon iconOxygenOutput;
    private IIcon iconElectricCompressor;
    private IIcon iconCircuitFabricator;
    private IIcon[] iconOxygenStorageModule;

    public BlockMachine2(String assetName) {
        super(GCBlocks.machine);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149658_d(GalacticraftCore.TEXTURE_PREFIX + assetName);
        this.func_149663_c(assetName);
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine");
        this.iconInput = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_input");
        this.iconOxygenInput = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_oxygen_input");
        this.iconOxygenOutput = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_oxygen_output");
        this.iconMachineSide = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_side");
        this.iconElectricCompressor = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "electric_compressor");
        this.iconCircuitFabricator = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "circuit_fabricator");
        this.iconOxygenStorageModule = new IIcon[17];
        for (int i = 0; i < this.iconOxygenStorageModule.length; ++i) {
            this.iconOxygenStorageModule[i] = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "oxygenStorageModule_" + i);
        }
    }

    public int func_149645_b() {
        return GalacticraftCore.proxy.getBlockRender((Block)this);
    }

    public void func_149734_b(World par1World, int x, int y, int z, Random par5Random) {
        TileEntity tile = par1World.func_147438_o(x, y, z);
        if (tile instanceof TileEntityCoalGenerator) {
            TileEntityCoalGenerator tileEntity = (TileEntityCoalGenerator)tile;
            if (tileEntity.heatGJperTick > 0.0f) {
                int metadata = par1World.func_72805_g(x, y, z);
                float var7 = (float)x + 0.5f;
                float var8 = (float)y + 0.0f + par5Random.nextFloat() * 6.0f / 16.0f;
                float var9 = (float)z + 0.5f;
                float var10 = 0.52f;
                float var11 = par5Random.nextFloat() * 0.6f - 0.3f;
                if (metadata == 3) {
                    par1World.func_72869_a("smoke", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                } else if (metadata == 2) {
                    par1World.func_72869_a("smoke", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                } else if (metadata == 1) {
                    par1World.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
                } else if (metadata == 0) {
                    par1World.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= 8) {
            metadata -= 8;
            if (side == 0 || side == 1) {
                return this.field_149761_L;
            }
            if (side == metadata + 2) {
                return this.iconOxygenInput;
            }
            if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
                return this.iconOxygenOutput;
            }
            int oxygenLevel = 0;
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileEntityOxygenStorageModule) {
                oxygenLevel = Math.min(((TileEntityOxygenStorageModule)tile).scaledOxygenLevel, 16);
            }
            return this.iconOxygenStorageModule[oxygenLevel];
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.field_149761_L;
        }
        if (metadata >= 8) {
            metadata -= 8;
            if (side == 0 || side == 1) {
                return this.field_149761_L;
            }
            if (side == metadata + 2) {
                return this.iconOxygenInput;
            }
            if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
                return this.iconOxygenOutput;
            }
            return this.iconOxygenStorageModule[16];
        }
        if (metadata >= 4) {
            if ((metadata -= 4) == 0 && side == 4 || metadata == 1 && side == 5 || metadata == 2 && side == 3 || metadata == 3 && side == 2) {
                return this.iconCircuitFabricator;
            }
            if (side == ForgeDirection.getOrientation((int)(metadata + 2)).ordinal()) {
                return this.iconInput;
            }
        } else if (metadata >= 0) {
            if ((metadata += 0) == 0 && side == 4 || metadata == 1 && side == 5 || metadata == 2 && side == 3 || metadata == 3 && side == 2) {
                return this.iconElectricCompressor;
            }
            if (side == ForgeDirection.getOrientation((int)(metadata + 2)).ordinal()) {
                return this.iconInput;
            }
        }
        return this.iconMachineSide;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata = world.func_72805_g(x, y, z);
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        if (metadata >= 8) {
            world.func_72921_c(x, y, z, 8 + change, 3);
        } else if (metadata >= 4) {
            world.func_72921_c(x, y, z, 4 + change, 3);
        } else if (metadata >= 0) {
            world.func_72921_c(x, y, z, 0 + change, 3);
        }
    }

    @Override
    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata;
        int original = metadata = par1World.func_72805_g(x, y, z);
        int change = 0;
        if (metadata >= 8) {
            original -= 8;
        } else if (metadata >= 4) {
            original -= 4;
        } else if (metadata >= 0) {
            original += 0;
            TileEntity te = par1World.func_147438_o(x, y, z);
            if (te instanceof TileBaseUniversalElectrical) {
                ((TileBaseUniversalElectrical)te).updateFacing();
            }
        }
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        if (metadata >= 8) {
            change += 8;
        } else if (metadata >= 4) {
            change += 4;
        } else if (metadata >= 0) {
            change += 0;
        }
        par1World.func_72921_c(x, y, z, change, 3);
        return true;
    }

    @Override
    public boolean onMachineActivated(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        if (!par1World.field_72995_K) {
            par5EntityPlayer.openGui((Object)GalacticraftCore.instance, -1, par1World, x, y, z);
            return true;
        }
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= 8) {
            return new TileEntityOxygenStorageModule();
        }
        if (metadata >= 4) {
            return new TileEntityCircuitFabricator();
        }
        if (metadata >= 0) {
            return new TileEntityElectricIngotCompressor();
        }
        return null;
    }

    public ItemStack getElectricCompressor() {
        return new ItemStack((Block)this, 1, 0);
    }

    public ItemStack getCircuitFabricator() {
        return new ItemStack((Block)this, 1, 4);
    }

    public ItemStack getOxygenStorageModule() {
        return new ItemStack((Block)this, 1, 8);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(this.getElectricCompressor());
        par3List.add(this.getCircuitFabricator());
        par3List.add(this.getOxygenStorageModule());
    }

    public int func_149692_a(int metadata) {
        if (metadata >= 8) {
            return 8;
        }
        if (metadata >= 4) {
            return 4;
        }
        if (metadata >= 0) {
            return 0;
        }
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int metadata = this.func_149643_k(world, x, y, z);
        return new ItemStack((Block)this, 1, metadata);
    }

    @Override
    public String getShiftDescription(int meta) {
        switch (meta) {
            case 4: {
                return GCCoreUtil.translate("tile.circuitFabricator.description");
            }
            case 0: {
                return GCCoreUtil.translate("tile.compressorElectric.description");
            }
            case 8: {
                return GCCoreUtil.translate("tile.oxygenStorageModule.description");
            }
        }
        return "";
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }
}

