/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IHydrogenNetwork;
import micdoodle8.mods.galacticraft.api.transmission.grid.PathfinderChecker;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkConnection;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.transmission.tile.ITransmitter;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityMethaneSynthesizer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class HydrogenNetwork
implements IHydrogenNetwork {
    public Map<TileEntity, ForgeDirection> hydrogenTiles = new HashMap<TileEntity, ForgeDirection>();
    private final Set<ITransmitter> pipes = new HashSet<ITransmitter>();

    @Override
    public float produce(float totalHydrogen, TileEntity ... ignoreTiles) {
        float totalHydrogenRequest;
        float remainingUsableHydrogen = totalHydrogen;
        if (this.hydrogenTiles.isEmpty()) {
            this.refreshHydrogenTiles();
        }
        if (!this.hydrogenTiles.isEmpty() && (totalHydrogenRequest = this.getRequest(ignoreTiles)) > 0.0f) {
            List<TileEntity> ignoreTilesList = Arrays.asList(ignoreTiles);
            for (TileEntity tileEntity : new HashSet<TileEntity>(this.hydrogenTiles.keySet())) {
                TileEntityMethaneSynthesizer hydrogenTile;
                if (ignoreTilesList.contains(tileEntity) || !(tileEntity instanceof TileEntityMethaneSynthesizer) || !(hydrogenTile = (TileEntityMethaneSynthesizer)tileEntity).shouldPullHydrogen()) continue;
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    float hydrogenToSend;
                    ITransmitter transmitter;
                    TileEntity tile = new BlockVec3(tileEntity).modifyPositionFromSide(direction, 1).getTileEntity((IBlockAccess)tileEntity.func_145831_w());
                    if (!hydrogenTile.canConnect(direction, NetworkType.HYDROGEN) || !(tile instanceof ITransmitter) || !this.pipes.contains(transmitter = (ITransmitter)tile) || !((hydrogenToSend = Math.max(totalHydrogen, totalHydrogen * (hydrogenTile.getHydrogenRequest(direction).floatValue() / totalHydrogenRequest))) > 0.0f)) continue;
                    remainingUsableHydrogen -= hydrogenTile.receiveHydrogen(direction, hydrogenToSend, true);
                }
            }
        }
        return remainingUsableHydrogen;
    }

    @Override
    public float getRequest(TileEntity ... ignoreTiles) {
        ArrayList<Float> requests = new ArrayList<Float>();
        if (this.hydrogenTiles.isEmpty()) {
            this.refreshHydrogenTiles();
        }
        List<TileEntity> ignoreTilesList = Arrays.asList(ignoreTiles);
        for (TileEntity tileEntity : new HashSet<TileEntity>(this.hydrogenTiles.keySet())) {
            if (ignoreTilesList.contains(tileEntity) || !(tileEntity instanceof TileEntityMethaneSynthesizer) || !((TileEntityMethaneSynthesizer)tileEntity).shouldPullHydrogen() || tileEntity.func_145837_r() || tileEntity.func_145831_w().func_147438_o(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e) != tileEntity) continue;
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                ITransmitter transmitter;
                BlockVec3 tileVec = new BlockVec3(tileEntity);
                TileEntity tile = tileVec.modifyPositionFromSide(direction, 1).getTileEntity((IBlockAccess)tileEntity.func_145831_w());
                if (!((TileEntityMethaneSynthesizer)tileEntity).canConnect(direction, NetworkType.HYDROGEN) || !(tile instanceof ITransmitter) || !this.pipes.contains(transmitter = (ITransmitter)tile)) continue;
                requests.add(((TileEntityMethaneSynthesizer)tileEntity).getHydrogenRequest(direction));
            }
        }
        float total = 0.0f;
        for (Float f : requests) {
            total += f.floatValue();
        }
        return total;
    }

    @Override
    public void refresh() {
        this.hydrogenTiles.clear();
        try {
            Iterator<ITransmitter> it = this.pipes.iterator();
            while (it.hasNext()) {
                ITransmitter transmitter = it.next();
                if (transmitter == null) {
                    it.remove();
                    continue;
                }
                transmitter.onNetworkChanged();
                if (((TileEntity)transmitter).func_145837_r() || ((TileEntity)transmitter).func_145831_w() == null) {
                    it.remove();
                    continue;
                }
                transmitter.setNetwork(this);
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to refresh hydrogen pipe network.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public void refreshHydrogenTiles() {
        try {
            Iterator<ITransmitter> it = this.pipes.iterator();
            while (it.hasNext()) {
                ITransmitter transmitter = it.next();
                if (transmitter == null || ((TileEntity)transmitter).func_145837_r() || ((TileEntity)transmitter).func_145831_w() == null) {
                    it.remove();
                    continue;
                }
                for (int i = 0; i < transmitter.getAdjacentConnections().length; ++i) {
                    TileEntity acceptor = transmitter.getAdjacentConnections()[i];
                    if (acceptor instanceof ITransmitter || !(acceptor instanceof IConnector)) continue;
                    this.hydrogenTiles.put(acceptor, ForgeDirection.getOrientation((int)i));
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to refresh hydrogen pipe network.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public Set<ITransmitter> getTransmitters() {
        return this.pipes;
    }

    @Override
    public IHydrogenNetwork merge(IHydrogenNetwork network) {
        if (network != null && network != this) {
            HydrogenNetwork newNetwork = new HydrogenNetwork();
            newNetwork.pipes.addAll(this.pipes);
            newNetwork.pipes.addAll(network.getTransmitters());
            newNetwork.refresh();
            return newNetwork;
        }
        return this;
    }

    @Override
    public void split(ITransmitter splitPoint) {
        if (splitPoint instanceof TileEntity) {
            TileEntity[] connectedBlocks;
            this.pipes.remove(splitPoint);
            for (TileEntity connectedBlockA : connectedBlocks = splitPoint.getAdjacentConnections()) {
                if (!(connectedBlockA instanceof INetworkConnection)) continue;
                for (TileEntity connectedBlockB : connectedBlocks) {
                    if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof INetworkConnection)) continue;
                    PathfinderChecker finder = new PathfinderChecker(((TileEntity)splitPoint).func_145831_w(), (INetworkConnection)connectedBlockB, NetworkType.HYDROGEN, splitPoint);
                    finder.init(new BlockVec3(connectedBlockA));
                    if (finder.results.size() > 0) {
                        for (BlockVec3 node : finder.closedSet) {
                            TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).func_145831_w());
                            if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                            ((INetworkProvider)nodeTile).setNetwork(this);
                        }
                        continue;
                    }
                    HydrogenNetwork newNetwork = new HydrogenNetwork();
                    for (BlockVec3 node : finder.closedSet) {
                        TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).func_145831_w());
                        if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                        newNetwork.getTransmitters().add((ITransmitter)nodeTile);
                    }
                    newNetwork.refresh();
                }
            }
        }
    }

    public String toString() {
        return "HydrogenNetwork[" + this.hashCode() + "|Pipes:" + this.pipes.size() + "|Acceptors:" + this.hydrogenTiles.size() + "]";
    }
}

