/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketDynamic
implements IPacket {
    private int type;
    private int dimID;
    private Object[] data;
    private ArrayList<Object> sendData;

    public PacketDynamic() {
    }

    public PacketDynamic(Entity entity) {
        assert (entity instanceof IPacketReceiver) : "Entity does not implement " + IPacketReceiver.class.getSimpleName();
        this.type = 0;
        this.dimID = entity.field_70170_p.field_73011_w.field_76574_g;
        this.data = new Object[]{entity.func_145782_y()};
        this.sendData = new ArrayList();
        ((IPacketReceiver)entity).getNetworkedData(this.sendData);
    }

    public PacketDynamic(TileEntity tile) {
        assert (tile instanceof IPacketReceiver) : "TileEntity does not implement " + IPacketReceiver.class.getSimpleName();
        this.type = 1;
        this.dimID = tile.func_145831_w().field_73011_w.field_76574_g;
        this.data = new Object[]{tile.field_145851_c, tile.field_145848_d, tile.field_145849_e};
        this.sendData = new ArrayList();
        ((IPacketReceiver)tile).getNetworkedData(this.sendData);
    }

    @Override
    public void encodeInto(ChannelHandlerContext context, ByteBuf buffer) {
        buffer.writeInt(this.type);
        buffer.writeInt(this.dimID);
        switch (this.type) {
            case 0: {
                buffer.writeInt(((Integer)this.data[0]).intValue());
                break;
            }
            case 1: {
                buffer.writeInt(((Integer)this.data[0]).intValue());
                buffer.writeInt(((Integer)this.data[1]).intValue());
                buffer.writeInt(((Integer)this.data[2]).intValue());
            }
        }
        try {
            NetworkUtil.encodeData(buffer, this.sendData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext context, ByteBuf buffer) {
        this.type = buffer.readInt();
        this.dimID = buffer.readInt();
        World world = GalacticraftCore.proxy.getWorldForID(this.dimID);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            world = MinecraftServer.func_71276_C().func_71218_a(this.dimID);
        }
        if (world == null) {
            FMLLog.severe((String)("Failed to get world for dimension ID: " + this.dimID), (Object[])new Object[0]);
        }
        switch (this.type) {
            case 0: {
                Entity entity;
                this.data = new Object[1];
                this.data[0] = buffer.readInt();
                if (world == null || !((entity = world.func_73045_a(((Integer)this.data[0]).intValue())) instanceof IPacketReceiver) || buffer.readableBytes() <= 0) break;
                ((IPacketReceiver)entity).decodePacketdata(buffer);
                break;
            }
            case 1: {
                TileEntity tile;
                this.data = new Object[3];
                this.data[0] = buffer.readInt();
                this.data[1] = buffer.readInt();
                this.data[2] = buffer.readInt();
                if (world == null || !((tile = world.func_147438_o(((Integer)this.data[0]).intValue(), ((Integer)this.data[1]).intValue(), ((Integer)this.data[2]).intValue())) instanceof IPacketReceiver)) break;
                ((IPacketReceiver)tile).decodePacketdata(buffer);
            }
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        this.handleData(Side.CLIENT, player);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        this.handleData(Side.SERVER, player);
    }

    private void handleData(Side side, EntityPlayer player) {
        switch (this.type) {
            case 0: {
                Entity entity = player.field_70170_p.func_73045_a(((Integer)this.data[0]).intValue());
                if (!(entity instanceof IPacketReceiver)) break;
                ((IPacketReceiver)entity).handlePacketData(side, player);
                if (side != Side.SERVER || !(player instanceof EntityPlayerMP)) break;
                GalacticraftCore.packetPipeline.sendTo(new PacketDynamic(entity), (EntityPlayerMP)player);
                break;
            }
            case 1: {
                TileEntity tile = player.field_70170_p.func_147438_o(((Integer)this.data[0]).intValue(), ((Integer)this.data[1]).intValue(), ((Integer)this.data[2]).intValue());
                if (!(tile instanceof IPacketReceiver)) break;
                ((IPacketReceiver)tile).handlePacketData(side, player);
                if (side != Side.SERVER || !(player instanceof EntityPlayerMP)) break;
                GalacticraftCore.packetPipeline.sendTo(new PacketDynamic(tile), (EntityPlayerMP)player);
            }
        }
    }
}

