/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityArclamp
extends TileEntity {
    private int ticks = 0;
    private int sideRear = 0;
    public int facing = 0;
    private final HashSet<BlockVec3> airToRestore = new HashSet();
    private boolean isActive = false;
    private AxisAlignedBB thisAABB;
    private Vec3 thisPos;
    private int facingSide = 0;
    public boolean updateClientFlag;

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean initialLight = false;
        if (this.updateClientFlag) {
            GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_ARCLAMP_FACING, new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing}), this.field_145850_b.field_73011_w.field_76574_g);
            this.updateClientFlag = false;
        }
        if (RedstoneUtil.isBlockReceivingRedstone(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            if (this.isActive) {
                this.isActive = false;
                this.revertAir();
                this.func_70296_d();
            }
        } else if (!this.isActive) {
            this.isActive = true;
            initialLight = true;
        }
        if (this.isActive) {
            List moblist;
            if (this.thisAABB == null) {
                initialLight = true;
                int side = this.func_145832_p();
                switch (side) {
                    case 0: {
                        this.sideRear = side;
                        this.facingSide = this.facing + 2;
                        this.thisAABB = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 20), (double)(this.field_145848_d - 8), (double)(this.field_145849_e - 20), (double)(this.field_145851_c + 20), (double)(this.field_145848_d + 20), (double)(this.field_145849_e + 20));
                        break;
                    }
                    case 1: {
                        this.sideRear = side;
                        this.facingSide = this.facing + 2;
                        this.thisAABB = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 20), (double)(this.field_145848_d - 20), (double)(this.field_145849_e - 20), (double)(this.field_145851_c + 20), (double)(this.field_145848_d + 8), (double)(this.field_145849_e + 20));
                        break;
                    }
                    case 2: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        if (this.facing > 1) {
                            this.facingSide = 7 - this.facing;
                        }
                        this.thisAABB = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 20), (double)(this.field_145848_d - 20), (double)(this.field_145849_e - 8), (double)(this.field_145851_c + 20), (double)(this.field_145848_d + 20), (double)(this.field_145849_e + 20));
                        break;
                    }
                    case 3: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        if (this.facing > 1) {
                            this.facingSide += 2;
                        }
                        this.thisAABB = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 20), (double)(this.field_145848_d - 20), (double)(this.field_145849_e - 20), (double)(this.field_145851_c + 20), (double)(this.field_145848_d + 20), (double)(this.field_145849_e + 8));
                        break;
                    }
                    case 4: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        this.thisAABB = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 8), (double)(this.field_145848_d - 20), (double)(this.field_145849_e - 20), (double)(this.field_145851_c + 20), (double)(this.field_145848_d + 20), (double)(this.field_145849_e + 20));
                        break;
                    }
                    case 5: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        if (this.facing > 1) {
                            this.facingSide = 5 - this.facing;
                        }
                        this.thisAABB = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 20), (double)(this.field_145848_d - 20), (double)(this.field_145849_e - 20), (double)(this.field_145851_c + 8), (double)(this.field_145848_d + 20), (double)(this.field_145849_e + 20));
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (initialLight || this.ticks % 100 == 0) {
                this.lightArea();
            }
            if (this.field_145850_b.field_73012_v.nextInt(20) == 0 && !(moblist = this.field_145850_b.func_94576_a(null, this.thisAABB, IMob.field_82192_a)).isEmpty()) {
                for (Entity entry : moblist) {
                    double distanceNew;
                    PathNavigate nav;
                    EntityCreature e;
                    Vec3 vecNewTarget;
                    if (!(entry instanceof EntityCreature) || (vecNewTarget = RandomPositionGenerator.func_75461_b((EntityCreature)(e = (EntityCreature)entry), (int)16, (int)7, (Vec3)this.thisPos)) == null || (nav = e.func_70661_as()) == null) continue;
                    Vec3 vecOldTarget = null;
                    if (nav.func_75505_d() != null && !nav.func_75505_d().func_75879_b()) {
                        vecOldTarget = nav.func_75505_d().func_75878_a((Entity)e);
                    }
                    if (!((distanceNew = vecNewTarget.func_72445_d((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e)) > e.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e)) || vecOldTarget != null && !(distanceNew > vecOldTarget.func_72445_d((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e))) continue;
                    e.func_70661_as().func_75492_a(vecNewTarget.field_72450_a, vecNewTarget.field_72448_b, vecNewTarget.field_72449_c, 0.3);
                }
            }
        }
        ++this.ticks;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.thisPos = Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5));
        this.ticks = 0;
        this.thisAABB = null;
        if (this.field_145850_b.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_ARCLAMP_FACING, new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e}));
        } else {
            this.isActive = true;
        }
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            this.revertAir();
        }
        this.isActive = false;
        super.func_145843_s();
    }

    public void lightArea() {
        Block b;
        Block breatheableAirID = GCBlocks.breatheableAir;
        Block brightAir = GCBlocks.brightAir;
        Block brightBreatheableAir = GCBlocks.brightBreatheableAir;
        HashSet<BlockVec3> checked = new HashSet<BlockVec3>();
        LinkedList<BlockVec3> currentLayer = new LinkedList<BlockVec3>();
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        BlockVec3 thisvec = new BlockVec3(this);
        currentLayer.add(thisvec);
        World world = this.field_145850_b;
        int sideskip1 = this.sideRear;
        int sideskip2 = this.facingSide ^ 1;
        for (int i = 0; i < 6; ++i) {
            BlockVec3 onEitherSide;
            if (i == sideskip1 || i == sideskip2 || i == (sideskip1 ^ 1) || i == (sideskip2 ^ 1) || (b = (onEitherSide = thisvec.newVecSide(i)).getBlockIDsafe_noChunkLoad(world)) == null || b.func_149717_k() >= 15) continue;
            currentLayer.add(onEitherSide);
        }
        BlockVec3 inFront = new BlockVec3(this);
        for (int i = 0; i < 5; ++i) {
            b = (inFront = inFront.newVecSide(this.facingSide).newVecSide(sideskip1 ^ 1)).getBlockIDsafe_noChunkLoad(world);
            if (b == null || b.func_149717_k() >= 15) continue;
            currentLayer.add(inFront);
        }
        for (int count = 0; count < 14; ++count) {
            for (BlockVec3 vec : currentLayer) {
                int side = 0;
                int bits = vec.sideDoneBits;
                boolean allAir = true;
                do {
                    BlockVec3 sideVec;
                    if ((bits & 1 << side) != 0 || checked.contains(sideVec = vec.newVecSide(side))) continue;
                    checked.add(sideVec);
                    Block b2 = sideVec.getBlockIDsafe_noChunkLoad(world);
                    if (b2 instanceof BlockAir) {
                        if (side == sideskip1 || side == sideskip2) continue;
                        nextLayer.add(sideVec);
                        continue;
                    }
                    allAir = false;
                    if (b2 == null || b2.getLightOpacity((IBlockAccess)world, sideVec.x, sideVec.y, sideVec.z) != 0 || side == sideskip1 || side == sideskip2) continue;
                    nextLayer.add(sideVec);
                } while (++side < 6);
                if (allAir) continue;
                Block id = vec.getBlockIDsafe_noChunkLoad(world);
                if (Blocks.field_150350_a == id) {
                    world.func_147465_d(vec.x, vec.y, vec.z, brightAir, 0, 2);
                    this.airToRestore.add(vec);
                    this.func_70296_d();
                    continue;
                }
                if (id != breatheableAirID) continue;
                world.func_147465_d(vec.x, vec.y, vec.z, brightBreatheableAir, 0, 2);
                this.airToRestore.add(vec);
                this.func_70296_d();
            }
            currentLayer = nextLayer;
            nextLayer = new LinkedList();
            if (currentLayer.size() == 0) break;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.facing = nbt.func_74762_e("Facing");
        this.updateClientFlag = true;
        this.airToRestore.clear();
        NBTTagList airBlocks = nbt.func_150295_c("AirBlocks", 10);
        if (airBlocks.func_74745_c() > 0) {
            for (int j = airBlocks.func_74745_c() - 1; j >= 0; --j) {
                NBTTagCompound tag1 = airBlocks.func_150305_b(j);
                if (tag1 == null) continue;
                this.airToRestore.add(BlockVec3.readFromNBT(tag1));
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Facing", this.facing);
        NBTTagList airBlocks = new NBTTagList();
        for (BlockVec3 vec : this.airToRestore) {
            NBTTagCompound tag = new NBTTagCompound();
            vec.writeToNBT(tag);
            airBlocks.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("AirBlocks", (NBTBase)airBlocks);
    }

    public void facingChanged() {
        this.facing -= 2;
        if (this.facing < 0) {
            this.facing = 1 - this.facing;
        }
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_ARCLAMP_FACING, new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing}), this.field_145850_b.field_73011_w.field_76574_g);
        this.thisAABB = null;
        this.revertAir();
        this.func_70296_d();
    }

    private void revertAir() {
        Block brightAir = GCBlocks.brightAir;
        Block brightBreatheableAir = GCBlocks.brightBreatheableAir;
        for (BlockVec3 vec : this.airToRestore) {
            Block b = vec.getBlock((IBlockAccess)this.field_145850_b);
            if (b == brightAir) {
                this.field_145850_b.func_147465_d(vec.x, vec.y, vec.z, Blocks.field_150350_a, 0, 2);
                continue;
            }
            if (b != brightBreatheableAir) continue;
            this.field_145850_b.func_147465_d(vec.x, vec.y, vec.z, GCBlocks.breatheableAir, 0, 2);
        }
        this.airToRestore.clear();
    }

    public boolean getEnabled() {
        return !RedstoneUtil.isBlockReceivingRedstone(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

