/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityElectrolyzer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityGasLiquefier;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityMethaneSynthesizer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockMachineMarsT2
extends BlockTileGC
implements ItemBlockDesc.IBlockShiftDesc {
    public static final int GAS_LIQUEFIER = 0;
    public static final int METHANE_SYNTHESIZER = 4;
    public static final int ELECTROLYZER = 8;
    private IIcon iconMachineSide;
    private IIcon iconInput;
    private IIcon iconGasInput;
    private IIcon iconGasOutput;
    private IIcon iconWaterInput;
    private IIcon iconGasLiquefier;
    private IIcon iconMethaneSynthesizer;
    private IIcon iconElectrolyzer;

    public BlockMachineMarsT2() {
        super(GCBlocks.machine);
        this.func_149672_a(Block.field_149777_j);
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("galacticraftasteroids:machine");
        this.iconInput = par1IconRegister.func_94245_a("galacticraftasteroids:machine_input");
        this.iconMachineSide = par1IconRegister.func_94245_a("galacticraftasteroids:machine_side_warning");
        this.iconGasInput = par1IconRegister.func_94245_a("galacticraftasteroids:machine_oxygen_input_warning");
        this.iconGasOutput = par1IconRegister.func_94245_a("galacticraftasteroids:machine_oxygen_output_warning");
        this.iconWaterInput = par1IconRegister.func_94245_a("galacticraftasteroids:machine_water_input_warning");
        this.iconGasLiquefier = par1IconRegister.func_94245_a("galacticraftasteroids:gasLiquefier");
        this.iconMethaneSynthesizer = par1IconRegister.func_94245_a("galacticraftasteroids:methaneSynthesizer");
        this.iconElectrolyzer = par1IconRegister.func_94245_a("galacticraftasteroids:electrolyzer");
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public int func_149645_b() {
        return GalacticraftPlanets.getBlockRenderID((Block)this);
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0) {
            return this.iconInput;
        }
        if (side == 1) {
            return this.field_149761_L;
        }
        int metaside = (metadata & 3) + 2;
        switch (metadata &= 0xC) {
            case 0: {
                if (side == metaside) {
                    return this.iconGasInput;
                }
                if (7 - (metaside ^ (metaside > 3 ? 0 : 1)) != side) break;
                return this.iconGasLiquefier;
            }
            case 4: {
                if (side == metaside) {
                    return this.iconGasInput;
                }
                if (side == (metaside ^ 1)) {
                    return this.iconGasOutput;
                }
                if (7 - (metaside ^ (metaside > 3 ? 0 : 1)) != side) break;
                return this.iconMethaneSynthesizer;
            }
            case 8: {
                if (side == (metaside ^ 1)) {
                    return this.iconGasOutput;
                }
                if (7 - (metaside ^ (metaside > 3 ? 0 : 1)) == side) {
                    return this.iconElectrolyzer;
                }
                if (side == metaside) {
                    return this.iconWaterInput;
                }
                return this.iconGasOutput;
            }
        }
        return this.iconMachineSide;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata = world.func_72805_g(x, y, z);
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, (metadata & 0xC) + change, 3);
    }

    @Override
    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = par1World.func_72805_g(x, y, z);
        int original = metadata & 3;
        int change = 0;
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        TileEntity te = par1World.func_147438_o(x, y, z);
        if (te instanceof TileBaseUniversalElectrical) {
            ((TileBaseUniversalElectrical)te).updateFacing();
        }
        par1World.func_72921_c(x, y, z, (metadata & 0xC) + change, 3);
        return true;
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        par5EntityPlayer.openGui((Object)GalacticraftPlanets.instance, 2, world, x, y, z);
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata &= 0xC) {
            case 0: {
                return new TileEntityGasLiquefier();
            }
            case 4: {
                return new TileEntityMethaneSynthesizer();
            }
            case 8: {
                return new TileEntityElectrolyzer();
            }
        }
        return null;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        par3List.add(new ItemStack((Block)this, 1, 0));
        par3List.add(new ItemStack((Block)this, 1, 4));
        par3List.add(new ItemStack((Block)this, 1, 8));
    }

    public int func_149692_a(int metadata) {
        return metadata & 0xC;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int metadata = this.func_149643_k(world, x, y, z);
        return new ItemStack((Block)this, 1, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World par1World, int par2, int par3, int par4, Random rand) {
        TileEntity te = par1World.func_147438_o(par2, par3, par4);
        if (te instanceof TileEntityGasLiquefier) {
            TileEntityGasLiquefier tileEntity = (TileEntityGasLiquefier)te;
            if (tileEntity.processTicks > 0) {
                float x = (float)par2 + 0.5f;
                float y = (float)par3 + 0.8f + 0.05f * (float)rand.nextInt(3);
                float z = (float)par4 + 0.5f;
                for (float i = -0.41f + 0.16f * rand.nextFloat(); i < 0.5f; i += 0.167f) {
                    if (rand.nextInt(3) == 0) {
                        GalacticraftCore.proxy.spawnParticle("whiteSmokeTiny", new Vector3(x + i, y, z - 0.41f), new Vector3(0.0, -0.015, -0.0015), new Object[0]);
                    }
                    if (rand.nextInt(3) == 0) {
                        GalacticraftCore.proxy.spawnParticle("whiteSmokeTiny", new Vector3(x + i, y, z + 0.537f), new Vector3(0.0, -0.015, 0.0015), new Object[0]);
                    }
                    if (rand.nextInt(3) == 0) {
                        GalacticraftCore.proxy.spawnParticle("whiteSmokeTiny", new Vector3(x - 0.41f, y, z + i), new Vector3(-0.0015, -0.015, 0.0), new Object[0]);
                    }
                    if (rand.nextInt(3) != 0) continue;
                    GalacticraftCore.proxy.spawnParticle("whiteSmokeTiny", new Vector3(x + 0.537f, y, z + i), new Vector3(0.0015, -0.015, 0.0), new Object[0]);
                }
            }
        }
    }

    @Override
    public String getShiftDescription(int meta) {
        switch (meta) {
            case 8: {
                return GCCoreUtil.translate("tile.electrolyzer.description");
            }
            case 0: {
                return GCCoreUtil.translate("tile.gasLiquefier.description");
            }
            case 4: {
                return GCCoreUtil.translate("tile.methaneSynthesizer.description");
            }
        }
        return "";
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }
}

