/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.network.PacketSimpleMars;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.biome.BiomeGenBase;

public class TileEntityCryogenicChamber
extends TileEntityMulti
implements IMultiBlock {
    public boolean isOccupied;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        EntityPlayer.EnumStatus enumstatus = this.sleepInBedAt(entityPlayer, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        switch (enumstatus) {
            case OK: {
                ((EntityPlayerMP)entityPlayer).field_71135_a.func_147364_a(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, entityPlayer.field_70177_z, entityPlayer.field_70125_A);
                GalacticraftCore.packetPipeline.sendTo(new PacketSimpleMars(PacketSimpleMars.EnumSimplePacketMars.C_BEGIN_CRYOGENIC_SLEEP, new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e}), (EntityPlayerMP)entityPlayer);
                return true;
            }
            case NOT_POSSIBLE_NOW: {
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translateWithFormat("gui.cryogenic.chat.cantUse", GCPlayerStats.get((EntityPlayerMP)((EntityPlayerMP)entityPlayer)).cryogenicChamberCooldown / 20)));
                return false;
            }
        }
        return false;
    }

    public EntityPlayer.EnumStatus sleepInBedAt(EntityPlayer entityPlayer, int par1, int par2, int par3) {
        if (!this.field_145850_b.field_72995_K) {
            if (entityPlayer.func_70608_bn() || !entityPlayer.func_70089_S()) {
                return EntityPlayer.EnumStatus.OTHER_PROBLEM;
            }
            if (this.field_145850_b.func_72807_a(par1, par3) == BiomeGenBase.field_76778_j) {
                return EntityPlayer.EnumStatus.NOT_POSSIBLE_HERE;
            }
            if (GCPlayerStats.get((EntityPlayerMP)((EntityPlayerMP)entityPlayer)).cryogenicChamberCooldown > 0) {
                return EntityPlayer.EnumStatus.NOT_POSSIBLE_NOW;
            }
        }
        if (entityPlayer.func_70115_ae()) {
            entityPlayer.func_70078_a(null);
        }
        entityPlayer.func_70107_b((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 1.9f), (double)((float)this.field_145849_e + 0.5f));
        entityPlayer.field_71083_bS = true;
        entityPlayer.field_71076_b = 0;
        entityPlayer.field_71081_bT = new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        entityPlayer.field_70181_x = 0.0;
        entityPlayer.field_70179_y = 0.0;
        entityPlayer.field_70159_w = 0.0;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72854_c();
        }
        return EntityPlayer.EnumStatus.OK;
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
    }

    @Override
    public void onCreate(BlockVec3 placedPosition) {
        this.mainBlockPosition = placedPosition;
        this.func_70296_d();
        int buildHeight = this.field_145850_b.func_72800_K() - 1;
        for (int y = 0; y < 3; ++y) {
            if (placedPosition.y + y > buildHeight) {
                return;
            }
            BlockVec3 vecToAdd = new BlockVec3(placedPosition.x, placedPosition.y + y, placedPosition.z);
            if (vecToAdd.equals(placedPosition)) continue;
            ((BlockMulti)GCBlocks.fakeBlock).makeFakeBlock(this.field_145850_b, vecToAdd, placedPosition, 5);
        }
    }

    @Override
    public void onDestroy(TileEntity callingBlock) {
        int y;
        BlockVec3 thisBlock = new BlockVec3(this);
        int fakeBlockCount = 0;
        for (y = 0; y < 3; ++y) {
            if (y == 0 || this.field_145850_b.func_147439_a(thisBlock.x, thisBlock.y + y, thisBlock.z) != GCBlocks.fakeBlock) continue;
            ++fakeBlockCount;
        }
        if (fakeBlockCount == 0) {
            return;
        }
        for (y = 0; y < 3; ++y) {
            if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
                FMLClientHandler.instance().getClient().field_71452_i.func_147215_a(thisBlock.x, thisBlock.y + y, thisBlock.z, MarsBlocks.machine, Block.func_149682_b((Block)MarsBlocks.machine) >> 12 & 0xFF);
            }
            this.field_145850_b.func_147480_a(thisBlock.x, thisBlock.y + y, thisBlock.z, true);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isOccupied = nbt.func_74767_n("IsChamberOccupied");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("IsChamberOccupied", this.isOccupied);
    }
}

