/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.network.PacketSimpleAsteroids;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMinerBase
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IMultiBlock {
    public static final int HOLDSIZE = 72;
    private ItemStack[] containingItems = new ItemStack[73];
    private final int[] slotArray;
    public boolean isMaster = false;
    public int facing;
    private BlockVec3 mainBlockPosition;
    private final LinkedList<BlockVec3> targetPoints = new LinkedList();
    private WeakReference<TileEntityMinerBase> masterTile = null;
    public boolean updateClientFlag;
    public boolean findTargetPointsFlag;
    public int linkCountDown = 0;
    public int numUsingPlayers;
    public EntityAstroMiner linkedMiner = null;
    public UUID linkedMinerID = null;

    public TileEntityMinerBase() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 20.0f : 12.0f);
        this.slotArray = new int[72];
        for (int i = 0; i < 72; ++i) {
            this.slotArray[i] = i + 1;
        }
    }

    @Override
    public void func_145845_h() {
        TileEntityMinerBase master;
        super.func_145845_h();
        if (this.updateClientFlag) {
            this.updateClient();
            this.updateClientFlag = false;
        }
        if (this.findTargetPointsFlag) {
            if (this.isMaster && this.linkedMiner != null) {
                this.findTargetPoints();
            }
            this.findTargetPointsFlag = false;
        }
        if (!this.isMaster && (master = this.getMaster()) != null) {
            float energyLimit = master.storage.getCapacityGC() - master.storage.getEnergyStoredGC();
            if (energyLimit < 0.0f) {
                energyLimit = 0.0f;
            }
            this.storage.setCapacity(energyLimit);
            this.storage.setMaxExtract(energyLimit);
            this.storage.setMaxReceive(energyLimit);
            float hasEnergy = this.getEnergyStoredGC();
            if (hasEnergy > 0.0f) {
                this.extractEnergyGC(null, master.receiveEnergyGC(null, hasEnergy, false), false);
            }
        }
        if (this.linkCountDown > 0) {
            --this.linkCountDown;
        }
    }

    public boolean spawnMiner(EntityPlayerMP player) {
        if (this.isMaster) {
            if (this.linkedMiner != null && this.linkedMiner.field_70128_L) {
                this.unlinkMiner();
            }
            if (this.linkedMinerID == null && EntityAstroMiner.spawnMinerAtBase(this.field_145850_b, this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e + 1, this.facing + 2 ^ 1, new BlockVec3(this), player)) {
                this.findTargetPoints();
                return true;
            }
            return false;
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.spawnMiner(player);
        }
        return false;
    }

    public TileEntityMinerBase getMaster() {
        TileEntity tileEntity;
        if (this.mainBlockPosition == null) {
            return null;
        }
        if (this.masterTile == null && (tileEntity = this.mainBlockPosition.getTileEntity((IBlockAccess)this.field_145850_b)) != null && tileEntity instanceof TileEntityMinerBase) {
            this.masterTile = new WeakReference<TileEntityMinerBase>((TileEntityMinerBase)tileEntity);
        }
        if (this.masterTile == null) {
            this.field_145850_b.func_147468_f(this.mainBlockPosition.x, this.mainBlockPosition.y, this.mainBlockPosition.z);
        } else {
            TileEntityMinerBase master = (TileEntityMinerBase)this.masterTile.get();
            if (master != null) {
                return master;
            }
            this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.containingItems = this.readStandardItemsFromNBT(nbt);
        this.isMaster = nbt.func_74767_n("isMaster");
        if (!this.isMaster) {
            this.mainBlockPosition = BlockVec3.readFromNBT(nbt.func_74775_l("masterpos"));
        }
        this.facing = nbt.func_74762_e("facing");
        this.updateClientFlag = true;
        this.linkedMinerID = nbt.func_150297_b("LinkedUUIDMost", 4) && nbt.func_150297_b("LinkedUUIDLeast", 4) ? new UUID(nbt.func_74763_f("LinkedUUIDMost"), nbt.func_74763_f("LinkedUUIDLeast")) : null;
        if (nbt.func_74764_b("TargetPoints")) {
            this.targetPoints.clear();
            NBTTagList mpList = nbt.func_150295_c("TargetPoints", 10);
            for (int j = 0; j < mpList.func_74745_c(); ++j) {
                NBTTagCompound bvTag = mpList.func_150305_b(j);
                this.targetPoints.add(BlockVec3.readFromNBT(bvTag));
            }
        } else {
            this.findTargetPointsFlag = this.isMaster;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeStandardItemsToNBT(nbt);
        nbt.func_74757_a("isMaster", this.isMaster);
        if (!this.isMaster && this.mainBlockPosition != null) {
            NBTTagCompound masterTag = new NBTTagCompound();
            this.mainBlockPosition.writeToNBT(masterTag);
            nbt.func_74782_a("masterpos", (NBTBase)masterTag);
        }
        nbt.func_74768_a("facing", this.facing);
        if (this.isMaster && this.linkedMinerID != null) {
            nbt.func_74772_a("LinkedUUIDMost", this.linkedMinerID.getMostSignificantBits());
            nbt.func_74772_a("LinkedUUIDLeast", this.linkedMinerID.getLeastSignificantBits());
        }
        NBTTagList mpList = new NBTTagList();
        for (BlockVec3 element : this.targetPoints) {
            mpList.func_74742_a((NBTBase)element.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("TargetPoints", (NBTBase)mpList);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean addToInventory(ItemStack itemstack) {
        ItemStack existingStack;
        int k;
        boolean flag1 = false;
        int invSize = this.func_70302_i_();
        if (itemstack.func_77985_e()) {
            for (k = 1; itemstack.field_77994_a > 0 && k < invSize; ++k) {
                existingStack = this.containingItems[k];
                if (existingStack == null || existingStack.func_77973_b() != itemstack.func_77973_b() || itemstack.func_77981_g() && itemstack.func_77960_j() != existingStack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)existingStack)) continue;
                int combined = existingStack.field_77994_a + itemstack.field_77994_a;
                if (combined <= itemstack.func_77976_d()) {
                    itemstack.field_77994_a = 0;
                    existingStack.field_77994_a = combined;
                    flag1 = true;
                    continue;
                }
                if (existingStack.field_77994_a >= itemstack.func_77976_d()) continue;
                itemstack.field_77994_a -= itemstack.func_77976_d() - existingStack.field_77994_a;
                existingStack.field_77994_a = itemstack.func_77976_d();
                flag1 = true;
            }
        }
        if (itemstack.field_77994_a > 0) {
            for (k = 1; k < invSize; ++k) {
                existingStack = this.containingItems[k];
                if (existingStack != null) continue;
                this.containingItems[k] = itemstack.func_77946_l();
                itemstack.field_77994_a = 0;
                flag1 = true;
                break;
            }
        }
        this.func_70296_d();
        return flag1;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimpleAsteroids(PacketSimpleAsteroids.EnumSimplePacketAsteroids.S_REQUEST_MINERBASE_FACING, new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e}));
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("tile.minerBase.name");
    }

    @Override
    public double getPacketRange() {
        return 20.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }

    @Override
    protected ItemStack[] getContainingItems() {
        if (this.isMaster) {
            return this.containingItems;
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.getContainingItems();
        }
        return this.containingItems;
    }

    @Override
    public boolean shouldUseEnergy() {
        return false;
    }

    public void setMainBlockPos(int x, int y, int z) {
        this.masterTile = null;
        if (this.field_145851_c == x && this.field_145848_d == y && this.field_145849_e == z) {
            this.isMaster = true;
            this.mainBlockPosition = null;
            return;
        }
        this.isMaster = false;
        this.mainBlockPosition = new BlockVec3(x, y, z);
        this.func_70296_d();
    }

    public void onBlockRemoval() {
        if (this.isMaster) {
            this.func_145843_s();
            this.onDestroy(this);
            return;
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null && !master.func_145837_r()) {
            this.field_145850_b.func_147480_a(master.field_145851_c, master.field_145848_d, master.field_145849_e, false);
        }
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer) {
        if (this.isMaster) {
            ItemStack holding = entityPlayer.func_71045_bC();
            if (holding != null && holding.func_77973_b() == AsteroidsItems.astroMiner) {
                return false;
            }
            entityPlayer.openGui((Object)GalacticraftPlanets.instance, 3, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        TileEntityMinerBase master = this.getMaster();
        return master != null && master.onActivated(entityPlayer);
    }

    @Override
    public void onCreate(BlockVec3 placedPosition) {
    }

    @Override
    public void onDestroy(TileEntity callingBlock) {
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    this.field_145850_b.func_147480_a(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z, false);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
    }

    @Override
    public void updateFacing() {
        if (this.isMaster && this.linkedMinerID == null) {
            switch (this.facing) {
                case 0: {
                    this.facing = 3;
                    break;
                }
                case 3: {
                    this.facing = 1;
                    break;
                }
                case 1: {
                    this.facing = 2;
                    break;
                }
                case 2: {
                    this.facing = 0;
                }
            }
            super.updateFacing();
        } else {
            TileEntityMinerBase master = this.getMaster();
            if (master != null) {
                master.updateFacing();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.updateClient();
        }
        this.func_70296_d();
    }

    private void updateClient() {
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        if (this.mainBlockPosition != null) {
            x = this.mainBlockPosition.x;
            y = this.mainBlockPosition.y;
            z = this.mainBlockPosition.z;
        }
        int link = this.linkedMinerID != null ? 1 : 0;
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimpleAsteroids(PacketSimpleAsteroids.EnumSimplePacketAsteroids.C_UPDATE_MINERBASE_FACING, new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing, x, y, z, link}), this.field_145850_b.field_73011_w.field_76574_g);
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        if (this.isMaster) {
            return ForgeDirection.getOrientation((int)(this.facing + 2));
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return ForgeDirection.getOrientation((int)(master.facing + 2));
        }
        return ForgeDirection.UNKNOWN;
    }

    public void linkMiner(EntityAstroMiner entityAstroMiner) {
        this.linkedMiner = entityAstroMiner;
        this.linkedMinerID = this.linkedMiner.func_110124_au();
        this.updateClientFlag = true;
        this.func_70296_d();
    }

    public void unlinkMiner() {
        this.linkedMiner = null;
        this.linkedMinerID = null;
        this.updateClientFlag = true;
        this.func_70296_d();
    }

    public UUID getLinkedMiner() {
        if (this.isMaster) {
            return this.linkedMinerID;
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.linkedMinerID;
        }
        return null;
    }

    public int[] func_94128_d(int side) {
        if (this.isMaster) {
            return side != this.facing + 2 ? this.slotArray : new int[]{};
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.func_94128_d(side);
        }
        return new int[0];
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (this.isMaster) {
            if (side != this.facing + 2) {
                return slotID > 0 || ItemElectricBase.isElectricItemEmpty(itemstack);
            }
            return false;
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.func_102008_b(slotID, itemstack, side);
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (this.isMaster) {
            return slotID > 0 || ItemElectricBase.isElectricItem(itemstack.func_77973_b());
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.func_94041_b(slotID, itemstack);
        }
        return false;
    }

    @Override
    public ItemStack func_70301_a(int par1) {
        if (this.isMaster) {
            return super.func_70301_a(par1);
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.func_70301_a(par1);
        }
        return null;
    }

    @Override
    public ItemStack func_70298_a(int par1, int par2) {
        if (this.isMaster) {
            return super.func_70298_a(par1, par2);
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.func_70298_a(par1, par2);
        }
        return null;
    }

    @Override
    public ItemStack func_70304_b(int par1) {
        if (this.isMaster) {
            return super.func_70304_b(par1);
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            return master.func_70304_b(par1);
        }
        return null;
    }

    @Override
    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        if (this.isMaster) {
            super.func_70299_a(par1, par2ItemStack);
            this.func_70296_d();
            return;
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            master.func_70299_a(par1, par2ItemStack);
        }
    }

    @Override
    public ItemStack getBatteryInSlot() {
        if (this.isMaster) {
            return this.func_70301_a(0);
        }
        TileEntityMinerBase master = this.getMaster();
        if (master != null) {
            master.getBatteryInSlot();
        }
        return null;
    }

    @Override
    public int func_70302_i_() {
        return 73;
    }

    public BlockVec3 findNextTarget() {
        if (!this.targetPoints.isEmpty()) {
            BlockVec3 pos = this.targetPoints.removeFirst();
            this.func_70296_d();
            if (pos != null) {
                return pos.clone();
            }
        }
        return null;
    }

    private void findTargetPoints() {
        ArrayList<BlockVec3> roids;
        this.targetPoints.clear();
        int baseFacing = this.facing + 2 ^ 1;
        BlockVec3 posnTarget = new BlockVec3(this);
        if (this.field_145850_b.field_73011_w instanceof WorldProviderAsteroids && (roids = ((WorldProviderAsteroids)this.field_145850_b.field_73011_w).getClosestAsteroidsXZ(posnTarget.x, posnTarget.y, posnTarget.z, baseFacing, 100)) != null && roids.size() > 0) {
            this.targetPoints.addAll(roids);
            return;
        }
        posnTarget.modifyPositionFromSide(ForgeDirection.getOrientation((int)baseFacing), this.field_145850_b.field_73012_v.nextInt(16) + 32);
        int miny = Math.min(this.field_145848_d * 2 - 90, this.field_145848_d - 22);
        if (miny < 5) {
            miny = 5;
        }
        posnTarget.y = miny + 5 + this.field_145850_b.field_73012_v.nextInt(4);
        this.targetPoints.add(posnTarget);
        ForgeDirection lateral = ForgeDirection.NORTH;
        ForgeDirection inLine = ForgeDirection.getOrientation((int)baseFacing);
        if ((baseFacing & 6) == 2) {
            lateral = ForgeDirection.WEST;
        }
        this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, 13));
        this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, -13));
        if (posnTarget.y > 17) {
            this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, 7).modifyPositionFromSide(ForgeDirection.DOWN, 11));
            this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, -7).modifyPositionFromSide(ForgeDirection.DOWN, 11));
        } else {
            this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, 26));
            this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, -26));
        }
        this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, 7).modifyPositionFromSide(ForgeDirection.UP, 11));
        this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, -7).modifyPositionFromSide(ForgeDirection.UP, 11));
        if (posnTarget.y < this.field_145848_d - 38) {
            this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, 13).modifyPositionFromSide(ForgeDirection.UP, 22));
            this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(ForgeDirection.UP, 22));
            this.targetPoints.add(posnTarget.clone().modifyPositionFromSide(lateral, -13).modifyPositionFromSide(ForgeDirection.UP, 22));
        }
        int s = this.targetPoints.size();
        for (int i = 0; i < s; ++i) {
            this.targetPoints.add(this.targetPoints.get(i).clone().modifyPositionFromSide(inLine, 30));
        }
        this.func_70296_d();
    }

    @Override
    public void setDisabled(int index, boolean disabled) {
        TileEntityMinerBase master;
        if (!this.isMaster) {
            master = this.getMaster();
            if (master == null) {
                return;
            }
        } else {
            master = this;
        }
        if (master.linkedMiner != null) {
            master.linkedMiner.recall();
        }
    }
}

