/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import gregtech.api.util.GT_ModHandler;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.command.CommandGCAstroMiner;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.recipe.NasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.core.util.RecipeUtil;
import micdoodle8.mods.galacticraft.planets.IPlanetsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.ConfigManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.TeleportTypeAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityEntryPod;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityGrapple;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntitySmallAsteroid;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityTier3Rocket;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.player.AsteroidsPlayerHandler;
import micdoodle8.mods.galacticraft.planets.asteroids.event.AsteroidsEventHandler;
import micdoodle8.mods.galacticraft.planets.asteroids.inventory.ContainerAstroMinerDock;
import micdoodle8.mods.galacticraft.planets.asteroids.inventory.ContainerShortRangeTelepad;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.network.PacketSimpleAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.recipe.CanisterRecipes;
import micdoodle8.mods.galacticraft.planets.asteroids.recipe.RecipeManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.schematic.SchematicAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.schematic.SchematicTier3Rocket;
import micdoodle8.mods.galacticraft.planets.asteroids.tick.AsteroidsTickHandlerServer;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReceiver;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReflector;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBase;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBaseSingle;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityShortRangeTelepad;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityTelepadFake;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityTreasureChestAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.ChunkProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringTranslate;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.RecipeSorter;

public class AsteroidsModule
implements IPlanetsModule {
    public static Planet planetAsteroids;
    private File GCPlanetsSource;
    public static final String ASSET_PREFIX = "galacticraftasteroids";
    public static final String TEXTURE_PREFIX = "galacticraftasteroids:";
    public static AsteroidsPlayerHandler playerHandler;
    public static Fluid fluidMethaneGas;
    public static Fluid fluidOxygenGas;
    public static Fluid fluidNitrogenGas;
    public static Fluid fluidLiquidMethane;
    public static Fluid fluidLiquidOxygen;
    public static Fluid fluidLiquidNitrogen;
    public static Fluid fluidLiquidArgon;
    public static Fluid fluidAtmosphericGases;

    private Fluid registerFluid(String fluidName, int density, int viscosity, int temperature, boolean gaseous) {
        Fluid returnFluid = FluidRegistry.getFluid((String)fluidName);
        if (returnFluid == null) {
            FluidRegistry.registerFluid((Fluid)new Fluid(fluidName).setDensity(density).setViscosity(viscosity).setTemperature(temperature).setGaseous(gaseous));
            returnFluid = FluidRegistry.getFluid((String)fluidName);
        }
        return returnFluid;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.GCPlanetsSource = event.getSourceFile();
        playerHandler = new AsteroidsPlayerHandler();
        MinecraftForge.EVENT_BUS.register((Object)playerHandler);
        FMLCommonHandler.instance().bus().register((Object)playerHandler);
        AsteroidsEventHandler eventHandler = new AsteroidsEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        FMLCommonHandler.instance().bus().register((Object)eventHandler);
        RecipeSorter.register((String)"galacticraftmars:canisterRecipe", CanisterRecipes.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        fluidMethaneGas = this.registerFluid("methane", 1, 11, 295, true);
        fluidAtmosphericGases = this.registerFluid("atmosphericgases", 1, 13, 295, true);
        fluidLiquidMethane = this.registerFluid("liquidmethane", 450, 120, 109, false);
        fluidLiquidOxygen = this.registerFluid("liquidoxygen", 1141, 140, 90, false);
        fluidOxygenGas = this.registerFluid("oxygen", 1, 13, 295, true);
        fluidLiquidNitrogen = this.registerFluid("liquidnitrogen", 808, 130, 90, false);
        fluidNitrogenGas = this.registerFluid("nitrogen", 1, 12, 295, true);
        this.registerFluid("carbondioxide", 2, 20, 295, true);
        this.registerFluid("hydrogen", 1, 1, 295, true);
        this.registerFluid("argon", 1, 4, 295, true);
        fluidLiquidArgon = this.registerFluid("liquidargon", 900, 100, 87, false);
        this.registerFluid("helium", 1, 1, 295, true);
        AsteroidBlocks.initBlocks();
        AsteroidBlocks.registerBlocks();
        AsteroidBlocks.setHarvestLevels();
        AsteroidBlocks.oreDictRegistration();
        AsteroidsItems.initItems();
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluidMethaneGas, 1000), new ItemStack(AsteroidsItems.methaneCanister, 1, 1), new ItemStack(GCItems.oilCanister, 1, 1001)));
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluidLiquidOxygen, 1000), new ItemStack(AsteroidsItems.canisterLOX, 1, 1), new ItemStack(GCItems.oilCanister, 1, 1001)));
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluidLiquidNitrogen, 1000), new ItemStack(AsteroidsItems.canisterLN2, 1, 1), new ItemStack(GCItems.oilCanister, 1, 1001)));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        int i;
        this.registerMicroBlocks();
        SchematicRegistry.registerSchematicRecipe(new SchematicTier3Rocket());
        SchematicRegistry.registerSchematicRecipe(new SchematicAstroMiner());
        GalacticraftCore.packetPipeline.addDiscriminator(7, PacketSimpleAsteroids.class);
        AsteroidsTickHandlerServer eventHandler = new AsteroidsTickHandlerServer();
        FMLCommonHandler.instance().bus().register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        this.registerEntities();
        RecipeManagerAsteroids.loadRecipes();
        planetAsteroids = new Planet("asteroids").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetAsteroids.setDimensionInfo(ConfigManagerAsteroids.dimensionIDAsteroids, WorldProviderAsteroids.class).setTierRequired(3);
        planetAsteroids.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.375f, 1.375f)).setRelativeOrbitTime(45.0f).setPhaseShift((float)(Math.random() * (Math.PI * 2)));
        planetAsteroids.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/asteroid.png"));
        GalaxyRegistry.registerPlanet(planetAsteroids);
        GalacticraftRegistry.registerTeleportType(WorldProviderAsteroids.class, new TeleportTypeAsteroids());
        HashMap<Integer, ItemStack> input = new HashMap<Integer, ItemStack>();
        for (i = 1; i <= 8; ++i) {
            input.put(i, new ItemStack(MarsItems.marsItemBasic, 1, 3));
        }
        input.put(9, new ItemStack(GCItems.flagPole));
        input.put(10, new ItemStack(GCItems.flagPole));
        for (i = 11; i <= 13; ++i) {
            input.put(i, new ItemStack(AsteroidsItems.basicItem));
        }
        for (i = 14; i <= 17; ++i) {
            input.put(i, new ItemStack(AsteroidsItems.orionDrive));
        }
        if (GalacticraftCore.isGalaxySpaceLoaded) {
            input.put(18, GT_ModHandler.getModItem((String)"GalaxySpace", (String)"item.RocketControlComputer", (long)1L, (int)102));
        }
        input.put(19, new ItemStack(GCItems.basicItem, 1, 14));
        input.put(20, new ItemStack(GCItems.basicItem, 1, 14));
        for (i = 21; i <= 23; ++i) {
            input.put(i, new ItemStack(GCItems.heavyPlatingTier1));
        }
        input.put(24, RecipeUtil.getChestItemStack(1, 1));
        input.put(25, RecipeUtil.getChestItemStack(1, 1));
        input.put(26, new ItemStack(AsteroidsItems.basicItem, 1, 8));
        input.put(27, new ItemStack(AsteroidBlocks.beamReceiver));
        input.put(28, GT_ModHandler.getModItem((String)"gregtech", (String)"gt.metaitem.01", (long)1L, (int)32603));
        input.put(29, GT_ModHandler.getModItem((String)"gregtech", (String)"gt.metaitem.01", (long)1L, (int)32603));
        GalacticraftRegistry.addAstroMinerRecipe(new NasaWorkbenchRecipe(new ItemStack(AsteroidsItems.astroMiner, 1, 0), input));
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        try {
            ZipFile zf = new ZipFile(this.GCPlanetsSource);
            Pattern assetENUSLang = Pattern.compile("assets/(.*)/lang/(?:.+/|)([\\w_-]+).lang");
            for (ZipEntry zipEntry : Collections.list(zf.entries())) {
                Matcher matcher;
                if (!zipEntry.getName().contains("galacticraftasteroids/lang") || !(matcher = assetENUSLang.matcher(zipEntry.getName())).matches()) continue;
                String lang = matcher.group(2);
                LanguageRegistry.instance().injectLanguage(lang, StringTranslate.parseLangFile((InputStream)zf.getInputStream(zipEntry)));
                if (!"en_US".equals(lang) || event.getSide() != Side.SERVER) continue;
                StringTranslate.inject((InputStream)zf.getInputStream(zipEntry));
            }
            zf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandGCAstroMiner());
        ChunkProviderAsteroids.reset();
    }

    @Override
    public void serverInit(FMLServerStartedEvent event) {
        AsteroidsTickHandlerServer.restart();
    }

    @Override
    public void getGuiIDs(List<Integer> idList) {
        idList.add(3);
    }

    @Override
    public Object getGuiElement(Side side, int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (side == Side.SERVER) {
            TileEntity tile = world.func_147438_o(x, y, z);
            switch (ID) {
                case 3: {
                    if (tile instanceof TileEntityShortRangeTelepad) {
                        return new ContainerShortRangeTelepad(player.field_71071_by, (TileEntityShortRangeTelepad)tile);
                    }
                    if (!(tile instanceof TileEntityMinerBase)) break;
                    return new ContainerAstroMinerDock(player.field_71071_by, (TileEntityMinerBase)tile);
                }
            }
        }
        return null;
    }

    private void registerEntities() {
        this.registerCreatures();
        this.registerNonMobEntities();
        this.registerTileEntities();
    }

    private void registerCreatures() {
    }

    private void registerNonMobEntities() {
        MarsModule.registerGalacticraftNonMobEntity(EntitySmallAsteroid.class, "SmallAsteroidGC", 150, 3, true);
        MarsModule.registerGalacticraftNonMobEntity(EntityGrapple.class, "GrappleHookGC", 150, 1, true);
        MarsModule.registerGalacticraftNonMobEntity(EntityTier3Rocket.class, "Tier3RocketGC", 150, 1, false);
        MarsModule.registerGalacticraftNonMobEntity(EntityEntryPod.class, "EntryPodAsteroids", 150, 1, true);
        MarsModule.registerGalacticraftNonMobEntity(EntityAstroMiner.class, "AstroMiner", 80, 1, true);
    }

    private void registerMicroBlocks() {
        try {
            Class<?> clazz = Class.forName("codechicken.microblock.MicroMaterialRegistry");
            if (clazz != null) {
                Method[] methodz;
                Method registerMethod = null;
                for (Method m : methodz = clazz.getMethods()) {
                    if (!m.getName().equals("registerMaterial")) continue;
                    registerMethod = m;
                    break;
                }
                Class<?> clazzbm = Class.forName("codechicken.microblock.BlockMicroMaterial");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockBasic, 0), "tile.asteroidsBlock.asteroid0");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockBasic, 1), "tile.asteroidsBlock.asteroid1");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockBasic, 2), "tile.asteroidsBlock.asteroid2");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockDenseIce, 0), "tile.denseIce");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityBeamReflector.class, (String)"Beam Reflector");
        GameRegistry.registerTileEntity(TileEntityBeamReceiver.class, (String)"Beam Receiver");
        GameRegistry.registerTileEntity(TileEntityShortRangeTelepad.class, (String)"Short Range Telepad");
        GameRegistry.registerTileEntity(TileEntityTelepadFake.class, (String)"Fake Short Range Telepad");
        GameRegistry.registerTileEntity(TileEntityTreasureChestAsteroids.class, (String)"Asteroids Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityMinerBaseSingle.class, (String)"Astro Miner Base Builder");
        GameRegistry.registerTileEntity(TileEntityMinerBase.class, (String)"Astro Miner Base");
    }

    @Override
    public Configuration getConfiguration() {
        return ConfigManagerAsteroids.config;
    }

    @Override
    public void syncConfig() {
        ConfigManagerAsteroids.syncConfig(false, false);
    }
}

