/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.wrappers;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import net.minecraft.nbt.NBTTagCompound;

public class FlagData {
    private int height;
    private int width;
    private final byte[][][] color;

    public FlagData(int width, int height) {
        this.height = height;
        this.width = width;
        this.color = new byte[width][height][3];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                this.color[i][j][0] = 127;
                this.color[i][j][1] = 127;
                this.color[i][j][2] = 127;
            }
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Vector3 getColorAt(int posX, int posY) {
        if (posX >= this.width || posY >= this.height) {
            return new Vector3(0.0, 0.0, 0.0);
        }
        return new Vector3((double)(this.color[posX][posY][0] + 128) / 256.0, (double)(this.color[posX][posY][1] + 128) / 256.0, (double)(this.color[posX][posY][2] + 128) / 256.0);
    }

    public void setColorAt(int posX, int posY, Vector3 colorVec) {
        this.color[posX][posY][0] = (byte)(colorVec.intX() - 128);
        this.color[posX][posY][1] = (byte)(colorVec.intY() - 128);
        this.color[posX][posY][2] = (byte)(colorVec.intZ() - 128);
    }

    public static FlagData readFlagData(NBTTagCompound nbt) {
        if (nbt.func_74764_b("FlagWidth")) {
            int width = nbt.func_74762_e("FlagWidth");
            int height = nbt.func_74762_e("FlagHeight");
            FlagData flagData = new FlagData(width, height);
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    flagData.color[i][j][0] = nbt.func_74771_c("ColorR-X" + i + "-Y" + j);
                    flagData.color[i][j][1] = nbt.func_74771_c("ColorG-X" + i + "-Y" + j);
                    flagData.color[i][j][2] = nbt.func_74771_c("ColorB-X" + i + "-Y" + j);
                }
            }
            return flagData;
        }
        int width = nbt.func_74762_e("FWidth");
        int height = nbt.func_74762_e("FHeight");
        FlagData flagData = new FlagData(width, height);
        for (int i = 0; i < height; ++i) {
            int[] colorRow = nbt.func_74759_k("FRow" + i);
            for (int j = 0; j < width; ++j) {
                int color = colorRow[j];
                flagData.color[j][i][0] = (byte)(color >> 16);
                flagData.color[j][i][1] = (byte)(color >> 8 & 0xFF);
                flagData.color[j][i][2] = (byte)(color & 0xFF);
            }
        }
        return flagData;
    }

    public void saveFlagData(NBTTagCompound nbt) {
        nbt.func_74768_a("FWidth", this.width);
        nbt.func_74768_a("FHeight", this.height);
        for (int i = 0; i < this.height; ++i) {
            int[] colorRow = new int[this.width];
            for (int j = 0; j < this.width; ++j) {
                byte[] arrayColor = this.color[j][i];
                colorRow[j] = ColorUtil.to32BitColorB(arrayColor[0], arrayColor[1], arrayColor[2]);
            }
            nbt.func_74783_a("FRow" + i, colorRow);
        }
    }

    public BufferedImage toBufferedImage() {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                int col = this.color[i][j][0] + 128 << 16 | this.color[i][j][1] + 128 << 8 | this.color[i][j][2] + 128;
                image.setRGB(i, j, col);
            }
        }
        return image;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlagData flagData = (FlagData)o;
        if (this.height != flagData.height) {
            return false;
        }
        if (this.width != flagData.width) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.color, (Object[])flagData.color);
    }
}

