/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.item.IBreathableArmor;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.ItemOxygenGear;
import micdoodle8.mods.galacticraft.core.items.ItemOxygenMask;
import micdoodle8.mods.galacticraft.core.items.ItemOxygenTank;
import micdoodle8.mods.galacticraft.core.oxygen.OxygenPressureProtocol;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDistributor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.util.ForgeDirection;

public class OxygenUtil {
    private static HashSet<BlockVec3> checked;

    @SideOnly(value=Side.CLIENT)
    public static boolean shouldDisplayTankGui(GuiScreen gui) {
        if (FMLClientHandler.instance().getClient().field_71474_y.field_74319_N) {
            return false;
        }
        if (gui == null) {
            return true;
        }
        if (gui instanceof GuiInventory) {
            return false;
        }
        return gui instanceof GuiChat;
    }

    public static boolean isAABBInBreathableAirBlock(EntityLivingBase entity) {
        return OxygenUtil.isAABBInBreathableAirBlock(entity, false);
    }

    public static boolean isAABBInBreathableAirBlock(EntityLivingBase entity, boolean testThermal) {
        double y = entity.field_70163_u + (double)entity.func_70047_e();
        double x = entity.field_70165_t;
        double z = entity.field_70161_v;
        double sx = entity.field_70121_D.field_72336_d - entity.field_70121_D.field_72340_a;
        double sy = entity.field_70121_D.field_72337_e - entity.field_70121_D.field_72338_b;
        double sz = entity.field_70121_D.field_72334_f - entity.field_70121_D.field_72339_c;
        double smin = Math.min(sx, Math.min(sy, sz)) / 2.0;
        return OxygenUtil.isAABBInBreathableAirBlock(entity.field_70170_p, AxisAlignedBB.func_72330_a((double)(x - smin), (double)(y - smin), (double)(z - smin), (double)(x + smin), (double)(y + smin), (double)(z + smin)), testThermal);
    }

    public static boolean isAABBInBreathableAirBlock(World world, AxisAlignedBB bb) {
        return OxygenUtil.isAABBInBreathableAirBlock(world, bb, false);
    }

    public static boolean isAABBInBreathableAirBlock(World world, AxisAlignedBB bb, boolean testThermal) {
        double avgX = (bb.field_72340_a + bb.field_72336_d) / 2.0;
        double avgY = (bb.field_72338_b + bb.field_72337_e) / 2.0;
        double avgZ = (bb.field_72339_c + bb.field_72334_f) / 2.0;
        if (testThermal) {
            return OxygenUtil.isInOxygenAndThermalBlock(world, bb.func_72329_c().func_72331_e(0.001, 0.001, 0.001));
        }
        if (OxygenUtil.inOxygenBubble(world, avgX, avgY, avgZ)) {
            return true;
        }
        return OxygenUtil.isInOxygenBlock(world, bb.func_72329_c().func_72331_e(0.001, 0.001, 0.001));
    }

    public static boolean isInOxygenBlock(World world, AxisAlignedBB bb) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76128_c((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76128_c((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)bb.field_72334_f);
        checked = new HashSet();
        if (world.func_72904_c(i, k, i1, j, l, j1)) {
            for (int x = i; x <= j; ++x) {
                for (int y = k; y <= l; ++y) {
                    for (int z = i1; z <= j1; ++z) {
                        Block block = world.func_147439_a(x, y, z);
                        if (OxygenUtil.testContactWithBreathableAir(world, block, x, y, z, 0) < 0) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isInOxygenAndThermalBlock(World world, AxisAlignedBB bb) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76128_c((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76128_c((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)bb.field_72334_f);
        checked = new HashSet();
        if (world.func_72904_c(i, k, i1, j, l, j1)) {
            for (int x = i; x <= j; ++x) {
                for (int y = k; y <= l; ++y) {
                    for (int z = i1; z <= j1; ++z) {
                        Block block = world.func_147439_a(x, y, z);
                        if (OxygenUtil.testContactWithBreathableAir(world, block, x, y, z, 0) != 1) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean checkTorchHasOxygen(World world, Block block, int x, int y, int z) {
        if (OxygenUtil.inOxygenBubble(world, (double)x + 0.5, (double)y + 0.6, (double)z + 0.5)) {
            return true;
        }
        checked = new HashSet();
        BlockVec3 vec = new BlockVec3(x, y, z);
        for (int side = 0; side < 6; ++side) {
            BlockVec3 sidevec = vec.newVecSide(side);
            Block newblock = sidevec.getBlockID_noChunkLoad(world);
            if (OxygenUtil.testContactWithBreathableAir(world, newblock, sidevec.x, sidevec.y, sidevec.z, 1) < 0) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int testContactWithBreathableAir(World world, Block block, int x, int y, int z, int limitCount) {
        BlockVec3 vec = new BlockVec3(x, y, z);
        checked.add(vec);
        if (block == GCBlocks.breatheableAir || block == GCBlocks.brightBreatheableAir) {
            return world.func_72805_g(x, y, z);
        }
        if (block == null || block.func_149688_o() == Material.field_151579_a) {
            return -1;
        }
        boolean permeableFlag = false;
        if (!(block instanceof BlockLeavesBase)) {
            if (block.func_149662_c()) {
                if (!(block instanceof BlockGravel) && block.func_149688_o() != Material.field_151580_n && !(block instanceof BlockSponge)) return -1;
                permeableFlag = true;
            } else {
                ArrayList<Integer> metaList;
                if (block instanceof BlockGlass || block instanceof BlockStainedGlass || block instanceof BlockLiquid) {
                    return -1;
                }
                if (OxygenPressureProtocol.nonPermeableBlocks.containsKey(block) && ((metaList = OxygenPressureProtocol.nonPermeableBlocks.get(block)).contains(-1) || metaList.contains(world.func_72805_g(x, y, z)))) {
                    return -1;
                }
            }
        } else {
            permeableFlag = true;
        }
        if (limitCount >= 5) return -1;
        for (int side = 0; side < 6; ++side) {
            Block newblock;
            int adjResult;
            BlockVec3 sidevec;
            if (!permeableFlag && !OxygenUtil.canBlockPassAirOnSide(world, block, vec, side) || checked.contains(sidevec = vec.newVecSide(side)) || (adjResult = OxygenUtil.testContactWithBreathableAir(world, newblock = sidevec.getBlockID_noChunkLoad(world), sidevec.x, sidevec.y, sidevec.z, limitCount + 1)) < 0) continue;
            return adjResult;
        }
        return -1;
    }

    private static boolean canBlockPassAirOnSide(World world, Block block, BlockVec3 vec, int side) {
        if (block instanceof IPartialSealableBlock) {
            return !((IPartialSealableBlock)block).isSealed(world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)side));
        }
        if (block instanceof BlockSlab) {
            return !(side == 0 && (vec.getBlockMetadata((IBlockAccess)world) & 8) == 8 || side == 1 && (vec.getBlockMetadata((IBlockAccess)world) & 8) == 0);
        }
        if (block instanceof BlockFarmland || block instanceof BlockEnchantmentTable || block instanceof BlockLiquid) {
            return side != 1;
        }
        if (block instanceof BlockPistonBase) {
            int meta = vec.getBlockMetadata((IBlockAccess)world);
            if (BlockPistonBase.func_150075_c((int)meta)) {
                int facing = BlockPistonBase.func_150076_b((int)meta);
                return side != facing;
            }
            return false;
        }
        return !block.isSideSolid((IBlockAccess)world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)(side ^ 1)));
    }

    public static int getDrainSpacing(ItemStack tank, ItemStack tank2) {
        boolean tank2Valid;
        boolean tank1Valid = tank != null && tank.func_77973_b() instanceof ItemOxygenTank && tank.func_77958_k() - tank.func_77960_j() > 0;
        boolean bl = tank2Valid = tank2 != null && tank2.func_77973_b() instanceof ItemOxygenTank && tank2.func_77958_k() - tank2.func_77960_j() > 0;
        if (!tank1Valid && !tank2Valid) {
            return 0;
        }
        return 9;
    }

    public static boolean hasValidOxygenSetup(EntityPlayerMP player) {
        IBreathableArmor breathableArmor;
        boolean handled;
        boolean missingComponent = false;
        GCPlayerStats stats = GCPlayerStats.get(player);
        if (stats.extendedInventory.func_70301_a(0) == null || !OxygenUtil.isItemValidForPlayerTankInv(0, stats.extendedInventory.func_70301_a(0))) {
            handled = false;
            for (ItemStack armorStack : player.field_71071_by.field_70460_b) {
                if (armorStack == null || !(armorStack.func_77973_b() instanceof IBreathableArmor) || !(breathableArmor = (IBreathableArmor)armorStack.func_77973_b()).handleGearType(IBreathableArmor.EnumGearType.HELMET) || !breathableArmor.canBreathe(armorStack, (EntityPlayer)player, IBreathableArmor.EnumGearType.HELMET)) continue;
                handled = true;
            }
            if (!handled) {
                missingComponent = true;
            }
        }
        if (stats.extendedInventory.func_70301_a(1) == null || !OxygenUtil.isItemValidForPlayerTankInv(1, stats.extendedInventory.func_70301_a(1))) {
            handled = false;
            for (ItemStack armorStack : player.field_71071_by.field_70460_b) {
                if (armorStack == null || !(armorStack.func_77973_b() instanceof IBreathableArmor) || !(breathableArmor = (IBreathableArmor)armorStack.func_77973_b()).handleGearType(IBreathableArmor.EnumGearType.GEAR) || !breathableArmor.canBreathe(armorStack, (EntityPlayer)player, IBreathableArmor.EnumGearType.GEAR)) continue;
                handled = true;
            }
            if (!handled) {
                missingComponent = true;
            }
        }
        if (!(stats.extendedInventory.func_70301_a(2) != null && OxygenUtil.isItemValidForPlayerTankInv(2, stats.extendedInventory.func_70301_a(2)) || stats.extendedInventory.func_70301_a(3) != null && OxygenUtil.isItemValidForPlayerTankInv(3, stats.extendedInventory.func_70301_a(3)))) {
            handled = false;
            for (ItemStack armorStack : player.field_71071_by.field_70460_b) {
                if (armorStack == null || !(armorStack.func_77973_b() instanceof IBreathableArmor)) continue;
                breathableArmor = (IBreathableArmor)armorStack.func_77973_b();
                if (breathableArmor.handleGearType(IBreathableArmor.EnumGearType.TANK1) && breathableArmor.canBreathe(armorStack, (EntityPlayer)player, IBreathableArmor.EnumGearType.TANK1)) {
                    handled = true;
                }
                if (!breathableArmor.handleGearType(IBreathableArmor.EnumGearType.TANK2) || !breathableArmor.canBreathe(armorStack, (EntityPlayer)player, IBreathableArmor.EnumGearType.TANK2)) continue;
                handled = true;
            }
            if (!handled) {
                missingComponent = true;
            }
        }
        return !missingComponent;
    }

    public static boolean isItemValidForPlayerTankInv(int slotIndex, ItemStack stack) {
        switch (slotIndex) {
            case 0: {
                return stack.func_77973_b() instanceof ItemOxygenMask;
            }
            case 1: {
                return stack.func_77973_b() instanceof ItemOxygenGear;
            }
            case 2: {
                return stack.func_77973_b() instanceof ItemOxygenTank;
            }
            case 3: {
                return stack.func_77973_b() instanceof ItemOxygenTank;
            }
        }
        return false;
    }

    public static TileEntity[] getAdjacentOxygenConnections(TileEntity tile) {
        TileEntity[] adjacentConnections = new TileEntity[ForgeDirection.VALID_DIRECTIONS.length];
        BlockVec3 thisVec = new BlockVec3(tile);
        World world = tile.func_145831_w();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = thisVec.getTileEntityOnSide(world, direction);
            if (!(tileEntity instanceof IConnector) || !((IConnector)tileEntity).canConnect(direction.getOpposite(), NetworkType.OXYGEN)) continue;
            adjacentConnections[direction.ordinal()] = tileEntity;
        }
        return adjacentConnections;
    }

    public static boolean noAtmosphericCombustion(WorldProvider provider) {
        if (provider instanceof IGalacticraftWorldProvider) {
            return !((IGalacticraftWorldProvider)provider).isGasPresent(IAtmosphericGas.OXYGEN) && !((IGalacticraftWorldProvider)provider).hasBreathableAtmosphere();
        }
        return false;
    }

    public static boolean inOxygenBubble(World worldObj, double avgX, double avgY, double avgZ) {
        for (BlockVec3Dim blockVec : TileEntityOxygenDistributor.loadedTiles) {
            TileEntity tile;
            if (blockVec == null || blockVec.dim != worldObj.field_73011_w.field_76574_g || !((tile = worldObj.func_147438_o(blockVec.x, blockVec.y, blockVec.z)) instanceof TileEntityOxygenDistributor) || !((TileEntityOxygenDistributor)tile).inBubble(avgX, avgY, avgZ)) continue;
            return true;
        }
        return false;
    }
}

