/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.entity.ITelemetry;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldProvider;

public class TileEntityTelemetry
extends TileEntity {
    public Class clientClass;
    public int[] clientData = new int[]{-1};
    public String clientName;
    public GameProfile clientGameProfile = null;
    public static HashSet<BlockVec3Dim> loadedList = new HashSet();
    public Entity linkedEntity;
    private UUID toUpdate = null;
    private int pulseRate = 400;
    private int lastHurttime = 0;
    private int ticks = 0;

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            loadedList.add(new BlockVec3Dim(this));
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            loadedList.remove(new BlockVec3Dim(this));
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && ++this.ticks % 2 == 0) {
            String name;
            if (this.toUpdate != null) {
                this.addTrackedEntity(this.toUpdate);
                this.toUpdate = null;
            }
            int[] data = new int[]{-1, -1, -1, -1, -1};
            String strUUID = "";
            if (this.linkedEntity != null) {
                if (this.linkedEntity.field_70128_L) {
                    this.linkedEntity = null;
                    name = "";
                } else {
                    name = this.linkedEntity instanceof EntityPlayerMP ? "$" + this.linkedEntity.func_70005_c_() : (String)EntityList.field_75626_c.get(this.linkedEntity.getClass());
                    if (name == null) {
                        GCLog.info("Telemetry Unit: Error finding name for " + this.linkedEntity.getClass().getSimpleName());
                        name = "";
                    }
                    double xmotion = this.linkedEntity.field_70159_w;
                    double ymotion = this.linkedEntity instanceof EntityLivingBase ? this.linkedEntity.field_70181_x + 0.078 : this.linkedEntity.field_70181_x;
                    double zmotion = this.linkedEntity.field_70179_y;
                    data[2] = (int)((double)MathHelper.func_76133_a((double)(xmotion * xmotion + ymotion * ymotion + zmotion * zmotion)) * 2000.0);
                    if (this.linkedEntity instanceof ITelemetry) {
                        ((ITelemetry)this.linkedEntity).transmitData(data);
                    } else if (this.linkedEntity instanceof EntityLivingBase) {
                        EntityLivingBase eLiving = (EntityLivingBase)this.linkedEntity;
                        data[0] = eLiving.field_70737_aN;
                        --this.pulseRate;
                        if (eLiving.field_70737_aN > this.lastHurttime) {
                            this.pulseRate += 100;
                        }
                        this.lastHurttime = eLiving.field_70737_aN;
                        if (eLiving.field_70154_o != null) {
                            data[2] = data[2] / 4;
                        } else if (data[2] > 1) {
                            this.pulseRate += 2;
                        }
                        this.pulseRate += Math.max(data[2] - this.pulseRate, 0) / 4;
                        if (this.pulseRate > 2000) {
                            this.pulseRate = 2000;
                        }
                        if (this.pulseRate < 400) {
                            this.pulseRate = 400;
                        }
                        data[2] = this.pulseRate / 10;
                        data[1] = (int)(eLiving.func_110143_aJ() * 100.0f / eLiving.func_110138_aP());
                        if (eLiving instanceof EntityPlayerMP) {
                            data[3] = ((EntityPlayerMP)eLiving).func_71024_bL().func_75116_a() * 5;
                            GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)eLiving);
                            data[4] = stats.airRemaining * 4096 + stats.airRemaining2;
                            UUID uuid = eLiving.func_110124_au();
                            if (uuid != null) {
                                strUUID = uuid.toString();
                            }
                        } else if (eLiving instanceof EntityHorse) {
                            data[3] = ((EntityHorse)eLiving).func_110265_bP();
                            data[4] = ((EntityHorse)eLiving).func_110202_bQ();
                        } else if (eLiving instanceof EntityVillager) {
                            data[3] = ((EntityVillager)eLiving).func_70946_n();
                            data[4] = ((EntityVillager)eLiving).func_70874_b();
                        } else if (eLiving instanceof EntityWolf) {
                            data[3] = ((EntityWolf)eLiving).func_82186_bH();
                            data[4] = ((EntityWolf)eLiving).func_70922_bv() ? 1 : 0;
                        } else if (eLiving instanceof EntitySheep) {
                            data[3] = ((EntitySheep)eLiving).func_70896_n();
                            data[4] = ((EntitySheep)eLiving).func_70892_o() ? 1 : 0;
                        } else if (eLiving instanceof EntityOcelot) {
                            data[3] = ((EntityOcelot)eLiving).func_70913_u();
                        } else if (eLiving instanceof EntitySkeleton) {
                            data[3] = ((EntitySkeleton)eLiving).func_82202_m();
                        } else if (eLiving instanceof EntityZombie) {
                            data[3] = ((EntityZombie)eLiving).func_82231_m() ? 1 : 0;
                            data[4] = eLiving.func_70631_g_() ? 1 : 0;
                        }
                    }
                }
            } else {
                name = "";
            }
            GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_TELEMETRY, new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, name, data[0], data[1], data[2], data[3], data[4], strUUID}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 320.0));
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        Long msb = nbt.func_74763_f("entityUUIDMost");
        Long lsb = nbt.func_74763_f("entityUUIDLeast");
        this.toUpdate = new UUID(msb, lsb);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.linkedEntity != null && !this.linkedEntity.field_70128_L) {
            nbt.func_74772_a("entityUUIDMost", this.linkedEntity.func_110124_au().getMostSignificantBits());
            nbt.func_74772_a("entityUUIDLeast", this.linkedEntity.func_110124_au().getLeastSignificantBits());
        }
    }

    public void addTrackedEntity(UUID uuid) {
        this.pulseRate = 400;
        this.lastHurttime = 0;
        List eList = this.field_145850_b.field_72996_f;
        for (Entity e : eList) {
            if (!e.func_110124_au().equals(uuid)) continue;
            this.linkedEntity = e;
            if (e instanceof EntitySpaceshipBase) {
                ((EntitySpaceshipBase)e).addTelemetry(this);
            }
            return;
        }
        this.linkedEntity = null;
    }

    public void addTrackedEntity(Entity e) {
        this.pulseRate = 400;
        this.lastHurttime = 0;
        this.linkedEntity = e;
        if (e instanceof EntitySpaceshipBase) {
            ((EntitySpaceshipBase)e).addTelemetry(this);
        }
    }

    public void removeTrackedEntity() {
        this.pulseRate = 400;
        this.linkedEntity = null;
    }

    public static TileEntityTelemetry getNearest(TileEntity te) {
        if (te == null) {
            return null;
        }
        BlockVec3 target = new BlockVec3(te);
        int distSq = 1025;
        BlockVec3Dim nearest = null;
        int dim = te.func_145831_w().field_73011_w.field_76574_g;
        for (BlockVec3Dim telemeter : loadedList) {
            int dist;
            if (telemeter.dim != dim || (dist = telemeter.distanceSquared(target)) >= distSq) continue;
            distSq = dist;
            nearest = telemeter;
        }
        if (nearest == null) {
            return null;
        }
        TileEntity result = te.func_145831_w().func_147438_o(nearest.x, nearest.y, nearest.z);
        if (result instanceof TileEntityTelemetry) {
            return (TileEntityTelemetry)result;
        }
        return null;
    }

    public static void frequencyModulePlayer(ItemStack held, EntityPlayerMP player) {
        if (held == null) {
            return;
        }
        NBTTagCompound fmData = held.field_77990_d;
        if (fmData != null && fmData.func_74764_b("teDim")) {
            int dim = fmData.func_74762_e("teDim");
            int x = fmData.func_74762_e("teCoordX");
            int y = fmData.func_74762_e("teCoordY");
            int z = fmData.func_74762_e("teCoordZ");
            WorldProvider wp = WorldUtil.getProviderForDimensionServer(dim);
            if (wp == null || wp.field_76579_a == null) {
                GCLog.debug("Frequency module worn: world provider is null.  This is a bug. " + dim);
            } else {
                TileEntity te = wp.field_76579_a.func_147438_o(x, y, z);
                if (te instanceof TileEntityTelemetry) {
                    if (player == null) {
                        ((TileEntityTelemetry)te).removeTrackedEntity();
                    } else {
                        ((TileEntityTelemetry)te).addTrackedEntity(player.func_110124_au());
                    }
                }
            }
        }
    }

    public static void updateLinkedPlayer(EntityPlayerMP playerOld, EntityPlayerMP playerNew) {
        for (BlockVec3Dim telemeter : loadedList) {
            TileEntity te = telemeter.getTileEntityNoLoad();
            if (!(te instanceof TileEntityTelemetry) || ((TileEntityTelemetry)te).linkedEntity != playerOld) continue;
            ((TileEntityTelemetry)te).linkedEntity = playerNew;
        }
    }
}

