/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCargoLoader
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
ILandingPadAttachable {
    private ItemStack[] containingItems = new ItemStack[15];
    public boolean outOfItems;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean targetFull;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean targetNoInventory;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean noTarget;
    public ICargoEntity attachedFuelable;

    public TileEntityCargoLoader() {
        this.storage.setMaxExtract(45.0f);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticks % 100 == 0) {
                this.checkForCargoEntity();
            }
            if (this.attachedFuelable != null) {
                this.noTarget = false;
                ItemStack stack = this.removeCargo((boolean)false).resultStack;
                if (stack != null) {
                    this.outOfItems = false;
                    ICargoEntity.EnumCargoLoadingState state = this.attachedFuelable.addCargo(stack, false);
                    this.targetFull = state == ICargoEntity.EnumCargoLoadingState.FULL;
                    this.targetNoInventory = state == ICargoEntity.EnumCargoLoadingState.NOINVENTORY;
                    boolean bl = this.noTarget = state == ICargoEntity.EnumCargoLoadingState.NOTARGET;
                    if (this.ticks % 15 == 0 && state == ICargoEntity.EnumCargoLoadingState.SUCCESS && !this.disabled && this.hasEnoughEnergyToRun) {
                        this.attachedFuelable.addCargo(this.removeCargo((boolean)true).resultStack, true);
                    }
                } else {
                    this.outOfItems = true;
                }
            } else {
                this.noTarget = true;
            }
        }
    }

    public void checkForCargoEntity() {
        boolean foundFuelable = false;
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (dir == ForgeDirection.UNKNOWN) continue;
            TileEntity pad = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, dir);
            if (pad != null && pad instanceof TileEntityMulti) {
                TileEntity mainTile = ((TileEntityMulti)pad).getMainBlockTile();
                if (!(mainTile instanceof ICargoEntity)) continue;
                this.attachedFuelable = (ICargoEntity)mainTile;
                foundFuelable = true;
                break;
            }
            if (pad == null || !(pad instanceof ICargoEntity)) continue;
            this.attachedFuelable = (ICargoEntity)pad;
            foundFuelable = true;
            break;
        }
        if (!foundFuelable) {
            this.attachedFuelable = null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
    }

    @Override
    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("container.cargoloader.name");
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side != this.func_145832_p() + 2) {
            int[] nArray2 = new int[15];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArray2[5] = 5;
            nArray2[6] = 6;
            nArray2[7] = 7;
            nArray2[8] = 8;
            nArray2[9] = 9;
            nArray2[10] = 10;
            nArray2[11] = 11;
            nArray2[12] = 12;
            nArray2[13] = 13;
            nArray = nArray2;
            nArray2[14] = 14;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        if (side != this.func_145832_p() + 2) {
            if (slotID == 0) {
                return ItemElectricBase.isElectricItem(itemstack.func_77973_b());
            }
            return true;
        }
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return ItemElectricBase.isElectricItem(itemstack.func_77973_b());
        }
        return true;
    }

    @Override
    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        ItemStack stackAt;
        int count = 1;
        for (count = 1; count < this.containingItems.length; ++count) {
            stackAt = this.containingItems[count];
            if (stackAt == null || stackAt.func_77973_b() != stack.func_77973_b() || stackAt.func_77960_j() != stack.func_77960_j() || stackAt.field_77994_a >= stackAt.func_77976_d()) continue;
            if (stackAt.field_77994_a + stack.field_77994_a <= stackAt.func_77976_d()) {
                if (doAdd) {
                    this.containingItems[count].field_77994_a += stack.field_77994_a;
                    this.func_70296_d();
                }
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            int origSize = stackAt.field_77994_a;
            int surplus = origSize + stack.field_77994_a - stackAt.func_77976_d();
            if (doAdd) {
                this.containingItems[count].field_77994_a = stackAt.func_77976_d();
                this.func_70296_d();
            }
            stack.field_77994_a = surplus;
            if (this.addCargo(stack, doAdd) == ICargoEntity.EnumCargoLoadingState.SUCCESS) {
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            this.containingItems[count].field_77994_a = origSize;
            return ICargoEntity.EnumCargoLoadingState.FULL;
        }
        for (count = 1; count < this.containingItems.length; ++count) {
            stackAt = this.containingItems[count];
            if (stackAt != null) continue;
            if (doAdd) {
                this.containingItems[count] = stack;
                this.func_70296_d();
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        for (int i = 1; i < this.containingItems.length; ++i) {
            ItemStack stackAt = this.containingItems[i];
            if (stackAt == null) continue;
            ItemStack resultStack = stackAt.func_77946_l();
            resultStack.field_77994_a = 1;
            if (doRemove && --stackAt.field_77994_a <= 0) {
                this.containingItems[i] = null;
            }
            if (doRemove) {
                this.func_70296_d();
            }
            return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.SUCCESS, resultStack);
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.EMPTY, null);
    }

    @Override
    public boolean canAttachToLandingPad(IBlockAccess world, int x, int y, int z) {
        return true;
    }
}

