/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.event.ZeroGravityEvent;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.dimension.SpinManager;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.MinecraftForge;

public class FreefallHandler {
    private static double pPrevMotionX;
    public static double pPrevMotionY;
    private static double pPrevMotionZ;
    private static float jetpackBoost;
    public static boolean sneakLast;
    private final GCPlayerStatsClient stats;

    public FreefallHandler(GCPlayerStatsClient statsClient) {
        this.stats = statsClient;
    }

    public static boolean testFreefall(EntityPlayer player) {
        double blockYmax;
        int zz;
        ZeroGravityEvent.InFreefall zeroGEvent = new ZeroGravityEvent.InFreefall((EntityLivingBase)player);
        MinecraftForge.EVENT_BUS.post((Event)zeroGEvent);
        if (zeroGEvent.isCanceled()) {
            return false;
        }
        int playerFeetOnY = (int)(player.field_70121_D.field_72338_b - 0.01);
        int xx = MathHelper.func_76128_c((double)player.field_70165_t);
        Block b = player.field_70170_p.func_147439_a(xx, playerFeetOnY, zz = MathHelper.func_76128_c((double)player.field_70161_v));
        if (b.func_149688_o() != Material.field_151579_a && !(b instanceof BlockLiquid) && player.field_70121_D.field_72338_b - (blockYmax = (double)playerFeetOnY + b.func_149669_A()) < 0.01 && player.field_70121_D.field_72338_b - blockYmax > -0.5) {
            AxisAlignedBB collisionBox;
            player.field_70122_E = true;
            if (player.field_70121_D.field_72338_b - blockYmax > 0.0) {
                player.field_70163_u -= player.field_70121_D.field_72338_b - blockYmax;
                player.field_70121_D.func_72317_d(0.0, blockYmax - player.field_70121_D.field_72338_b, 0.0);
            } else if (b.func_149678_a(player.field_70170_p.func_72805_g(xx, playerFeetOnY, zz), false) && (collisionBox = b.func_149668_a(player.field_70170_p, xx, playerFeetOnY, zz)) != null && collisionBox.func_72326_a(player.field_70121_D)) {
                player.field_70163_u -= player.field_70121_D.field_72338_b - blockYmax;
                player.field_70121_D.func_72317_d(0.0, blockYmax - player.field_70121_D.field_72338_b, 0.0);
            }
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean testFreefall(EntityPlayerSP p, boolean flag) {
        boolean checkBlockWithinReach;
        World world = p.field_70170_p;
        WorldProvider worldProvider = world.field_73011_w;
        if (!(worldProvider instanceof IZeroGDimension)) {
            return false;
        }
        ZeroGravityEvent.InFreefall zeroGEvent = new ZeroGravityEvent.InFreefall((EntityLivingBase)p);
        MinecraftForge.EVENT_BUS.post((Event)zeroGEvent);
        if (zeroGEvent.isCanceled()) {
            return false;
        }
        if (this.stats.pjumpticks > 0 || this.stats.pWasOnGround && p.field_71158_b.field_78901_c) {
            return false;
        }
        if (p.field_70154_o != null) {
            Entity e = p.field_70154_o;
            if (e instanceof EntitySpaceshipBase) {
                return ((EntitySpaceshipBase)e).getLaunched();
            }
            if (e instanceof EntityLanderBase) {
                return false;
            }
        }
        if (!flag) {
            return false;
        }
        float rY = p.field_70177_z % 360.0f;
        double zreach = 0.0;
        double xreach = 0.0;
        if (rY < 80.0f || rY > 280.0f) {
            zreach = 0.2;
        }
        if (rY < 170.0f && rY > 10.0f) {
            xreach = 0.2;
        }
        if (rY < 260.0f && rY > 100.0f) {
            zreach = -0.2;
        }
        if (rY < 350.0f && rY > 190.0f) {
            xreach = -0.2;
        }
        AxisAlignedBB playerReach = p.field_70121_D.func_72321_a(xreach, 0.0, zreach);
        if (worldProvider instanceof WorldProviderSpaceStation) {
            SpinManager spinManager = ((WorldProviderSpaceStation)worldProvider).getSpinManager();
            checkBlockWithinReach = playerReach.field_72336_d >= (double)spinManager.ssBoundsMinX && playerReach.field_72340_a <= (double)spinManager.ssBoundsMaxX && playerReach.field_72337_e >= (double)spinManager.ssBoundsMinY && playerReach.field_72338_b <= (double)spinManager.ssBoundsMaxY && playerReach.field_72334_f >= (double)spinManager.ssBoundsMinZ && playerReach.field_72339_c <= (double)spinManager.ssBoundsMaxZ;
        } else {
            checkBlockWithinReach = true;
        }
        if (checkBlockWithinReach) {
            int xm = MathHelper.func_76128_c((double)playerReach.field_72340_a);
            int xx = MathHelper.func_76128_c((double)playerReach.field_72336_d);
            int ym = MathHelper.func_76128_c((double)playerReach.field_72338_b);
            int yy = MathHelper.func_76128_c((double)playerReach.field_72337_e);
            int zm = MathHelper.func_76128_c((double)playerReach.field_72339_c);
            int zz = MathHelper.func_76128_c((double)playerReach.field_72334_f);
            for (int x = xm; x <= xx; ++x) {
                for (int y = ym; y <= yy; ++y) {
                    for (int z = zm; z <= zz; ++z) {
                        Block b = world.func_147439_a(x, y, z);
                        if (Blocks.field_150350_a == b || GCBlocks.brightAir == b) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setupFreefallPre(EntityPlayerSP p) {
        jetpackBoost = 0.0f;
        pPrevMotionX = p.field_70159_w;
        pPrevMotionY = p.field_70181_x;
        pPrevMotionZ = p.field_70179_y;
    }

    public static void updateFreefall(EntityPlayer p) {
        pPrevMotionX = p.field_70159_w;
        pPrevMotionY = p.field_70181_x;
        pPrevMotionZ = p.field_70179_y;
    }

    @SideOnly(value=Side.CLIENT)
    public void preVanillaMotion(EntityPlayerSP p) {
        FreefallHandler.setupFreefallPre(p);
        this.stats.pWasOnGround = p.field_70122_E;
    }

    @SideOnly(value=Side.CLIENT)
    public void postVanillaMotion(EntityPlayerSP p) {
        boolean doCentrifugal;
        World world = p.field_70170_p;
        WorldProvider worldProvider = world.field_73011_w;
        if (!(worldProvider instanceof IZeroGDimension)) {
            return;
        }
        ZeroGravityEvent.Motion zeroGEvent = new ZeroGravityEvent.Motion((EntityLivingBase)p);
        MinecraftForge.EVENT_BUS.post((Event)zeroGEvent);
        if (zeroGEvent.isCanceled()) {
            return;
        }
        boolean freefall = this.stats.inFreefall;
        if (freefall) {
            p.field_70139_V = 0.0f;
        }
        this.stats.inFreefall = freefall = this.testFreefall(p, freefall);
        this.stats.inFreefallFirstCheck = true;
        SpinManager spinManager = null;
        if (worldProvider instanceof WorldProviderSpaceStation) {
            spinManager = ((WorldProviderSpaceStation)worldProvider).getSpinManager();
        }
        boolean bl = doCentrifugal = spinManager != null;
        if (freefall) {
            this.stats.pjumpticks = 0;
            p.field_70159_w /= (double)0.91f;
            p.field_70179_y /= (double)0.91f;
            p.field_70181_x /= (double)0.98f;
            if (spinManager != null) {
                doCentrifugal = spinManager.updatePlayerForSpin(p, 1.0f);
            }
            p.field_71075_bZ.field_75100_b = true;
            double dx = p.field_70159_w - pPrevMotionX;
            double dy = p.field_70181_x - pPrevMotionY;
            double dz = p.field_70179_y - pPrevMotionZ;
            p.field_70159_w -= dx / 1.2;
            p.field_70181_x -= dy / 1.2;
            p.field_70179_y -= dz / 1.2;
            if (p.field_70159_w > (double)1.2f) {
                p.field_70159_w = 1.2f;
            }
            if (p.field_70159_w < (double)-1.2f) {
                p.field_70159_w = -1.2f;
            }
            if (p.field_70181_x > (double)0.7f) {
                p.field_70181_x = 0.7f;
            }
            if (p.field_70181_x < (double)-0.7f) {
                p.field_70181_x = -0.7f;
            }
            if (p.field_70179_y > (double)1.2f) {
                p.field_70179_y = 1.2f;
            }
            if (p.field_70179_y < (double)-1.2f) {
                p.field_70179_y = -1.2f;
            }
        } else {
            double dy = p.field_70181_x - pPrevMotionY;
            if (p.field_71158_b.field_78901_c) {
                if ((p.field_70122_E || this.stats.pWasOnGround) && !p.field_71075_bZ.field_75098_d) {
                    if (this.stats.pjumpticks < 25) {
                        ++this.stats.pjumpticks;
                    }
                    p.field_70181_x -= dy;
                } else {
                    p.field_70181_x += 0.015;
                    if (this.stats.pjumpticks == 0) {
                        p.field_70181_x -= dy;
                    }
                }
            } else if (this.stats.pjumpticks > 0) {
                p.field_70181_x += 0.0145 * (double)this.stats.pjumpticks;
                this.stats.pjumpticks = 0;
            } else if (p.field_71158_b.field_78899_d) {
                if (!p.field_70122_E) {
                    p.field_70181_x -= 0.015;
                }
                this.stats.pjumpticks = 0;
            }
        }
        if (doCentrifugal && !p.field_70122_E) {
            spinManager.applyCentrifugalForce(p);
        }
        pPrevMotionX = p.field_70159_w;
        pPrevMotionY = p.field_70181_x;
        pPrevMotionZ = p.field_70179_y;
    }
}

