/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import cpw.mods.fml.client.FMLClientHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityAdvancedMotion;
import micdoodle8.mods.galacticraft.core.entities.IScaleableFuelLevel;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.inventory.IInventorySettable;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.network.PacketDynamicInventory;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public abstract class EntityLanderBase
extends EntityAdvancedMotion
implements IInventorySettable,
IScaleableFuelLevel {
    private final int FUEL_TANK_CAPACITY = 5000;
    public FluidTank fuelTank = new FluidTank(this.FUEL_TANK_CAPACITY);
    protected boolean hasReceivedPacket;
    private boolean lastShouldMove;
    private UUID persistantRiderUUID;
    private Boolean shouldMoveClient;
    private Boolean shouldMoveServer;
    private ArrayList prevData;
    private boolean networkDataChanged;

    public EntityLanderBase(World var1, float yOffset) {
        super(var1, yOffset);
        this.func_70105_a(3.0f, 3.0f);
    }

    @Override
    public void func_70043_V() {
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v);
        }
    }

    @Override
    public boolean shouldSendAdvancedMotionPacket() {
        return this.shouldMoveClient != null && this.shouldMoveServer != null;
    }

    @Override
    public boolean canSetPositionClient() {
        return this.shouldSendAdvancedMotionPacket();
    }

    @Override
    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.fuelTank.getFluid() == null ? 0.0 : (double)this.fuelTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.FUEL_TANK_CAPACITY);
    }

    public EntityLanderBase(World var1, double var2, double var4, double var6, float yOffset) {
        this(var1, yOffset);
        this.func_70107_b(var2, var4 + (double)this.field_70129_M, var6);
    }

    public EntityLanderBase(EntityPlayerMP player, float yOffset) {
        this(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, yOffset);
        GCPlayerStats stats = GCPlayerStats.get(player);
        this.containedItems = new ItemStack[stats.rocketStacks.length + 1];
        for (int i = 0; i < stats.rocketStacks.length; ++i) {
            ItemStack item;
            this.containedItems[i] = stats.rocketStacks[i] != null ? (item = stats.rocketStacks[i].func_77946_l()) : null;
        }
        this.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
        player.func_70078_a((Entity)this);
    }

    @Override
    public void func_70071_h_() {
        AxisAlignedBB box;
        List var15;
        EntityPlayer player;
        super.func_70071_h_();
        if (this.ticks < 40L && this.field_70163_u > 150.0 && this.field_70153_n == null && (player = this.field_70170_p.func_72890_a((Entity)this, 5.0)) != null && player.field_70154_o == null) {
            player.func_70078_a((Entity)this);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.checkFluidTankTransfer(this.containedItems.length - 1, this.fuelTank);
        }
        if ((var15 = this.field_70170_p.func_72839_b((Entity)this, box = this.field_70121_D.func_72314_b(0.2, 0.4, 0.2))) != null && !var15.isEmpty()) {
            for (Entity entity : var15) {
                if (entity == this.field_70153_n) continue;
                this.pushEntityAway(entity);
            }
        }
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        FluidUtil.tryFillContainerFuel(tank, this.containedItems, slot);
    }

    private void pushEntityAway(Entity entityToPush) {
        double d1;
        double d0;
        double d2;
        if (this.field_70153_n != entityToPush && this.field_70154_o != entityToPush && (d2 = MathHelper.func_76132_a((double)(d0 = this.field_70165_t - entityToPush.field_70165_t), (double)(d1 = this.field_70161_v - entityToPush.field_70161_v))) >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            entityToPush.func_70024_g(-(d0 *= (double)(1.0f - entityToPush.field_70144_Y)), 0.0, -(d1 *= (double)(1.0f - entityToPush.field_70144_Y)));
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        NBTTagList var2 = nbt.func_150295_c("Items", 10);
        int invSize = nbt.func_74762_e("rocketStacksLength");
        if (invSize < 3) {
            invSize = 3;
        }
        this.containedItems = new ItemStack[invSize];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.containedItems.length) continue;
            this.containedItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
        if (nbt.func_74764_b("RiderUUID_LSB")) {
            this.persistantRiderUUID = new UUID(nbt.func_74763_f("RiderUUID_LSB"), nbt.func_74763_f("RiderUUID_MSB"));
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        UUID id;
        NBTTagList nbttaglist = new NBTTagList();
        nbt.func_74768_a("rocketStacksLength", this.containedItems.length);
        for (int i = 0; i < this.containedItems.length; ++i) {
            if (this.containedItems[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.containedItems[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
        if ((id = this.getOwnerUUID()) != null) {
            nbt.func_74772_a("RiderUUID_LSB", id.getLeastSignificantBits());
            nbt.func_74772_a("RiderUUID_MSB", id.getMostSignificantBits());
        }
    }

    @Override
    public boolean shouldMove() {
        if (this.shouldMoveClient == null || this.shouldMoveServer == null) {
            return false;
        }
        if (this.ticks < 40L) {
            return false;
        }
        return !this.field_70122_E;
    }

    public abstract double getInitialMotionY();

    @Override
    public void tickInAir() {
        if (this.field_70170_p.field_72995_K) {
            if (!this.shouldMove()) {
                this.field_70179_y = 0.0;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
            }
            if (this.shouldMove() && !this.lastShouldMove) {
                this.field_70181_x = this.getInitialMotionY();
            }
            this.lastShouldMove = this.shouldMove();
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData() {
        ArrayList<Object> objList = new ArrayList<Object>();
        if (!this.field_70170_p.field_72995_K) {
            Integer cargoLength = this.containedItems != null ? this.containedItems.length : 0;
            objList.add(cargoLength);
            objList.add(this.fuelTank.getFluid() == null ? 0 : this.fuelTank.getFluid().amount);
        }
        if (this.field_70170_p.field_72995_K) {
            this.shouldMoveClient = this.shouldMove();
            objList.add(this.shouldMoveClient);
        } else {
            this.shouldMoveServer = this.shouldMove();
            objList.add(this.shouldMoveServer);
            objList.add(this.field_70153_n == null ? -1 : this.field_70153_n.func_145782_y());
        }
        this.networkDataChanged = !objList.equals(this.prevData);
        this.prevData = objList;
        return objList;
    }

    @Override
    public boolean networkedDataChanged() {
        return this.networkDataChanged || this.shouldMoveClient == null || this.shouldMoveServer == null;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @Override
    public int getPacketTickSpacing() {
        return 2;
    }

    @Override
    public double getPacketSendDistance() {
        return 250.0;
    }

    @Override
    public void readNetworkedData(ByteBuf buffer) {
        try {
            if (this.field_70170_p.field_72995_K) {
                if (!this.hasReceivedPacket) {
                    GalacticraftCore.packetPipeline.sendToServer(new PacketDynamic(this));
                    this.hasReceivedPacket = true;
                }
                int cargoLength = buffer.readInt();
                if (this.containedItems == null || this.containedItems.length == 0) {
                    this.containedItems = new ItemStack[cargoLength];
                    GalacticraftCore.packetPipeline.sendToServer(new PacketDynamicInventory(this));
                }
                this.fuelTank.setFluid(new FluidStack(GalacticraftCore.fluidFuel, buffer.readInt()));
                this.shouldMoveServer = buffer.readBoolean();
                int shouldBeMountedId = buffer.readInt();
                if (this.field_70153_n == null) {
                    Entity e;
                    if (shouldBeMountedId > -1 && (e = FMLClientHandler.instance().getWorldClient().func_73045_a(shouldBeMountedId)) != null) {
                        if (e.field_71093_bK != this.field_71093_bK) {
                            if (e instanceof EntityPlayer) {
                                e = WorldUtil.forceRespawnClient(this.field_71093_bK, e.field_70170_p.field_73013_u.func_151525_a(), e.field_70170_p.func_72912_H().func_76067_t().func_77127_a(), ((EntityPlayerMP)e).field_71134_c.func_73081_b().func_77148_a());
                                e.func_70078_a((Entity)this);
                            }
                        } else {
                            e.func_70078_a((Entity)this);
                        }
                    }
                } else if (this.field_70153_n.func_145782_y() != shouldBeMountedId) {
                    if (shouldBeMountedId == -1) {
                        this.field_70153_n.func_70078_a(null);
                    } else {
                        Entity e = FMLClientHandler.instance().getWorldClient().func_73045_a(shouldBeMountedId);
                        if (e != null) {
                            if (e.field_71093_bK != this.field_71093_bK) {
                                if (e instanceof EntityPlayer) {
                                    e = WorldUtil.forceRespawnClient(this.field_71093_bK, e.field_70170_p.field_73013_u.func_151525_a(), e.field_70170_p.func_72912_H().func_76067_t().func_77127_a(), ((EntityPlayerMP)e).field_71134_c.func_73081_b().func_77148_a());
                                    e.func_70078_a((Entity)this);
                                }
                            } else {
                                e.func_70078_a((Entity)this);
                            }
                        }
                    }
                }
            } else {
                this.shouldMoveClient = buffer.readBoolean();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean allowDamageSource(DamageSource damageSource) {
        return !damageSource.func_94541_c();
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        return new ArrayList<ItemStack>(Arrays.asList(this.containedItems));
    }

    public int func_70302_i_() {
        return this.containedItems.length;
    }

    @Override
    public void setSizeInventory(int size) {
        this.containedItems = new ItemStack[size];
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return false;
    }

    @Override
    public double getPacketRange() {
        return 50.0;
    }

    @Override
    public UUID getOwnerUUID() {
        UUID id;
        if (this.field_70153_n != null && !(this.field_70153_n instanceof EntityPlayer)) {
            return null;
        }
        if (this.field_70153_n != null) {
            id = this.field_70153_n.getPersistentID();
            if (id != null) {
                this.persistantRiderUUID = id;
            }
        } else {
            id = this.persistantRiderUUID;
        }
        return id;
    }
}

