/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import cpw.mods.fml.client.FMLClientHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.entity.IIgnoreShift;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.entities.EntityAdvancedMotion;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityCelestialFake
extends EntityAdvancedMotion
implements IIgnoreShift {
    private UUID persistantRiderUUID;
    private Boolean shouldMoveClient;
    private Boolean shouldMoveServer;
    private ArrayList prevData;
    private boolean networkDataChanged;

    public EntityCelestialFake(World var1) {
        this(var1, 0.0f);
    }

    public EntityCelestialFake(World var1, float yOffset) {
        super(var1, yOffset);
        this.func_70105_a(3.0f, 1.0f);
    }

    @Override
    public void func_70043_V() {
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v);
        }
    }

    @Override
    public boolean shouldSendAdvancedMotionPacket() {
        return this.shouldMoveClient != null && this.shouldMoveServer != null;
    }

    @Override
    public boolean canSetPositionClient() {
        return this.shouldSendAdvancedMotionPacket();
    }

    public EntityCelestialFake(World var1, double var2, double var4, double var6, float yOffset) {
        this(var1, yOffset);
        this.func_70107_b(var2, var4 + (double)this.field_70129_M, var6);
    }

    public EntityCelestialFake(EntityPlayerMP player, float yOffset) {
        this(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, yOffset);
        this.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
        this.field_70153_n = player;
        player.field_70154_o = this;
    }

    @Override
    public void func_70071_h_() {
        AxisAlignedBB box;
        List var15;
        EntityPlayer player;
        super.func_70071_h_();
        if (this.ticks < 40L && this.field_70163_u > 150.0 && this.field_70153_n == null && (player = this.field_70170_p.func_72890_a((Entity)this, 5.0)) != null && player.field_70154_o == null) {
            player.func_70078_a((Entity)this);
        }
        if ((var15 = this.field_70170_p.func_72839_b((Entity)this, box = this.field_70121_D.func_72314_b(0.2, 0.4, 0.2))) != null && !var15.isEmpty()) {
            for (Entity entity : var15) {
                if (entity == this.field_70153_n) continue;
                this.pushEntityAway(entity);
            }
        }
    }

    private void pushEntityAway(Entity entityToPush) {
        double d1;
        double d0;
        double d2;
        if (this.field_70153_n != entityToPush && this.field_70154_o != entityToPush && (d2 = MathHelper.func_76132_a((double)(d0 = this.field_70165_t - entityToPush.field_70165_t), (double)(d1 = this.field_70161_v - entityToPush.field_70161_v))) >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            entityToPush.func_70024_g(-(d0 *= (double)(1.0f - entityToPush.field_70144_Y)), 0.0, -(d1 *= (double)(1.0f - entityToPush.field_70144_Y)));
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("RiderUUID_LSB")) {
            this.persistantRiderUUID = new UUID(nbt.func_74763_f("RiderUUID_LSB"), nbt.func_74763_f("RiderUUID_MSB"));
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        UUID id = this.getOwnerUUID();
        if (id != null) {
            nbt.func_74772_a("RiderUUID_LSB", id.getLeastSignificantBits());
            nbt.func_74772_a("RiderUUID_MSB", id.getMostSignificantBits());
        }
    }

    @Override
    public boolean shouldMove() {
        return false;
    }

    @Override
    public void tickInAir() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData() {
        ArrayList<Object> objList = new ArrayList<Object>();
        if (this.field_70170_p.field_72995_K) {
            this.shouldMoveClient = this.shouldMove();
            objList.add(this.shouldMoveClient);
        } else {
            this.shouldMoveServer = this.shouldMove();
            objList.add(this.shouldMoveServer);
            objList.add(this.field_70153_n == null ? -1 : this.field_70153_n.func_145782_y());
        }
        this.networkDataChanged = !objList.equals(this.prevData);
        this.prevData = objList;
        return objList;
    }

    @Override
    public boolean networkedDataChanged() {
        return this.networkDataChanged;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @Override
    public int getPacketTickSpacing() {
        return 2;
    }

    @Override
    public double getPacketSendDistance() {
        return 500.0;
    }

    @Override
    public void readNetworkedData(ByteBuf buffer) {
        try {
            if (this.field_70170_p.field_72995_K) {
                this.shouldMoveServer = buffer.readBoolean();
                int shouldBeMountedId = buffer.readInt();
                if (this.field_70153_n == null) {
                    Entity e;
                    if (shouldBeMountedId > -1 && (e = FMLClientHandler.instance().getWorldClient().func_73045_a(shouldBeMountedId)) != null) {
                        e.func_70078_a((Entity)this);
                    }
                } else if (this.field_70153_n.func_145782_y() != shouldBeMountedId) {
                    if (shouldBeMountedId == -1) {
                        this.field_70153_n.func_70078_a(null);
                    } else {
                        Entity e = FMLClientHandler.instance().getWorldClient().func_73045_a(shouldBeMountedId);
                        if (e != null) {
                            e.func_70078_a((Entity)this);
                        }
                    }
                }
            } else {
                this.shouldMoveClient = buffer.readBoolean();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean allowDamageSource(DamageSource damageSource) {
        return !damageSource.func_94541_c();
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        return null;
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return false;
    }

    @Override
    public double getPacketRange() {
        return 50.0;
    }

    @Override
    public UUID getOwnerUUID() {
        UUID id;
        if (this.field_70153_n != null && !(this.field_70153_n instanceof EntityPlayer)) {
            return null;
        }
        if (this.field_70153_n != null) {
            id = this.field_70153_n.getPersistentID();
            if (id != null) {
                this.persistantRiderUUID = id;
            }
        } else {
            id = this.persistantRiderUUID;
        }
        return id;
    }

    @Override
    public boolean pressKey(int key) {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public boolean shouldSpawnParticles() {
        return false;
    }

    @Override
    public Map<Vector3, Vector3> getParticleMap() {
        return null;
    }

    @Override
    public EntityFX getParticle(Random rand, double x, double y, double z, double motX, double motY, double motZ) {
        return null;
    }

    @Override
    public void tickOnGround() {
        this.tickInAir();
    }

    @Override
    public void onGroundHit() {
    }

    @Override
    public Vector3 getMotionVec() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    @Override
    public boolean shouldIgnoreShiftExit() {
        return true;
    }
}

