/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.grid;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.FMLLog;
import ic2.api.energy.tile.IEnergySink;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.transmission.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.energy.grid.NetworkFinder;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyNetwork
implements IElectricityNetwork {
    private final boolean isMekLoaded = EnergyConfigHandler.isMekanismLoaded() && !EnergyConfigHandler.disableMekanismOutput;
    private final boolean isRF1Loaded = EnergyConfigHandler.isRFAPIv1Loaded() && !EnergyConfigHandler.disableRFOutput;
    private final boolean isRF2Loaded = EnergyConfigHandler.isRFAPIv2Loaded() && !EnergyConfigHandler.disableRFOutput;
    private final boolean isIC2Loaded = EnergyConfigHandler.isIndustrialCraft2Loaded() && !EnergyConfigHandler.disableIC2Output;
    private final boolean isBCLoaded = EnergyConfigHandler.isBuildcraftLoaded() && !EnergyConfigHandler.disableBuildCraftOutput;
    public static int tickCount = 0;
    private int tickDone = -1;
    private float totalRequested = 0.0f;
    private float totalStorageExcess = 0.0f;
    private float totalEnergy = 0.0f;
    private float totalSent = 0.0f;
    private boolean doneScheduled = false;
    private boolean spamstop = false;
    private boolean loopPrevention = false;
    public int networkTierGC = 1;
    private int producersTierGC = 1;
    private final List<TileEntity> connectedAcceptors = new LinkedList<TileEntity>();
    private final List<ForgeDirection> connectedDirections = new LinkedList<ForgeDirection>();
    private final Set<TileEntity> availableAcceptors = new HashSet<TileEntity>();
    private final Map<TileEntity, ForgeDirection> availableconnectedDirections = new HashMap<TileEntity, ForgeDirection>();
    private final Map<TileEntity, Float> energyRequests = new HashMap<TileEntity, Float>();
    private final List<TileEntity> ignoreAcceptors = new LinkedList<TileEntity>();
    private final Set<IConductor> conductors = new HashSet<IConductor>();
    private static final float ENERGY_STORAGE_LEVEL = 200.0f;

    @Override
    public Set<IConductor> getTransmitters() {
        return this.conductors;
    }

    @Override
    public float getRequest(TileEntity ... ignoreTiles) {
        if (tickCount != this.tickDone) {
            this.ignoreAcceptors.clear();
            this.ignoreAcceptors.addAll(Arrays.asList(ignoreTiles));
            this.doTickStartCalc();
        }
        return this.totalRequested - this.totalEnergy - this.totalSent;
    }

    @Override
    public float produce(float energy, boolean doReceive, int producerTier, TileEntity ... ignoreTiles) {
        if (this.loopPrevention) {
            return energy;
        }
        if (energy > 0.0f) {
            if (tickCount != this.tickDone) {
                this.tickDone = tickCount;
                this.ignoreAcceptors.clear();
                this.ignoreAcceptors.addAll(Arrays.asList(ignoreTiles));
                this.producersTierGC = 1;
                this.doTickStartCalc();
            } else {
                this.ignoreAcceptors.addAll(Arrays.asList(ignoreTiles));
            }
            if (!this.doneScheduled && this.totalRequested > 0.0f) {
                TickHandlerServer.scheduleNetworkTick(this);
                this.doneScheduled = true;
            }
            float totalEnergyLast = this.totalEnergy;
            if (doReceive) {
                this.totalEnergy += Math.min(energy, this.totalRequested - totalEnergyLast);
                if (producerTier > 1) {
                    this.producersTierGC = 2;
                }
            }
            if (this.totalRequested >= totalEnergyLast + energy) {
                return 0.0f;
            }
            if (totalEnergyLast >= this.totalRequested) {
                return energy;
            }
            return totalEnergyLast + energy - this.totalRequested;
        }
        return energy;
    }

    public void tickEnd() {
        this.doneScheduled = false;
        this.loopPrevention = true;
        if (this.totalEnergy > 0.0f) {
            this.doTickStartCalc();
            if (this.totalRequested > 0.0f) {
                this.totalSent = this.doProduce();
                this.totalEnergy = this.totalSent < this.totalEnergy ? (this.totalEnergy -= this.totalSent) : 0.0f;
            } else {
                this.totalEnergy = 0.0f;
            }
        } else {
            this.totalEnergy = 0.0f;
        }
        this.loopPrevention = false;
    }

    private void doTickStartCalc() {
        this.tickDone = tickCount;
        this.totalSent = 0.0f;
        this.refreshAcceptors();
        if (!EnergyUtil.initialisedIC2Methods) {
            EnergyUtil.initialiseIC2Methods();
        }
        if (this.conductors.size() == 0) {
            return;
        }
        this.loopPrevention = true;
        this.availableAcceptors.clear();
        this.availableconnectedDirections.clear();
        this.energyRequests.clear();
        this.totalRequested = 0.0f;
        this.totalStorageExcess = 0.0f;
        if (!this.connectedAcceptors.isEmpty()) {
            Iterator<ForgeDirection> acceptorDirection = this.connectedDirections.iterator();
            for (TileEntity acceptor : this.connectedAcceptors) {
                ForgeDirection sideFrom = acceptorDirection.next();
                if (this.ignoreAcceptors.contains(acceptor) || this.availableAcceptors.contains(acceptor)) continue;
                float e = 0.0f;
                if (acceptor instanceof IElectrical) {
                    e = ((IElectrical)acceptor).getRequest(sideFrom);
                } else if (this.isIC2Loaded && acceptor instanceof IEnergySink) {
                    double result;
                    block13: {
                        result = 0.0;
                        try {
                            result = (Double)EnergyUtil.demandedEnergyIC2.invoke((Object)acceptor, new Object[0]);
                        }
                        catch (Exception ex) {
                            if (!ConfigManagerCore.enableDebug) break block13;
                            ex.printStackTrace();
                        }
                    }
                    result = Math.min(result, this.networkTierGC == 2 ? 256.0 : 128.0);
                    e = (float)result / EnergyConfigHandler.TO_IC2_RATIO;
                } else if (this.isRF2Loaded && acceptor instanceof IEnergyReceiver) {
                    e = (float)((IEnergyReceiver)acceptor).receiveEnergy(sideFrom, Integer.MAX_VALUE, true) / EnergyConfigHandler.TO_RF_RATIO;
                } else if (this.isRF1Loaded && acceptor instanceof IEnergyHandler) {
                    e = (float)((IEnergyHandler)acceptor).receiveEnergy(sideFrom, Integer.MAX_VALUE, true) / EnergyConfigHandler.TO_RF_RATIO;
                }
                if (!(e > 0.0f)) continue;
                this.availableAcceptors.add(acceptor);
                this.availableconnectedDirections.put(acceptor, sideFrom);
                this.energyRequests.put(acceptor, Float.valueOf(e));
                this.totalRequested += e;
                if (!(e > 200.0f)) continue;
                this.totalStorageExcess += e - 200.0f;
            }
        }
        this.loopPrevention = false;
    }

    private float doProduce() {
        float returnvalue;
        float sent;
        block27: {
            sent = 0.0f;
            if (!this.availableAcceptors.isEmpty()) {
                float energyNeeded = this.totalRequested;
                float energyAvailable = this.totalEnergy;
                float reducor = 1.0f;
                float energyStorageReducor = 1.0f;
                if (energyNeeded > energyAvailable) {
                    if ((energyNeeded -= this.totalStorageExcess) > energyAvailable) {
                        energyStorageReducor = 0.0f;
                        reducor = energyAvailable / energyNeeded;
                    } else {
                        energyStorageReducor = (energyAvailable - energyNeeded) / this.totalStorageExcess;
                    }
                }
                int tierProduced = Math.min(this.producersTierGC, this.networkTierGC);
                TileEntity debugTE = null;
                try {
                    Iterator<TileEntity> iterator = this.availableAcceptors.iterator();
                    while (iterator.hasNext()) {
                        float sentToAcceptor;
                        TileEntity tileEntity;
                        debugTE = tileEntity = iterator.next();
                        if (sent >= energyAvailable) break;
                        float currentSending = this.energyRequests.get(tileEntity).floatValue();
                        if (currentSending > 200.0f) {
                            currentSending = 200.0f + (currentSending - 200.0f) * energyStorageReducor;
                        }
                        if ((currentSending *= reducor) > energyAvailable - sent) {
                            currentSending = energyAvailable - sent;
                        }
                        ForgeDirection sideFrom = this.availableconnectedDirections.get(tileEntity);
                        if (tileEntity instanceof IElectrical) {
                            sentToAcceptor = ((IElectrical)tileEntity).receiveElectricity(sideFrom, currentSending, tierProduced, true);
                        } else if (this.isIC2Loaded && tileEntity instanceof IEnergySink) {
                            double energySendingIC2 = currentSending * EnergyConfigHandler.TO_IC2_RATIO;
                            if (energySendingIC2 >= 1.0) {
                                double result;
                                block28: {
                                    result = 0.0;
                                    try {
                                        result = EnergyUtil.voltageParameterIC2 ? ((Double)EnergyUtil.injectEnergyIC2.invoke((Object)tileEntity, sideFrom, energySendingIC2, 120.0)).doubleValue() : ((Double)EnergyUtil.injectEnergyIC2.invoke((Object)tileEntity, sideFrom, energySendingIC2)).doubleValue();
                                    }
                                    catch (Exception ex) {
                                        if (!ConfigManagerCore.enableDebug) break block28;
                                        ex.printStackTrace();
                                    }
                                }
                                sentToAcceptor = currentSending - (float)result / EnergyConfigHandler.TO_IC2_RATIO;
                                if (sentToAcceptor < 0.0f) {
                                    sentToAcceptor = 0.0f;
                                }
                            } else {
                                sentToAcceptor = 0.0f;
                            }
                        } else if (this.isRF2Loaded && tileEntity instanceof IEnergyReceiver) {
                            int currentSendinginRF = currentSending >= 2.1474836E9f / EnergyConfigHandler.TO_RF_RATIO ? Integer.MAX_VALUE : (int)(currentSending * EnergyConfigHandler.TO_RF_RATIO);
                            sentToAcceptor = (float)((IEnergyReceiver)tileEntity).receiveEnergy(sideFrom, currentSendinginRF, false) / EnergyConfigHandler.TO_RF_RATIO;
                        } else if (this.isRF1Loaded && tileEntity instanceof IEnergyHandler) {
                            int currentSendinginRF = currentSending >= 2.1474836E9f / EnergyConfigHandler.TO_RF_RATIO ? Integer.MAX_VALUE : (int)(currentSending * EnergyConfigHandler.TO_RF_RATIO);
                            sentToAcceptor = (float)((IEnergyHandler)tileEntity).receiveEnergy(sideFrom, currentSendinginRF, false) / EnergyConfigHandler.TO_RF_RATIO;
                        } else {
                            sentToAcceptor = 0.0f;
                        }
                        if (sentToAcceptor / currentSending > 1.002f && sentToAcceptor > 0.01f) {
                            if (!this.spamstop) {
                                FMLLog.info((String)("Energy network: acceptor took too much energy, offered " + currentSending + ", took " + sentToAcceptor + ". " + tileEntity.toString()), (Object[])new Object[0]);
                                this.spamstop = true;
                            }
                            sentToAcceptor = currentSending;
                        }
                        sent += sentToAcceptor;
                    }
                }
                catch (Exception e) {
                    GCLog.severe("DEBUG Energy network loop issue, please report this");
                    if (debugTE == null) break block27;
                    GCLog.severe("Problem was likely caused by tile in dim " + debugTE.func_145831_w().field_73011_w.field_76574_g + " at " + debugTE.field_145851_c + "," + debugTE.field_145848_d + "," + debugTE.field_145849_e + " Type:" + debugTE.getClass().getSimpleName());
                }
            }
        }
        if (tickCount % 200 == 0) {
            this.spamstop = false;
        }
        if ((returnvalue = sent) > this.totalEnergy) {
            returnvalue = this.totalEnergy;
        }
        if (returnvalue < 0.0f) {
            returnvalue = 0.0f;
        }
        return returnvalue;
    }

    public void refreshWithChecks() {
        int tierfound = 2;
        Iterator<IConductor> it = this.conductors.iterator();
        while (it.hasNext()) {
            IConductor conductor = it.next();
            if (conductor == null) {
                it.remove();
                continue;
            }
            TileEntity tile = (TileEntity)conductor;
            World world = tile.func_145831_w();
            if (tile.func_145837_r() || world == null || !world.func_72899_e(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)) {
                it.remove();
                continue;
            }
            if (conductor != world.func_147438_o(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)) {
                it.remove();
                continue;
            }
            if (conductor.getTierGC() < 2) {
                tierfound = 1;
            }
            if (conductor.getNetwork() == this) continue;
            conductor.setNetwork(this);
            conductor.onNetworkChanged();
        }
        this.networkTierGC = tierfound;
    }

    @Override
    public void refresh() {
        int tierfound = 2;
        Iterator<IConductor> it = this.conductors.iterator();
        while (it.hasNext()) {
            IConductor conductor = it.next();
            if (conductor == null) {
                it.remove();
                continue;
            }
            TileEntity tile = (TileEntity)conductor;
            World world = tile.func_145831_w();
            if (tile.func_145837_r() || world == null) {
                it.remove();
                continue;
            }
            if (conductor.getTierGC() < 2) {
                tierfound = 1;
            }
            if (conductor.getNetwork() == this) continue;
            conductor.setNetwork(this);
            conductor.onNetworkChanged();
        }
        this.networkTierGC = tierfound;
    }

    private void refreshAcceptors() {
        this.connectedAcceptors.clear();
        this.connectedDirections.clear();
        this.refreshWithChecks();
        try {
            LinkedList<IConductor> conductorsCopy = new LinkedList<IConductor>();
            conductorsCopy.addAll(this.conductors);
            for (IConductor conductor : conductorsCopy) {
                EnergyUtil.setAdjacentPowerConnections((TileEntity)conductor, this.connectedAcceptors, this.connectedDirections);
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"GC Aluminium Wire: Error when testing whether another mod's tileEntity can accept energy.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public IElectricityNetwork merge(IElectricityNetwork network) {
        if (network != null && network != this) {
            Set<IConductor> thisNetwork = this.conductors;
            Set thatNetwork = network.getTransmitters();
            if (thisNetwork.size() >= thatNetwork.size()) {
                thisNetwork.addAll(thatNetwork);
                this.refresh();
                if (network instanceof EnergyNetwork) {
                    ((EnergyNetwork)network).destroy();
                }
                return this;
            }
            thatNetwork.addAll(thisNetwork);
            network.refresh();
            this.destroy();
            return network;
        }
        return this;
    }

    private void destroy() {
        this.conductors.clear();
        this.connectedAcceptors.clear();
        this.availableAcceptors.clear();
        this.totalEnergy = 0.0f;
        this.totalRequested = 0.0f;
        try {
            Class<?> clazz = Class.forName("micdoodle8.mods.galacticraft.core.tick.TickHandlerServer");
            clazz.getMethod("removeNetworkTick", this.getClass()).invoke(null, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void split(IConductor splitPoint) {
        if (splitPoint instanceof TileEntity) {
            this.getTransmitters().remove(splitPoint);
            splitPoint.setNetwork(null);
            if (this.getTransmitters().size() > 1) {
                World world = ((TileEntity)splitPoint).func_145831_w();
                if (this.getTransmitters().size() > 0) {
                    TileEntity[] nextToSplit = new TileEntity[6];
                    boolean[] toDo = new boolean[]{true, true, true, true, true, true};
                    int xCoord = ((TileEntity)splitPoint).field_145851_c;
                    int yCoord = ((TileEntity)splitPoint).field_145848_d;
                    int zCoord = ((TileEntity)splitPoint).field_145849_e;
                    for (int j = 0; j < 6; ++j) {
                        TileEntity tileEntity;
                        switch (j) {
                            case 0: {
                                tileEntity = world.func_147438_o(xCoord, yCoord - 1, zCoord);
                                break;
                            }
                            case 1: {
                                tileEntity = world.func_147438_o(xCoord, yCoord + 1, zCoord);
                                break;
                            }
                            case 2: {
                                tileEntity = world.func_147438_o(xCoord, yCoord, zCoord - 1);
                                break;
                            }
                            case 3: {
                                tileEntity = world.func_147438_o(xCoord, yCoord, zCoord + 1);
                                break;
                            }
                            case 4: {
                                tileEntity = world.func_147438_o(xCoord - 1, yCoord, zCoord);
                                break;
                            }
                            case 5: {
                                tileEntity = world.func_147438_o(xCoord + 1, yCoord, zCoord);
                                break;
                            }
                            default: {
                                tileEntity = null;
                            }
                        }
                        if (tileEntity instanceof IConductor) {
                            nextToSplit[j] = tileEntity;
                            continue;
                        }
                        toDo[j] = false;
                    }
                    for (int i1 = 0; i1 < 6; ++i1) {
                        if (!toDo[i1]) continue;
                        TileEntity connectedBlockA = nextToSplit[i1];
                        NetworkFinder finder = new NetworkFinder(world, new BlockVec3(connectedBlockA), new BlockVec3((TileEntity)splitPoint));
                        List<IConductor> partNetwork = finder.exploreNetwork();
                        for (int i2 = i1 + 1; i2 < 6; ++i2) {
                            TileEntity connectedBlockB = nextToSplit[i2];
                            if (!toDo[i2] || !partNetwork.contains(connectedBlockB)) continue;
                            toDo[i2] = false;
                        }
                        EnergyNetwork newNetwork = new EnergyNetwork();
                        newNetwork.getTransmitters().addAll(partNetwork);
                        newNetwork.refreshWithChecks();
                    }
                    this.destroy();
                }
            } else if (this.getTransmitters().size() == 0) {
                this.destroy();
            }
        }
    }

    public String toString() {
        return "EnergyNetwork[" + this.hashCode() + "|Wires:" + this.getTransmitters().size() + "|Acceptors:" + this.connectedAcceptors.size() + "]";
    }
}

