/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.gui.screen;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.text.Bidi;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SmallFontRenderer
implements IResourceManagerReloadListener {
    private static final ResourceLocation[] field_111274_c = new ResourceLocation[256];
    private final int[] charWidth = new int[256];
    public int FONT_HEIGHT = 9;
    public Random fontRandom = new Random();
    private final byte[] glyphWidth = new byte[65536];
    private final int[] colorCode = new int[32];
    private final ResourceLocation field_111273_g;
    private final TextureManager renderEngine;
    private float posX;
    private float posY;
    private boolean unicodeFlag;
    private boolean bidiFlag;
    private float red;
    private float blue;
    private float green;
    private float alpha;
    private int textColor;
    private boolean randomStyle;
    private boolean boldStyle;
    private boolean italicStyle;
    private boolean underlineStyle;
    private boolean strikethroughStyle;

    public SmallFontRenderer(GameSettings par1GameSettings, ResourceLocation par2ResourceLocation, TextureManager par3TextureManager, boolean par4) {
        this.field_111273_g = par2ResourceLocation;
        this.renderEngine = par3TextureManager;
        this.unicodeFlag = true;
        for (int i = 0; i < 32; ++i) {
            int j = (i >> 3 & 1) * 85;
            int k = (i >> 2 & 1) * 170 + j;
            int l = (i >> 1 & 1) * 170 + j;
            int i1 = (i & 1) * 170 + j;
            if (i == 6) {
                k += 85;
            }
            if (par1GameSettings.field_74337_g) {
                int j1 = (k * 30 + l * 59 + i1 * 11) / 100;
                int k1 = (k * 30 + l * 70) / 100;
                int l1 = (k * 30 + i1 * 70) / 100;
                k = j1;
                l = k1;
                i1 = l1;
            }
            if (i >= 16) {
                k /= 4;
                l /= 4;
                i1 /= 4;
            }
            this.colorCode[i] = (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
        }
        this.readGlyphSizes();
    }

    private void func_111272_d() {
        BufferedImage bufferedimage;
        try {
            bufferedimage = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(this.field_111273_g).func_110527_b());
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        int i = bufferedimage.getWidth();
        int j = bufferedimage.getHeight();
        int[] aint = new int[i * j];
        bufferedimage.getRGB(0, 0, i, j, aint, 0, i);
        int k = j / 16;
        int l = i / 16;
        boolean b0 = true;
        float f = 8.0f / (float)l;
        for (int i1 = 0; i1 < 256; ++i1) {
            int l1;
            int j1 = i1 % 16;
            int k1 = i1 / 16;
            if (i1 == 32) {
                this.charWidth[i1] = 4;
            }
            for (l1 = l - 1; l1 >= 0; --l1) {
                int i2 = j1 * l + l1;
                boolean flag = true;
                for (int j2 = 0; j2 < k && flag; ++j2) {
                    int k2 = (k1 * l + j2) * i;
                    if ((aint[i2 + k2] >> 24 & 0xFF) == 0) continue;
                    flag = false;
                }
                if (!flag) break;
            }
            this.charWidth[i1] = (int)(0.5 + (double)((float)(++l1) * f)) + 1;
        }
    }

    private void readGlyphSizes() {
        try {
            InputStream inputstream = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("font/glyph_sizes.bin")).func_110527_b();
            inputstream.read(this.glyphWidth);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
    }

    private float renderCharAtPos(int par1, char par2, boolean par3) {
        return par2 == ' ' ? 4.0f : (par1 > 0 && !this.unicodeFlag ? this.renderDefaultChar(par1 + 32, par3) : this.renderUnicodeChar(par2, par3));
    }

    private float renderDefaultChar(int par1, boolean par2) {
        float f = par1 % 16 * 8;
        float f1 = par1 / 16 * 8;
        float f2 = par2 ? 1.0f : 0.0f;
        this.renderEngine.func_110577_a(this.field_111273_g);
        float f3 = (float)this.charWidth[par1] - 0.01f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)(this.posX + f2), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.posX - f2), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f + f3 - 1.0f) / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)(this.posX + f3 - 1.0f + f2), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)((f + f3 - 1.0f) / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.posX + f3 - 1.0f - f2), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glEnd();
        return this.charWidth[par1];
    }

    private ResourceLocation func_111271_a(int par1) {
        if (field_111274_c[par1] == null) {
            SmallFontRenderer.field_111274_c[par1] = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", par1));
        }
        return field_111274_c[par1];
    }

    private void loadGlyphTexture(int par1) {
        this.renderEngine.func_110577_a(this.func_111271_a(par1));
    }

    private float renderUnicodeChar(char par1, boolean par2) {
        if (this.glyphWidth[par1] == 0) {
            return 0.0f;
        }
        int i = par1 / 256;
        this.loadGlyphTexture(i);
        int j = this.glyphWidth[par1] >>> 4;
        int k = this.glyphWidth[par1] & 0xF;
        float f1 = k + 1;
        float f2 = par1 % 16 * 16 + j;
        float f3 = (par1 & 0xFF) / 16 * 16;
        float f4 = f1 - (float)j - 0.02f;
        float f5 = par2 ? 1.0f : 0.0f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)(this.posX + f5), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.posX - f5), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)(this.posX + f4 / 2.0f + f5), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.posX + f4 / 2.0f - f5), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glEnd();
        return (f1 - (float)j) / 2.0f + 1.0f;
    }

    public int drawStringWithShadow(String par1Str, int par2, int par3, int par4) {
        return this.drawString(par1Str, par2, par3, par4, true);
    }

    public int drawString(String par1Str, int par2, int par3, int par4) {
        return this.drawString(par1Str, par2, par3, par4, false);
    }

    public int drawString(String par1Str, int par2, int par3, int par4, boolean par5) {
        int l;
        this.resetStyles();
        if (this.bidiFlag) {
            par1Str = this.bidiReorder(par1Str);
        }
        if (par5) {
            l = this.renderString(par1Str, par2 + 1, par3 + 1, par4, true);
            l = Math.max(l, this.renderString(par1Str, par2, par3, par4, false));
        } else {
            l = this.renderString(par1Str, par2, par3, par4, false);
        }
        return l;
    }

    private String bidiReorder(String par1Str) {
        if (par1Str != null && Bidi.requiresBidi(par1Str.toCharArray(), 0, par1Str.length())) {
            int i;
            Bidi bidi = new Bidi(par1Str, -2);
            byte[] abyte = new byte[bidi.getRunCount()];
            Object[] astring = new String[abyte.length];
            for (int j = 0; j < abyte.length; ++j) {
                int k = bidi.getRunStart(j);
                i = bidi.getRunLimit(j);
                int l = bidi.getRunLevel(j);
                String s1 = par1Str.substring(k, i);
                abyte[j] = (byte)l;
                astring[j] = s1;
            }
            String[] astring1 = (String[])astring.clone();
            Bidi.reorderVisually(abyte, 0, astring, 0, abyte.length);
            StringBuilder stringbuilder = new StringBuilder();
            for (i = 0; i < astring.length; ++i) {
                int i1;
                byte b0 = abyte[i];
                for (i1 = 0; i1 < astring1.length; ++i1) {
                    if (!astring1[i1].equals(astring[i])) {
                        continue;
                    }
                    b0 = abyte[i1];
                    break;
                }
                if ((b0 & 1) == 0) {
                    stringbuilder.append((String)astring[i]);
                    continue;
                }
                for (i1 = ((String)astring[i]).length() - 1; i1 >= 0; --i1) {
                    char c0 = ((String)astring[i]).charAt(i1);
                    if (c0 == '(') {
                        c0 = ')';
                    } else if (c0 == ')') {
                        c0 = '(';
                    }
                    stringbuilder.append(c0);
                }
            }
            return stringbuilder.toString();
        }
        return par1Str;
    }

    private void resetStyles() {
        this.randomStyle = false;
        this.boldStyle = false;
        this.italicStyle = false;
        this.underlineStyle = false;
        this.strikethroughStyle = false;
    }

    private void renderStringAtPos(String par1Str, boolean par2) {
        for (int i = 0; i < par1Str.length(); ++i) {
            Tessellator tessellator;
            boolean flag1;
            int k;
            int j;
            char c0 = par1Str.charAt(i);
            if (c0 == '\u00a7' && i + 1 < par1Str.length()) {
                j = "0123456789abcdefklmnor".indexOf(par1Str.toLowerCase().charAt(i + 1));
                if (j < 16) {
                    this.randomStyle = false;
                    this.boldStyle = false;
                    this.strikethroughStyle = false;
                    this.underlineStyle = false;
                    this.italicStyle = false;
                    if (j < 0 || j > 15) {
                        j = 15;
                    }
                    if (par2) {
                        j += 16;
                    }
                    this.textColor = k = this.colorCode[j];
                    GL11.glColor4f((float)((float)(k >> 16) / 255.0f), (float)((float)(k >> 8 & 0xFF) / 255.0f), (float)((float)(k & 0xFF) / 255.0f), (float)this.alpha);
                } else if (j == 16) {
                    this.randomStyle = true;
                } else if (j == 17) {
                    this.boldStyle = true;
                } else if (j == 18) {
                    this.strikethroughStyle = true;
                } else if (j == 19) {
                    this.underlineStyle = true;
                } else if (j == 20) {
                    this.italicStyle = true;
                } else if (j == 21) {
                    this.randomStyle = false;
                    this.boldStyle = false;
                    this.strikethroughStyle = false;
                    this.underlineStyle = false;
                    this.italicStyle = false;
                    GL11.glColor4f((float)this.red, (float)this.blue, (float)this.green, (float)this.alpha);
                }
                ++i;
                continue;
            }
            j = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(c0);
            if (this.randomStyle && j != -1) {
                while (this.charWidth[j] != this.charWidth[k = this.fontRandom.nextInt(this.charWidth.length)]) {
                }
                j = k;
            }
            float f = this.unicodeFlag ? 0.5f : 1.0f;
            boolean bl = flag1 = (c0 == '\u0000' || j == -1 || this.unicodeFlag) && par2;
            if (flag1) {
                this.posX -= f;
                this.posY -= f;
            }
            float f1 = this.renderCharAtPos(j, c0, this.italicStyle);
            if (flag1) {
                this.posX += f;
                this.posY += f;
            }
            if (this.boldStyle) {
                this.posX += f;
                if (flag1) {
                    this.posX -= f;
                    this.posY -= f;
                }
                this.renderCharAtPos(j, c0, this.italicStyle);
                this.posX -= f;
                if (flag1) {
                    this.posX += f;
                    this.posY += f;
                }
                f1 += 1.0f;
            }
            if (this.strikethroughStyle) {
                tessellator = Tessellator.field_78398_a;
                GL11.glDisable((int)3553);
                tessellator.func_78382_b();
                tessellator.func_78377_a((double)this.posX, (double)(this.posY + (float)(this.FONT_HEIGHT / 2)), 0.0);
                tessellator.func_78377_a((double)(this.posX + f1), (double)(this.posY + (float)(this.FONT_HEIGHT / 2)), 0.0);
                tessellator.func_78377_a((double)(this.posX + f1), (double)(this.posY + (float)(this.FONT_HEIGHT / 2) - 1.0f), 0.0);
                tessellator.func_78377_a((double)this.posX, (double)(this.posY + (float)(this.FONT_HEIGHT / 2) - 1.0f), 0.0);
                tessellator.func_78381_a();
                GL11.glEnable((int)3553);
            }
            if (this.underlineStyle) {
                tessellator = Tessellator.field_78398_a;
                GL11.glDisable((int)3553);
                tessellator.func_78382_b();
                int l = this.underlineStyle ? -1 : 0;
                tessellator.func_78377_a((double)(this.posX + (float)l), (double)(this.posY + (float)this.FONT_HEIGHT), 0.0);
                tessellator.func_78377_a((double)(this.posX + f1), (double)(this.posY + (float)this.FONT_HEIGHT), 0.0);
                tessellator.func_78377_a((double)(this.posX + f1), (double)(this.posY + (float)this.FONT_HEIGHT - 1.0f), 0.0);
                tessellator.func_78377_a((double)(this.posX + (float)l), (double)(this.posY + (float)this.FONT_HEIGHT - 1.0f), 0.0);
                tessellator.func_78381_a();
                GL11.glEnable((int)3553);
            }
            this.posX += (float)((int)f1);
        }
    }

    private int renderStringAligned(String par1Str, int par2, int par3, int par4, int par5, boolean par6) {
        if (this.bidiFlag) {
            par1Str = this.bidiReorder(par1Str);
            int i1 = this.getStringWidth(par1Str);
            par2 = par2 + par4 - i1;
        }
        return this.renderString(par1Str, par2, par3, par5, par6);
    }

    private int renderString(String par1Str, int par2, int par3, int par4, boolean par5) {
        if (par1Str == null) {
            return 0;
        }
        if ((par4 & 0xFC000000) == 0) {
            par4 |= 0xFF000000;
        }
        if (par5) {
            par4 = (par4 & 0xFCFCFC) >> 2 | par4 & 0xFF000000;
        }
        this.red = (float)(par4 >> 16 & 0xFF) / 255.0f;
        this.blue = (float)(par4 >> 8 & 0xFF) / 255.0f;
        this.green = (float)(par4 & 0xFF) / 255.0f;
        this.alpha = (float)(par4 >> 24 & 0xFF) / 255.0f;
        GL11.glColor4f((float)this.red, (float)this.blue, (float)this.green, (float)this.alpha);
        this.posX = par2;
        this.posY = par3;
        this.renderStringAtPos(par1Str, par5);
        return (int)this.posX;
    }

    public int getStringWidth(String par1Str) {
        if (par1Str == null) {
            return 0;
        }
        int i = 0;
        boolean flag = false;
        for (int j = 0; j < par1Str.length(); ++j) {
            char c0 = par1Str.charAt(j);
            int k = this.getCharWidth(c0);
            if (k < 0 && j < par1Str.length() - 1) {
                if ((c0 = par1Str.charAt(++j)) != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag = false;
                    }
                } else {
                    flag = true;
                }
                k = 0;
            }
            i += k;
            if (!flag) continue;
            ++i;
        }
        return i;
    }

    public int getCharWidth(char par1) {
        if (par1 == '\u00a7') {
            return -1;
        }
        if (par1 == ' ') {
            return 4;
        }
        int i = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(par1);
        if (par1 > '\u0000' && i != -1 && !this.unicodeFlag) {
            return this.charWidth[i];
        }
        if (this.glyphWidth[par1] != 0) {
            int j = this.glyphWidth[par1] >>> 4;
            int k = this.glyphWidth[par1] & 0xF;
            if (k > 7) {
                k = 15;
                j = 0;
            }
            return (++k - j) / 2 + 1;
        }
        return 0;
    }

    public String trimStringToWidth(String par1Str, int par2) {
        return this.trimStringToWidth(par1Str, par2, false);
    }

    public String trimStringToWidth(String par1Str, int par2, boolean par3) {
        StringBuilder stringbuilder = new StringBuilder();
        int j = 0;
        int k = par3 ? par1Str.length() - 1 : 0;
        int l = par3 ? -1 : 1;
        boolean flag1 = false;
        boolean flag2 = false;
        for (int i1 = k; i1 >= 0 && i1 < par1Str.length() && j < par2; i1 += l) {
            char c0 = par1Str.charAt(i1);
            int j1 = this.getCharWidth(c0);
            if (flag1) {
                flag1 = false;
                if (c0 != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag2 = false;
                    }
                } else {
                    flag2 = true;
                }
            } else if (j1 < 0) {
                flag1 = true;
            } else {
                j += j1;
                if (flag2) {
                    ++j;
                }
            }
            if (j > par2) break;
            if (par3) {
                stringbuilder.insert(0, c0);
                continue;
            }
            stringbuilder.append(c0);
        }
        return stringbuilder.toString();
    }

    private String trimStringNewline(String par1Str) {
        while (par1Str != null && par1Str.endsWith("\n")) {
            par1Str = par1Str.substring(0, par1Str.length() - 1);
        }
        return par1Str;
    }

    public void drawSplitString(String par1Str, int par2, int par3, int par4, int par5) {
        this.resetStyles();
        this.textColor = par5;
        par1Str = this.trimStringNewline(par1Str);
        this.renderSplitString(par1Str, par2, par3, par4, false);
    }

    private void renderSplitString(String par1Str, int par2, int par3, int par4, boolean par5) {
        List<?> list = this.listFormattedStringToWidth(par1Str, par4);
        for (String s1 : list) {
            this.renderStringAligned(s1, par2, par3, par4, this.textColor, par5);
            par3 += this.FONT_HEIGHT;
        }
    }

    public int splitStringWidth(String par1Str, int par2) {
        return this.FONT_HEIGHT * this.listFormattedStringToWidth(par1Str, par2).size();
    }

    public void setUnicodeFlag(boolean par1) {
        this.unicodeFlag = par1;
    }

    public boolean getUnicodeFlag() {
        return this.unicodeFlag;
    }

    public void setBidiFlag(boolean par1) {
        this.bidiFlag = par1;
    }

    public List<?> listFormattedStringToWidth(String par1Str, int par2) {
        return Arrays.asList(this.wrapFormattedStringToWidth(par1Str, par2).split("\n"));
    }

    String wrapFormattedStringToWidth(String par1Str, int par2) {
        int j = this.sizeStringToWidth(par1Str, par2);
        if (par1Str.length() <= j) {
            return par1Str;
        }
        String s1 = par1Str.substring(0, j);
        char c0 = par1Str.charAt(j);
        boolean flag = c0 == ' ' || c0 == '\n';
        String s2 = SmallFontRenderer.getFormatFromString(s1) + par1Str.substring(j + (flag ? 1 : 0));
        return s1 + "\n" + this.wrapFormattedStringToWidth(s2, par2);
    }

    private int sizeStringToWidth(String par1Str, int par2) {
        int l;
        int j = par1Str.length();
        int k = 0;
        int i1 = -1;
        boolean flag = false;
        for (l = 0; l < j; ++l) {
            char c0 = par1Str.charAt(l);
            switch (c0) {
                case '\n': {
                    --l;
                    break;
                }
                case '\u00a7': {
                    char c1;
                    if (l >= j - 1) break;
                    if ((c1 = par1Str.charAt(++l)) != 'l' && c1 != 'L') {
                        if (c1 != 'r' && c1 != 'R' && !SmallFontRenderer.isFormatColor(c1)) break;
                        flag = false;
                        break;
                    }
                    flag = true;
                    break;
                }
                case ' ': {
                    i1 = l;
                }
                default: {
                    k += this.getCharWidth(c0);
                    if (!flag) break;
                    ++k;
                }
            }
            if (c0 == '\n') {
                i1 = ++l;
                break;
            }
            if (k > par2) break;
        }
        return l != j && i1 != -1 && i1 < l ? i1 : l;
    }

    private static boolean isFormatColor(char par0) {
        return par0 >= '0' && par0 <= '9' || par0 >= 'a' && par0 <= 'f' || par0 >= 'A' && par0 <= 'F';
    }

    private static boolean isFormatSpecial(char par0) {
        return par0 >= 'k' && par0 <= 'o' || par0 >= 'K' && par0 <= 'O' || par0 == 'r' || par0 == 'R';
    }

    private static String getFormatFromString(String par0Str) {
        String s1 = "";
        int i = -1;
        int j = par0Str.length();
        while ((i = par0Str.indexOf(167, i + 1)) != -1) {
            if (i >= j - 1) continue;
            char c0 = par0Str.charAt(i + 1);
            if (SmallFontRenderer.isFormatColor(c0)) {
                s1 = "\u00a7" + c0;
                continue;
            }
            if (!SmallFontRenderer.isFormatSpecial(c0)) continue;
            s1 = s1 + "\u00a7" + c0;
        }
        return s1;
    }

    public boolean getBidiFlag() {
        return this.bidiFlag;
    }

    public void func_110549_a(IResourceManager var1) {
        this.func_111272_d();
    }
}

