/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLockController;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockAirLockFrame
extends BlockAdvancedTile
implements ItemBlockDesc.IBlockShiftDesc {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] airLockIcons;
    public static int METADATA_AIR_LOCK_FRAME = 0;
    public static int METADATA_AIR_LOCK_CONTROLLER = 1;

    public BlockAirLockFrame(String assetName) {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149658_d(GalacticraftCore.TEXTURE_PREFIX + assetName);
        this.func_149663_c(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, METADATA_AIR_LOCK_FRAME));
        par3List.add(new ItemStack(par1, 1, METADATA_AIR_LOCK_CONTROLLER));
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public boolean func_149742_c(World par1World, int par2, int par3, int par4) {
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityAirLockController && entityLiving instanceof EntityPlayer) {
            ((TileEntityAirLockController)tile).ownerName = ((EntityPlayer)entityLiving).func_146103_bH().getName();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.airLockIcons = new IIcon[8];
        this.airLockIcons[0] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "airlock_off");
        this.airLockIcons[1] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "airlock_on_1");
        this.airLockIcons[2] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "airlock_on_2");
        this.airLockIcons[3] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "airlock_on_3");
        this.airLockIcons[4] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "airlock_on_4");
        this.airLockIcons[5] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "airlock_on_5");
        this.airLockIcons[6] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "airlock_control_on");
        this.airLockIcons[7] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "airlock_control_off");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        if (par2 >= METADATA_AIR_LOCK_CONTROLLER) {
            if (par1 == ForgeDirection.UP.ordinal() || par1 == ForgeDirection.DOWN.ordinal()) {
                return this.airLockIcons[0];
            }
            return this.airLockIcons[7];
        }
        return this.airLockIcons[0];
    }

    public IIcon func_149673_e(IBlockAccess world, int par2, int par3, int par4, int side) {
        if (world.func_72805_g(par2, par3, par4) >= METADATA_AIR_LOCK_CONTROLLER) {
            if (side == ForgeDirection.UP.ordinal() || side == ForgeDirection.DOWN.ordinal()) {
                return this.airLockIcons[0];
            }
            TileEntity tile = world.func_147438_o(par2, par3, par4);
            if (tile instanceof TileEntityAirLockController) {
                TileEntityAirLockController controller = (TileEntityAirLockController)tile;
                if (controller.active) {
                    return this.airLockIcons[6];
                }
                return this.airLockIcons[7];
            }
            return this.airLockIcons[6];
        }
        for (ForgeDirection orientation : ForgeDirection.values()) {
            Vector3 vector;
            Vector3 blockVec;
            Block connection;
            if (orientation == ForgeDirection.UNKNOWN || (connection = (blockVec = this.modifyPositionFromSide((vector = new Vector3(par2, par3, par4)).clone(), orientation, 1.0)).getBlock(world)) == null || !connection.equals(GCBlocks.airLockSeal)) continue;
            if (orientation.offsetY == -1) {
                if (side == 0) {
                    return this.airLockIcons[1];
                }
                if (side == 1) {
                    return this.airLockIcons[0];
                }
                return this.airLockIcons[2];
            }
            if (orientation.offsetY == 1 || orientation.ordinal() == side) {
                if (side == 0) {
                    return this.airLockIcons[0];
                }
                if (side == 1) {
                    return this.airLockIcons[1];
                }
                return this.airLockIcons[3];
            }
            if (orientation.getOpposite().ordinal() == side) {
                return this.airLockIcons[0];
            }
            blockVec = vector.clone().translate(new Vector3(orientation.offsetX, orientation.offsetY, orientation.offsetZ));
            connection = blockVec.getBlock(world);
            if (connection == null || !connection.equals(GCBlocks.airLockSeal)) continue;
            if (orientation.offsetX == 1) {
                if (side == 0 || side == 1 || side == 3) {
                    return this.airLockIcons[4];
                }
                if (side != 2) continue;
                return this.airLockIcons[5];
            }
            if (orientation.offsetX == -1) {
                if (side == 0 || side == 1 || side == 3) {
                    return this.airLockIcons[5];
                }
                if (side != 2) continue;
                return this.airLockIcons[4];
            }
            if (orientation.offsetZ == 1) {
                if (side == 0 || side == 1) {
                    return this.airLockIcons[2];
                }
                if (side == 4) {
                    return this.airLockIcons[4];
                }
                if (side != 5) continue;
                return this.airLockIcons[5];
            }
            if (orientation.offsetZ != -1) continue;
            if (side == 0 || side == 1) {
                return this.airLockIcons[3];
            }
            if (side == 4) {
                return this.airLockIcons[5];
            }
            if (side != 5) continue;
            return this.airLockIcons[4];
        }
        return this.airLockIcons[0];
    }

    public Vector3 modifyPositionFromSide(Vector3 vec, ForgeDirection side, double amount) {
        switch (side.ordinal()) {
            case 0: {
                vec.y -= amount;
                break;
            }
            case 1: {
                vec.y += amount;
                break;
            }
            case 2: {
                vec.z -= amount;
                break;
            }
            case 3: {
                vec.z += amount;
                break;
            }
            case 4: {
                vec.x -= amount;
                break;
            }
            case 5: {
                vec.x += amount;
            }
        }
        return vec;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata < METADATA_AIR_LOCK_CONTROLLER) {
            return new TileEntityAirLock();
        }
        return new TileEntityAirLockController();
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (metadata >= METADATA_AIR_LOCK_CONTROLLER && tile instanceof TileEntityAirLockController) {
            entityPlayer.openGui((Object)GalacticraftCore.instance, -1, world, x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityAirLockController) {
            ((TileEntityAirLockController)tile).unsealAirLock();
        }
        super.func_149749_a(world, x, y, z, block, par6);
    }

    public int func_149692_a(int metadata) {
        if (metadata >= METADATA_AIR_LOCK_CONTROLLER) {
            return METADATA_AIR_LOCK_CONTROLLER;
        }
        if (metadata >= METADATA_AIR_LOCK_FRAME) {
            return METADATA_AIR_LOCK_FRAME;
        }
        return 0;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }
}

