/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.client.IGameScreen;
import micdoodle8.mods.galacticraft.api.recipe.INasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.api.world.SpaceStationType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraftforge.common.DimensionManager;

public class GalacticraftRegistry {
    private static final Map<Class<? extends WorldProvider>, ITeleportType> teleportTypeMap = new HashMap<Class<? extends WorldProvider>, ITeleportType>();
    private static final List<SpaceStationType> spaceStations = new ArrayList<SpaceStationType>();
    private static final List<INasaWorkbenchRecipe> rocketBenchT1Recipes = new ArrayList<INasaWorkbenchRecipe>();
    private static final List<INasaWorkbenchRecipe> buggyBenchRecipes = new ArrayList<INasaWorkbenchRecipe>();
    private static final List<INasaWorkbenchRecipe> rocketBenchT2Recipes = new ArrayList<INasaWorkbenchRecipe>();
    private static final List<INasaWorkbenchRecipe> cargoRocketRecipes = new ArrayList<INasaWorkbenchRecipe>();
    private static final List<INasaWorkbenchRecipe> rocketBenchT3Recipes = new ArrayList<INasaWorkbenchRecipe>();
    private static final List<INasaWorkbenchRecipe> astroMinerRecipes = new ArrayList<INasaWorkbenchRecipe>();
    private static final Map<Class<? extends WorldProvider>, ResourceLocation> rocketGuiMap = new HashMap<Class<? extends WorldProvider>, ResourceLocation>();
    private static final Map<Integer, List<ItemStack>> dungeonLootMap = new HashMap<Integer, List<ItemStack>>();
    private static final List<Integer> worldProviderIDs = new ArrayList<Integer>();
    private static final List<IGameScreen> gameScreens = new ArrayList<IGameScreen>();
    private static int maxScreenTypes;

    public static void registerTeleportType(Class<? extends WorldProvider> clazz, ITeleportType type) {
        if (!teleportTypeMap.containsKey(clazz)) {
            teleportTypeMap.put(clazz, type);
        }
    }

    public static void registerRocketGui(Class<? extends WorldProvider> clazz, ResourceLocation rocketGui) {
        if (!rocketGuiMap.containsKey(clazz)) {
            rocketGuiMap.put(clazz, rocketGui);
        }
    }

    public static void addDungeonLoot(int tier, ItemStack loot) {
        List<Object> dungeonStacks = null;
        if (dungeonLootMap.containsKey(tier)) {
            dungeonStacks = dungeonLootMap.get(tier);
            dungeonStacks.add(loot);
        } else {
            dungeonStacks = new ArrayList<ItemStack>();
            dungeonStacks.add(loot);
        }
        dungeonLootMap.put(tier, dungeonStacks);
    }

    public static void addT1RocketRecipe(INasaWorkbenchRecipe recipe) {
        rocketBenchT1Recipes.add(recipe);
    }

    public static void addT2RocketRecipe(INasaWorkbenchRecipe recipe) {
        rocketBenchT2Recipes.add(recipe);
    }

    public static void addT3RocketRecipe(INasaWorkbenchRecipe recipe) {
        rocketBenchT3Recipes.add(recipe);
    }

    public static void addCargoRocketRecipe(INasaWorkbenchRecipe recipe) {
        cargoRocketRecipes.add(recipe);
    }

    public static void addMoonBuggyRecipe(INasaWorkbenchRecipe recipe) {
        buggyBenchRecipes.add(recipe);
    }

    public static void addAstroMinerRecipe(INasaWorkbenchRecipe recipe) {
        astroMinerRecipes.add(recipe);
    }

    public static ITeleportType getTeleportTypeForDimension(Class<? extends WorldProvider> clazz) {
        if (!IGalacticraftWorldProvider.class.isAssignableFrom(clazz)) {
            clazz = WorldProviderSurface.class;
        }
        return teleportTypeMap.get(clazz);
    }

    public static void registerSpaceStation(SpaceStationType type) {
        for (SpaceStationType type1 : spaceStations) {
            if (type1.getWorldToOrbitID() != type.getWorldToOrbitID()) continue;
            throw new RuntimeException("Two space station types registered with the same home planet ID: " + type.getWorldToOrbitID());
        }
        spaceStations.add(type);
    }

    public SpaceStationType getTypeFromPlanetID(int planetID) {
        return spaceStations.get(planetID);
    }

    public static List<SpaceStationType> getSpaceStationData() {
        return spaceStations;
    }

    public static List<INasaWorkbenchRecipe> getRocketT1Recipes() {
        return rocketBenchT1Recipes;
    }

    public static List<INasaWorkbenchRecipe> getRocketT2Recipes() {
        return rocketBenchT2Recipes;
    }

    public static List<INasaWorkbenchRecipe> getRocketT3Recipes() {
        return rocketBenchT3Recipes;
    }

    public static List<INasaWorkbenchRecipe> getCargoRocketRecipes() {
        return cargoRocketRecipes;
    }

    public static List<INasaWorkbenchRecipe> getBuggyBenchRecipes() {
        return buggyBenchRecipes;
    }

    public static List<INasaWorkbenchRecipe> getAstroMinerRecipes() {
        return astroMinerRecipes;
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getResouceLocationForDimension(Class<? extends WorldProvider> clazz) {
        if (!IGalacticraftWorldProvider.class.isAssignableFrom(clazz)) {
            clazz = WorldProviderSurface.class;
        }
        return rocketGuiMap.get(clazz);
    }

    public static List<ItemStack> getDungeonLoot(int tier) {
        return dungeonLootMap.get(tier);
    }

    public static boolean registerProvider(int id, Class<? extends WorldProvider> provider, boolean keepLoaded, int defaultID) {
        boolean flag = DimensionManager.registerProviderType((int)id, provider, (boolean)keepLoaded);
        if (flag) {
            worldProviderIDs.add(id);
            return true;
        }
        worldProviderIDs.add(defaultID);
        FMLLog.severe((String)("Could not register dimension " + id + " - does it clash with another mod?  Change the ID in config."), (Object[])new Object[0]);
        return false;
    }

    @Deprecated
    public static void registerProvider(int id, Class<? extends WorldProvider> provider, boolean keepLoaded) {
        GalacticraftRegistry.registerProvider(id, provider, keepLoaded, 0);
    }

    public static int getProviderID(int index) {
        return worldProviderIDs.get(index);
    }

    public static int registerScreen(IGameScreen screen) {
        gameScreens.add(screen);
        screen.setFrameSize(0.098f);
        return ++maxScreenTypes - 1;
    }

    public static int getMaxScreenTypes() {
        return maxScreenTypes;
    }

    public static IGameScreen getGameScreen(int type) {
        return gameScreens.get(type);
    }
}

