/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IGridNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.transmission.tile.ITransmitter;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.planets.mars.tile.HydrogenNetwork;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHydrogenPipe
extends TileEntity
implements ITransmitter {
    private IGridNetwork network;
    public TileEntity[] adjacentConnections = null;

    public boolean canUpdate() {
        return this.field_145850_b == null || !this.field_145850_b.field_72995_K;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            TickHandlerServer.hydrogenTransmitterUpdates.add(this);
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            this.getNetwork().split(this);
        }
        super.func_145843_s();
    }

    @Override
    public IGridNetwork getNetwork() {
        if (this.network == null) {
            this.resetNetwork();
        }
        return this.network;
    }

    @Override
    public void onNetworkChanged() {
    }

    protected void resetNetwork() {
        HydrogenNetwork network = new HydrogenNetwork();
        network.getTransmitters().add(this);
        this.setNetwork(network);
    }

    @Override
    public void setNetwork(IGridNetwork network) {
        this.network = network;
    }

    @Override
    public void refresh() {
        if (!this.field_145850_b.field_72995_K) {
            this.adjacentConnections = null;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, side);
                if (tileEntity == null || tileEntity.getClass() != this.getClass() || !(tileEntity instanceof INetworkProvider) || this.getNetwork().equals(((INetworkProvider)tileEntity).getNetwork())) continue;
                this.setNetwork(this.getNetwork().merge(((INetworkProvider)tileEntity).getNetwork()));
            }
            this.getNetwork().refresh();
        }
    }

    @Override
    public TileEntity[] getAdjacentConnections() {
        if (this.adjacentConnections == null) {
            this.adjacentConnections = TileEntityHydrogenPipe.getAdjacentHydrogenConnections(this);
        }
        return this.adjacentConnections;
    }

    public static TileEntity[] getAdjacentHydrogenConnections(TileEntity tile) {
        TileEntity[] adjacentConnections = new TileEntity[ForgeDirection.VALID_DIRECTIONS.length];
        boolean isMekLoaded = EnergyConfigHandler.isMekanismLoaded();
        BlockVec3 thisVec = new BlockVec3(tile);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = thisVec.getTileEntityOnSide(tile.func_145831_w(), direction);
            if (!(tileEntity instanceof IConnector) || !((IConnector)tileEntity).canConnect(direction.getOpposite(), NetworkType.HYDROGEN)) continue;
            adjacentConnections[direction.ordinal()] = tileEntity;
        }
        return adjacentConnections;
    }

    @Override
    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        return type == NetworkType.HYDROGEN;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    @Override
    public NetworkType getNetworkType() {
        return NetworkType.HYDROGEN;
    }
}

