/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.mixinplugin;

import com.google.common.io.Files;
import java.nio.file.Path;

public enum TargetedMod {
    VANILLA("Minecraft", "unused", true),
    FORGE("Forge", "unused", true),
    PLAYER_API("Player-API", "Player-API", false),
    OPTIFINE("Optifine", "OptiFine_1.7.10", false),
    SYNCMOD("Sync Mod", "sync", false);

    public final String modName;
    public final String jarNamePrefixLowercase;
    public final boolean loadInDevelopment;

    private TargetedMod(String modName, String jarNamePrefix, boolean loadInDevelopment) {
        this.modName = modName;
        this.jarNamePrefixLowercase = jarNamePrefix.toLowerCase();
        this.loadInDevelopment = loadInDevelopment;
    }

    public boolean isMatchingJar(Path path) {
        String pathString = path.toString();
        String nameLowerCase = Files.getNameWithoutExtension((String)pathString).toLowerCase();
        String fileExtension = Files.getFileExtension((String)pathString);
        return nameLowerCase.startsWith(this.jarNamePrefixLowercase) && "jar".equals(fileExtension);
    }

    public String toString() {
        return "TargetedMod{modName='" + this.modName + '\'' + ", jarNamePrefixLowercase='" + this.jarNamePrefixLowercase + '\'' + '}';
    }
}

