/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.mixinplugin;

import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.core.mixinplugin.Side;
import micdoodle8.mods.galacticraft.core.mixinplugin.TargetedMod;

public enum Mixin {
    ForgeHooksClientMixin("forge.ForgeHooksClientMixin", TargetedMod.FORGE),
    ChunkProviderServerMixin("minecraft.ChunkProviderServerMixin", TargetedMod.VANILLA),
    EffectRendererMixin("minecraft.EffectRendererMixin", Side.CLIENT, TargetedMod.VANILLA),
    EntityArrowMixin("minecraft.EntityArrowMixin", TargetedMod.VANILLA),
    EntityGolemMixin("minecraft.EntityGolemMixin", TargetedMod.VANILLA),
    EntityItemMixin("minecraft.EntityItemMixin", TargetedMod.VANILLA),
    EntityLivingBaseMixin("minecraft.EntityLivingBaseMixin", TargetedMod.VANILLA),
    EntityMixin("minecraft.EntityMixin", Side.CLIENT, TargetedMod.VANILLA),
    EntityRendererMixin("minecraft.EntityRendererMixin", Side.CLIENT, TargetedMod.VANILLA),
    EntityRendererWithoutOptifineMixin("minecraft.EntityRendererWithoutOptifineMixin", Side.CLIENT, true, false, TargetedMod.VANILLA),
    GuiSleepMPMxin("minecraft.GuiSleepMPMxin", Side.CLIENT, TargetedMod.VANILLA),
    ItemRendererMixin("minecraft.ItemRendererMixin", Side.CLIENT, TargetedMod.VANILLA),
    NetHandlerPlayClientMixin("minecraft.NetHandlerPlayClientMixin", Side.CLIENT, TargetedMod.VANILLA),
    PlayerControllerMPMixin("minecraft.PlayerControllerMPMixin", Side.CLIENT, false, true, TargetedMod.VANILLA),
    RendererLivingEntityMixin("minecraft.RendererLivingEntityMixin", Side.CLIENT, TargetedMod.VANILLA),
    WorldMixin("minecraft.WorldMixin", TargetedMod.VANILLA);

    public final String mixinClass;
    public final List<TargetedMod> targetedMods;
    private final Side side;
    private final boolean injectAlongPlayerAPI;
    private final boolean isInjectAlongOptifine;

    private Mixin(String mixinClass, Side side, boolean injectAlongPlayerAPI, boolean isInjectAlongOptifine, TargetedMod ... targetedMods) {
        this.mixinClass = mixinClass;
        this.targetedMods = Arrays.asList(targetedMods);
        this.side = side;
        this.injectAlongPlayerAPI = injectAlongPlayerAPI;
        this.isInjectAlongOptifine = isInjectAlongOptifine;
    }

    private Mixin(String mixinClass, Side side, TargetedMod ... targetedMods) {
        this.mixinClass = mixinClass;
        this.targetedMods = Arrays.asList(targetedMods);
        this.side = side;
        this.injectAlongPlayerAPI = true;
        this.isInjectAlongOptifine = true;
    }

    private Mixin(String mixinClass, boolean injectAlongPlayerAPI, boolean isInjectAlongOptifine, TargetedMod ... targetedMods) {
        this.mixinClass = mixinClass;
        this.targetedMods = Arrays.asList(targetedMods);
        this.side = Side.BOTH;
        this.injectAlongPlayerAPI = injectAlongPlayerAPI;
        this.isInjectAlongOptifine = isInjectAlongOptifine;
    }

    private Mixin(String mixinClass, TargetedMod ... targetedMods) {
        this.mixinClass = mixinClass;
        this.targetedMods = Arrays.asList(targetedMods);
        this.side = Side.BOTH;
        this.injectAlongPlayerAPI = true;
        this.isInjectAlongOptifine = true;
    }

    public boolean shouldLoad(List<TargetedMod> loadedMods) {
        return (this.side == Side.BOTH || this.side == Side.SERVER && FMLLaunchHandler.side().isServer() || this.side == Side.CLIENT && FMLLaunchHandler.side().isClient()) && loadedMods.containsAll(this.targetedMods) && (!loadedMods.contains((Object)TargetedMod.PLAYER_API) || this.injectAlongPlayerAPI) && (!loadedMods.contains((Object)TargetedMod.OPTIFINE) || this.isInjectAlongOptifine);
    }
}

