/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.entity.IAntiGrav;
import micdoodle8.mods.galacticraft.api.entity.IWorldTransferCallback;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.item.IArmorGravity;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.recipe.SpaceStationRecipe;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.api.world.SpaceStationType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.SkyProviderOverworld;
import micdoodle8.mods.galacticraft.core.dimension.SpaceStationWorldData;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.EntityArrowGC;
import micdoodle8.mods.galacticraft.core.entities.EntityCelestialFake;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.ItemParaChute;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.VersionUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldUtil {
    public static HashMap<Integer, Integer> registeredSpaceStations;
    public static Map<Integer, String> dimNames;
    public static Map<EntityPlayerMP, HashMap<String, Integer>> celestialMapCache;
    public static List<Integer> registeredPlanets;
    private static IWorldGenerator generatorGCGreg;
    private static IWorldGenerator generatorCoFH;
    private static IWorldGenerator generatorDenseOres;
    private static IWorldGenerator generatorTCAuraNodes;
    private static IWorldGenerator generatorAE2meteors;
    private static Method generateTCAuraNodes;
    private static boolean generatorsInitialised;

    public static double getGravityForEntity(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            if (entity instanceof EntityChicken && !OxygenUtil.isAABBInBreathableAirBlock(entity.field_70170_p, entity.field_70121_D)) {
                return 0.08;
            }
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)entity.field_70170_p.field_73011_w;
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (player.field_71071_by != null) {
                    int armorModLowGrav = 100;
                    int armorModHighGrav = 100;
                    for (int i = 0; i < 4; ++i) {
                        ItemStack armorPiece = player.func_82169_q(i);
                        if (armorPiece == null || !(armorPiece.func_77973_b() instanceof IArmorGravity)) continue;
                        armorModLowGrav -= ((IArmorGravity)armorPiece.func_77973_b()).gravityOverrideIfLow(player);
                        armorModHighGrav -= ((IArmorGravity)armorPiece.func_77973_b()).gravityOverrideIfHigh(player);
                    }
                    if (armorModLowGrav > 100) {
                        armorModLowGrav = 100;
                    }
                    if (armorModHighGrav > 100) {
                        armorModHighGrav = 100;
                    }
                    if (armorModLowGrav < 0) {
                        armorModLowGrav = 0;
                    }
                    if (armorModHighGrav < 0) {
                        armorModHighGrav = 0;
                    }
                    if (customProvider.getGravity() > 0.0f) {
                        return 0.08 - (double)(customProvider.getGravity() * (float)armorModLowGrav / 100.0f);
                    }
                    return 0.08 - (double)(customProvider.getGravity() * (float)armorModHighGrav / 100.0f);
                }
            }
            return 0.08 - (double)customProvider.getGravity();
        }
        if (entity instanceof IAntiGrav) {
            return 0.0;
        }
        return 0.08;
    }

    public static float getGravityFactor(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)entity.field_70170_p.field_73011_w;
            float returnValue = MathHelper.func_76129_c((float)(0.08f / (0.08f - customProvider.getGravity())));
            if (returnValue > 2.5f) {
                returnValue = 2.5f;
            }
            if (returnValue < 0.75f) {
                returnValue = 0.75f;
            }
            return returnValue;
        }
        if (entity instanceof IAntiGrav) {
            return 1.0f;
        }
        return 1.0f;
    }

    public static double getItemGravity(EntityItem e) {
        if (e.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)e.field_70170_p.field_73011_w;
            return Math.max(0.002, (double)0.04f - (customProvider instanceof IOrbitDimension ? 0.05999999910593033 : (double)customProvider.getGravity()) / 1.75);
        }
        return 0.04f;
    }

    public static float getArrowGravity(EntityArrow e) {
        if (e.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            return 0.005f;
        }
        return 0.05f;
    }

    public static float getRainStrength(World world, float partialTicks) {
        if (world.field_72995_K && world.field_73011_w.getSkyRenderer() instanceof SkyProviderOverworld) {
            return 0.0f;
        }
        return world.field_73003_n + (world.field_73004_o - world.field_73003_n) * partialTicks;
    }

    public static boolean shouldRenderFire(Entity entity) {
        if (entity.field_70170_p == null || !(entity.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider)) {
            return entity.func_70027_ad();
        }
        if (!(entity instanceof EntityLivingBase || entity instanceof EntityArrow || entity instanceof EntityArrowGC)) {
            return entity.func_70027_ad();
        }
        if (entity.func_70027_ad()) {
            if (OxygenUtil.noAtmosphericCombustion(entity.field_70170_p.field_73011_w)) {
                return OxygenUtil.isAABBInBreathableAirBlock(entity.field_70170_p, entity.field_70121_D);
            }
            return true;
        }
        return false;
    }

    public static Vector3 getWorldColor(World world) {
        return new Vector3(1.0, 1.0, 1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public static float getWorldBrightness(WorldClient world) {
        if (world.field_73011_w instanceof WorldProviderMoon) {
            float f1 = world.func_72826_c(1.0f);
            float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            f2 = 1.0f - f2;
            return f2 * 0.8f;
        }
        return world.func_72971_b(1.0f);
    }

    public static float getColorRed(World world) {
        return (float)WorldUtil.getWorldColor((World)world).x;
    }

    public static float getColorGreen(World world) {
        return (float)WorldUtil.getWorldColor((World)world).y;
    }

    public static float getColorBlue(World world) {
        return (float)WorldUtil.getWorldColor((World)world).z;
    }

    public static Vec3 getFogColorHook(World world) {
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (world.field_73011_w.getSkyRenderer() instanceof SkyProviderOverworld) {
            float var20 = ((float)player.field_70163_u - 200.0f) / 1000.0f;
            var20 = MathHelper.func_76129_c((float)var20);
            float var21 = Math.max(1.0f - var20 * 40.0f, 0.0f);
            Vec3 vec = world.func_72948_g(1.0f);
            return Vec3.func_72443_a((double)(vec.field_72450_a * (double)Math.max(1.0f - var20 * 1.29f, 0.0f)), (double)(vec.field_72448_b * (double)Math.max(1.0f - var20 * 1.29f, 0.0f)), (double)(vec.field_72449_c * (double)Math.max(1.0f - var20 * 1.29f, 0.0f)));
        }
        return world.func_72948_g(1.0f);
    }

    public static Vec3 getSkyColorHook(World world) {
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (world.field_73011_w.getSkyRenderer() instanceof SkyProviderOverworld || player != null && player.field_70163_u > 130.0 && player.field_70154_o instanceof EntitySpaceshipBase) {
            float f1 = world.func_72826_c(1.0f);
            float f2 = MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            int i = MathHelper.func_76128_c((double)player.field_70165_t);
            int j = MathHelper.func_76128_c((double)player.field_70163_u);
            int k = MathHelper.func_76128_c((double)player.field_70161_v);
            int l = ForgeHooksClient.getSkyBlendColour((World)world, (int)i, (int)j, (int)k);
            float f4 = (float)(l >> 16 & 0xFF) / 255.0f;
            float f5 = (float)(l >> 8 & 0xFF) / 255.0f;
            float f6 = (float)(l & 0xFF) / 255.0f;
            f4 *= f2;
            f5 *= f2;
            f6 *= f2;
            if (player.field_70163_u <= 200.0) {
                Vec3 vec = world.func_72833_a((Entity)FMLClientHandler.instance().getClient().field_71451_h, 1.0f);
                double blend = (player.field_70163_u - 130.0) / 70.0;
                double ablend = 1.0 - blend;
                return Vec3.func_72443_a((double)((double)f4 * blend + vec.field_72450_a * ablend), (double)((double)f5 * blend + vec.field_72448_b * ablend), (double)((double)f6 * blend + vec.field_72449_c * ablend));
            }
            double blend = Math.min(1.0, (player.field_70163_u - 200.0) / 300.0);
            double ablend = 1.0 - blend;
            return Vec3.func_72443_a((double)((double)f4 * ablend + (blend /= 255.0) * 31.0), (double)((double)f5 * ablend + blend * 8.0), (double)((double)f6 * ablend + blend * 99.0));
        }
        return world.func_72833_a((Entity)FMLClientHandler.instance().getClient().field_71451_h, 1.0f);
    }

    public static WorldProvider getProviderForNameServer(String par1String) {
        String nameToFind = par1String;
        if (par1String.contains("$")) {
            String[] twoDimensions = par1String.split("\\$");
            nameToFind = twoDimensions[0];
        }
        if (nameToFind == null) {
            return null;
        }
        for (Map.Entry<Integer, String> element : dimNames.entrySet()) {
            if (!nameToFind.equals(element.getValue())) continue;
            return WorldUtil.getProviderForDimensionServer(element.getKey());
        }
        GCLog.info("Failed to find matching world for '" + par1String + "'");
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static WorldProvider getProviderForNameClient(String par1String) {
        String nameToFind = par1String;
        if (par1String.contains("$")) {
            String[] twoDimensions = par1String.split("\\$");
            nameToFind = twoDimensions[0];
        }
        if (nameToFind == null) {
            return null;
        }
        for (Map.Entry<Integer, String> element : dimNames.entrySet()) {
            if (!nameToFind.equals(element.getValue())) continue;
            return WorldUtil.getProviderForDimensionClient(element.getKey());
        }
        GCLog.info("Failed to find matching world for '" + par1String + "'");
        return null;
    }

    public static void initialiseDimensionNames() {
        WorldProvider provider = WorldUtil.getProviderForDimensionServer(ConfigManagerCore.idDimensionOverworld);
        dimNames.put(ConfigManagerCore.idDimensionOverworld, new String(provider.func_80007_l()));
    }

    public static List<Integer> getPossibleDimensionsForSpaceshipTier(int tier, EntityPlayerMP playerBase) {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        if (!ConfigManagerCore.disableRocketsToOverworld) {
            temp.add(ConfigManagerCore.idDimensionOverworld);
        }
        for (Integer element : registeredPlanets) {
            WorldProvider provider;
            if (element == ConfigManagerCore.idDimensionOverworld || (provider = WorldUtil.getProviderForDimensionServer(element)) == null) continue;
            if (provider instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)provider).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        for (Integer element : registeredSpaceStations.keySet()) {
            SpaceStationWorldData data = SpaceStationWorldData.getStationData(playerBase.field_70170_p, element, null);
            if (ConfigManagerCore.spaceStationsRequirePermission && !data.getAllowedAll() && !data.getAllowedPlayers().contains(playerBase.func_146103_bH().getName()) && !VersionUtil.isPlayerOpped(playerBase)) continue;
            if (playerBase != null) {
                SpaceStationWorldData dataCurrent;
                if (playerBase.field_71093_bK == data.getHomePlanet()) {
                    temp.add(element);
                    continue;
                }
                if (playerBase.field_70170_p.field_73011_w instanceof IOrbitDimension && (dataCurrent = SpaceStationWorldData.getStationData(playerBase.field_70170_p, playerBase.field_71093_bK, null)).getHomePlanet() == data.getHomePlanet()) {
                    temp.add(element);
                    continue;
                }
            }
            WorldProvider homeWorld = WorldUtil.getProviderForDimensionServer(data.getHomePlanet());
            WorldProvider provider = WorldUtil.getProviderForDimensionServer(element);
            if (homeWorld == null) continue;
            if (homeWorld instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)homeWorld).canSpaceshipTierPass(tier) && (!ConfigManagerCore.allowSSatUnreachable || !((IGalacticraftWorldProvider)provider).canSpaceshipTierPass(tier))) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        return temp;
    }

    public static CelestialBody getReachableCelestialBodiesForDimensionID(int id) {
        ArrayList celestialBodyList = Lists.newArrayList();
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredSatellites().values());
        for (CelestialBody cBody : celestialBodyList) {
            if (!cBody.getReachable() || cBody.getDimensionID() != id) continue;
            return cBody;
        }
        return null;
    }

    public static CelestialBody getReachableCelestialBodiesForName(String name) {
        ArrayList celestialBodyList = Lists.newArrayList();
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredSatellites().values());
        for (CelestialBody cBody : celestialBodyList) {
            if (!cBody.getReachable() || !cBody.getName().equals(name)) continue;
            return cBody;
        }
        return null;
    }

    public static WorldProvider getProviderForDimensionServer(int id) {
        MinecraftServer theServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (theServer == null) {
            GCLog.debug("Called WorldUtil server side method but FML returned no server - is this a bug?");
            return null;
        }
        WorldServer ws = theServer.func_71218_a(id);
        if (ws != null) {
            return ws.field_73011_w;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static WorldProvider getProviderForDimensionClient(int id) {
        WorldClient ws = ClientProxyCore.mc.field_71441_e;
        if (ws != null && ws.field_73011_w.field_76574_g == id) {
            return ws.field_73011_w;
        }
        return WorldProvider.func_76570_a((int)id);
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensions(int tier, EntityPlayerMP playerBase) {
        List<Integer> ids = WorldUtil.getPossibleDimensionsForSpaceshipTier(tier, playerBase);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Integer id : ids) {
            CelestialBody celestialBody = WorldUtil.getReachableCelestialBodiesForDimensionID(id);
            if (id > 0 && celestialBody == null) {
                celestialBody = GalacticraftCore.satelliteSpaceStation;
                if (playerBase == null) continue;
                SpaceStationWorldData data = SpaceStationWorldData.getStationData(playerBase.field_70170_p, id, null);
                map.put(celestialBody.getName() + "$" + data.getOwner() + "$" + data.getSpaceStationName() + "$" + id + "$" + data.getHomePlanet(), id);
                continue;
            }
            if (celestialBody == GalacticraftCore.planetOverworld) {
                map.put(celestialBody.getName(), id);
                continue;
            }
            WorldProvider provider = WorldUtil.getProviderForDimensionServer(id);
            if (celestialBody == null || provider == null || (!(provider instanceof IGalacticraftWorldProvider) || provider instanceof IOrbitDimension) && provider.field_76574_g != 0) continue;
            map.put(celestialBody.getName(), provider.field_76574_g);
        }
        ArrayList<CelestialBody> cBodyList = new ArrayList<CelestialBody>();
        cBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        cBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        for (CelestialBody body : cBodyList) {
            if (body.getReachable()) continue;
            map.put(body.getLocalizedName() + "*", body.getDimensionID());
        }
        celestialMapCache.put(playerBase, map);
        return map;
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensionsAgain(int tier, EntityPlayerMP playerBase) {
        HashMap<String, Integer> map = celestialMapCache.get(playerBase);
        if (map != null) {
            return map;
        }
        return WorldUtil.getArrayOfPossibleDimensions(tier, playerBase);
    }

    private static List<Integer> getExistingSpaceStationList(File var0) {
        ArrayList<Integer> var1 = new ArrayList<Integer>();
        File[] var2 = var0.listFiles();
        if (var2 != null) {
            for (File var5 : var2) {
                if (!var5.getName().contains("spacestation_")) continue;
                String var6 = var5.getName();
                var6 = var6.substring(13, var6.length() - 4);
                var1.add(Integer.parseInt(var6));
            }
        }
        return var1;
    }

    public static void unregisterSpaceStations() {
        if (registeredSpaceStations != null) {
            for (Integer registeredID : registeredSpaceStations.keySet()) {
                DimensionManager.unregisterDimension((int)registeredID);
            }
            registeredSpaceStations = null;
        }
    }

    public static void registerSpaceStations(File spaceStationList) {
        registeredSpaceStations = Maps.newHashMap();
        MinecraftServer theServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (theServer == null) {
            return;
        }
        File[] var2 = spaceStationList.listFiles();
        if (var2 != null) {
            for (File var5 : var2) {
                if (!var5.getName().contains("spacestation_")) continue;
                try {
                    String name = var5.getName();
                    SpaceStationWorldData worldDataTemp = new SpaceStationWorldData(name);
                    name = name.substring(13, name.length() - 4);
                    int registeredID = Integer.parseInt(name);
                    FileInputStream fileinputstream = new FileInputStream(var5);
                    NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                    fileinputstream.close();
                    worldDataTemp.func_76184_a(nbttagcompound.func_74775_l("data"));
                    int id = Arrays.binarySearch(ConfigManagerCore.staticLoadDimensions, registeredID);
                    if (!DimensionManager.isDimensionRegistered((int)registeredID)) {
                        if (id >= 0) {
                            DimensionManager.registerDimension((int)registeredID, (int)worldDataTemp.getDimensionIdStatic());
                            registeredSpaceStations.put(registeredID, worldDataTemp.getDimensionIdStatic());
                            theServer.func_71218_a(registeredID);
                        } else {
                            DimensionManager.registerDimension((int)registeredID, (int)worldDataTemp.getDimensionIdDynamic());
                            registeredSpaceStations.put(registeredID, worldDataTemp.getDimensionIdDynamic());
                        }
                        dimNames.put(registeredID, "Space Station " + registeredID);
                        continue;
                    }
                    GCLog.severe("Dimension already registered to another mod: unable to register space station dimension " + registeredID);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean registerPlanet(int planetID, boolean initialiseDimensionAtServerInit, int defaultID) {
        if (registeredPlanets == null) {
            registeredPlanets = new ArrayList<Integer>();
        }
        if (initialiseDimensionAtServerInit) {
            if (DimensionManager.isDimensionRegistered((int)planetID)) {
                GCLog.severe("Dimension already registered to another mod: unable to register planet dimension " + planetID);
                registeredPlanets.add(defaultID);
                return false;
            }
            DimensionManager.registerDimension((int)planetID, (int)planetID);
            GCLog.info("Registered Dimension: " + planetID);
            registeredPlanets.add(planetID);
            WorldServer w = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(planetID);
            dimNames.put(planetID, new String(WorldUtil.getDimensionName(w.field_73011_w)));
            return true;
        }
        registeredPlanets.add(planetID);
        return true;
    }

    public static void unregisterPlanets() {
        if (registeredPlanets != null) {
            for (Integer var1 : registeredPlanets) {
                DimensionManager.unregisterDimension((int)var1);
                GCLog.info("Unregistered Dimension: " + var1);
            }
            registeredPlanets = null;
        }
        dimNames.clear();
    }

    @Deprecated
    public static void registerPlanet(int planetID, boolean initialiseDimensionAtServerInit) {
        WorldUtil.registerPlanet(planetID, initialiseDimensionAtServerInit, 0);
    }

    public static void registerPlanetClient(Integer dimID, int providerIndex) {
        int providerID = GalacticraftRegistry.getProviderID(providerIndex);
        if (providerID == 0) {
            GCLog.severe("Server dimension " + dimID + " has no match on client due to earlier registration problem.");
        } else if (dimID == 0) {
            GCLog.severe("Client dimension " + providerID + " has no match on server - probably a server dimension ID conflict problem.");
        } else if (!registeredPlanets.contains(dimID)) {
            registeredPlanets.add(dimID);
            DimensionManager.registerDimension((int)dimID, (int)providerID);
        } else {
            GCLog.severe("Dimension already registered to another mod: unable to register planet dimension " + dimID);
        }
    }

    public static Integer[] getArrayOfPossibleDimensions() {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        temp.add(ConfigManagerCore.idDimensionOverworld);
        for (Integer i : registeredPlanets) {
            temp.add(i);
        }
        if (registeredSpaceStations != null) {
            for (Integer i : registeredSpaceStations.keySet()) {
                temp.add(i);
            }
        }
        Integer[] finalArray = new Integer[temp.size()];
        int count = 0;
        for (Integer integ : temp) {
            finalArray[count++] = integ;
        }
        return finalArray;
    }

    public static SpaceStationWorldData bindSpaceStationToNewDimension(World world, EntityPlayerMP player, int homePlanetID) {
        int dynamicProviderID = -1;
        int staticProviderID = -1;
        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
            if (satellite.getParentPlanet().getDimensionID() != homePlanetID) continue;
            dynamicProviderID = satellite.getDimensionID();
            staticProviderID = satellite.getDimensionIdStatic();
        }
        if (dynamicProviderID == -1 || staticProviderID == -1) {
            throw new RuntimeException("Space station being bound on bad provider IDs!");
        }
        int newID = DimensionManager.getNextFreeDimId();
        SpaceStationWorldData data = WorldUtil.createSpaceStation(world, newID, homePlanetID, dynamicProviderID, staticProviderID, player);
        dimNames.put(newID, "Space Station " + newID);
        GCPlayerStats stats = GCPlayerStats.get(player);
        stats.spaceStationDimensionData.put(homePlanetID, newID);
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_CLIENT_ID, new Object[]{WorldUtil.spaceStationDataToString(stats.spaceStationDimensionData)}), player);
        return data;
    }

    public static SpaceStationWorldData createSpaceStation(World world, int dimID, int homePlanetID, int dynamicProviderID, int staticProviderID, EntityPlayerMP player) {
        if (!DimensionManager.isDimensionRegistered((int)dimID)) {
            int id;
            if (ConfigManagerCore.keepLoadedNewSpaceStations) {
                ConfigManagerCore.setLoaded(dimID);
            }
            if ((id = Arrays.binarySearch(ConfigManagerCore.staticLoadDimensions, dimID)) >= 0) {
                DimensionManager.registerDimension((int)dimID, (int)staticProviderID);
                registeredSpaceStations.put(dimID, staticProviderID);
            } else {
                DimensionManager.registerDimension((int)dimID, (int)dynamicProviderID);
                registeredSpaceStations.put(dimID, dynamicProviderID);
            }
        } else {
            GCLog.severe("Dimension already registered to another mod: unable to register space station dimension " + dimID);
        }
        GalacticraftCore.packetPipeline.sendToAll(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_LIST, WorldUtil.getSpaceStationList()));
        return SpaceStationWorldData.getStationData(world, dimID, homePlanetID, dynamicProviderID, staticProviderID, (EntityPlayer)player);
    }

    public static Entity transferEntityToDimension(Entity entity, int dimensionID, WorldServer world) {
        return WorldUtil.transferEntityToDimension(entity, dimensionID, world, true, null);
    }

    public static Entity transferEntityToDimension(Entity entity, int dimensionID, WorldServer world, boolean transferInv, EntityAutoRocket ridingRocket) {
        MinecraftServer mcServer;
        if (!world.field_72995_K && (mcServer = FMLCommonHandler.instance().getMinecraftServerInstance()) != null) {
            WorldServer var6 = mcServer.func_71218_a(dimensionID);
            if (var6 == null) {
                System.err.println("Cannot Transfer Entity to Dimension: Could not get World for Dimension " + dimensionID);
                return null;
            }
            ITeleportType type = GalacticraftRegistry.getTeleportTypeForDimension(var6.field_73011_w.getClass());
            if (type != null) {
                return WorldUtil.teleportEntity((World)var6, entity, dimensionID, type, transferInv, ridingRocket);
            }
        }
        return null;
    }

    private static Entity teleportEntity(World worldNew, Entity entity, int dimID, ITeleportType type, boolean transferInv, EntityAutoRocket ridingRocket) {
        World worldOld;
        NBTTagCompound nbt;
        ArrayList<TileEntityTelemetry> tList;
        Entity otherRiddenEntity = null;
        if (entity.field_70154_o != null) {
            if (entity.field_70154_o instanceof EntitySpaceshipBase) {
                entity.func_70078_a(entity.field_70154_o);
            } else if (entity.field_70154_o instanceof EntityCelestialFake) {
                entity.field_70154_o.func_70106_y();
                entity.func_70078_a(null);
            } else {
                otherRiddenEntity = entity.field_70154_o;
                entity.func_70078_a(null);
            }
        }
        boolean dimChange = entity.field_70170_p != worldNew;
        entity.field_70170_p.func_72866_a(entity, false);
        EntityPlayerMP player = null;
        Vector3 spawnPos = null;
        int oldDimID = entity.field_70170_p.field_73011_w.field_76574_g;
        if (ridingRocket != null) {
            tList = ridingRocket.getTelemetry();
            nbt = new NBTTagCompound();
            ridingRocket.field_70128_L = false;
            ridingRocket.field_70153_n = null;
            ridingRocket.func_70039_c(nbt);
            WorldUtil.removeEntityFromWorld(ridingRocket.field_70170_p, ridingRocket, true);
            ridingRocket = (EntityAutoRocket)EntityList.func_75615_a((NBTTagCompound)nbt, (World)worldNew);
            if (ridingRocket != null) {
                ridingRocket.setWaitForPlayer(true);
                if (ridingRocket instanceof IWorldTransferCallback) {
                    ((IWorldTransferCallback)((Object)ridingRocket)).onWorldTransferred(worldNew);
                }
            }
        }
        if (dimChange) {
            if (entity instanceof EntityPlayerMP) {
                player = (EntityPlayerMP)entity;
                worldOld = player.field_70170_p;
                if (ConfigManagerCore.enableDebug) {
                    try {
                        GCLog.info("DEBUG: Attempting to remove player from old dimension " + oldDimID);
                        ((WorldServer)worldOld).func_73040_p().func_72695_c(player);
                        GCLog.info("DEBUG: Successfully removed player from old dimension " + oldDimID);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        ((WorldServer)worldOld).func_73040_p().func_72695_c(player);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                GCPlayerStats stats = GCPlayerStats.get(player);
                stats.usingPlanetSelectionGui = false;
                player.field_71093_bK = dimID;
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("DEBUG: Sending respawn packet to player for dim " + dimID);
                }
                player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(dimID, player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                if (worldNew.field_73011_w instanceof WorldProviderOrbit && registeredSpaceStations.containsKey(dimID)) {
                    NBTTagCompound var2 = new NBTTagCompound();
                    SpaceStationWorldData.getStationData(worldNew, dimID, (EntityPlayer)player).func_76187_b(var2);
                    GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_DATA, new Object[]{dimID, var2}), player);
                }
                WorldUtil.removeEntityFromWorld(worldOld, (Entity)player, true);
                if (worldNew.field_73011_w instanceof WorldProviderSpaceStation) {
                    GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, new Object[0]), player);
                }
                spawnPos = ridingRocket != null ? new Vector3(ridingRocket) : type.getPlayerSpawnLocation((WorldServer)worldNew, player);
                WorldUtil.forceMoveEntityToPos(entity, (WorldServer)worldNew, spawnPos, true);
                player.field_71133_b.func_71203_ab().func_72375_a(player, (WorldServer)worldNew);
                GCLog.info("Server attempting to transfer player " + player.func_146103_bH().getName() + " to dimension " + worldNew.field_73011_w.field_76574_g);
                player.field_71134_c.func_73080_a((WorldServer)worldNew);
                player.field_71133_b.func_71203_ab().func_72354_b(player, (WorldServer)worldNew);
                player.field_71133_b.func_71203_ab().func_72385_f(player);
                for (Object o : player.func_70651_bq()) {
                    PotionEffect var10 = (PotionEffect)o;
                    player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), var10));
                }
                player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
            } else {
                tList = null;
                if (entity instanceof EntitySpaceshipBase) {
                    tList = ((EntitySpaceshipBase)entity).getTelemetry();
                }
                WorldUtil.removeEntityFromWorld(entity.field_70170_p, entity, true);
                nbt = new NBTTagCompound();
                entity.field_70128_L = false;
                entity.func_70039_c(nbt);
                entity = EntityList.func_75615_a((NBTTagCompound)nbt, (World)worldNew);
                if (entity == null) {
                    return null;
                }
                if (entity instanceof IWorldTransferCallback) {
                    ((IWorldTransferCallback)entity).onWorldTransferred(worldNew);
                }
                WorldUtil.forceMoveEntityToPos(entity, (WorldServer)worldNew, new Vector3(entity), true);
                if (tList != null && tList.size() > 0) {
                    for (TileEntityTelemetry t : tList) {
                        t.addTrackedEntity(entity);
                    }
                }
            }
        } else if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            player.func_71053_j();
            GCPlayerStats stats = GCPlayerStats.get(player);
            stats.usingPlanetSelectionGui = false;
            if (worldNew.field_73011_w instanceof WorldProviderSpaceStation) {
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, new Object[0]), player);
            }
            spawnPos = ridingRocket != null ? new Vector3(ridingRocket) : type.getPlayerSpawnLocation((WorldServer)entity.field_70170_p, (EntityPlayerMP)entity);
            WorldUtil.forceMoveEntityToPos(entity, (WorldServer)worldNew, spawnPos, false);
            GCLog.info("Server attempting to transfer player " + player.func_146103_bH().getName() + " within same dimension " + worldNew.field_73011_w.field_76574_g);
        }
        if (player != null) {
            GCPlayerStats playerStats = GCPlayerStats.get(player);
            if (ridingRocket == null && type.useParachute() && playerStats.extendedInventory.func_70301_a(4) != null && playerStats.extendedInventory.func_70301_a(4).func_77973_b() instanceof ItemParaChute) {
                GCPlayerHandler.setUsingParachute(player, playerStats, true);
            } else {
                GCPlayerHandler.setUsingParachute(player, playerStats, false);
            }
            if (playerStats.rocketStacks != null && playerStats.rocketStacks.length > 0) {
                for (int stack = 0; stack < playerStats.rocketStacks.length; ++stack) {
                    if (transferInv) {
                        if (playerStats.rocketStacks[stack] != null) continue;
                        if (stack == playerStats.rocketStacks.length - 1) {
                            if (playerStats.rocketItem == null) continue;
                            ItemStack rocket = new ItemStack(playerStats.rocketItem, 1, playerStats.rocketType);
                            NBTTagCompound nbt2 = new NBTTagCompound();
                            nbt2.func_74768_a("RocketFuel", playerStats.fuelLevel);
                            rocket.func_77982_d(nbt2);
                            playerStats.fuelLevel = 0;
                            playerStats.rocketStacks[stack] = rocket;
                            continue;
                        }
                        if (stack != playerStats.rocketStacks.length - 2) continue;
                        playerStats.rocketStacks[stack] = playerStats.launchpadStack;
                        playerStats.launchpadStack = null;
                        continue;
                    }
                    playerStats.rocketStacks[stack] = null;
                }
            }
            if (transferInv && playerStats.chestSpawnCooldown == 0) {
                playerStats.chestSpawnVector = type.getParaChestSpawnLocation((WorldServer)entity.field_70170_p, player, new Random());
                playerStats.chestSpawnCooldown = 200;
            }
        }
        if (ridingRocket != null) {
            worldNew.func_72838_d((Entity)ridingRocket);
            ridingRocket.func_70029_a(worldNew);
            worldNew.func_72866_a((Entity)ridingRocket, true);
            entity.func_70078_a((Entity)ridingRocket);
            GCLog.debug("Entering rocket at : " + entity.field_70165_t + "," + entity.field_70161_v + " rocket at: " + ridingRocket.field_70165_t + "," + ridingRocket.field_70161_v);
        } else if (otherRiddenEntity != null) {
            if (dimChange) {
                worldOld = otherRiddenEntity.field_70170_p;
                NBTTagCompound nbt3 = new NBTTagCompound();
                otherRiddenEntity.func_70039_c(nbt3);
                WorldUtil.removeEntityFromWorld(worldOld, otherRiddenEntity, true);
                otherRiddenEntity = EntityList.func_75615_a((NBTTagCompound)nbt3, (World)worldNew);
                worldNew.func_72838_d(otherRiddenEntity);
                otherRiddenEntity.func_70029_a(worldNew);
            }
            otherRiddenEntity.func_70080_a(entity.field_70165_t, entity.field_70163_u - 10.0, entity.field_70161_v, otherRiddenEntity.field_70177_z, otherRiddenEntity.field_70125_A);
            worldNew.func_72866_a(otherRiddenEntity, true);
        }
        if (entity instanceof EntityPlayerMP) {
            if (dimChange) {
                FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)((EntityPlayerMP)entity), oldDimID, dimID);
            }
            if (ridingRocket == null) {
                type.onSpaceDimensionChanged(worldNew, (EntityPlayerMP)entity, ridingRocket != null);
            }
        }
        return entity;
    }

    public static void forceMoveEntityToPos(Entity entity, WorldServer worldNew, Vector3 spawnPos, boolean spawnRequired) {
        ChunkCoordIntPair pair = worldNew.func_72964_e(spawnPos.intX() >> 4, spawnPos.intZ() >> 4).func_76632_l();
        GCLog.debug("Loading first chunk in new dimension at " + pair.field_77276_a + "," + pair.field_77275_b);
        worldNew.field_73059_b.func_73158_c(pair.field_77276_a, pair.field_77275_b);
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.func_147364_a(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
        }
        entity.func_70012_b(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
        if (spawnRequired) {
            worldNew.func_72838_d(entity);
            entity.func_70029_a((World)worldNew);
        }
        worldNew.func_72866_a(entity, true);
    }

    public static WorldServer getStartWorld(WorldServer worldOld) {
        if (ConfigManagerCore.challengeSpawnHandling) {
            WorldServer worldNew;
            WorldProvider wp = WorldUtil.getProviderForNameServer("planet.asteroids");
            WorldServer worldServer = worldNew = wp == null ? null : (WorldServer)wp.field_76579_a;
            if (worldNew != null) {
                return worldNew;
            }
        }
        return worldOld;
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer forceRespawnClient(int dimID, int par2, String par3, int par4) {
        S07PacketRespawn fakePacket = new S07PacketRespawn(dimID, EnumDifficulty.func_151523_a((int)par2), WorldType.func_77130_a((String)par3), WorldSettings.GameType.func_77146_a((int)par4));
        Minecraft.func_71410_x().func_147114_u().func_147280_a(fakePacket);
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    private static void removeEntityFromWorld(World var0, Entity var1, boolean directlyRemove) {
        if (var1 instanceof EntityPlayer) {
            EntityPlayer var2 = (EntityPlayer)var1;
            var2.func_71053_j();
            var0.field_73010_i.remove(var2);
            var0.func_72854_c();
        }
        if (directlyRemove) {
            ArrayList<Entity> l = new ArrayList<Entity>();
            l.add(var1);
            var0.func_72828_b(l);
        }
        var1.field_70128_L = false;
    }

    public static SpaceStationRecipe getSpaceStationRecipe(int planetID) {
        for (SpaceStationType type : GalacticraftRegistry.getSpaceStationData()) {
            if (type.getWorldToOrbitID() != planetID) continue;
            return type.getRecipeForSpaceStation();
        }
        return null;
    }

    public static List<Object> getPlanetList() {
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(WorldUtil.getPlanetListInts());
        return objList;
    }

    public static Integer[] getPlanetListInts() {
        Integer[] iArray = new Integer[registeredPlanets.size()];
        for (int i = 0; i < iArray.length; ++i) {
            iArray[i] = registeredPlanets.get(i);
        }
        return iArray;
    }

    public static void decodePlanetsListClient(List<Object> data) {
        try {
            if (ConfigManagerCore.enableDebug) {
                GCLog.info("GC connecting to server: received planets dimension ID list.");
            }
            if (registeredPlanets != null) {
                for (Integer registeredID : registeredPlanets) {
                    DimensionManager.unregisterDimension((int)registeredID);
                }
            }
            registeredPlanets = new ArrayList<Integer>();
            String ids = "";
            if (data.size() > 0) {
                int providerIndex = GalaxyRegistry.getRegisteredSatellites().size() * 2;
                if (data.get(0) instanceof Integer) {
                    for (Object o : data) {
                        WorldUtil.registerPlanetClient((Integer)o, providerIndex);
                        ++providerIndex;
                        ids = ids + ((Integer)o).toString() + " ";
                    }
                } else if (data.get(0) instanceof Integer[]) {
                    for (Integer o : (Integer[])data.get(0)) {
                        WorldUtil.registerPlanetClient(o, providerIndex);
                        ++providerIndex;
                        ids = ids + o.toString() + " ";
                    }
                }
            }
            if (ConfigManagerCore.enableDebug) {
                WorldProvider dimAst;
                WorldProvider dimMars;
                GCLog.debug("GC clientside planet dimensions registered: " + ids);
                WorldProvider dimMoon = WorldUtil.getProviderForNameClient("moon.moon");
                if (dimMoon != null) {
                    GCLog.debug("Crosscheck: Moon is " + dimMoon.field_76574_g);
                }
                if ((dimMars = WorldUtil.getProviderForNameClient("planet.mars")) != null) {
                    GCLog.debug("Crosscheck: Mars is " + dimMars.field_76574_g);
                }
                if ((dimAst = WorldUtil.getProviderForNameClient("planet.asteroids")) != null) {
                    GCLog.debug("Crosscheck: Asteroids is " + dimAst.field_76574_g);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Object> getSpaceStationList() {
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(WorldUtil.getSpaceStationListInts());
        return objList;
    }

    public static Integer[] getSpaceStationListInts() {
        Integer[] iArray = new Integer[registeredSpaceStations.size() * 2];
        int i = 0;
        for (Map.Entry<Integer, Integer> e : registeredSpaceStations.entrySet()) {
            iArray[i] = e.getKey();
            iArray[i + 1] = e.getValue();
            i += 2;
        }
        return iArray;
    }

    public static void decodeSpaceStationListClient(List<Object> data) {
        try {
            if (registeredSpaceStations != null) {
                for (Integer registeredID : registeredSpaceStations.keySet()) {
                    DimensionManager.unregisterDimension((int)registeredID);
                }
            }
            registeredSpaceStations = Maps.newHashMap();
            if (data.size() > 0) {
                if (data.get(0) instanceof Integer) {
                    for (int i = 0; i < data.size(); i += 2) {
                        WorldUtil.registerSSdim((Integer)data.get(i), (Integer)data.get(i + 1));
                    }
                } else if (data.get(0) instanceof Integer[]) {
                    Integer[] array = (Integer[])data.get(0);
                    for (int i = 0; i < array.length; i += 2) {
                        WorldUtil.registerSSdim(array[i], array[i + 1]);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void registerSSdim(Integer dimID, Integer providerKey) {
        if (!registeredSpaceStations.containsKey(dimID)) {
            if (!DimensionManager.isDimensionRegistered((int)dimID)) {
                registeredSpaceStations.put(dimID, providerKey);
                DimensionManager.registerDimension((int)dimID, (int)providerKey);
            } else {
                GCLog.severe("Dimension already registered on client: unable to register space station dimension " + dimID);
            }
        }
    }

    public static boolean otherModPreventGenerate(int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!(world.field_73011_w instanceof IGalacticraftWorldProvider)) {
            return false;
        }
        if (world.field_73011_w instanceof WorldProviderSpaceStation) {
            return true;
        }
        if (ConfigManagerCore.enableOtherModsFeatures) {
            return false;
        }
        if (!generatorsInitialised) {
            Set registeredGenerators;
            Field regField;
            block42: {
                block41: {
                    block40: {
                        block39: {
                            generatorsInitialised = true;
                            try {
                                Class<?> GCGreg = Class.forName("bloodasp.galacticgreg.GT_Worldgenerator_Space");
                                if (GCGreg == null) break block39;
                                regField = Class.forName("cpw.mods.fml.common.registry.GameRegistry").getDeclaredField("worldGenerators");
                                regField.setAccessible(true);
                                registeredGenerators = (Set)regField.get(null);
                                for (IWorldGenerator gen : registeredGenerators) {
                                    if (!GCGreg.isInstance(gen)) continue;
                                    generatorGCGreg = gen;
                                    break;
                                }
                            }
                            catch (Exception GCGreg) {
                                // empty catch block
                            }
                        }
                        try {
                            Class<?> cofh = Class.forName("cofh.core.world.WorldHandler");
                            if (cofh == null || !ConfigManagerCore.whitelistCoFHCoreGen) break block40;
                            regField = Class.forName("cpw.mods.fml.common.registry.GameRegistry").getDeclaredField("worldGenerators");
                            regField.setAccessible(true);
                            registeredGenerators = (Set)regField.get(null);
                            for (IWorldGenerator gen : registeredGenerators) {
                                if (!cofh.isInstance(gen)) continue;
                                generatorCoFH = gen;
                                break;
                            }
                        }
                        catch (Exception cofh) {
                            // empty catch block
                        }
                    }
                    try {
                        Class<?> denseOres = Class.forName("com.rwtema.denseores.WorldGenOres");
                        if (denseOres == null) break block41;
                        regField = Class.forName("cpw.mods.fml.common.registry.GameRegistry").getDeclaredField("worldGenerators");
                        regField.setAccessible(true);
                        registeredGenerators = (Set)regField.get(null);
                        for (IWorldGenerator gen : registeredGenerators) {
                            if (!denseOres.isInstance(gen)) continue;
                            generatorDenseOres = gen;
                            break;
                        }
                    }
                    catch (Exception denseOres) {
                        // empty catch block
                    }
                }
                try {
                    Class<?> ae2meteorPlace = null;
                    try {
                        ae2meteorPlace = Class.forName("appeng.hooks.MeteoriteWorldGen");
                    }
                    catch (ClassNotFoundException regField2) {
                        // empty catch block
                    }
                    if (ae2meteorPlace == null) {
                        try {
                            ae2meteorPlace = Class.forName("appeng.worldgen.MeteoriteWorldGen");
                        }
                        catch (ClassNotFoundException regField2) {
                            // empty catch block
                        }
                    }
                    if (ae2meteorPlace == null) break block42;
                    regField = Class.forName("cpw.mods.fml.common.registry.GameRegistry").getDeclaredField("worldGenerators");
                    regField.setAccessible(true);
                    registeredGenerators = (Set)regField.get(null);
                    for (IWorldGenerator gen : registeredGenerators) {
                        if (!ae2meteorPlace.isInstance(gen)) continue;
                        generatorAE2meteors = gen;
                        break;
                    }
                }
                catch (Exception ae2meteorPlace) {
                    // empty catch block
                }
            }
            try {
                Class<?> genThaumCraft = Class.forName("thaumcraft.common.lib.world.ThaumcraftWorldGenerator");
                if (genThaumCraft != null) {
                    regField = Class.forName("cpw.mods.fml.common.registry.GameRegistry").getDeclaredField("worldGenerators");
                    regField.setAccessible(true);
                    registeredGenerators = (Set)regField.get(null);
                    for (IWorldGenerator gen : registeredGenerators) {
                        if (!genThaumCraft.isInstance(gen)) continue;
                        generatorTCAuraNodes = gen;
                        break;
                    }
                    if (generatorTCAuraNodes != null && ConfigManagerCore.enableThaumCraftNodes) {
                        generateTCAuraNodes = genThaumCraft.getDeclaredMethod("generateWildNodes", World.class, Random.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                        generateTCAuraNodes.setAccessible(true);
                    }
                }
            }
            catch (Exception genThaumCraft) {
                // empty catch block
            }
            if (generatorGCGreg != null) {
                System.out.println("Whitelisting GalacticGreg oregen on planets.");
            }
            if (generatorCoFH != null) {
                System.out.println("Whitelisting CoFHCore custom oregen on planets.");
            }
            if (generatorDenseOres != null) {
                System.out.println("Whitelisting Dense Ores oregen on planets.");
            }
            if (generatorAE2meteors != null) {
                System.out.println("Whitelisting AE2 meteorites worldgen on planets.");
            }
            if (generatorTCAuraNodes != null && generateTCAuraNodes != null) {
                System.out.println("Whitelisting ThaumCraft aura node generation on planets.");
            }
        }
        if (generatorGCGreg != null || generatorCoFH != null || generatorDenseOres != null || generatorTCAuraNodes != null || generatorAE2meteors != null) {
            try {
                long worldSeed = world.func_72905_C();
                Random fmlRandom = new Random(worldSeed);
                long xSeed = fmlRandom.nextLong() >> 3;
                long zSeed = fmlRandom.nextLong() >> 3;
                long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
                fmlRandom.setSeed(chunkSeed);
                if (generatorCoFH != null) {
                    generatorCoFH.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                }
                if (generatorDenseOres != null) {
                    generatorDenseOres.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                }
                if (generatorGCGreg != null) {
                    generatorGCGreg.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                }
                if (generatorAE2meteors != null) {
                    generatorAE2meteors.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                }
                if (generateTCAuraNodes != null) {
                    generateTCAuraNodes.invoke((Object)generatorTCAuraNodes, world, fmlRandom, chunkX, chunkZ, false, true);
                }
            }
            catch (Exception e) {
                GCLog.severe("Error in another mod's worldgen.  This is NOT a Galacticraft bug.");
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void toCelestialSelection(EntityPlayerMP player, GCPlayerStats stats, int tier) {
        player.func_70078_a(null);
        stats.spaceshipTier = tier;
        HashMap<String, Integer> map = WorldUtil.getArrayOfPossibleDimensions(tier, player);
        String dimensionList = "";
        int count = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            dimensionList = dimensionList.concat(entry.getKey() + (count < map.entrySet().size() - 1 ? "?" : ""));
            ++count;
        }
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_DIMENSION_LIST, new Object[]{player.func_146103_bH().getName(), dimensionList}), player);
        stats.usingPlanetSelectionGui = true;
        stats.savedPlanetList = new String(dimensionList);
        EntityCelestialFake fakeEntity = new EntityCelestialFake(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f);
        player.field_70170_p.func_72838_d((Entity)fakeEntity);
        player.func_70078_a((Entity)fakeEntity);
    }

    public static Vector3 getFootprintPosition(World world, float rotation, Vector3 startPosition, BlockVec3 playerCenter) {
        int mainPosZ;
        int mainPosY;
        Vector3 position = startPosition.clone();
        float footprintScale = 0.375f;
        int mainPosX = position.intX();
        Block b1 = world.func_147439_a(mainPosX, mainPosY = position.intY(), mainPosZ = position.intZ());
        if (b1 != null && b1.isAir((IBlockAccess)world, mainPosX, mainPosY, mainPosZ)) {
            position.x += (double)(playerCenter.x - mainPosX);
            position.z += (double)(playerCenter.z - mainPosZ);
            Block b2 = world.func_147439_a(position.intX(), position.intY(), position.intZ());
            if (b2 != null && b2.isAir((IBlockAccess)world, position.intX(), position.intY(), position.intZ())) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    Block b3;
                    if (direction == ForgeDirection.DOWN || direction == ForgeDirection.UP || (b3 = world.func_147439_a(mainPosX + direction.offsetX, mainPosY, mainPosZ + direction.offsetZ)) == null || b3.isAir((IBlockAccess)world, mainPosX + direction.offsetX, mainPosY, mainPosZ + direction.offsetZ)) continue;
                    position.x += (double)direction.offsetX;
                    position.z += (double)direction.offsetZ;
                    break;
                }
            }
        }
        mainPosX = position.intX();
        mainPosZ = position.intZ();
        double x0 = Math.sin((double)(45.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.x;
        double x1 = Math.sin((double)(135.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.x;
        double x2 = Math.sin((double)(225.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.x;
        double x3 = Math.sin((double)(315.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.x;
        double z0 = Math.cos((double)(45.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.z;
        double z1 = Math.cos((double)(135.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.z;
        double z2 = Math.cos((double)(225.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.z;
        double z3 = Math.cos((double)(315.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.z;
        double xMin = Math.min(Math.min(x0, x1), Math.min(x2, x3));
        double xMax = Math.max(Math.max(x0, x1), Math.max(x2, x3));
        double zMin = Math.min(Math.min(z0, z1), Math.min(z2, z3));
        double zMax = Math.max(Math.max(z0, z1), Math.max(z2, z3));
        if (xMin < (double)mainPosX) {
            position.x += (double)mainPosX - xMin;
        }
        if (xMax > (double)(mainPosX + 1)) {
            position.x -= xMax - (double)(mainPosX + 1);
        }
        if (zMin < (double)mainPosZ) {
            position.z += (double)mainPosZ - zMin;
        }
        if (zMax > (double)(mainPosZ + 1)) {
            position.z -= zMax - (double)(mainPosZ + 1);
        }
        return position;
    }

    public static String spaceStationDataToString(HashMap<Integer, Integer> data) {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<Integer, Integer>> it = data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Integer> e = it.next();
            builder.append(e.getKey());
            builder.append("$");
            builder.append(e.getValue());
            if (!it.hasNext()) continue;
            builder.append("?");
        }
        return builder.toString();
    }

    public static HashMap<Integer, Integer> stringToSpaceStationData(String input) {
        HashMap data = Maps.newHashMap();
        if (!input.isEmpty()) {
            String[] str0 = input.split("\\?");
            for (int i = 0; i < str0.length; ++i) {
                String[] str1 = str0[i].split("\\$");
                data.put(Integer.parseInt(str1[0]), Integer.parseInt(str1[1]));
            }
        }
        return data;
    }

    public static String getDimensionName(WorldProvider wp) {
        CelestialBody cb;
        if (wp instanceof IGalacticraftWorldProvider && (cb = ((IGalacticraftWorldProvider)wp).getCelestialBody()) != null && !(cb instanceof Satellite)) {
            return cb.getUnlocalizedName();
        }
        if (wp.field_76574_g == ConfigManagerCore.idDimensionOverworld) {
            return "Overworld";
        }
        return wp.func_80007_l();
    }

    public static void setNextMorning(WorldServer world) {
        long current = world.func_72912_H().func_76073_f();
        long dayLength = 24000L;
        long newTime = current - current % dayLength + dayLength;
        if (world.field_73011_w instanceof WorldProviderSpace) {
            dayLength = ((WorldProviderSpace)world.field_73011_w).getDayLength();
            if (dayLength <= 0L) {
                return;
            }
            newTime = current - current % dayLength + dayLength;
        } else {
            long diff = newTime - current;
            for (WorldServer worldServer : MinecraftServer.func_71276_C().field_71305_c) {
                if (worldServer == world || !(worldServer.field_73011_w instanceof WorldProviderSpace)) continue;
                ((WorldProviderSpace)worldServer.field_73011_w).adjustTimeOffset(diff);
            }
        }
        world.field_73011_w.setWorldTime(newTime);
    }

    static {
        dimNames = new TreeMap<Integer, String>();
        celestialMapCache = new MapMaker().weakKeys().makeMap();
        generatorGCGreg = null;
        generatorCoFH = null;
        generatorDenseOres = null;
        generatorTCAuraNodes = null;
        generatorAE2meteors = null;
        generateTCAuraNodes = null;
        generatorsInitialised = false;
    }
}

