/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tick;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockUnlitTorch;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRace;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRaceManager;
import micdoodle8.mods.galacticraft.core.dimension.WorldDataSpaceRaces;
import micdoodle8.mods.galacticraft.core.energy.grid.EnergyNetwork;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseConductor;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.oxygen.ThreadFindSeal;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenTransmitter;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.MapUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.Footprint;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledBlockChange;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityHydrogenPipe;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;

public class TickHandlerServer {
    private static Map<Integer, CopyOnWriteArrayList<ScheduledBlockChange>> scheduledBlockChanges = new ConcurrentHashMap<Integer, CopyOnWriteArrayList<ScheduledBlockChange>>();
    private static Map<Integer, CopyOnWriteArrayList<BlockVec3>> scheduledTorchUpdates = new ConcurrentHashMap<Integer, CopyOnWriteArrayList<BlockVec3>>();
    private static Map<Integer, List<BlockVec3>> edgeChecks = new HashMap<Integer, List<BlockVec3>>();
    private static LinkedList<EnergyNetwork> networkTicks = new LinkedList();
    public static Map<Integer, Map<Long, List<Footprint>>> serverFootprintMap = new HashMap<Integer, Map<Long, List<Footprint>>>();
    public static List<BlockVec3Dim> footprintBlockChanges = Lists.newArrayList();
    public static WorldDataSpaceRaces spaceRaceData = null;
    public static ArrayList<EntityPlayerMP> playersRequestingMapData = Lists.newArrayList();
    private static long tickCount;
    public static LinkedList<TileEntityOxygenTransmitter> oxygenTransmitterUpdates;
    public static LinkedList<TileEntityHydrogenPipe> hydrogenTransmitterUpdates;
    public static LinkedList<TileBaseConductor> energyTransmitterUpdates;
    private final int MAX_BLOCKS_PER_TICK = 50000;

    public static void restart() {
        scheduledBlockChanges.clear();
        scheduledTorchUpdates.clear();
        edgeChecks.clear();
        networkTicks.clear();
        serverFootprintMap.clear();
        oxygenTransmitterUpdates.clear();
        hydrogenTransmitterUpdates.clear();
        energyTransmitterUpdates.clear();
        playersRequestingMapData.clear();
        networkTicks.clear();
        for (SpaceRace race : SpaceRaceManager.getSpaceRaces()) {
            SpaceRaceManager.removeSpaceRace(race);
        }
        spaceRaceData = null;
        tickCount = 0L;
        MapUtil.reset();
    }

    public static void addFootprint(long chunkKey, Footprint print, int dimID) {
        List<Footprint> footprints;
        Map<Long, List<Footprint>> footprintMap = serverFootprintMap.get(dimID);
        if (footprintMap == null) {
            footprintMap = new HashMap<Long, List<Footprint>>();
            footprints = new ArrayList<Footprint>();
        } else {
            footprints = footprintMap.get(chunkKey);
            if (footprints == null) {
                footprints = new ArrayList<Footprint>();
            }
        }
        footprints.add(print);
        footprintMap.put(chunkKey, footprints);
        serverFootprintMap.put(dimID, footprintMap);
    }

    public static void scheduleNewBlockChange(int dimID, ScheduledBlockChange change) {
        CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList == null) {
            changeList = new CopyOnWriteArrayList();
        }
        changeList.add(change);
        scheduledBlockChanges.put(dimID, changeList);
    }

    public static void scheduleNewBlockChange(int dimID, List<ScheduledBlockChange> changeAdd) {
        CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList == null) {
            changeList = new CopyOnWriteArrayList();
        }
        changeList.addAll(changeAdd);
        scheduledBlockChanges.put(dimID, changeList);
    }

    public static void scheduleNewTorchUpdate(int dimID, List<BlockVec3> torches) {
        CopyOnWriteArrayList<BlockVec3> updateList = scheduledTorchUpdates.get(dimID);
        if (updateList == null) {
            updateList = new CopyOnWriteArrayList();
        }
        updateList.addAll(torches);
        scheduledTorchUpdates.put(dimID, updateList);
    }

    public static void scheduleNewEdgeCheck(int dimID, BlockVec3 edgeBlock) {
        List<BlockVec3> updateList = edgeChecks.get(dimID);
        if (updateList == null) {
            updateList = new ArrayList<BlockVec3>();
        }
        updateList.add(edgeBlock);
        edgeChecks.put(dimID, updateList);
    }

    public static boolean scheduledForChange(int dimID, BlockVec3 test) {
        CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList != null) {
            for (ScheduledBlockChange change : changeList) {
                if (!test.equals(change.getChangePosition())) continue;
                return true;
            }
        }
        return false;
    }

    public static void scheduleNetworkTick(EnergyNetwork grid) {
        networkTicks.add(grid);
    }

    public static void removeNetworkTick(EnergyNetwork grid) {
        networkTicks.remove(grid);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            if (MapUtil.calculatingMap.get()) {
                MapUtil.BiomeMapNextTick();
            } else if (!MapUtil.doneOverworldTexture) {
                MapUtil.makeOverworldTexture();
            }
            if (spaceRaceData == null) {
                WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
                spaceRaceData = (WorldDataSpaceRaces)world.field_72988_C.func_75742_a(WorldDataSpaceRaces.class, "GCSpaceRaceData");
                if (spaceRaceData == null) {
                    spaceRaceData = new WorldDataSpaceRaces("GCSpaceRaceData");
                    world.field_72988_C.func_75745_a("GCSpaceRaceData", (WorldSavedData)spaceRaceData);
                }
            }
            SpaceRaceManager.tick();
            TileEntityOxygenSealer.onServerTick();
            if (tickCount % 100L == 0L) {
                WorldServer[] worlds = server.field_71305_c;
                for (int i = 0; i < worlds.length; ++i) {
                    Object world = worlds[i];
                    ChunkProviderServer chunkProviderServer = ((WorldServer)world).field_73059_b;
                    Map<Long, List<Footprint>> footprintMap = serverFootprintMap.get(((WorldServer)world).field_73011_w.field_76574_g);
                    if (footprintMap == null) continue;
                    boolean mapChanged = false;
                    if (chunkProviderServer != null) {
                        for (Chunk chunk : chunkProviderServer.field_73245_g) {
                            long chunkKey = ChunkCoordIntPair.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h);
                            List<Footprint> footprints = footprintMap.get(chunkKey);
                            if (footprints == null) continue;
                            ArrayList<Footprint> toRemove = new ArrayList<Footprint>();
                            for (int j = 0; j < footprints.size(); ++j) {
                                footprints.get((int)j).age = (short)(footprints.get((int)j).age + 100);
                                if (footprints.get((int)j).age < 3200) continue;
                                toRemove.add(footprints.get(j));
                            }
                            if (!toRemove.isEmpty()) {
                                footprints.removeAll(toRemove);
                            }
                            footprintMap.put(chunkKey, footprints);
                            mapChanged = true;
                            GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_FOOTPRINT_LIST, new Object[]{chunkKey, footprints.toArray(new Footprint[footprints.size()])}), ((WorldServer)worlds[i]).field_73011_w.field_76574_g);
                        }
                    }
                    if (!mapChanged) continue;
                    serverFootprintMap.put(((WorldServer)world).field_73011_w.field_76574_g, footprintMap);
                }
            }
            if (!footprintBlockChanges.isEmpty()) {
                for (BlockVec3Dim targetPoint : footprintBlockChanges) {
                    WorldServer[] worlds = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c;
                    for (int i = 0; i < worlds.length; ++i) {
                        WorldServer world = worlds[i];
                        if (world.field_73011_w.field_76574_g != targetPoint.dim) continue;
                        long chunkKey = ChunkCoordIntPair.func_77272_a((int)(targetPoint.x >> 4), (int)(targetPoint.z >> 4));
                        GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_FOOTPRINTS_REMOVED, new Object[]{chunkKey, new BlockVec3(targetPoint.x, targetPoint.y, targetPoint.z)}), new NetworkRegistry.TargetPoint(targetPoint.dim, (double)targetPoint.x, (double)targetPoint.y, (double)targetPoint.z, 50.0));
                    }
                }
                footprintBlockChanges.clear();
            }
            if (tickCount % 20L == 0L && !playersRequestingMapData.isEmpty()) {
                File baseFolder = new File(MinecraftServer.func_71276_C().func_71218_a(0).getChunkSaveLocation(), "galacticraft/overworldMap");
                if (!baseFolder.exists() && !baseFolder.mkdirs()) {
                    GCLog.severe("Base folder(s) could not be created: " + baseFolder.getAbsolutePath());
                } else {
                    ArrayList<EntityPlayerMP> copy = new ArrayList<EntityPlayerMP>(playersRequestingMapData);
                    BufferedImage reusable = new BufferedImage(400, 400, 1);
                    for (EntityPlayerMP playerMP : copy) {
                        GCPlayerStats stats = GCPlayerStats.get(playerMP);
                        MapUtil.makeVanillaMap(playerMP.field_71093_bK, (int)Math.floor(stats.coordsTeleportedFromX) >> 4, (int)Math.floor(stats.coordsTeleportedFromZ) >> 4, baseFolder, reusable);
                    }
                    playersRequestingMapData.removeAll(copy);
                }
            }
            if (++tickCount >= Long.MAX_VALUE) {
                tickCount = 0L;
            }
            ++EnergyNetwork.tickCount;
        } else if (event.phase == TickEvent.Phase.END) {
            LinkedList<Object> pass;
            int maxPasses = 10;
            while (!networkTicks.isEmpty()) {
                pass = new LinkedList<Object>();
                pass.addAll(networkTicks);
                networkTicks.clear();
                for (EnergyNetwork energyNetwork : pass) {
                    energyNetwork.tickEnd();
                }
                if (--maxPasses > 0) continue;
                break;
            }
            maxPasses = 10;
            while (!oxygenTransmitterUpdates.isEmpty()) {
                pass = new LinkedList();
                pass.addAll(oxygenTransmitterUpdates);
                oxygenTransmitterUpdates.clear();
                for (TileEntityOxygenTransmitter tileEntityOxygenTransmitter : pass) {
                    if (tileEntityOxygenTransmitter.func_145837_r()) continue;
                    tileEntityOxygenTransmitter.refresh();
                }
                if (--maxPasses > 0) continue;
                break;
            }
            maxPasses = 10;
            while (!hydrogenTransmitterUpdates.isEmpty()) {
                pass = new LinkedList();
                pass.addAll(hydrogenTransmitterUpdates);
                hydrogenTransmitterUpdates.clear();
                for (TileEntityHydrogenPipe tileEntityHydrogenPipe : pass) {
                    if (tileEntityHydrogenPipe.func_145837_r()) continue;
                    tileEntityHydrogenPipe.refresh();
                }
                if (--maxPasses > 0) continue;
                break;
            }
            maxPasses = 10;
            while (!energyTransmitterUpdates.isEmpty()) {
                pass = new LinkedList();
                pass.addAll(energyTransmitterUpdates);
                energyTransmitterUpdates.clear();
                for (TileBaseConductor tileBaseConductor : pass) {
                    if (tileBaseConductor.func_145837_r()) continue;
                    tileBaseConductor.refresh();
                }
                if (--maxPasses > 0) continue;
                break;
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            CopyOnWriteArrayList<BlockVec3> torchList;
            WorldServer world = (WorldServer)event.world;
            CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(world.field_73011_w.field_76574_g);
            if (changeList != null && !changeList.isEmpty()) {
                int blockCount = 0;
                int blockCountMax = Math.max(this.MAX_BLOCKS_PER_TICK, changeList.size() / 4);
                ArrayList<ScheduledBlockChange> newList = new ArrayList<ScheduledBlockChange>(Math.max(0, changeList.size() - blockCountMax));
                for (ScheduledBlockChange change : changeList) {
                    if (++blockCount > blockCountMax) {
                        newList.add(change);
                        continue;
                    }
                    if (change == null) continue;
                    BlockVec3 changePosition = change.getChangePosition();
                    Block block = world.func_147439_a(changePosition.x, changePosition.y, changePosition.z);
                    if (changePosition == null || !(block instanceof BlockAir) && block != Blocks.field_150480_ab) continue;
                    world.func_147465_d(changePosition.x, changePosition.y, changePosition.z, change.getChangeID(), change.getChangeMeta(), change.getChangeUpdateFlag());
                }
                changeList.clear();
                scheduledBlockChanges.remove(world.field_73011_w.field_76574_g);
                if (newList.size() > 0) {
                    scheduledBlockChanges.put(world.field_73011_w.field_76574_g, new CopyOnWriteArrayList(newList));
                }
            }
            if ((torchList = scheduledTorchUpdates.get(world.field_73011_w.field_76574_g)) != null && !torchList.isEmpty()) {
                for (BlockVec3 torch : torchList) {
                    Block b;
                    if (torch == null || !((b = world.func_147439_a(torch.x, torch.y, torch.z)) instanceof BlockUnlitTorch)) continue;
                    world.func_147454_a(torch.x, torch.y, torch.z, b, 2 + world.field_73012_v.nextInt(30), 0);
                }
                torchList.clear();
                scheduledTorchUpdates.remove(world.field_73011_w.field_76574_g);
            }
            if (world.field_73011_w instanceof IOrbitDimension) {
                Object[] entityList;
                for (Object o : entityList = world.field_72996_f.toArray()) {
                    IOrbitDimension dimension;
                    if (!(o instanceof Entity)) continue;
                    Entity e = (Entity)o;
                    if (!(e.field_70170_p.field_73011_w instanceof IOrbitDimension) || !(e.field_70163_u <= (double)(dimension = (IOrbitDimension)e.field_70170_p.field_73011_w).getYCoordToTeleportToPlanet())) continue;
                    int dim = 0;
                    try {
                        dim = WorldUtil.getProviderForNameServer((String)dimension.getPlanetToOrbit()).field_76574_g;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    WorldUtil.transferEntityToDimension(e, dim, world, false, null);
                }
            }
        } else if (event.phase == TickEvent.Phase.END) {
            WorldServer world = (WorldServer)event.world;
            List<BlockVec3> edgesList = edgeChecks.get(world.field_73011_w.field_76574_g);
            HashSet<BlockVec3> checkedThisTick = new HashSet<BlockVec3>();
            if (edgesList != null && !edgesList.isEmpty()) {
                ArrayList<BlockVec3> edgesListCopy = new ArrayList<BlockVec3>();
                edgesListCopy.addAll(edgesList);
                for (BlockVec3 edgeBlock : edgesListCopy) {
                    if (edgeBlock == null || checkedThisTick.contains(edgeBlock) || TickHandlerServer.scheduledForChange(world.field_73011_w.field_76574_g, edgeBlock)) continue;
                    ThreadFindSeal done = new ThreadFindSeal((World)world, edgeBlock, 2000, new ArrayList<TileEntityOxygenSealer>());
                    checkedThisTick.addAll(done.checkedAll());
                }
                edgeChecks.remove(world.field_73011_w.field_76574_g);
            }
        }
    }

    static {
        oxygenTransmitterUpdates = new LinkedList();
        hydrogenTransmitterUpdates = new LinkedList();
        energyTransmitterUpdates = new LinkedList();
    }
}

