/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import ic2.api.tile.IWrenchable;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(modid="IC2API", iface="ic2.api.tile.IWrenchable")
public abstract class TileBaseElectricBlock
extends TileBaseUniversalElectrical
implements IDisableableMachine,
IConnector,
IWrenchable {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean disabled = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int disableCooldown = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean hasEnoughEnergyToRun = false;
    public boolean noRedstoneControl = false;

    public boolean shouldPullEnergy() {
        return this.shouldUseEnergy() || this.getEnergyStoredGC(null) < this.getMaxEnergyStoredGC();
    }

    public abstract boolean shouldUseEnergy();

    public abstract ForgeDirection getElectricInputDirection();

    public abstract ItemStack getBatteryInSlot();

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStoredGC(null) * (float)i / this.getMaxEnergyStoredGC(null));
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.shouldPullEnergy() && this.getEnergyStoredGC(null) < this.getMaxEnergyStoredGC(null) && this.getBatteryInSlot() != null && this.getElectricInputDirection() != null) {
                this.discharge(this.getBatteryInSlot());
            }
            if (this.getEnergyStoredGC(null) > this.storage.getMaxExtract() && (this.noRedstoneControl || !RedstoneUtil.isBlockReceivingRedstone(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e))) {
                this.hasEnoughEnergyToRun = true;
                if (this.shouldUseEnergy()) {
                    this.storage.extractEnergyGC(this.storage.getMaxExtract(), false);
                } else {
                    this.slowDischarge();
                }
            } else {
                this.hasEnoughEnergyToRun = false;
                this.slowDischarge();
            }
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.disableCooldown > 0) {
            --this.disableCooldown;
        }
    }

    public void slowDischarge() {
        if (this.ticks % 10 == 0) {
            this.storage.extractEnergyGC(5.0f, false);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("isDisabled", this.getDisabled(0));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setDisabled(0, nbt.func_74767_n("isDisabled"));
    }

    @Override
    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 10;
        }
    }

    @Override
    public boolean getDisabled(int index) {
        return this.disabled;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public short getFacing() {
        return (short)this.field_145850_b.func_72805_g(MathHelper.func_76128_c((double)this.field_145851_c), MathHelper.func_76128_c((double)this.field_145848_d), MathHelper.func_76128_c((double)this.field_145849_e));
    }

    public void setFacing(short facing) {
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return false;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return this.func_145838_q().getPickBlock(null, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, entityPlayer);
    }

    @Override
    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        if (this.getElectricInputDirection() == null) {
            return EnumSet.noneOf(ForgeDirection.class);
        }
        return EnumSet.of(this.getElectricInputDirection());
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        if (direction == null || direction.equals((Object)ForgeDirection.UNKNOWN) || type != NetworkType.POWER) {
            return false;
        }
        return direction == this.getElectricInputDirection();
    }

    public String getGUIstatus() {
        if (!this.noRedstoneControl && RedstoneUtil.isBlockReceivingRedstone(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.off.name");
        }
        if (this.getEnergyStoredGC() == 0.0f) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.missingpower.name");
        }
        if (this.getDisabled(0)) {
            return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate("gui.status.ready.name");
        }
        if (this.getEnergyStoredGC() < this.storage.getMaxExtract()) {
            return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate("gui.status.missingpower.name");
        }
        return (Object)((Object)EnumColor.DARK_GREEN) + GCCoreUtil.translate("gui.status.active.name");
    }
}

