/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.asm;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import micdoodle8.mods.galacticraft.core.asm.GCLoadingPlugin;
import micdoodle8.mods.galacticraft.core.asm.ServerConfigurationManagerVisitor;
import micdoodle8.mods.galacticraft.core.asm.TransformerFactory;
import net.minecraft.crash.CrashReport;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.util.ReportedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.TraceClassVisitor;

public class GCTransformer
implements IClassTransformer {
    static final Logger log = LogManager.getLogger((String)"GCTransformer");
    private static final boolean DEBUG = Boolean.getBoolean("glease.debugasm");
    private static final ConcurrentMap<String, Integer> transformCounts = new ConcurrentHashMap<String, Integer>();
    private final Map<String, TransformerFactory> transformers = ImmutableMap.builder().put((Object)"net.minecraft.server.management.ServerConfigurationManager", (Object)new TransformerFactory(ServerConfigurationManagerVisitor::new)).build();

    static void catching(Exception e) {
        Object exception;
        log.fatal("Something went very wrong with class transforming! Aborting!!!", (Throwable)e);
        try {
            exception = new ReportedException(CrashReport.func_85055_a((Throwable)e, (String)"Transforming class"));
        }
        catch (Throwable e2) {
            exception = new RuntimeException("Transforming class", e);
        }
        throw exception;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        TransformerFactory factory = this.transformers.get(name);
        if (factory == null || factory.isInactive()) {
            return basicClass;
        }
        log.info("Transforming class {}", new Object[]{name});
        ClassReader cr = new ClassReader(basicClass);
        ClassWriter cw = new ClassWriter(factory.isExpandFrames() ? 2 : 0);
        byte[] transformedBytes = null;
        if (DEBUG) {
            int curCount = transformCounts.compute(transformedName, (k, v) -> v == null ? 0 : v + 1);
            String infix = curCount == 0 ? "" : "_" + curCount;
            try (PrintWriter origOut = new PrintWriter(new File(GCLoadingPlugin.debugOutputDir, name + infix + "_orig.txt"), "UTF-8");
                 PrintWriter tranOut = new PrintWriter(new File(GCLoadingPlugin.debugOutputDir, name + infix + "_tran.txt"), "UTF-8");){
                cr.accept((ClassVisitor)new TraceClassVisitor(factory.apply(327680, (ClassVisitor)new TraceClassVisitor((ClassVisitor)cw, tranOut)), origOut), factory.isExpandFrames() ? 4 : 0);
                transformedBytes = cw.toByteArray();
            }
            catch (Exception e) {
                log.warn("Unable to transform with debug output on. Now retrying without debug output.", (Throwable)e);
            }
        }
        if (transformedBytes == null || transformedBytes.length == 0) {
            try {
                cr.accept(factory.apply(327680, (ClassVisitor)cw), factory.isExpandFrames() ? 4 : 0);
                transformedBytes = cw.toByteArray();
            }
            catch (Exception e) {
                GCTransformer.catching(e);
            }
        }
        if (transformedBytes == null || transformedBytes.length == 0) {
            if (DEBUG) {
                GCTransformer.catching(new RuntimeException("Null or empty byte array created. This will not work well!"));
            } else {
                log.fatal("Null or empty byte array created. Transforming will rollback as a last effort attempt to make things work! However features will not function!");
                return basicClass;
            }
        }
        return transformedBytes;
    }
}

