/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.DynamicTextureProper;
import micdoodle8.mods.galacticraft.core.client.gui.screen.DrawGameScreen;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.MapGen;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.io.FileUtils;

public class MapUtil {
    public static AtomicBoolean calculatingMap = new AtomicBoolean();
    public static AtomicBoolean resetClientFlag = new AtomicBoolean();
    public static boolean doneOverworldTexture = false;
    public static ArrayList<BlockVec3> biomeColours = new ArrayList(40);
    public static final float[] parabolicField = new float[25];
    private static MapGen currentMap = null;
    private static MapGen slowMap = null;
    private static Random rand = new Random();
    private static final int SIZE_STD = 176;
    public static final int SIZE_STD2 = 352;
    private static LinkedList<MapGen> queuedMaps = new LinkedList();
    public static LinkedList<String> clientRequests = new LinkedList();

    public static void reset() {
        currentMap = null;
        slowMap = null;
        queuedMaps.clear();
        calculatingMap.set(false);
        doneOverworldTexture = false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void resetClient() {
        resetClientFlag.set(true);
    }

    @SideOnly(value=Side.CLIENT)
    public static void resetClientBody() {
        ClientProxyCore.overworldTextureRequestSent = false;
        ClientProxyCore.overworldTexturesValid = false;
        clientRequests.clear();
        File baseFolder = new File(FMLClientHandler.instance().getClient().field_71412_D, "assets/temp");
        if (baseFolder.exists() && baseFolder.isDirectory()) {
            for (File f : baseFolder.listFiles()) {
                if (!f.isFile()) continue;
                f.delete();
            }
        }
        GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_OVERWORLD_IMAGE, new Object[0]));
        DrawGameScreen.reusableMap = new DynamicTexture(352, 352);
        biomeColours.clear();
        MapUtil.setupColours();
    }

    public static void getLocalMap(World world, int chunkXPos, int chunkZPos, BufferedImage image) {
        for (int x0 = -12; x0 <= 12; ++x0) {
            for (int z0 = -12; z0 <= 12; ++z0) {
                Chunk chunk = world.func_72964_e(chunkXPos + x0, chunkZPos + z0);
                if (chunk == null) continue;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        int l4 = chunk.func_76611_b(x, z) + 1;
                        Block block = Blocks.field_150350_a;
                        int i5 = 0;
                        if (l4 > 1) {
                            while ((block = chunk.func_150810_a(x, --l4, z)).func_149728_f(i5 = chunk.func_76628_c(x, l4, z)) == MapColor.field_151660_b && l4 > 0) {
                            }
                        }
                        int col = block.func_149728_f((int)i5).field_76291_p;
                        image.setRGB(x + (x0 + 12) * 16, z + (z0 + 12) * 16, col);
                    }
                }
            }
        }
    }

    public static void makeOverworldTexture() {
        if (doneOverworldTexture) {
            return;
        }
        World world = WorldUtil.getProviderForDimensionServer((int)0).field_76579_a;
        if (world == null) {
            return;
        }
        File baseFolder = new File(MinecraftServer.func_71276_C().func_71218_a(0).getChunkSaveLocation(), "galacticraft/overworldMap");
        if (!baseFolder.exists() && !baseFolder.mkdirs()) {
            GCLog.severe("Base folder(s) could not be created: " + baseFolder.getAbsolutePath());
            doneOverworldTexture = true;
            return;
        }
        if (MapUtil.getBiomeMapForCoords(world, 0, 0, 7, 192, 48, baseFolder)) {
            doneOverworldTexture = true;
        }
    }

    public static void sendOverworldToClient(EntityPlayerMP client) {
        if (doneOverworldTexture) {
            try {
                File baseFolder = new File(MinecraftServer.func_71276_C().func_71218_a(0).getChunkSaveLocation(), "galacticraft/overworldMap");
                if (!baseFolder.exists()) {
                    GCLog.severe("Base folder missing: " + baseFolder.getAbsolutePath());
                    return;
                }
                File file = new File(baseFolder, "Overworld192.bin");
                if (file.exists()) {
                    GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_SEND_OVERWORLD_IMAGE, new Object[]{0, 0, FileUtils.readFileToByteArray((File)file)}), client);
                }
                if ((file = new File(baseFolder, "Overworld1536.bin")).exists()) {
                    GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_SEND_OVERWORLD_IMAGE, new Object[]{0, 0, FileUtils.readFileToByteArray((File)file)}), client);
                }
            }
            catch (Exception ex) {
                System.err.println("Error sending overworld image to player.");
                ex.printStackTrace();
            }
        }
    }

    public static void sendOrCreateMap(World world, int cx, int cz, EntityPlayerMP client) {
        try {
            File baseFolder = new File(MinecraftServer.func_71276_C().func_71218_a(0).getChunkSaveLocation(), "galacticraft/overworldMap");
            if (!baseFolder.exists()) {
                GCLog.severe("Base folder missing: " + baseFolder.getAbsolutePath());
                return;
            }
            File file = MapUtil.getFile(baseFolder, cx, cz);
            if (!file.exists()) {
                MapUtil.getBiomeMapForCoords(world, cx, cz, 1, 176, 176, baseFolder);
                return;
            }
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_SEND_OVERWORLD_IMAGE, new Object[]{cx, cz, FileUtils.readFileToByteArray((File)file)}), client);
        }
        catch (Exception ex) {
            System.err.println("Error sending map image to player.");
            ex.printStackTrace();
        }
    }

    public static boolean buildMaps(World world, int x, int z) {
        File baseFolder = new File(MinecraftServer.func_71276_C().func_71218_a(0).getChunkSaveLocation(), "galacticraft/overworldMap");
        if (!baseFolder.exists() && !baseFolder.mkdirs()) {
            GCLog.severe("Base folder(s) could not be created: " + baseFolder.getAbsolutePath());
            return false;
        }
        int cx = MapUtil.convertMap(x);
        int cz = MapUtil.convertMap(z);
        MapUtil.getBiomeMapForCoords(world, cx, cz, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx + 352, cz, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx, cz + 352, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx - 352, cz, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx, cz - 352, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx + 352, cz + 352, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx - 352, cz + 352, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx - 352, cz - 352, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx + 352, cz - 352, 1, 176, 176, baseFolder);
        return true;
    }

    private static int convertMap(int x) {
        int cx = x + 176;
        if (cx < 0) {
            cx -= 351;
        }
        return (cx /= 352) * 352;
    }

    public static boolean getBiomeMapForCoords(World world, int cx, int cz, int scale, int sizeX, int sizeZ, File baseFolder) {
        File outputFile;
        if (sizeX != sizeZ) {
            outputFile = new File(baseFolder, "Overworld" + sizeX + ".bin");
            if (sizeX == 1536) {
                return false;
            }
        } else {
            outputFile = MapUtil.getFile(baseFolder, cx, cz);
        }
        MapGen newGen = new MapGen(world, sizeX, sizeZ, cx, cz, 1 << scale, outputFile);
        if (newGen.calculatingMap) {
            if (calculatingMap.getAndSet(true)) {
                queuedMaps.add(newGen);
            } else {
                currentMap = newGen;
            }
            return false;
        }
        return true;
    }

    public static void BiomeMapNextTick() {
        MapGen map;
        boolean doingSlow = false;
        if (currentMap != null) {
            map = currentMap;
        } else if (slowMap != null) {
            map = slowMap;
            doingSlow = true;
        } else {
            return;
        }
        long end = System.nanoTime() + 4500000L;
        while (System.nanoTime() < end) {
            if (!map.BiomeMapOneTick()) continue;
            map.writeOutputFile(true);
            if (map.biomeMapFile.getName().equals("Overworld192.bin")) {
                doneOverworldTexture = true;
            }
            if (doingSlow) {
                slowMap = null;
            } else {
                currentMap = null;
                if (queuedMaps.size() > 0) {
                    currentMap = queuedMaps.removeFirst();
                }
            }
            if (currentMap == null && slowMap == null) {
                calculatingMap.set(false);
            }
            return;
        }
    }

    public static BufferedImage convertTo12pxTexture(BufferedImage overworldImage, BufferedImage paletteImage) {
        BufferedImage result = new BufferedImage(overworldImage.getWidth(), overworldImage.getHeight(), 1);
        TreeMap<Integer, Integer> mapColPos = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Integer> mapColPosB = new TreeMap<Integer, Integer>();
        int count = 0;
        for (int x = 0; x < overworldImage.getWidth(); x += 4) {
            for (int z = 0; z < overworldImage.getHeight(); z += 4) {
                int r = 0;
                int g = 0;
                int b = 0;
                for (int xx = 0; xx < 4; ++xx) {
                    for (int zz = 0; zz < 4; ++zz) {
                        int col = overworldImage.getRGB(xx + x, zz + z);
                        r += col >> 16;
                        g += col >> 8 & 0xFF;
                        b += col & 0xFF;
                    }
                }
                while (mapColPos.containsKey(g - b)) {
                    ++g;
                }
                mapColPos.put(g - b, count);
                if (x < overworldImage.getHeight()) {
                    int col = paletteImage.getRGB(x + 1, z + 1);
                    r = col >> 16;
                    g = col >> 8 & 0xFF;
                    b = col & 0xFF;
                    while (mapColPosB.containsKey(g - b)) {
                        ++g;
                    }
                    mapColPosB.put(g - b, col);
                }
                ++count;
            }
        }
        count = 0;
        int newCol = 0;
        Iterator it = mapColPosB.keySet().iterator();
        Iterator itt = mapColPos.keySet().iterator();
        int modulus = overworldImage.getHeight() / 4;
        int mod2 = overworldImage.getWidth() / overworldImage.getHeight();
        for (int x = 0; x < overworldImage.getWidth() / 4; ++x) {
            for (int z = 0; z < modulus; ++z) {
                if (count % mod2 == 0) {
                    newCol = (Integer)mapColPosB.get(it.next());
                }
                int position = (Integer)mapColPos.get(itt.next());
                int xx = position / modulus;
                int zz = position % modulus;
                for (int xxx = 0; xxx < 4; ++xxx) {
                    for (int zzz = 0; zzz < 4; ++zzz) {
                        result.setRGB(xx * 4 + xxx, zz * 4 + zzz, newCol);
                    }
                }
                ++count;
            }
        }
        return result;
    }

    public static BufferedImage readImage(Object source) throws IOException {
        ImageInputStream stream = ImageIO.createImageInputStream(source);
        ImageReader reader = ImageIO.getImageReaders(stream).next();
        reader.setInput(stream);
        ImageReadParam param = reader.getDefaultReadParam();
        ImageTypeSpecifier typeToUse = null;
        Iterator<ImageTypeSpecifier> i = reader.getImageTypes(0);
        while (i.hasNext()) {
            ImageTypeSpecifier type = i.next();
            if (!type.getColorModel().getColorSpace().isCS_sRGB()) continue;
            typeToUse = type;
        }
        if (typeToUse != null) {
            param.setDestinationType(typeToUse);
        }
        BufferedImage b = reader.read(0, param);
        reader.dispose();
        stream.close();
        return b;
    }

    @SideOnly(value=Side.CLIENT)
    public static void writeImgToFile(BufferedImage img, String name) {
        if (GalacticraftCore.enableJPEG) {
            File folder = new File(FMLClientHandler.instance().getClient().field_71412_D, "assets/temp");
            try {
                FileImageOutputStream outputStreamA = new FileImageOutputStream(new File(folder, name));
                GalacticraftCore.jpgWriter.setOutput(outputStreamA);
                GalacticraftCore.jpgWriter.write(null, new IIOImage(img, null, null), GalacticraftCore.writeParam);
                outputStreamA.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void getOverworldImageFromRaw(File folder, int cx, int cz, byte[] raw) throws IOException {
        if (raw.length == 0x120000) {
            File file0 = new File(folder, "overworldRaw.bin");
            if (!file0.exists() || file0.canRead() && file0.canWrite()) {
                FileUtils.writeByteArrayToFile((File)file0, (byte[])raw);
            } else {
                System.err.println("Cannot read/write to file %minecraftDir%/assets/temp/overworldRaw.bin");
            }
            BufferedImage worldImageLarge = new BufferedImage(3072, 768, 1);
            ArrayList cols = new ArrayList();
            int lastcol = -1;
            boolean idx = false;
            for (int x = 0; x < 1536; ++x) {
                for (int z = 0; z < 384; ++z) {
                    int arrayIndex = (x * 384 + z) * 2;
                    int biome = raw[arrayIndex] & 0xFF;
                    int height = raw[arrayIndex + 1] & 0xFF;
                    if (height < 63 && biome != 10) {
                        biome = 0;
                    }
                    if (height < 56 && biome == 0) {
                        biome = 24;
                    }
                    worldImageLarge.setRGB(x * 2, z * 2, MapUtil.convertBiomeColour(biome, height));
                    worldImageLarge.setRGB(x * 2, z * 2 + 1, MapUtil.convertBiomeColour(biome, height));
                    worldImageLarge.setRGB(x * 2 + 1, z * 2, MapUtil.convertBiomeColour(biome, height));
                    worldImageLarge.setRGB(x * 2 + 1, z * 2 + 1, MapUtil.convertBiomeColour(biome, height));
                }
            }
            if (ClientProxyCore.overworldTextureLarge == null) {
                ClientProxyCore.overworldTextureLarge = new DynamicTextureProper(768, 192);
            }
            ClientProxyCore.overworldTextureLarge.update(worldImageLarge);
            if (GalacticraftCore.enableJPEG) {
                FileImageOutputStream outputStream = new FileImageOutputStream(new File(folder, "large.jpg"));
                GalacticraftCore.jpgWriter.setOutput(outputStream);
                GalacticraftCore.jpgWriter.write(null, new IIOImage(worldImageLarge, null, null), GalacticraftCore.writeParam);
                outputStream.close();
            }
        } else if (raw.length == 18432) {
            BufferedImage worldImage = new BufferedImage(192, 48, 1);
            ArrayList cols = new ArrayList();
            int lastcol = -1;
            boolean idx = false;
            for (int x = 0; x < 192; ++x) {
                for (int z = 0; z < 48; ++z) {
                    int arrayIndex = (x * 48 + z) * 2;
                    int biome = raw[arrayIndex] & 0xFF;
                    int height = raw[arrayIndex + 1] & 0xFF;
                    if (height < 63 && biome != 10) {
                        biome = 0;
                    }
                    if (height < 56 && biome == 0) {
                        biome = 24;
                    }
                    worldImage.setRGB(x, z, MapUtil.convertBiomeColour(biome, height));
                }
            }
            IResourceManager rm = Minecraft.func_71410_x().func_110442_L();
            BufferedImage paletteImage = null;
            try {
                InputStream in = rm.func_110536_a(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/earth.png")).func_110527_b();
                paletteImage = ImageIO.read(in);
                in.close();
                paletteImage.getHeight();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            BufferedImage result = MapUtil.convertTo12pxTexture(worldImage, paletteImage);
            if (result != null) {
                if (ClientProxyCore.overworldTextureWide == null) {
                    ClientProxyCore.overworldTextureWide = new DynamicTextureProper(192, 48);
                }
                if (ClientProxyCore.overworldTextureClient == null) {
                    ClientProxyCore.overworldTextureClient = new DynamicTextureProper(48, 48);
                }
                ClientProxyCore.overworldTextureWide.update(result);
                ClientProxyCore.overworldTextureClient.update(result);
                ClientProxyCore.overworldTexturesValid = true;
            }
        } else {
            File file0 = MapUtil.getFile(folder, cx, cz);
            if (!file0.exists() || file0.canRead() && file0.canWrite()) {
                FileUtils.writeByteArrayToFile((File)file0, (byte[])raw);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean getMap(int[] image, World world, int xCoord, int zCoord) {
        int cx = MapUtil.convertMap(xCoord);
        int cz = MapUtil.convertMap(zCoord);
        File baseFolder = new File(FMLClientHandler.instance().getClient().field_71412_D, "assets/temp");
        if (!baseFolder.exists() && !baseFolder.mkdirs()) {
            GCLog.severe("Base folder(s) could not be created: " + baseFolder.getAbsolutePath());
            return false;
        }
        int dim = world.field_73011_w.field_76574_g;
        boolean result = true;
        if (MapUtil.makeRGBimage(image, baseFolder, cx - 352, cz - 352, 0, 0, xCoord, zCoord, dim, result)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx - 352, cz, 0, 176, xCoord, zCoord, dim, result)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx - 352, cz + 352, 0, 352, xCoord, zCoord, dim, result)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx, cz - 352, 176, 0, xCoord, zCoord, dim, result)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx, cz, 176, 176, xCoord, zCoord, dim, result)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx, cz + 352, 176, 352, xCoord, zCoord, dim, result)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx + 352, cz - 352, 352, 0, xCoord, zCoord, dim, result)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx + 352, cz, 352, 176, xCoord, zCoord, dim, result)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx + 352, cz + 352, 352, 352, xCoord, zCoord, dim, result)) {
            result = false;
        }
        return result;
    }

    private static boolean makeRGBimage(int[] array, File baseFolder, int cx, int cz, int offsetX, int offsetZ, int xCoord, int zCoord, int dim, boolean prevResult) {
        int imagex;
        File filename = MapUtil.getFile(baseFolder, cx, cz);
        if (!filename.exists()) {
            if (clientRequests.contains(filename.getName())) {
                GCLog.debug("Still waiting for file " + filename.getName());
            } else {
                clientRequests.add(filename.getName());
                GCLog.debug("Client requested file" + filename.getName());
                GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_MAP_IMAGE, new Object[]{dim, cx, cz}));
            }
            return true;
        }
        if (!prevResult) {
            return true;
        }
        int ox = (MapUtil.convertMap(xCoord) - xCoord - 176) / 2;
        int oz = (MapUtil.convertMap(zCoord) - zCoord - 176) / 2;
        byte[] raw = null;
        try {
            raw = FileUtils.readFileToByteArray((File)filename);
        }
        catch (IOException e) {
            GCLog.severe("Problem reading map file: " + baseFolder.getAbsolutePath() + filename.getName());
            return true;
        }
        if (raw == null || raw.length != 61952) {
            GCLog.debug("map size is " + raw.length);
            return true;
        }
        int xstart = Math.max(0, -offsetX - ox);
        int zstart = Math.max(0, -offsetZ - oz);
        for (int x = xstart; x < 176 && (imagex = x + offsetX + ox) < 352; ++x) {
            int imageZ;
            for (int z = zstart; z < 176 && (imageZ = z + oz + offsetZ) < 352; ++z) {
                int arrayIndex = (x * 176 + z) * 2;
                int biome = raw[arrayIndex] & 0xFF;
                int height = raw[arrayIndex + 1] & 0xFF;
                if (height < 63 && biome != 10) {
                    biome = 0;
                }
                if (height < 56 && biome == 0) {
                    biome = 24;
                }
                if (imagex < 0 || imageZ < 0) {
                    GCLog.debug("Outside image " + imagex + "," + imageZ + " - x=" + x + " z=" + z + " offsetX=" + offsetX + " offsetZ = " + offsetZ + " ox=" + ox + " oz=" + oz);
                    continue;
                }
                array[imagex + 352 * imageZ] = MapUtil.convertBiomeColour(biome, height) + -16777216;
            }
        }
        return false;
    }

    private static File getFile(File folder, int cx, int cz) {
        return new File(folder, "overworld" + cx / 352 + "_" + cz / 352 + ".bin");
    }

    public static int convertBiomeColour(int in, int height) {
        BlockVec3 bv;
        int rv;
        int s = biomeColours.size();
        if (in >= 128 && in < 128 + s) {
            in -= 128;
        }
        if ((rv = in >= s ? BiomeGenBase.func_150568_d((int)in).field_76790_z : ((bv = biomeColours.get(in)) == null ? BiomeGenBase.func_150568_d((int)in).field_76790_z : (bv.z > 0 && rand.nextInt(100) < bv.z ? bv.y : bv.x))) == 10232868 && rand.nextInt(2) == 0) {
            rv = 12559236;
        }
        if (height < 63) {
            return rv;
        }
        if (height > 92 && (in == 3 || in == 20 || in == 31 || in == 33 || in == 34) && rand.nextInt(8) > 98 - height) {
            rv = Material.field_151597_y.func_151565_r().field_76291_p;
        }
        float factor = ((float)height - 68.0f) / 114.0f;
        return ColorUtil.lighten(rv, factor);
    }

    private static void setupColours() {
        biomeColours.add(new BlockVec3(Material.field_151586_h.func_151565_r().field_76291_p, 0, 0));
        biomeColours.add(new BlockVec3(4813878, 0, 0));
        biomeColours.add(new BlockVec3(13946264, Material.field_151570_A.func_151565_r().field_76291_p, 3));
        biomeColours.add(new BlockVec3(5072204, Material.field_151576_e.func_151565_r().field_76291_p, 15));
        biomeColours.add(new BlockVec3(3962145, 2708502, 45));
        biomeColours.add(new BlockVec3(6454881, 1518103, 18));
        biomeColours.add(new BlockVec3(4412443, 1118985, 25));
        biomeColours.add(new BlockVec3(4813878, 0, 0));
        biomeColours.add(new BlockVec3(0, 0, 0));
        biomeColours.add(new BlockVec3(0, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151588_w.func_151565_r().field_76291_p, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151588_w.func_151565_r().field_76291_p, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151597_y.func_151565_r().field_76291_p, 4813878, 3));
        biomeColours.add(new BlockVec3(Material.field_151597_y.func_151565_r().field_76291_p, Material.field_151588_w.func_151565_r().field_76291_p, 5));
        biomeColours.add(new BlockVec3(6510175, 8131604, 10));
        biomeColours.add(new BlockVec3(0x6A6066, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151595_p.func_151565_r().field_76291_p, 0, 0));
        biomeColours.add(new BlockVec3(13946264, 0, 0));
        biomeColours.add(new BlockVec3(3962145, 2708502, 35));
        biomeColours.add(new BlockVec3(6454881, 1518103, 14));
        biomeColours.add(new BlockVec3(5072204, 4813878, 50));
        biomeColours.add(new BlockVec3(1534979, 1000706, 25));
        biomeColours.add(new BlockVec3(1534979, 1000706, 25));
        biomeColours.add(new BlockVec3(1534979, 1000706, 25));
        biomeColours.add(new BlockVec3(3092436, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151576_e.func_151565_r().field_76291_p, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151595_p.func_151565_r().field_76291_p, Material.field_151597_y.func_151565_r().field_76291_p, 75));
        biomeColours.add(new BlockVec3(5335862, 4813878, 65));
        biomeColours.add(new BlockVec3(5335862, 4813878, 55));
        biomeColours.add(new BlockVec3(10232868, 1977880, 98));
        biomeColours.add(new BlockVec3(Material.field_151597_y.func_151565_r().field_76291_p, 1518103, 12));
        biomeColours.add(new BlockVec3(Material.field_151597_y.func_151565_r().field_76291_p, 1518103, 12));
        biomeColours.add(new BlockVec3(1518103, 7228981, 12));
        biomeColours.add(new BlockVec3(1518103, 7228981, 12));
        biomeColours.add(new BlockVec3(8092024, 4813878, 10));
        biomeColours.add(new BlockVec3(5657897, 2499332, 20));
        biomeColours.add(new BlockVec3(5657897, 2499332, 14));
        biomeColours.add(new BlockVec3(10506783, 7417635, 14));
        biomeColours.add(new BlockVec3(10506783, 7417635, 17));
        biomeColours.add(new BlockVec3(10506783, 7417635, 20));
    }

    public static void makeVanillaMap(int dim, int chunkXPos, int chunkZPos, File baseFolder, BufferedImage image) {
        for (int x0 = -12; x0 <= 12; ++x0) {
            for (int z0 = -12; z0 <= 12; ++z0) {
                Chunk chunk = MinecraftServer.func_71276_C().func_71218_a(dim).func_72964_e(chunkXPos + x0, chunkZPos + z0);
                if (chunk == null) continue;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        int l4 = chunk.func_76611_b(x, z) + 1;
                        Block block = Blocks.field_150350_a;
                        int i5 = 0;
                        if (l4 > 1) {
                            while ((block = chunk.func_150810_a(x, --l4, z)).func_149728_f(i5 = chunk.func_76628_c(x, l4, z)) == MapColor.field_151660_b && l4 > 0) {
                            }
                        }
                        int col = block.func_149728_f((int)i5).field_76291_p;
                        image.setRGB(x + (x0 + 12) * 16, z + (z0 + 12) * 16, col);
                    }
                }
            }
        }
        try {
            File outputFile = new File(baseFolder, dim + "_" + chunkXPos + "_" + chunkZPos + ".jpg");
            if (!outputFile.exists() || outputFile.canWrite() && outputFile.canRead()) {
                ImageIO.write((RenderedImage)image, "jpg", outputFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        MapUtil.setupColours();
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                MapUtil.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
    }
}

