/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import cpw.mods.ironchest.IronChest;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.nei.BuggyRecipeHandler;
import micdoodle8.mods.galacticraft.core.nei.CircuitFabricatorRecipeHandler;
import micdoodle8.mods.galacticraft.core.nei.GCNEIHighlightHandler;
import micdoodle8.mods.galacticraft.core.nei.RefineryRecipeHandler;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class NEIGalacticraftConfig
implements IConfigureNEI {
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> rocketBenchRecipes = new HashMap();
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> buggyBenchRecipes = new HashMap();
    private static HashMap<PositionedStack, PositionedStack> refineryRecipes = new HashMap();
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> circuitFabricatorRecipes = new HashMap();
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> ingotCompressorRecipes = new HashMap();

    public void loadConfig() {
        this.registerRecipes();
        for (Item item : GCItems.hiddenItems) {
            API.hideItem((ItemStack)new ItemStack(item, 1, 0));
        }
        for (Block block : GCBlocks.hiddenBlocks) {
            API.hideItem((ItemStack)new ItemStack(block, 1, 0));
            if (block != GCBlocks.slabGCDouble) continue;
            for (int j = 1; j < (GalacticraftCore.isPlanetsLoaded ? 6 : 4); ++j) {
                API.hideItem((ItemStack)new ItemStack(block, 1, j));
            }
        }
        API.registerRecipeHandler((ICraftingHandler)new BuggyRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new BuggyRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RefineryRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RefineryRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CircuitFabricatorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CircuitFabricatorRecipeHandler());
        API.registerHighlightIdentifier((Block)GCBlocks.basicBlock, (IHighlightHandler)new GCNEIHighlightHandler());
        API.registerHighlightIdentifier((Block)GCBlocks.blockMoon, (IHighlightHandler)new GCNEIHighlightHandler());
        API.registerHighlightIdentifier((Block)GCBlocks.fakeBlock, (IHighlightHandler)new GCNEIHighlightHandler());
    }

    public String getName() {
        return "Galacticraft NEI Plugin";
    }

    public String getVersion() {
        return "3.0.33-GTNH";
    }

    public void registerIngotCompressorRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        ingotCompressorRecipes.put(input, output);
    }

    public void registerCircuitFabricatorRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        circuitFabricatorRecipes.put(input, output);
    }

    public void registerRocketBenchRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        rocketBenchRecipes.put(input, output);
    }

    public void registerBuggyBenchRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        buggyBenchRecipes.put(input, output);
    }

    public void registerRefineryRecipe(PositionedStack input, PositionedStack output) {
        refineryRecipes.put(input, output);
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getIngotCompressorRecipes() {
        return ingotCompressorRecipes.entrySet();
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getCircuitFabricatorRecipes() {
        return circuitFabricatorRecipes.entrySet();
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getRocketBenchRecipes() {
        return rocketBenchRecipes.entrySet();
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getBuggyBenchRecipes() {
        return buggyBenchRecipes.entrySet();
    }

    public static Set<Map.Entry<PositionedStack, PositionedStack>> getRefineryRecipes() {
        return refineryRecipes.entrySet();
    }

    public void registerRecipes() {
        this.registerRefineryRecipe(new PositionedStack((Object)new ItemStack(GCItems.oilCanister, 1, 1), 2, 3), new PositionedStack((Object)new ItemStack(GCItems.fuelCanister, 1, 1), 148, 3));
        this.addBuggyRecipes();
        this.addCircuitFabricatorRecipes();
        this.addIngotCompressorRecipes();
    }

    private void addBuggyRecipes() {
        int x = 4;
        int y = 16;
        HashMap<Integer, PositionedStack> input = new HashMap<Integer, PositionedStack>();
        input.put(1, new PositionedStack((Object)new ItemStack(GCItems.basicItem, 1, 19), 62 - x, 19 - y));
        input.put(2, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 1), 62 - x, 55 - y));
        if (GalacticraftCore.isGalaxySpaceLoaded) {
            input.put(3, new PositionedStack((Object)GT_ModHandler.getModItem((String)"GalaxySpace", (String)"item.RocketControlComputer", (long)1L, (int)100), 62 - x, 73 - y));
        }
        input.put(4, new PositionedStack((Object)new ItemStack(GCItems.partBuggy), 8 - x, 19 - y));
        input.put(5, new PositionedStack((Object)new ItemStack(GCItems.partBuggy), 116 - x, 19 - y));
        input.put(6, new PositionedStack((Object)new ItemStack(GCItems.partBuggy), 8 - x, 109 - y));
        input.put(7, new PositionedStack((Object)new ItemStack(GCItems.partBuggy), 116 - x, 109 - y));
        input.put(8, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.StainlessSteel, (long)1L), 26 - x, 19 - y));
        input.put(9, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.StainlessSteel, (long)1L), 98 - x, 19 - y));
        input.put(10, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.StainlessSteel, (long)1L), 26 - x, 109 - y));
        input.put(11, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.StainlessSteel, (long)1L), 98 - x, 109 - y));
        input.put(12, new PositionedStack((Object)new ItemStack(GCItems.meteoricIronIngot, 1, 1), 44 - x, 19 - y));
        input.put(13, new PositionedStack((Object)new ItemStack(GCItems.meteoricIronIngot, 1, 1), 80 - x, 19 - y));
        input.put(14, new PositionedStack((Object)new ItemStack(GCItems.meteoricIronIngot, 1, 1), 44 - x, 109 - y));
        input.put(15, new PositionedStack((Object)new ItemStack(GCItems.meteoricIronIngot, 1, 1), 62 - x, 109 - y));
        input.put(16, new PositionedStack((Object)new ItemStack(GCItems.meteoricIronIngot, 1, 1), 80 - x, 109 - y));
        input.put(17, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 8 - x, 37 - y));
        input.put(18, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 26 - x, 37 - y));
        input.put(19, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 98 - x, 37 - y));
        input.put(20, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 116 - x, 37 - y));
        input.put(21, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 8 - x, 91 - y));
        input.put(22, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 26 - x, 91 - y));
        input.put(23, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 98 - x, 91 - y));
        input.put(24, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 116 - x, 91 - y));
        input.put(25, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 44 - x, 37 - y));
        input.put(26, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 62 - x, 37 - y));
        input.put(27, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 80 - x, 37 - y));
        input.put(28, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 44 - x, 55 - y));
        input.put(29, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 80 - x, 55 - y));
        input.put(30, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 44 - x, 73 - y));
        input.put(31, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 80 - x, 73 - y));
        input.put(32, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 44 - x, 91 - y));
        input.put(33, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 62 - x, 91 - y));
        input.put(34, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 80 - x, 91 - y));
        this.registerBuggyBenchRecipe(input, new PositionedStack((Object)new ItemStack(GCItems.buggy), 143 - x, 64 - y));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input);
        input2.put(35, new PositionedStack((Object)new ItemStack((Block)IronChest.ironChestBlock, 1, 3), 107 - x, 64 - y));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.buggy, 1, 1), 143 - x, 64 - y));
        input2 = new HashMap<Integer, PositionedStack>(input);
        input2.put(35, new PositionedStack((Object)new ItemStack((Block)IronChest.ironChestBlock), 107 - x, 64 - y));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.buggy, 1, 2), 143 - x, 64 - y));
        input2 = new HashMap<Integer, PositionedStack>(input);
        input2.put(35, new PositionedStack((Object)new ItemStack((Block)IronChest.ironChestBlock, 1, 1), 107 - x, 64 - y));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.buggy, 1, 3), 143 - x, 64 - y));
    }

    private void addRocketRecipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        input1.put(0, new PositionedStack((Object)new ItemStack(GCItems.partNoseCone), 45, 15));
        input1.put(1, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 36, 33));
        input1.put(2, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 36, 51));
        input1.put(3, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 36, 69));
        input1.put(4, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 36, 87));
        input1.put(5, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 54, 33));
        input1.put(6, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 54, 51));
        input1.put(7, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 54, 69));
        input1.put(8, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 54, 87));
        input1.put(9, new PositionedStack((Object)new ItemStack(GCItems.rocketEngine), 45, 105));
        input1.put(10, new PositionedStack((Object)new ItemStack(GCItems.partFins), 18, 87));
        input1.put(11, new PositionedStack((Object)new ItemStack(GCItems.partFins), 18, 105));
        input1.put(12, new PositionedStack((Object)new ItemStack(GCItems.partFins), 72, 87));
        input1.put(13, new PositionedStack((Object)new ItemStack(GCItems.partFins), 72, 105));
        this.registerRocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 0), 139, 92));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 1), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 1), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 1), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 8));
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 2), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 8));
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 2), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 8));
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 2), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 8));
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 8));
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.rocketTier1, 1, 3), 139, 92));
    }

    private void addCircuitFabricatorRecipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        input1.put(0, new PositionedStack((Object)new ItemStack(Items.field_151045_i), 10, 22));
        int siliconCount = OreDictionary.getOres((String)ConfigManagerCore.otherModsSilicon).size();
        ItemStack[] silicons = new ItemStack[siliconCount];
        for (int j = 0; j < siliconCount; ++j) {
            silicons[j] = (ItemStack)OreDictionary.getOres((String)ConfigManagerCore.otherModsSilicon).get(j);
        }
        input1.put(1, new PositionedStack((Object)silicons, 69, 51));
        input1.put(2, new PositionedStack((Object)silicons, 69, 69));
        input1.put(3, new PositionedStack((Object)new ItemStack(Items.field_151137_ax), 117, 51));
        input1.put(4, new PositionedStack((Object)new ItemStack(Blocks.field_150429_aA), 140, 25));
        this.registerCircuitFabricatorRecipe(input1, new PositionedStack((Object)new ItemStack(GCItems.basicItem, ConfigManagerCore.quickMode ? 5 : 3, 13), 147, 91));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(4, new PositionedStack((Object)new ItemStack(Items.field_151100_aR, 1, 4), 140, 25));
        this.registerCircuitFabricatorRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.basicItem, 9, 12), 147, 91));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(4, new PositionedStack((Object)new ItemStack(Items.field_151107_aW), 140, 25));
        this.registerCircuitFabricatorRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.basicItem, ConfigManagerCore.quickMode ? 2 : 1, 14), 147, 91));
    }

    private void addIngotCompressorRecipes() {
        for (int i = 0; i < CompressorRecipes.getRecipeList().size(); ++i) {
            int j;
            ShapedRecipes recipe;
            HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
            IRecipe rec = CompressorRecipes.getRecipeList().get(i);
            if (rec instanceof ShapedRecipes) {
                recipe = (ShapedRecipes)rec;
                for (j = 0; j < recipe.field_77574_d.length; ++j) {
                    ItemStack stack = recipe.field_77574_d[j];
                    input1.put(j, new PositionedStack((Object)stack, 21 + j % 3 * 18, 26 + j / 3 * 18));
                }
            } else if (rec instanceof ShapelessOreRecipe) {
                recipe = (ShapelessOreRecipe)rec;
                for (j = 0; j < recipe.getInput().size(); ++j) {
                    Object obj = recipe.getInput().get(j);
                    input1.put(j, new PositionedStack(obj, 21 + j % 3 * 18, 26 + j / 3 * 18));
                }
            }
            ItemStack resultItemStack = rec.func_77571_b();
            if (ConfigManagerCore.quickMode && resultItemStack.func_77973_b().func_77667_c(resultItemStack).contains("compressed")) {
                resultItemStack.field_77994_a *= 2;
            }
            this.registerIngotCompressorRecipe(input1, new PositionedStack((Object)resultItemStack, 140, 46));
        }
    }
}

