/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.tile;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.lang.reflect.Constructor;
import java.util.EnumSet;
import mekanism.api.energy.ICableOutputter;
import mekanism.api.energy.IStrictEnergyAcceptor;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorageTile;
import micdoodle8.mods.galacticraft.core.tile.ReceiverMode;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(modid="IC2API", iface="ic2.api.energy.tile.IEnergySink"), @Optional.Interface(modid="CoFHAPI|energy", iface="cofh.api.energy.IEnergyHandler"), @Optional.Interface(modid="MekanismAPI|energy", iface="mekanism.api.energy.IStrictEnergyAcceptor"), @Optional.Interface(modid="MekanismAPI|energy", iface="mekanism.api.energy.ICableOutputter")})
public abstract class TileBaseUniversalElectrical
extends EnergyStorageTile
implements IEnergySink,
IEnergyHandler,
IStrictEnergyAcceptor,
ICableOutputter {
    protected boolean isAddedToEnergyNet;
    protected Object powerHandlerBC;
    private float IC2surplusInGJ = 0.0f;

    @Override
    public double getPacketRange() {
        return 12.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }

    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.allOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public float getRequest(ForgeDirection direction) {
        if (this.getElectricalInputDirections().contains(direction) || direction == ForgeDirection.UNKNOWN) {
            return super.getRequest(direction);
        }
        return 0.0f;
    }

    @Override
    public float receiveElectricity(ForgeDirection from, float receive, int tier, boolean doReceive) {
        if (this.getElectricalInputDirections().contains(from) || from == ForgeDirection.UNKNOWN) {
            return super.receiveElectricity(from, receive, tier, doReceive);
        }
        return 0.0f;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
    }

    public void discharge(ItemStack itemStack) {
        if (itemStack != null) {
            IElectricItem electricItem;
            Item item = itemStack.func_77973_b();
            float energyToDischarge = this.getRequest(ForgeDirection.UNKNOWN);
            if (item instanceof IItemElectric) {
                this.storage.receiveEnergyGC(ElectricItemHelper.dischargeItem(itemStack, energyToDischarge));
            } else if (EnergyConfigHandler.isRFAPILoaded() && item instanceof IEnergyContainerItem) {
                this.storage.receiveEnergyGC((float)((IEnergyContainerItem)item).extractEnergy(itemStack, (int)(energyToDischarge / EnergyConfigHandler.RF_RATIO), false) * EnergyConfigHandler.RF_RATIO);
            } else if (EnergyConfigHandler.isIndustrialCraft2Loaded() && item instanceof IElectricItem && (electricItem = (IElectricItem)item).canProvideEnergy(itemStack)) {
                double result = 0.0;
                double energyDischargeIC2 = energyToDischarge / EnergyConfigHandler.IC2_RATIO;
                result = ElectricItem.manager.discharge(itemStack, energyDischargeIC2, 4, false, false, false);
                float energyDischarged = (float)result * EnergyConfigHandler.IC2_RATIO;
                this.storage.receiveEnergyGC(energyDischarged);
            }
        }
    }

    @Override
    public void initiate() {
        super.initiate();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isAddedToEnergyNet) {
                this.initIC();
            }
            if (EnergyConfigHandler.isIndustrialCraft2Loaded() && this.IC2surplusInGJ >= 0.001f) {
                this.IC2surplusInGJ -= this.storage.receiveEnergyGC(this.IC2surplusInGJ);
                if (this.IC2surplusInGJ < 0.001f) {
                    this.IC2surplusInGJ = 0.0f;
                }
            }
        }
    }

    public void func_145843_s() {
        this.unloadTileIC2();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.unloadTileIC2();
        super.onChunkUnload();
    }

    protected void initIC() {
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            try {
                Class<?> tileLoadEvent = Class.forName("ic2.api.energy.event.EnergyTileLoadEvent");
                Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
                Constructor<?> constr = tileLoadEvent.getConstructor(energyTile);
                Object o = constr.newInstance(this);
                if (o != null && o instanceof Event) {
                    MinecraftForge.EVENT_BUS.post((Event)o);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isAddedToEnergyNet = true;
    }

    private void unloadTileIC2() {
        if (this.isAddedToEnergyNet && this.field_145850_b != null) {
            if (EnergyConfigHandler.isIndustrialCraft2Loaded() && !this.field_145850_b.field_72995_K) {
                try {
                    Class<?> tileLoadEvent = Class.forName("ic2.api.energy.event.EnergyTileUnloadEvent");
                    Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
                    Constructor<?> constr = tileLoadEvent.getConstructor(energyTile);
                    Object o = constr.newInstance(this);
                    if (o != null && o instanceof Event) {
                        MinecraftForge.EVENT_BUS.post((Event)o);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.isAddedToEnergyNet = false;
        }
    }

    public double getDemandedEnergy() {
        if (EnergyConfigHandler.disableIC2Input) {
            return 0.0;
        }
        try {
            if (this.IC2surplusInGJ < 0.001f) {
                this.IC2surplusInGJ = 0.0f;
                return Math.ceil(this.storage.receiveEnergyGC(2.1474836E9f, true) / EnergyConfigHandler.IC2_RATIO);
            }
            float received = this.storage.receiveEnergyGC(this.IC2surplusInGJ, true);
            if (received == this.IC2surplusInGJ) {
                return Math.ceil((this.storage.receiveEnergyGC(2.1474836E9f, true) - this.IC2surplusInGJ) / EnergyConfigHandler.IC2_RATIO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    public double injectEnergy(ForgeDirection direction, double amount, double voltage) {
        if (!EnergyConfigHandler.disableIC2Input && (direction == ForgeDirection.UNKNOWN || this.getElectricalInputDirections().contains(direction))) {
            float convertedEnergy = (float)amount * EnergyConfigHandler.IC2_RATIO;
            int tierFromIC2 = (int)voltage > 120 ? 2 : 1;
            float receive = this.receiveElectricity(direction, convertedEnergy, tierFromIC2, true);
            this.IC2surplusInGJ = convertedEnergy > receive ? convertedEnergy - receive : 0.0f;
            return 0.0;
        }
        return amount;
    }

    public int getSinkTier() {
        return 3;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        if (emitter instanceof IElectrical || emitter instanceof IConductor) {
            return false;
        }
        try {
            Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
            if (!energyTile.isInstance(emitter)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getElectricalInputDirections().contains(direction);
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (EnergyConfigHandler.disableRFInput) {
            return 0;
        }
        if (!this.getElectricalInputDirections().contains(from)) {
            return 0;
        }
        return MathHelper.func_76141_d((float)(super.receiveElectricity(from, (float)maxReceive * EnergyConfigHandler.RF_RATIO, 1, !simulate) / EnergyConfigHandler.RF_RATIO));
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return this.getElectricalInputDirections().contains(from) || this.getElectricalOutputDirections().contains(from);
    }

    public int getEnergyStored(ForgeDirection from) {
        return MathHelper.func_76141_d((float)(this.getEnergyStoredGC() / EnergyConfigHandler.RF_RATIO));
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return MathHelper.func_76141_d((float)(this.getMaxEnergyStoredGC() / EnergyConfigHandler.RF_RATIO));
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public double transferEnergyToAcceptor(ForgeDirection from, double amount) {
        if (EnergyConfigHandler.disableMekanismInput) {
            return 0.0;
        }
        if (!this.getElectricalInputDirections().contains(from)) {
            return 0.0;
        }
        return this.receiveElectricity(from, (float)amount * EnergyConfigHandler.MEKANISM_RATIO, 1, true) / EnergyConfigHandler.MEKANISM_RATIO;
    }

    public boolean canReceiveEnergy(ForgeDirection side) {
        return this.getElectricalInputDirections().contains(side);
    }

    public double getEnergy() {
        if (EnergyConfigHandler.disableMekanismInput) {
            return 0.0;
        }
        return this.getEnergyStoredGC() / EnergyConfigHandler.MEKANISM_RATIO;
    }

    public void setEnergy(double energy) {
        if (EnergyConfigHandler.disableMekanismInput) {
            return;
        }
        this.storage.setEnergyStored((float)energy * EnergyConfigHandler.MEKANISM_RATIO);
    }

    public double getMaxEnergy() {
        if (EnergyConfigHandler.disableMekanismInput) {
            return 0.0;
        }
        return this.getMaxEnergyStoredGC() / EnergyConfigHandler.MEKANISM_RATIO;
    }

    public boolean canOutputTo(ForgeDirection side) {
        return false;
    }

    @Override
    public ReceiverMode getModeFromDirection(ForgeDirection direction) {
        if (this.getElectricalInputDirections().contains(direction)) {
            return ReceiverMode.RECEIVE;
        }
        if (this.getElectricalOutputDirections().contains(direction)) {
            return ReceiverMode.EXTRACT;
        }
        return null;
    }

    public void updateFacing() {
        if (EnergyConfigHandler.isIndustrialCraft2Loaded() && !this.field_145850_b.field_72995_K) {
            this.unloadTileIC2();
        }
    }
}

