/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockSlabGC
extends BlockSlab {
    private static final String[] woodTypes = new String[]{"tin", "tin", "moon", "moonBricks", "mars", "marsBricks"};
    private IIcon[] textures;
    private IIcon[] tinSideIcon;
    private final boolean isDoubleSlab;

    public BlockSlabGC(String name, boolean par2, Material material) {
        super(par2, material);
        this.isDoubleSlab = par2;
        this.func_149663_c(name);
        this.field_149783_u = true;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.textures = new IIcon[6];
        this.textures[0] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "deco_aluminium_4");
        this.textures[1] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "deco_aluminium_2");
        this.textures[2] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX_MOON + "bottom");
        this.textures[3] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX_MOON + "brick");
        if (GalacticraftCore.isPlanetsLoaded) {
            try {
                String prefix = (String)Class.forName("micdoodle8.mods.galacticraft.planets.mars.MarsModule").getField("TEXTURE_PREFIX").get(null);
                this.textures[4] = par1IconRegister.func_94245_a(prefix + "cobblestone");
                this.textures[5] = par1IconRegister.func_94245_a(prefix + "brick");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.textures[4] = this.textures[3];
                this.textures[5] = this.textures[3];
            }
        } else {
            this.textures[4] = this.textures[3];
            this.textures[5] = this.textures[3];
        }
        this.tinSideIcon = new IIcon[1];
        this.tinSideIcon[0] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "deco_aluminium_1");
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta == 1 || meta == 9) {
            switch (side) {
                case 0: {
                    return this.textures[0];
                }
                case 1: {
                    return this.textures[1];
                }
                case 2: {
                    return this.tinSideIcon[0];
                }
                case 3: {
                    return this.tinSideIcon[0];
                }
                case 4: {
                    return this.tinSideIcon[0];
                }
                case 5: {
                    return this.tinSideIcon[0];
                }
            }
        }
        return this.textures[BlockSlabGC.getTypeFromMeta(meta)];
    }

    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        int max = 0;
        max = GalacticraftCore.isPlanetsLoaded ? 6 : 4;
        for (int i = 0; i < max; ++i) {
            list.add(new ItemStack(block, 1, i));
        }
    }

    public String func_150002_b(int meta) {
        return woodTypes[this.getWoodType(meta)] + "Slab";
    }

    public int func_149692_a(int meta) {
        return meta & 7;
    }

    public Item func_149650_a(int meta, Random par2Random, int par3) {
        if (this.isDoubleSlab && this == GCBlocks.slabGCDouble) {
            return Item.func_150898_a((Block)GCBlocks.slabGCHalf);
        }
        return Item.func_150898_a((Block)this);
    }

    public CreativeTabs func_149708_J() {
        if (!this.isDoubleSlab) {
            return GalacticraftCore.galacticraftBlocksTab;
        }
        return null;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        float hardness = this.field_149782_v;
        switch (BlockSlabGC.getTypeFromMeta(meta)) {
            case 2: 
            case 3: {
                hardness = 1.5f;
                break;
            }
            default: {
                hardness = 2.0f;
            }
        }
        return hardness;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return super.func_149712_f(world, x, y, z);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        if (this == GCBlocks.slabGCDouble) {
            return new ItemStack(GCBlocks.slabGCHalf, 1, world.func_72805_g(x, y, z));
        }
        return new ItemStack(GCBlocks.slabGCHalf, 1, world.func_72805_g(x, y, z) & 7);
    }

    protected ItemStack func_149644_j(int par1) {
        return new ItemStack((Block)this, 2, par1);
    }

    private int getWoodType(int meta) {
        if ((meta = BlockSlabGC.getTypeFromMeta(meta)) < woodTypes.length) {
            return meta;
        }
        return 0;
    }

    private static int getTypeFromMeta(int meta) {
        return Math.min(5, meta & 7);
    }
}

