/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.network;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.event.EventWakePlayer;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiCargoRocket;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiSlimelingInventory;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityCargoRocket;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntitySlimeling;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityCryogenicChamber;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.util.MarsUtil;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.MinecraftForge;

public class PacketSimpleMars
implements IPacket {
    private EnumSimplePacketMars type;
    private List<Object> data;

    public PacketSimpleMars() {
    }

    public PacketSimpleMars(EnumSimplePacketMars packetType, Object[] data) {
        this(packetType, Arrays.asList(data));
    }

    public PacketSimpleMars(EnumSimplePacketMars packetType, List<Object> data) {
        if (packetType.getDecodeClasses().length != data.size()) {
            GCLog.info("Simple Packet found data length different than packet type");
        }
        this.type = packetType;
        this.data = data;
    }

    @Override
    public void encodeInto(ChannelHandlerContext context, ByteBuf buffer) {
        buffer.writeInt(this.type.ordinal());
        try {
            NetworkUtil.encodeData(buffer, this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext context, ByteBuf buffer) {
        this.type = EnumSimplePacketMars.values()[buffer.readInt()];
        if (this.type.getDecodeClasses().length > 0) {
            this.data = NetworkUtil.decodeData(this.type.getDecodeClasses(), buffer);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        EntityClientPlayerMP playerBaseClient = null;
        if (player instanceof EntityClientPlayerMP) {
            playerBaseClient = (EntityClientPlayerMP)player;
        }
        switch (this.type) {
            case C_OPEN_CUSTOM_GUI: {
                int entityID = 0;
                Entity entity = null;
                switch ((Integer)this.data.get(1)) {
                    case 0: {
                        entityID = (Integer)this.data.get(2);
                        entity = player.field_70170_p.func_73045_a(entityID);
                        if (entity != null && entity instanceof EntitySlimeling) {
                            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiSlimelingInventory(player, (EntitySlimeling)entity));
                        }
                        player.field_71070_bA.field_75152_c = (Integer)this.data.get(0);
                        break;
                    }
                    case 1: {
                        entityID = (Integer)this.data.get(2);
                        entity = player.field_70170_p.func_73045_a(entityID);
                        if (entity != null && entity instanceof EntityCargoRocket) {
                            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiCargoRocket((IInventory)player.field_71071_by, (EntityCargoRocket)entity));
                        }
                        player.field_71070_bA.field_75152_c = (Integer)this.data.get(0);
                    }
                }
            }
            case C_BEGIN_CRYOGENIC_SLEEP: {
                TileEntity tile = player.field_70170_p.func_147438_o(((Integer)this.data.get(0)).intValue(), ((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue());
                if (!(tile instanceof TileEntityCryogenicChamber)) break;
                ((TileEntityCryogenicChamber)tile).sleepInBedAt(player, (Integer)this.data.get(0), (Integer)this.data.get(1), (Integer)this.data.get(2));
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer(player, false);
        GCPlayerStats stats = GCPlayerStats.get(playerBase);
        block0 : switch (this.type) {
            case S_UPDATE_SLIMELING_DATA: {
                Entity entity = player.field_70170_p.func_73045_a(((Integer)this.data.get(0)).intValue());
                if (!(entity instanceof EntitySlimeling)) break;
                EntitySlimeling slimeling = (EntitySlimeling)entity;
                int subType = (Integer)this.data.get(1);
                switch (subType) {
                    case 0: {
                        if (player != slimeling.func_70902_q() || slimeling.field_70170_p.field_72995_K) break;
                        slimeling.setSittingAI(!slimeling.func_70906_o());
                        slimeling.func_70637_d(false);
                        slimeling.func_70778_a(null);
                        slimeling.func_70784_b(null);
                        slimeling.func_70624_b(null);
                        break;
                    }
                    case 1: {
                        if (player != slimeling.func_70902_q() || slimeling.field_70170_p.field_72995_K) break;
                        slimeling.slimelingName = (String)this.data.get(2);
                        slimeling.setName(slimeling.slimelingName);
                        break;
                    }
                    case 2: {
                        if (player != slimeling.func_70902_q() || slimeling.field_70170_p.field_72995_K) break;
                        slimeling.age += 5000;
                        break;
                    }
                    case 3: {
                        if (slimeling.func_70880_s() || player != slimeling.func_70902_q() || slimeling.field_70170_p.field_72995_K) break;
                        slimeling.func_146082_f((EntityPlayer)playerBase);
                        break;
                    }
                    case 4: {
                        if (player != slimeling.func_70902_q() || slimeling.field_70170_p.field_72995_K) break;
                        slimeling.attackDamage = Math.min(slimeling.attackDamage + 0.1f, 1.0f);
                        break;
                    }
                    case 5: {
                        if (player != slimeling.func_70902_q() || slimeling.field_70170_p.field_72995_K) break;
                        slimeling.func_70606_j(slimeling.func_110143_aJ() + 5.0f);
                        break;
                    }
                    case 6: {
                        if (player != slimeling.func_70902_q() || slimeling.field_70170_p.field_72995_K) break;
                        MarsUtil.openSlimelingInventory(playerBase, slimeling);
                    }
                }
                break;
            }
            case S_WAKE_PLAYER: {
                ChunkCoordinates c = playerBase.field_71081_bT;
                if (c == null) break;
                EventWakePlayer event = new EventWakePlayer((EntityPlayer)playerBase, c.field_71574_a, c.field_71572_b, c.field_71573_c, true, true, false, true);
                MinecraftForge.EVENT_BUS.post((Event)event);
                playerBase.func_70999_a(true, true, false);
                break;
            }
            case S_UPDATE_ADVANCED_GUI: {
                TileEntity tile = player.field_70170_p.func_147438_o(((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue(), ((Integer)this.data.get(3)).intValue());
                switch ((Integer)this.data.get(0)) {
                    case 0: {
                        if (!(tile instanceof TileEntityLaunchController)) break block0;
                        TileEntityLaunchController launchController = (TileEntityLaunchController)tile;
                        launchController.setFrequency((Integer)this.data.get(4));
                        break block0;
                    }
                    case 1: {
                        if (!(tile instanceof TileEntityLaunchController)) break block0;
                        TileEntityLaunchController launchController = (TileEntityLaunchController)tile;
                        launchController.setLaunchDropdownSelection((Integer)this.data.get(4));
                        break block0;
                    }
                    case 2: {
                        if (!(tile instanceof TileEntityLaunchController)) break block0;
                        TileEntityLaunchController launchController = (TileEntityLaunchController)tile;
                        launchController.setDestinationFrequency((Integer)this.data.get(4));
                        break block0;
                    }
                    case 3: {
                        if (!(tile instanceof TileEntityLaunchController)) break block0;
                        TileEntityLaunchController launchController = (TileEntityLaunchController)tile;
                        launchController.launchPadRemovalDisabled = (Integer)this.data.get(4) == 1;
                        break block0;
                    }
                    case 4: {
                        if (!(tile instanceof TileEntityLaunchController)) break block0;
                        TileEntityLaunchController launchController = (TileEntityLaunchController)tile;
                        launchController.setLaunchSchedulingEnabled((Integer)this.data.get(4) == 1);
                        break block0;
                    }
                    case 5: {
                        if (!(tile instanceof TileEntityLaunchController)) break block0;
                        TileEntityLaunchController launchController = (TileEntityLaunchController)tile;
                        launchController.requiresClientUpdate = true;
                        break block0;
                    }
                }
                break;
            }
            case S_UPDATE_CARGO_ROCKET_STATUS: {
                Entity entity2 = player.field_70170_p.func_73045_a(((Integer)this.data.get(0)).intValue());
                if (!(entity2 instanceof EntityCargoRocket)) break;
                EntityCargoRocket rocket = (EntityCargoRocket)entity2;
                rocket.statusValid = rocket.checkLaunchValidity();
                break;
            }
        }
    }

    public static enum EnumSimplePacketMars {
        S_UPDATE_SLIMELING_DATA(Side.SERVER, Integer.class, Integer.class, String.class),
        S_WAKE_PLAYER(Side.SERVER, new Class[0]),
        S_UPDATE_ADVANCED_GUI(Side.SERVER, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class),
        S_UPDATE_CARGO_ROCKET_STATUS(Side.SERVER, Integer.class, Integer.class),
        C_OPEN_CUSTOM_GUI(Side.CLIENT, Integer.class, Integer.class, Integer.class),
        C_BEGIN_CRYOGENIC_SLEEP(Side.CLIENT, Integer.class, Integer.class, Integer.class);

        private Side targetSide;
        private Class<?>[] decodeAs;

        private EnumSimplePacketMars(Side targetSide, Class<?> ... decodeAs) {
            this.targetSide = targetSide;
            this.decodeAs = decodeAs;
        }

        public Side getTargetSide() {
            return this.targetSide;
        }

        public Class<?>[] getDecodeClasses() {
            return this.decodeAs;
        }
    }
}

