/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import cpw.mods.ironchest.IronChest;
import galaxyspace.core.register.GSItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.mars.nei.CargoRocketRecipeHandler;
import micdoodle8.mods.galacticraft.planets.mars.nei.GCMarsNEIHighlightHandler;
import micdoodle8.mods.galacticraft.planets.mars.nei.GasLiquefierRecipeHandler;
import micdoodle8.mods.galacticraft.planets.mars.nei.MethaneSynthesizerRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class NEIGalacticraftMarsConfig
implements IConfigureNEI {
    private static HashMap<ArrayList<PositionedStack>, PositionedStack> rocketBenchRecipes = new HashMap();
    private static HashMap<ArrayList<PositionedStack>, PositionedStack> cargoBenchRecipes = new HashMap();
    private static HashMap<PositionedStack, PositionedStack> liquefierRecipes = new HashMap();
    private static HashMap<PositionedStack, PositionedStack> synthesizerRecipes = new HashMap();
    public static GCMarsNEIHighlightHandler planetsHighlightHandler = new GCMarsNEIHighlightHandler();

    public void loadConfig() {
        this.registerRecipes();
        API.registerRecipeHandler((ICraftingHandler)new CargoRocketRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CargoRocketRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new GasLiquefierRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new GasLiquefierRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new MethaneSynthesizerRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new MethaneSynthesizerRecipeHandler());
        API.registerHighlightIdentifier((Block)MarsBlocks.marsBlock, (IHighlightHandler)planetsHighlightHandler);
    }

    public String getName() {
        return "Galacticraft Mars NEI Plugin";
    }

    public String getVersion() {
        return "3.0.13-GTNH";
    }

    public void registerRocketBenchRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        rocketBenchRecipes.put(input, output);
    }

    public void registerCargoBenchRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        cargoBenchRecipes.put(input, output);
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getRocketBenchRecipes() {
        return rocketBenchRecipes.entrySet();
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getCargoBenchRecipes() {
        return cargoBenchRecipes.entrySet();
    }

    private void registerLiquefierRecipe(PositionedStack inputStack, PositionedStack outputStack) {
        liquefierRecipes.put(inputStack, outputStack);
    }

    public static Set<Map.Entry<PositionedStack, PositionedStack>> getLiquefierRecipes() {
        return liquefierRecipes.entrySet();
    }

    private void registerSynthesizerRecipe(PositionedStack inputStack, PositionedStack outputStack) {
        synthesizerRecipes.put(inputStack, outputStack);
    }

    public static Set<Map.Entry<PositionedStack, PositionedStack>> getSynthesizerRecipes() {
        return synthesizerRecipes.entrySet();
    }

    public void registerRecipes() {
        ArrayList<PositionedStack> input = new ArrayList<PositionedStack>();
        ArrayList<Object> input2 = new ArrayList<PositionedStack>();
        int x = 4;
        int y = 16;
        input.add(new PositionedStack((Object)new ItemStack(GCItems.basicItem, 1, 14), 134 - x, 10 - y));
        input.add(new PositionedStack((Object)new ItemStack(GSItems.ControlComputer, 1, 101), 134 - x, 28 - y));
        input.add(new PositionedStack((Object)new ItemStack(GSItems.ModuleSmallFuelCanister), 116 - x, 19 - y));
        input.add(new PositionedStack((Object)new ItemStack(GSItems.ModuleSmallFuelCanister), 152 - x, 19 - y));
        input.add(new PositionedStack((Object)new ItemStack(GSItems.ModuleSmallFuelCanister), 116 - x, 37 - y));
        input.add(new PositionedStack((Object)new ItemStack(GCItems.partNoseCone), 53 - x, 19 - y));
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 2; ++j) {
                input.add(new PositionedStack((Object)new ItemStack(MarsItems.marsItemBasic, 1, 3), 44 + j * 18 - x, 37 + i * 18 - y));
            }
        }
        input.add(new PositionedStack((Object)new ItemStack(GCItems.rocketEngine), 53 - x, 109 - y));
        input.add(new PositionedStack((Object)new ItemStack(GCItems.partFins), 26 - x, 91 - y));
        input.add(new PositionedStack((Object)new ItemStack(GCItems.partFins), 80 - x, 91 - y));
        input.add(new PositionedStack((Object)new ItemStack(GCItems.partFins), 26 - x, 109 - y));
        input.add(new PositionedStack((Object)new ItemStack(GCItems.partFins), 80 - x, 109 - y));
        input2 = new ArrayList(input);
        input2.add(new PositionedStack((Object)new ItemStack((Block)IronChest.ironChestBlock, 1, 3), 134 - x, 46 - y));
        this.registerCargoBenchRecipe(input2, new PositionedStack((Object)new ItemStack(MarsItems.spaceship, 1, 11), 134 - x, 73 - y));
        input2 = new ArrayList(input);
        input2.add(new PositionedStack((Object)new ItemStack((Block)IronChest.ironChestBlock), 134 - x, 46 - y));
        this.registerCargoBenchRecipe(input2, new PositionedStack((Object)new ItemStack(MarsItems.spaceship, 1, 12), 134 - x, 73 - y));
        input2 = new ArrayList(input);
        input2.add(new PositionedStack((Object)new ItemStack((Block)IronChest.ironChestBlock, 1, 1), 134 - x, 46 - y));
        this.registerCargoBenchRecipe(input2, new PositionedStack((Object)new ItemStack(MarsItems.spaceship, 1, 13), 134 - x, 73 - y));
        this.registerLiquefierRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.methaneCanister, 1, 1), 2, 3), new PositionedStack((Object)new ItemStack(GCItems.fuelCanister, 1, 1), 127, 3));
        this.registerLiquefierRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.atmosphericValve, 1, 0), 2, 3), new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLN2, 1, 1), 127, 3));
        this.registerLiquefierRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.atmosphericValve, 1, 0), 2, 3), new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLOX, 1, 1), 148, 3));
        this.registerLiquefierRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLN2, 1, 501), 2, 3), new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLN2, 1, 1), 127, 3));
        this.registerLiquefierRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLOX, 1, 501), 2, 3), new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLOX, 1, 1), 148, 3));
        this.registerSynthesizerRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.atmosphericValve, 1, 0), 23, 3), new PositionedStack((Object)new ItemStack(AsteroidsItems.methaneCanister, 1, 1), 148, 3));
        this.registerSynthesizerRecipe(new PositionedStack((Object)new ItemStack(MarsItems.carbonFragments, 25, 0), 23, 49), new PositionedStack((Object)new ItemStack(AsteroidsItems.methaneCanister, 1, 1), 148, 3));
    }
}

