/*
 * Decompiled with CFR 0.152.
 */
package bloodasp.galacticgreg;

import bloodasp.galacticgreg.GT_TileEntity_Ores_Space;
import bloodasp.galacticgreg.GalacticGreg;
import bloodasp.galacticgreg.api.ModDimensionDef;
import bloodasp.galacticgreg.dynconfig.DynamicOreMixWorldConfig;
import bloodasp.galacticgreg.registry.GalacticGregRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.world.GT_Worldgen;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class GT_Worldgen_GT_Ore_SmallPieces_Space
extends GT_Worldgen {
    public final short mMinY;
    public final short mMaxY;
    public final short mAmount;
    public final short mMeta;
    private long mProfilingStart;
    private long mProfilingEnd;
    private DynamicOreMixWorldConfig _mDynWorldConfig;

    public GT_Worldgen_GT_Ore_SmallPieces_Space(String pName, boolean pDefault, int pMinY, int pMaxY, int pAmount, Materials pPrimary) {
        super(pName, GalacticGreg.smallOreWorldgenList, pDefault);
        this.mMinY = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "MinHeight", pMinY);
        this.mMaxY = (short)Math.max(this.mMinY + 1, GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "MaxHeight", pMaxY));
        this.mAmount = (short)Math.max(1, GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Amount", pAmount));
        this.mMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Ore", pPrimary.mMetaItemSubID);
        this._mDynWorldConfig = new DynamicOreMixWorldConfig(this.mWorldGenName);
        this._mDynWorldConfig.InitDynamicConfig();
        GalacticGreg.Logger.trace("Initialized new OreLayer: %s", pName);
    }

    public GT_Worldgen_GT_Ore_SmallPieces_Space(String pName, boolean pDefault, int pMinY, int pMaxY, int pAmount, short pPrimary) {
        super(pName, GalacticGreg.smallOreWorldgenList, pDefault);
        this.mMinY = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "MinHeight", pMinY);
        this.mMaxY = (short)Math.max(this.mMinY + 1, GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "MaxHeight", pMaxY));
        this.mAmount = (short)Math.max(1, GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Amount", pAmount));
        this.mMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Ore", (int)pPrimary);
        this._mDynWorldConfig = new DynamicOreMixWorldConfig(this.mWorldGenName);
        this._mDynWorldConfig.InitDynamicConfig();
        GalacticGreg.Logger.trace("Initialized new OreLayer: %s", pName);
    }

    public boolean isEnabledForDim(ModDimensionDef pDimensionDef) {
        return this._mDynWorldConfig.isEnabledInDim(pDimensionDef);
    }

    public boolean executeWorldgen(World pWorld, Random pRandom, String pBiome, int pDimensionType, int pChunkX, int pChunkZ, IChunkProvider pChunkGenerator, IChunkProvider pChunkProvider) {
        GalacticGreg.Logger.trace("Entering executeWorldgen for [%s]", this.mWorldGenName);
        ModDimensionDef tMDD = GalacticGregRegistry.getDimensionTypeByChunkGenerator(pChunkGenerator);
        if (tMDD == null) {
            GalacticGreg.Logger.trace("Can't find dimension definition for ChunkProvider %s, skipping", pChunkGenerator.toString());
            return false;
        }
        if (!this._mDynWorldConfig.isEnabledInDim(tMDD)) {
            GalacticGreg.Logger.trace("OreGen for %s is disallowed in dimension %s, skipping", this.mWorldGenName, tMDD.getDimensionName());
            return false;
        }
        if (GalacticGreg.GalacticConfig.ProfileOreGen) {
            this.mProfilingStart = System.currentTimeMillis();
        }
        if (this.mMeta > 0) {
            int j = Math.max(1, this.mAmount / 2 + pRandom.nextInt(this.mAmount) / 2);
            for (int i = 0; i < j; ++i) {
                GT_TileEntity_Ores_Space.setOuterSpaceOreBlock(tMDD, pWorld, pChunkX + pRandom.nextInt(16), this.mMinY + pRandom.nextInt(Math.max(1, this.mMaxY - this.mMinY)), pChunkZ + pRandom.nextInt(16), this.mMeta + 16000);
            }
        }
        if (GalacticGreg.GalacticConfig.ProfileOreGen) {
            try {
                this.mProfilingEnd = System.currentTimeMillis();
                long tTotalTime = this.mProfilingEnd - this.mProfilingStart;
                GalacticGreg.Profiler.AddTimeToList(tMDD, tTotalTime);
                GalacticGreg.Logger.debug("Done with SmallOre-Worldgen in DimensionType %s. Generation took %d ms", tMDD.getDimensionName(), tTotalTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GalacticGreg.Logger.trace("Leaving executeWorldgen", new Object[0]);
        return true;
    }

    public boolean isAllowedForHeight(int pTargetHeight) {
        return pTargetHeight >= this.mMinY && pTargetHeight <= this.mMaxY;
    }
}

