/*
 * Decompiled with CFR 0.152.
 */
package bloodasp.galacticgreg.dynconfig;

import bloodasp.galacticgreg.GalacticGreg;
import bloodasp.galacticgreg.api.ModContainer;
import bloodasp.galacticgreg.api.ModDimensionDef;
import bloodasp.galacticgreg.registry.GalacticGregRegistry;
import gregtech.api.GregTech_API;
import java.util.HashMap;
import java.util.Map;

public class DynamicOreMixWorldConfig {
    private String _mWorldGenName;
    private Map<String, Boolean> _mDynWorldConfigMap = null;
    private final String _mConfigName;

    private String getConfigKeyName(ModContainer pMC, ModDimensionDef pMDD) {
        return this.getConfigKeyName(pMC, pMDD, "");
    }

    private String getConfigKeyName(ModContainer pMC, ModDimensionDef pMDD, String pAdditionalName) {
        String tRet = String.format("%s_%s", pMC.getModName(), pMDD.getDimensionName());
        if (pAdditionalName.length() > 1) {
            tRet = String.format("%s_%s", tRet, pAdditionalName);
        }
        return tRet;
    }

    public DynamicOreMixWorldConfig(String pWorldGenName) {
        this._mWorldGenName = pWorldGenName;
        this._mDynWorldConfigMap = new HashMap<String, Boolean>();
        this._mConfigName = String.format("worldgen.%s", this._mWorldGenName);
    }

    public DynamicOreMixWorldConfig(String pWorldGenName, boolean bw) {
        this._mWorldGenName = pWorldGenName;
        this._mDynWorldConfigMap = new HashMap<String, Boolean>();
        this._mConfigName = String.format("worldgen.gagregbartworks.%s", this._mWorldGenName);
    }

    public boolean isEnabledInDim(ModDimensionDef pMDD) {
        String tDimIdentifier = pMDD.getDimIdentifier();
        if (this._mDynWorldConfigMap.containsKey(tDimIdentifier)) {
            return this._mDynWorldConfigMap.get(tDimIdentifier);
        }
        return false;
    }

    public boolean InitDynamicConfig() {
        try {
            for (ModContainer mc : GalacticGregRegistry.getModContainers()) {
                if (!mc.getEnabled()) continue;
                for (ModDimensionDef mdd : mc.getDimensionList()) {
                    String tDimIdentifier = mdd.getDimIdentifier();
                    if (this._mDynWorldConfigMap.containsKey(tDimIdentifier)) {
                        GalacticGreg.Logger.error("Found 2 Dimensions with the same Identifier: %s Dimension will not generate Ores", tDimIdentifier);
                        continue;
                    }
                    boolean tFlag = GregTech_API.sWorldgenFile.get((Object)this._mConfigName, this.getConfigKeyName(mc, mdd), false);
                    this._mDynWorldConfigMap.put(tDimIdentifier, tFlag);
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

