/*
 * Decompiled with CFR 0.152.
 */
package bloodasp.galacticgreg;

import bloodasp.galacticgreg.auxiliary.GalacticGregConfig;
import bloodasp.galacticgreg.auxiliary.LogHelper;
import bloodasp.galacticgreg.auxiliary.ProfilingStorage;
import bloodasp.galacticgreg.bartworks.BW_Worldgen_Ore_Layer_Space;
import bloodasp.galacticgreg.bartworks.BW_Worldgen_Ore_SmallOre_Space;
import bloodasp.galacticgreg.command.AEStorageCommand;
import bloodasp.galacticgreg.command.ProfilingCommand;
import bloodasp.galacticgreg.registry.GalacticGregRegistry;
import bloodasp.galacticgreg.schematics.SpaceSchematicHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import gregtech.api.GregTech_API;
import gregtech.api.world.GT_Worldgen;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.command.ICommand;

@Mod(modid="galacticgreg", version="1.0.2", dependencies="required-after:GalacticraftCore; required-after:gregtech@5.09.32.30;", acceptableRemoteVersions="*")
public class GalacticGreg {
    public static final List<GT_Worldgen> smallOreWorldgenList = new ArrayList<GT_Worldgen>();
    public static final List<GT_Worldgen> oreVeinWorldgenList = new ArrayList<GT_Worldgen>();
    public static final String NICE_MODID = "GalacticGreg";
    public static final String MODID = "galacticgreg";
    public static final String VERSION = "1.0.2";
    public static final LogHelper Logger = new LogHelper("GalacticGreg");
    public static ProfilingStorage Profiler = new ProfilingStorage();
    public static SpaceSchematicHandler SchematicHandler;
    public static Random GalacticRandom;
    public static GalacticGregConfig GalacticConfig;
    public static final ArrayList<Runnable> ADDITIONALVEINREGISTER;

    @Mod.EventHandler
    public void onPreLoad(FMLPreInitializationEvent aEvent) {
        GalacticConfig = new GalacticGregConfig(aEvent.getModConfigurationDirectory(), NICE_MODID, NICE_MODID);
        if (!GalacticConfig.LoadConfig()) {
            Logger.warn("Something went wrong while reading GalacticGregs config file. Things will be wonky..", new Object[0]);
        }
        GalacticRandom = new Random(System.currentTimeMillis());
        if (GalacticGreg.GalacticConfig.SchematicsEnabled) {
            SchematicHandler = new SpaceSchematicHandler(aEvent.getModConfigurationDirectory());
        }
        Logger.trace("Leaving PRELOAD", new Object[0]);
    }

    @Mod.EventHandler
    public void onPostLoad(FMLPostInitializationEvent aEvent) {
        Logger.trace("Entering POSTLOAD", new Object[0]);
        if (!GalacticGregRegistry.InitRegistry()) {
            throw new RuntimeException("GalacticGreg registry has been finalized from a 3rd-party mod, this is forbidden!");
        }
        if (Loader.isModLoaded((String)"bartworks")) {
            int f;
            int j = GregTech_API.sWorldgenFile.get((Object)"worldgen.GaGregBartworks", "AmountOfCustomLargeVeinSlots", 0);
            for (f = 0; f < j; ++f) {
                new BW_Worldgen_Ore_Layer_Space("mix.custom." + (f < 10 ? "0" : "") + f, GregTech_API.sWorldgenFile.get((Object)("worldgen.GaGregBartworks.mix.custom." + (f < 10 ? "0" : "") + f), "Enabled", false));
            }
            j = GregTech_API.sWorldgenFile.get((Object)"worldgen.GaGregBartworks", "AmountOfCustomSmallSlots", 0);
            for (f = 0; f < j; ++f) {
                new BW_Worldgen_Ore_SmallOre_Space("small.custom." + (f < 10 ? "0" : "") + f, GregTech_API.sWorldgenFile.get((Object)("worldgen.GaGregBartworks.small.custom." + (f < 10 ? "0" : "") + f), "Enabled", false));
            }
        }
        for (Runnable r : ADDITIONALVEINREGISTER) {
            try {
                r.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GalacticConfig.serverPostInit();
        Logger.trace("Leaving POSTLOAD", new Object[0]);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent pEvent) {
        Logger.trace("Entering SERVERLOAD", new Object[0]);
        if (GalacticGreg.GalacticConfig.ProfileOreGen) {
            pEvent.registerServerCommand((ICommand)new ProfilingCommand());
        }
        if (Loader.isModLoaded((String)"appliedenergistics2") && GalacticGreg.GalacticConfig.EnableAEExportCommand && GalacticGreg.GalacticConfig.SchematicsEnabled) {
            pEvent.registerServerCommand((ICommand)new AEStorageCommand());
        }
        Logger.trace("Leaving SERVERLOAD", new Object[0]);
    }

    static {
        GalacticRandom = null;
        GalacticConfig = null;
        ADDITIONALVEINREGISTER = new ArrayList();
    }
}

