/*
 * Decompiled with CFR 0.152.
 */
package bloodasp.galacticgreg;

import bloodasp.galacticgreg.GT_TileEntity_Ores_Space;
import bloodasp.galacticgreg.GalacticGreg;
import bloodasp.galacticgreg.api.ModDimensionDef;
import bloodasp.galacticgreg.auxiliary.GTOreGroup;
import bloodasp.galacticgreg.bartworks.BW_Worldgen_Ore_Layer_Space;
import bloodasp.galacticgreg.dynconfig.DynamicOreMixWorldConfig;
import bloodasp.galacticgreg.registry.GalacticGregRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.util.GT_Log;
import gregtech.api.world.GT_Worldgen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class GT_Worldgen_GT_Ore_Layer_Space
extends GT_Worldgen {
    public static int sWeight = 0;
    public final short mMinY;
    public final short mMaxY;
    public final short mWeight;
    public final short mDensity;
    public final short mSize;
    public final short mPrimaryMeta;
    public final short mSecondaryMeta;
    public final short mBetweenMeta;
    public final short mSporadicMeta;
    private long mProfilingStart;
    private long mProfilingEnd;
    private DynamicOreMixWorldConfig _mDynWorldConfig = null;
    private static Map<String, Integer> _mBufferedVeinCountList = new HashMap<String, Integer>();
    private static Map<String, List<String>> _mBufferedVeinList = new HashMap<String, List<String>>();

    public GT_Worldgen_GT_Ore_Layer_Space(String pName, boolean pDefault, int pMinY, int pMaxY, int pWeight, int pDensity, int pSize, Materials pPrimary, Materials pSecondary, Materials pBetween, Materials pSporadic) {
        super(pName, GalacticGreg.oreVeinWorldgenList, pDefault);
        this.mMinY = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "MinHeight", pMinY);
        this.mMaxY = (short)Math.max(this.mMinY + 5, GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "MaxHeight", pMaxY));
        this.mWeight = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "RandomWeight", pWeight);
        this.mDensity = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Density", pDensity);
        this.mSize = (short)Math.max(1, GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Size", pSize));
        this.mPrimaryMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OrePrimaryLayer", pPrimary.mMetaItemSubID);
        this.mSecondaryMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OreSecondaryLayer", pSecondary.mMetaItemSubID);
        this.mBetweenMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OreSporadiclyInbetween", pBetween.mMetaItemSubID);
        this.mSporadicMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OreSporaticlyAround", pSporadic.mMetaItemSubID);
        this._mDynWorldConfig = new DynamicOreMixWorldConfig(this.mWorldGenName);
        this._mDynWorldConfig.InitDynamicConfig();
        GalacticGreg.Logger.trace("Initialized new OreLayer: %s", pName);
        if (this.mEnabled) {
            sWeight += this.mWeight;
        }
    }

    public GT_Worldgen_GT_Ore_Layer_Space(String pName, boolean pDefault, int pMinY, int pMaxY, int pWeight, int pDensity, int pSize, short pPrimary, short pSecondary, short pBetween, short pSporadic) {
        super(pName, GalacticGreg.oreVeinWorldgenList, pDefault);
        this.mMinY = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "MinHeight", pMinY);
        this.mMaxY = (short)Math.max(this.mMinY + 5, GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "MaxHeight", pMaxY));
        this.mWeight = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "RandomWeight", pWeight);
        this.mDensity = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Density", pDensity);
        this.mSize = (short)Math.max(1, GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Size", pSize));
        this.mPrimaryMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OrePrimaryLayer", (int)pPrimary);
        this.mSecondaryMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OreSecondaryLayer", (int)pSecondary);
        this.mBetweenMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OreSporadiclyInbetween", (int)pBetween);
        this.mSporadicMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OreSporaticlyAround", (int)pSporadic);
        this._mDynWorldConfig = new DynamicOreMixWorldConfig(this.mWorldGenName);
        this._mDynWorldConfig.InitDynamicConfig();
        GalacticGreg.Logger.trace("Initialized new OreLayer: %s", pName);
        if (this.mEnabled) {
            sWeight += this.mWeight;
        }
    }

    public boolean isEnabledForDim(ModDimensionDef pDimensionDef) {
        return this._mDynWorldConfig.isEnabledInDim(pDimensionDef);
    }

    private static int getNumOremixedForDim(ModDimensionDef pDimensionDef) {
        int tVal = 0;
        if (_mBufferedVeinCountList.containsKey(pDimensionDef.getDimIdentifier())) {
            tVal = _mBufferedVeinCountList.get(pDimensionDef.getDimIdentifier());
        } else {
            for (GT_Worldgen tWorldGen : GalacticGreg.oreVeinWorldgenList) {
                if (!(tWorldGen instanceof GT_Worldgen_GT_Ore_Layer_Space) || !((GT_Worldgen_GT_Ore_Layer_Space)tWorldGen).isEnabledForDim(pDimensionDef)) continue;
                ++tVal;
            }
            _mBufferedVeinCountList.put(pDimensionDef.getDimIdentifier(), tVal);
        }
        return tVal;
    }

    private static List<String> getOreMixIDsForDim(ModDimensionDef pDimensionDef) {
        ArrayList<String> tReturn = null;
        if (_mBufferedVeinList.containsKey(pDimensionDef.getDimIdentifier())) {
            tReturn = _mBufferedVeinList.get(pDimensionDef.getDimIdentifier());
        } else {
            tReturn = new ArrayList();
            for (GT_Worldgen tWorldGen : GalacticGreg.oreVeinWorldgenList) {
                if (tWorldGen instanceof GT_Worldgen_GT_Ore_Layer_Space && ((GT_Worldgen_GT_Ore_Layer_Space)tWorldGen).isEnabledForDim(pDimensionDef)) {
                    tReturn.add(tWorldGen.mWorldGenName);
                    continue;
                }
                if (!(tWorldGen instanceof BW_Worldgen_Ore_Layer_Space) || !((BW_Worldgen_Ore_Layer_Space)tWorldGen).isEnabledForDim(pDimensionDef)) continue;
                tReturn.add(tWorldGen.mWorldGenName);
            }
            _mBufferedVeinList.put(pDimensionDef.getDimIdentifier(), tReturn);
        }
        return tReturn;
    }

    private static short getMaxWeightForDim(ModDimensionDef pDimensionDef) {
        short tVal = 0;
        for (GT_Worldgen tWorldGen : GalacticGreg.oreVeinWorldgenList) {
            if (!(tWorldGen instanceof GT_Worldgen_GT_Ore_Layer_Space) || !((GT_Worldgen_GT_Ore_Layer_Space)tWorldGen).isEnabledForDim(pDimensionDef) || tVal >= ((GT_Worldgen_GT_Ore_Layer_Space)tWorldGen).mWeight) continue;
            tVal = ((GT_Worldgen_GT_Ore_Layer_Space)tWorldGen).mWeight;
        }
        return tVal;
    }

    public static GTOreGroup getRandomOreGroup(ModDimensionDef pDimensionDef, Random pRandom, boolean pIgnoreWeight) {
        short primaryMeta = 0;
        short secondaryMeta = 0;
        short betweenMeta = 0;
        short sporadicMeta = 0;
        if (pIgnoreWeight) {
            List<String> tEnabledVeins = GT_Worldgen_GT_Ore_Layer_Space.getOreMixIDsForDim(pDimensionDef);
            int tRnd = pRandom.nextInt(tEnabledVeins.size());
            String tVeinName = tEnabledVeins.get(tRnd);
            GT_Worldgen tGen = null;
            for (GT_Worldgen tWorldGen : GalacticGreg.oreVeinWorldgenList) {
                if (!(tWorldGen instanceof GT_Worldgen_GT_Ore_Layer_Space) || !((GT_Worldgen_GT_Ore_Layer_Space)tWorldGen).mWorldGenName.equals(tVeinName)) continue;
                tGen = tWorldGen;
            }
            if (tGen != null) {
                GalacticGreg.Logger.trace("Using Oremix %s for asteroid", tGen.mWorldGenName);
                primaryMeta = ((GT_Worldgen_GT_Ore_Layer_Space)tGen).mPrimaryMeta;
                secondaryMeta = ((GT_Worldgen_GT_Ore_Layer_Space)tGen).mSecondaryMeta;
                betweenMeta = ((GT_Worldgen_GT_Ore_Layer_Space)tGen).mBetweenMeta;
                sporadicMeta = ((GT_Worldgen_GT_Ore_Layer_Space)tGen).mSporadicMeta;
            }
        } else if (sWeight > 0 && GalacticGreg.oreVeinWorldgenList.size() > 0) {
            GalacticGreg.Logger.trace("About to select oremix", new Object[0]);
            boolean temp = true;
            block3: for (int i = 0; i < 256 && temp; ++i) {
                int tRandomWeight = pRandom.nextInt(sWeight);
                for (GT_Worldgen tWorldGen : GalacticGreg.oreVeinWorldgenList) {
                    if (!(tWorldGen instanceof GT_Worldgen_GT_Ore_Layer_Space) || (tRandomWeight -= ((GT_Worldgen_GT_Ore_Layer_Space)tWorldGen).mWeight) > 0) continue;
                    try {
                        if (!((GT_Worldgen_GT_Ore_Layer_Space)tWorldGen).isEnabledForDim(pDimensionDef)) continue;
                        GalacticGreg.Logger.trace("Using Oremix %s for asteroid", tWorldGen.mWorldGenName);
                        primaryMeta = ((GT_Worldgen_GT_Ore_Layer_Space)tWorldGen).mPrimaryMeta;
                        secondaryMeta = ((GT_Worldgen_GT_Ore_Layer_Space)tWorldGen).mSecondaryMeta;
                        betweenMeta = ((GT_Worldgen_GT_Ore_Layer_Space)tWorldGen).mBetweenMeta;
                        sporadicMeta = ((GT_Worldgen_GT_Ore_Layer_Space)tWorldGen).mSporadicMeta;
                        temp = false;
                        continue block3;
                    }
                    catch (Throwable e) {
                        e.printStackTrace(GT_Log.err);
                    }
                }
            }
        }
        if (primaryMeta != 0 || secondaryMeta != 0 || betweenMeta != 0 || sporadicMeta != 0) {
            return new GTOreGroup(primaryMeta, secondaryMeta, betweenMeta, sporadicMeta);
        }
        return null;
    }

    public boolean executeWorldgen(World pWorld, Random pRandom, String pBiome, int pDimensionType, int pChunkX, int pChunkZ, IChunkProvider pChunkGenerator, IChunkProvider pChunkProvider) {
        GalacticGreg.Logger.trace("Entering executeWorldgen for [%s]", this.mWorldGenName);
        ModDimensionDef tMDD = GalacticGregRegistry.getDimensionTypeByChunkGenerator(pChunkGenerator);
        if (tMDD == null) {
            GalacticGreg.Logger.trace("Can't find dimension definition for ChunkProvider %s, skipping", pChunkGenerator.toString());
            return false;
        }
        if (!this._mDynWorldConfig.isEnabledInDim(tMDD)) {
            GalacticGreg.Logger.trace("OreGen for %s is disallowed in dimension %s, skipping", this.mWorldGenName, tMDD.getDimensionName());
            return false;
        }
        if (GalacticGreg.GalacticConfig.ProfileOreGen) {
            this.mProfilingStart = System.currentTimeMillis();
        }
        int tMinY = this.mMinY + pRandom.nextInt(this.mMaxY - this.mMinY - 5);
        int cX = pChunkX - pRandom.nextInt(this.mSize);
        int eX = pChunkX + 16 + pRandom.nextInt(this.mSize);
        for (int tX = cX; tX <= eX; ++tX) {
            int cZ = pChunkZ - pRandom.nextInt(this.mSize);
            int eZ = pChunkZ + 16 + pRandom.nextInt(this.mSize);
            for (int tZ = cZ; tZ <= eZ; ++tZ) {
                int i;
                if (this.mSecondaryMeta > 0) {
                    for (i = tMinY - 1; i < tMinY + 2; ++i) {
                        if (pRandom.nextInt(Math.max(1, Math.max(Math.abs(cZ - tZ), Math.abs(eZ - tZ)) / this.mDensity)) != 0 && pRandom.nextInt(Math.max(1, Math.max(Math.abs(cX - tX), Math.abs(eX - tX)) / this.mDensity)) != 0) continue;
                        GT_TileEntity_Ores_Space.setOuterSpaceOreBlock(tMDD, pWorld, tX, i, tZ, this.mSecondaryMeta);
                    }
                }
                if (this.mBetweenMeta > 0 && (pRandom.nextInt(Math.max(1, Math.max(Math.abs(cZ - tZ), Math.abs(eZ - tZ)) / this.mDensity)) == 0 || pRandom.nextInt(Math.max(1, Math.max(Math.abs(cX - tX), Math.abs(eX - tX)) / this.mDensity)) == 0)) {
                    GT_TileEntity_Ores_Space.setOuterSpaceOreBlock(tMDD, pWorld, tX, tMinY + 2 + pRandom.nextInt(2), tZ, this.mBetweenMeta);
                }
                if (this.mPrimaryMeta > 0) {
                    for (i = tMinY + 3; i < tMinY + 6; ++i) {
                        if (pRandom.nextInt(Math.max(1, Math.max(Math.abs(cZ - tZ), Math.abs(eZ - tZ)) / this.mDensity)) != 0 && pRandom.nextInt(Math.max(1, Math.max(Math.abs(cX - tX), Math.abs(eX - tX)) / this.mDensity)) != 0) continue;
                        GT_TileEntity_Ores_Space.setOuterSpaceOreBlock(tMDD, pWorld, tX, i, tZ, this.mPrimaryMeta);
                    }
                }
                if (this.mSporadicMeta <= 0 || pRandom.nextInt(Math.max(1, Math.max(Math.abs(cZ - tZ), Math.abs(eZ - tZ)) / this.mDensity)) != 0 && pRandom.nextInt(Math.max(1, Math.max(Math.abs(cX - tX), Math.abs(eX - tX)) / this.mDensity)) != 0) continue;
                GT_TileEntity_Ores_Space.setOuterSpaceOreBlock(tMDD, pWorld, tX, tMinY - 1 + pRandom.nextInt(7), tZ, this.mSporadicMeta);
            }
        }
        if (GalacticGreg.GalacticConfig.ProfileOreGen) {
            try {
                this.mProfilingEnd = System.currentTimeMillis();
                long tTotalTime = this.mProfilingEnd - this.mProfilingStart;
                GalacticGreg.Profiler.AddTimeToList(tMDD, tTotalTime);
                GalacticGreg.Logger.debug("Done with OreLayer-Worldgen in DimensionType %s. Generation took %d ms", tMDD.getDimensionName(), tTotalTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GalacticGreg.Logger.trace("Leaving executeWorldgen", new Object[0]);
        return true;
    }
}

