/*
 * Decompiled with CFR 0.152.
 */
package bloodasp.galacticgreg.command;

import appeng.api.util.WorldCoord;
import appeng.items.storage.ItemSpatialStorageCell;
import bloodasp.galacticgreg.GalacticGreg;
import bloodasp.galacticgreg.auxiliary.PlayerChatHelper;
import bloodasp.galacticgreg.schematics.SpaceSchematic;
import bloodasp.galacticgreg.schematics.SpaceSchematicFactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class AEStorageCommand
implements ICommand {
    private List aliases = new ArrayList();

    public AEStorageCommand() {
        this.aliases.add("exportae");
    }

    public String func_71517_b() {
        return "exportae";
    }

    public String func_71518_a(ICommandSender pCommandSender) {
        return "exportae <structure name>";
    }

    public List func_71514_a() {
        return this.aliases;
    }

    public void func_71515_b(ICommandSender pCommandSender, String[] pArgs) {
        try {
            if (pCommandSender instanceof EntityPlayer) {
                if (pArgs.length < 1) {
                    return;
                }
                String tName = pArgs[0].toString();
                EntityPlayer tEP = (EntityPlayer)pCommandSender;
                ItemStack tIS = tEP.field_71071_by.func_70448_g();
                if (tIS.func_77973_b() instanceof ItemSpatialStorageCell) {
                    ItemSpatialStorageCell tCell = (ItemSpatialStorageCell)tIS.func_77973_b();
                    World tSpatialWorld = tCell.getWorld(tIS);
                    WorldCoord storedSize = tCell.getStoredSize(tIS);
                    if (storedSize.x == 0 || storedSize.y == 0 || storedSize.z == 0) {
                        PlayerChatHelper.SendError(pCommandSender, "Error: This spatial storage is empty");
                        return;
                    }
                    GalacticGreg.Logger.info("Creating Structure from Spatial AE drive. Dimensions: X [%d] Y [%d] Z [%d]", storedSize.x, storedSize.y, storedSize.z);
                    SpaceSchematic tSchematic = SpaceSchematicFactory.createSchematic(tName);
                    boolean tTEWarningSend = false;
                    for (int lX = 1; lX <= storedSize.x; ++lX) {
                        for (int lY = 65; lY < 65 + storedSize.y; ++lY) {
                            for (int lZ = 1; lZ <= storedSize.z; ++lZ) {
                                Block b = tSpatialWorld.func_147439_a(lX, lY, lZ);
                                int bm = tSpatialWorld.func_72805_g(lX, lY, lZ);
                                String tBlockName = Block.field_149771_c.func_148750_c((Object)b);
                                TileEntity bTE = tSpatialWorld.func_147438_o(lX, lY, lZ);
                                String tMsg = String.format("[X-%d][Y-%d][Z-%d] ", lX, lY, lZ);
                                String nbtComp = "";
                                if (b == null) continue;
                                tMsg = tMsg + tBlockName;
                                if (bTE != null) {
                                    tMsg = tMsg + " TE";
                                    GalacticGreg.Logger.warn("Warning: Found TileEntity at X[%d] Y[%d] Z[%d]. NBT States are not exported!", lX, lY, lZ);
                                    if (!tTEWarningSend) {
                                        tTEWarningSend = true;
                                        PlayerChatHelper.SendWarn(pCommandSender, "TileEntity states are not exported!");
                                    }
                                }
                                if (b == Blocks.field_150350_a) continue;
                                tSchematic.addStructureInfo(SpaceSchematicFactory.createStructureInfo(lX, lY, lZ, b, bm));
                            }
                        }
                    }
                    if (!GalacticGreg.SchematicHandler.SaveSpaceStructure(tSchematic)) {
                        PlayerChatHelper.SendError(pCommandSender, "Something went wrong. Structure not saved");
                    } else {
                        PlayerChatHelper.SendInfo(pCommandSender, "Structure has been exported to " + tSchematic.getName() + ".xml. It contains " + tSchematic.coordInfo().size() + " Blocks");
                        PlayerChatHelper.SendInfo(pCommandSender, "You have to edit the file before a reload will accept it!");
                    }
                } else {
                    PlayerChatHelper.SendError(pCommandSender, "Error: Item in your hand is not a spatial storage drive!");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_71519_b(ICommandSender pCommandSender) {
        if (pCommandSender instanceof EntityPlayerMP) {
            EntityPlayerMP tEP = (EntityPlayerMP)pCommandSender;
            return MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(tEP.func_146103_bH());
        }
        return false;
    }

    public int compareTo(Object o) {
        return 0;
    }

    public List func_71516_a(ICommandSender p_71516_1_, String[] p_71516_2_) {
        return null;
    }

    public boolean func_82358_a(String[] p_82358_1_, int p_82358_2_) {
        return false;
    }
}

