/*
 * Decompiled with CFR 0.152.
 */
package com.detrav.net;

import com.detrav.DetravScannerMod;
import com.detrav.gui.DetravScannerGUI;
import com.detrav.gui.textures.DetravMapTexture;
import com.detrav.net.DetravPacket;
import com.detrav.utils.GTppHelper;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.google.common.base.Objects;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.util.GT_LanguageManager;
import gtPlusPlus.core.material.Material;
import java.util.HashMap;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ProspectingPacket
extends DetravPacket {
    public final int chunkX;
    public final int chunkZ;
    public final int posX;
    public final int posZ;
    public final int size;
    public final int ptype;
    public final HashMap<Byte, Short>[][] map;
    public final HashMap<String, Integer> ores;
    public final HashMap<Short, String> metaMap;
    public static final HashMap<Integer, short[]> fluidColors = new HashMap();
    public int level = -1;

    public ProspectingPacket(int chunkX, int chunkZ, int posX, int posZ, int size, int ptype) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.posX = posX;
        this.posZ = posZ;
        this.size = size;
        this.ptype = ptype;
        this.map = new HashMap[(size * 2 + 1) * 16][(size * 2 + 1) * 16];
        this.ores = new HashMap();
        this.metaMap = new HashMap();
    }

    private static void addOre(ProspectingPacket packet, byte y, int i, int j, short meta) {
        String name;
        short[] rgba;
        block12: {
            try {
                if (packet.ptype == 0 || packet.ptype == 1) {
                    if (meta < 7000 || meta > 7500) {
                        if (meta > 0) {
                            Materials tMaterial = GregTech_API.sGeneratedMaterials[meta % 1000];
                            rgba = tMaterial.getRGBA();
                            name = tMaterial.getLocalizedNameForItem(GT_LanguageManager.getTranslation((String)("gt.blockores." + meta + ".name")));
                        } else {
                            short[] sArray;
                            name = GT_LanguageManager.getTranslation((String)("bw.blockores.01." + meta * -1 + ".name"));
                            Werkstoff werkstoff = Werkstoff.werkstoffHashMap.getOrDefault((short)(meta * -1), null);
                            if (werkstoff != null) {
                                sArray = werkstoff.getRGBA();
                            } else {
                                short[] sArray2 = new short[4];
                                sArray2[0] = 0;
                                sArray2[1] = 0;
                                sArray2[2] = 0;
                                sArray = sArray2;
                                sArray2[3] = 0;
                            }
                            rgba = sArray;
                        }
                    } else {
                        Material pMaterial = GTppHelper.decodeoresGTpp.get((short)(meta - 7000));
                        rgba = pMaterial.getRGBA();
                        name = pMaterial.getLocalizedName() + " Ore";
                    }
                    break block12;
                }
                if (packet.ptype == 2) {
                    rgba = fluidColors.get(meta);
                    if (rgba == null) {
                        DetravScannerMod.proxy.sendPlayerExeption("Unknown fluid ID = " + meta + " Please add to FluidColors.java!");
                        rgba = new short[]{0, 0, 0, 0};
                    }
                    name = (String)Objects.firstNonNull((Object)FluidRegistry.getFluid((int)meta).getLocalizedName(new FluidStack(FluidRegistry.getFluid((int)meta), 0)), (Object)StatCollector.func_74838_a((String)"gui.detrav.scanner.unknown_fluid"));
                    break block12;
                }
                if (packet.ptype == 3) {
                    name = StatCollector.func_74838_a((String)"gui.detrav.scanner.pollution");
                    rgba = new short[]{125, 123, 118, 0};
                    break block12;
                }
                return;
            }
            catch (Exception ignored) {
                return;
            }
        }
        packet.ores.put(name, ((rgba[0] & 0xFF) << 16) + ((rgba[1] & 0xFF) << 8) + (rgba[2] & 0xFF));
        packet.metaMap.put(meta, name);
    }

    public static Object decode(ByteArrayDataInput aData) {
        ProspectingPacket packet = new ProspectingPacket(aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt());
        packet.level = aData.readInt();
        int aSize = (packet.size * 2 + 1) * 16;
        int checkOut = 0;
        for (int i = 0; i < aSize; ++i) {
            for (int j = 0; j < aSize; ++j) {
                int kSize = aData.readByte();
                if (kSize == 0) continue;
                packet.map[i][j] = new HashMap();
                for (int k = 0; k < kSize; ++k) {
                    byte y = aData.readByte();
                    short meta = aData.readShort();
                    packet.map[i][j].put(y, meta);
                    if (packet.ptype != 2 || y == 1) {
                        ProspectingPacket.addOre(packet, y, i, j, meta);
                    }
                    ++checkOut;
                }
            }
        }
        int checkOut2 = aData.readInt();
        if (checkOut != checkOut2) {
            return null;
        }
        return packet;
    }

    @Override
    public int getPacketID() {
        return 0;
    }

    @Override
    public byte[] encode() {
        ByteArrayDataOutput tOut = ByteStreams.newDataOutput((int)1);
        tOut.writeInt(this.chunkX);
        tOut.writeInt(this.chunkZ);
        tOut.writeInt(this.posX);
        tOut.writeInt(this.posZ);
        tOut.writeInt(this.size);
        tOut.writeInt(this.ptype);
        tOut.writeInt(this.level);
        int aSize = (this.size * 2 + 1) * 16;
        int checkOut = 0;
        for (int i = 0; i < aSize; ++i) {
            for (int j = 0; j < aSize; ++j) {
                if (this.map[i][j] == null) {
                    tOut.writeByte(0);
                    continue;
                }
                tOut.writeByte(this.map[i][j].keySet().size());
                for (byte key : this.map[i][j].keySet()) {
                    tOut.writeByte((int)key);
                    tOut.writeShort((int)this.map[i][j].get(key).shortValue());
                    ++checkOut;
                }
            }
        }
        tOut.writeInt(checkOut);
        return tOut.toByteArray();
    }

    @Override
    public void process() {
        DetravScannerGUI.newMap(new DetravMapTexture(this));
        DetravScannerMod.proxy.openProspectorGUI();
    }

    public void addBlock(int x, int y, int z, short metaData) {
        int aX = x - (this.chunkX - this.size) * 16;
        int aZ = z - (this.chunkZ - this.size) * 16;
        if (this.map[aX][aZ] == null) {
            this.map[aX][aZ] = new HashMap();
        }
        this.map[aX][aZ].put((byte)y, metaData);
    }

    public int getSize() {
        return (this.size * 2 + 1) * 16;
    }
}

