/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech.machines;

import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gttweaker.mods.AddMultipleRecipeAction;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Pulverizer")
@ModOnly(value={"gregtech"})
public class Pulverizer {
    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, IIngredient input, int[] outChances, int durationTicks, int euPerTick) {
        if (outputs.length < 1) {
            MineTweakerAPI.logError((String)"Pulverizer must have at least 1 output");
        } else if (outputs.length != outChances.length) {
            MineTweakerAPI.logError((String)"Number of Outputs does not equal number of Chances");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Pulverizer recipe for " + input, new Object[]{input, outputs, outChances, durationTicks, euPerTick}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{i.nextItem()}).itemOutputs(i.nextItemArr()).outputChances(i.nextIntArr()).duration(i.nextInt()).duration(i.nextInt()).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
                }
            });
        }
    }
}

