/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech.machines;

import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTUtility;
import gttweaker.mods.AddMultipleRecipeAction;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.DistillationTower")
@ModOnly(value={"gregtech"})
public class DistillationTower {
    @ZenMethod
    public static void addRecipe(ILiquidStack[] fluidOutput, IItemStack itemOutput, ILiquidStack fluidInput, int durationTicks, int euPerTick) {
        if (fluidOutput.length < 1) {
            MineTweakerAPI.logError((String)"Distillation Tower must have at least 1 Fluid output");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Distillation Tower recipe for " + fluidInput.getDisplayName(), new Object[]{fluidInput, fluidOutput, itemOutput, durationTicks, euPerTick}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    FluidStack fluidInput = i.nextFluid();
                    FluidStack[] fluidOutputs = i.nextFluidArr();
                    ItemStack output = i.nextItem();
                    int duration = i.nextInt();
                    int eut = i.nextInt();
                    GTValues.RA.stdBuilder().itemOutputs(new ItemStack[]{output}).fluidInputs(new FluidStack[]{fluidInput}).fluidOutputs(fluidOutputs).duration(duration).eut(eut).addTo((IRecipeMap)RecipeMaps.distillationTowerRecipes);
                }
            });
        }
    }

    @ZenMethod
    public static void addUniversalRecipe(ILiquidStack[] fluidOutput, IItemStack itemOutput, ILiquidStack fluidInput, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding universal distillation recipe for " + fluidInput.getDisplayName(), new Object[]{fluidInput, fluidOutput, itemOutput, durationTicks, euPerTick}){

            @Override
            protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                FluidStack fluidInput = i.nextFluid();
                FluidStack[] fluidOutputs = i.nextFluidArr();
                ItemStack output = i.nextItem();
                int duration = i.nextInt();
                int eut = i.nextInt();
                for (int idx = 0; idx < Math.min(fluidOutputs.length, 11); ++idx) {
                    GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTUtility.getIntegratedCircuit((int)(idx + 1))}).itemOutputs(new ItemStack[]{output}).fluidInputs(new FluidStack[]{fluidInput}).fluidOutputs(new FluidStack[]{fluidOutputs[idx]}).duration(duration * 2).eut(eut / 4).addTo((IRecipeMap)RecipeMaps.distilleryRecipes);
                }
                GTValues.RA.stdBuilder().itemOutputs(new ItemStack[]{output}).fluidInputs(new FluidStack[]{fluidInput}).fluidOutputs(fluidOutputs).duration(duration).eut(eut).addTo((IRecipeMap)RecipeMaps.distillationTowerRecipes);
            }
        });
    }
}

