/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.modcustomfuels;

import com.dreammaster.main.MainRegistry;
import com.dreammaster.modcustomfuels.CustomFuels;
import com.dreammaster.modcustomfuels.CustomFuelsFactory;
import cpw.mods.fml.common.IFuelHandler;
import eu.usrv.yamcore.auxiliary.LogHelper;
import gregtech.api.util.GT_Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import net.minecraft.item.ItemStack;

public class CustomFuelsHandler
implements IFuelHandler {
    private LogHelper _mLogger = MainRegistry.Logger;
    private String _mConfigFileName;
    private CustomFuelsFactory _mCfF = new CustomFuelsFactory();
    private CustomFuels _mCustomFuels;
    private HashMap<GT_Utility.ItemId, Short> customFuelToValueMap = new HashMap();

    public CustomFuelsHandler() {
        this._mConfigFileName = String.format("config/%s/CustomFuels.xml", "GTNewHorizons");
    }

    public void registerCustomFuelValue(ItemStack fuel, short value) {
        this.customFuelToValueMap.put(GT_Utility.ItemId.createNoCopy((ItemStack)fuel), value);
    }

    public void InitSampleConfig() {
        this._mCustomFuels = new CustomFuels();
        this._mCustomFuels.getFuelItems().add(this._mCfF.createCustomFuelItem("minecraft:diamond", 102400));
    }

    public boolean SaveCustomFuels() {
        try {
            JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{CustomFuels.class});
            Marshaller jaxMarsh = tJaxbCtx.createMarshaller();
            jaxMarsh.setProperty("jaxb.formatted.output", (Object)true);
            jaxMarsh.marshal((Object)this._mCustomFuels, (OutputStream)new FileOutputStream(this._mConfigFileName, false));
            this._mLogger.debug((Object)"Config file written");
            return true;
        }
        catch (Exception e) {
            this._mLogger.error((Object)"Unable to create new CustomFuels.xml. What did you do??");
            e.printStackTrace();
            return false;
        }
    }

    public void LoadConfig() {
        this._mLogger.debug((Object)"CustomFuels entering state: LOAD CONFIG");
        File tConfigFile = new File(this._mConfigFileName);
        if (!tConfigFile.exists()) {
            this._mLogger.debug((Object)"CustomFuels Config file not found, assuming first-start. Creating default one");
            this.InitSampleConfig();
            this.SaveCustomFuels();
        }
        if (!this.ReloadCustomFuels()) {
            this._mLogger.warn((Object)"Configuration File seems to be damaged, loading does-nothing-evil default config. You should fix your file and reload it");
            MainRegistry.AddLoginError("[CustomFuels] Config file not loaded due errors");
            this.InitSampleConfig();
        }
    }

    public boolean ReloadCustomFuels() {
        boolean tResult = false;
        this._mLogger.debug((Object)"CustomFuelsHandler will now try to load it's configuration");
        try {
            JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{CustomFuels.class});
            File tConfigFile = new File(this._mConfigFileName);
            Unmarshaller jaxUnmarsh = tJaxbCtx.createUnmarshaller();
            CustomFuels tNewItemCollection = (CustomFuels)jaxUnmarsh.unmarshal(tConfigFile);
            this._mLogger.debug((Object)"Config file has been loaded. Entering Verify state");
            this._mCustomFuels = tNewItemCollection;
            tResult = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tResult;
    }

    public int getBurnTime(ItemStack pIS) {
        ItemStack stack;
        if (pIS.field_77990_d == null) {
            stack = pIS;
        } else {
            stack = pIS.func_77946_l();
            stack.field_77990_d = null;
        }
        Short fuelValue = this.customFuelToValueMap.get(GT_Utility.ItemId.createNoCopy((ItemStack)stack));
        if (fuelValue != null) {
            return fuelValue.shortValue();
        }
        try {
            boolean tReturnValue = false;
            CustomFuels.FuelItem tFI = this._mCustomFuels.FindFuelValue(pIS);
            if (tFI != null) {
                return tFI.getBurnTime();
            }
            return 0;
        }
        catch (Exception e) {
            this._mLogger.error((Object)"Something went wrong");
            e.printStackTrace();
            return 0;
        }
    }
}

