/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.gthandler.nameRemover;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.common.items.GT_IntegratedCircuit_Item;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class NameRemover
extends GT_MetaTileEntity_BasicMachine {
    public NameRemover(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "It can fix broken ores...and get rid of any disassembly data you don't want!", 2, 1, "NameRemover.png", "NameRemover", new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_DISASSEMBLER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_DISASSEMBLER), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_DISASSEMBLER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_DISASSEMBLER), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_DISASSEMBLER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_DISASSEMBLER)});
    }

    public NameRemover(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 2, 1, aGUIName, aNEIName);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new NameRemover(this.mName, this.mTier, this.mDescription, this.mTextures, this.mGUIName, this.mNEIName);
    }

    public int checkRecipe() {
        if (this.getInputAt(0) == null) {
            return 0;
        }
        ItemStack output = this.getInputAt(0).func_77946_l();
        NBTTagCompound nbt = output.func_77978_p();
        boolean removeName = false;
        boolean removeDisassembly = false;
        if (nbt != null) {
            ItemStack circuit = this.getInputAt(1);
            int circuitSetting = 0;
            if (circuit != null && circuit.func_77973_b() instanceof GT_IntegratedCircuit_Item) {
                circuitSetting = circuit.func_77960_j();
            }
            switch (circuitSetting) {
                case 1: {
                    removeName = true;
                    break;
                }
                case 2: {
                    removeDisassembly = true;
                    break;
                }
                default: {
                    removeName = true;
                    removeDisassembly = true;
                }
            }
            if (removeName && nbt.func_74764_b("display")) {
                nbt.func_74775_l("display").func_82580_o("Name");
                if (nbt.func_74775_l("display").func_82582_d()) {
                    nbt.func_82580_o("display");
                }
            }
            if (removeDisassembly && nbt.func_74764_b("GT.CraftingComponents")) {
                nbt.func_82580_o("GT.CraftingComponents");
            }
            if (nbt.func_82582_d()) {
                output.func_77982_d(null);
            }
        }
        if (this.canOutput(new ItemStack[]{output})) {
            this.getInputAt((int)0).field_77994_a = 0;
            this.mEUt = 0;
            this.mMaxProgresstime = 20;
            this.mOutputItems[0] = output;
            return 2;
        }
        return 0;
    }

    public String[] getDescription() {
        ArrayList<String> description = new ArrayList<String>();
        description.add("Removes various NBT tags.");
        description.add(" ");
        description.add(EnumChatFormatting.UNDERLINE + "First Slot" + EnumChatFormatting.RESET);
        description.add("The item you want to strip of NBT");
        description.add(" ");
        description.add(EnumChatFormatting.UNDERLINE + "Second Slot" + EnumChatFormatting.RESET);
        description.add("One of the following circuits:");
        description.add(EnumChatFormatting.BOLD + "Circuit 1:" + EnumChatFormatting.RESET + "  Attempt to fix broken ores by removing the Display Name tag");
        description.add(EnumChatFormatting.BOLD + "Circuit 2:" + EnumChatFormatting.RESET + "  Remove disassembly tags");
        description.add(" ");
        description.add(EnumChatFormatting.BOLD + "No Circuit:" + EnumChatFormatting.RESET + " Remove all of the above");
        return description.toArray(new String[0]);
    }

    public boolean isElectric() {
        return false;
    }

    public long maxEUStore() {
        return 0L;
    }

    public long getMinimumStoredEU() {
        return 0L;
    }

    public long maxAmperesIn() {
        return 0L;
    }

    public long maxAmperesOut() {
        return 0L;
    }
}

