/*
 * Decompiled with CFR 0.152.
 */
package com.detrav.utils;

import com.detrav.net.DetravProPickPacket00;
import gregtech.api.enums.Materials;
import java.util.Arrays;
import java.util.Objects;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidColors {
    public static void makeColors() {
        FluidColors.reFillFluidColors();
        Arrays.stream(Materials.values()).forEach(mat -> {
            if (mat.getSolid(0L) != null) {
                DetravProPickPacket00.fluidColors.putIfAbsent(mat.getSolid(0L).getFluidID(), mat.mRGBa);
            }
            if (mat.getGas(0L) != null) {
                DetravProPickPacket00.fluidColors.putIfAbsent(mat.getGas(0L).getFluidID(), mat.mRGBa);
            }
            if (mat.getFluid(0L) != null) {
                DetravProPickPacket00.fluidColors.putIfAbsent(mat.getFluid(0L).getFluidID(), mat.mRGBa);
            }
            if (mat.getMolten(0L) != null) {
                DetravProPickPacket00.fluidColors.putIfAbsent(mat.getMolten(0L).getFluidID(), mat.mRGBa);
            }
        });
        FluidRegistry.getRegisteredFluids().values().stream().filter(Objects::nonNull).forEach(fluid -> DetravProPickPacket00.fluidColors.putIfAbsent(fluid.getID(), FluidColors.convertColorInt(fluid.getColor())));
    }

    private static void reFillFluidColors() {
        try {
            DetravProPickPacket00.fluidColors.put(Materials.NatruralGas.mGas.getID(), new short[]{0, 255, 255});
            DetravProPickPacket00.fluidColors.put(Materials.OilLight.mFluid.getID(), new short[]{255, 255, 0});
            DetravProPickPacket00.fluidColors.put(Materials.OilMedium.mFluid.getID(), new short[]{0, 255, 0});
            DetravProPickPacket00.fluidColors.put(Materials.OilHeavy.mFluid.getID(), new short[]{255, 0, 255});
            DetravProPickPacket00.fluidColors.put(Materials.Oil.mFluid.getID(), new short[]{0, 0, 0});
            DetravProPickPacket00.fluidColors.put(Materials.Helium_3.mGas.getID(), new short[]{128, 32, 224});
            DetravProPickPacket00.fluidColors.put(Materials.SaltWater.mFluid.getID(), new short[]{128, 255, 128});
            DetravProPickPacket00.fluidColors.put(Materials.Lead.getMolten(0L).getFluid().getID(), new short[]{208, 208, 208});
            DetravProPickPacket00.fluidColors.put(Materials.Chlorobenzene.mFluid.getID(), new short[]{64, 128, 64});
            DetravProPickPacket00.fluidColors.put(FluidRegistry.getFluid((String)"liquid_extra_heavy_oil").getID(), new short[]{0, 0, 80});
            DetravProPickPacket00.fluidColors.put(Materials.Oxygen.mGas.getID(), new short[]{64, 64, 160});
            DetravProPickPacket00.fluidColors.put(Materials.Nitrogen.mGas.getID(), new short[]{0, 128, 208});
            DetravProPickPacket00.fluidColors.put(Materials.Methane.mGas.getID(), new short[]{128, 32, 32});
            DetravProPickPacket00.fluidColors.put(Materials.Ethane.mGas.getID(), new short[]{64, 128, 32});
            DetravProPickPacket00.fluidColors.put(Materials.Ethylene.mGas.getID(), new short[]{208, 208, 208});
            DetravProPickPacket00.fluidColors.put(FluidRegistry.LAVA.getID(), new short[]{255, 0, 0});
            DetravProPickPacket00.fluidColors.put(FluidRegistry.getFluid((String)"unknowwater").getID(), new short[]{138, 43, 226});
            DetravProPickPacket00.fluidColors.put(Materials.Hydrogen.mGas.getID(), new short[]{50, 50, 214});
            DetravProPickPacket00.fluidColors.put(Materials.SulfuricAcid.mFluid.getID(), new short[]{255, 185, 15});
            DetravProPickPacket00.fluidColors.put(Materials.HydricSulfide.mFluid.getID(), new short[]{255, 143, 67});
            DetravProPickPacket00.fluidColors.put(Materials.CarbonMonoxide.mGas.getID(), new short[]{16, 78, 139});
            DetravProPickPacket00.fluidColors.put(Materials.CarbonDioxide.mGas.getID(), new short[]{105, 105, 105});
            DetravProPickPacket00.fluidColors.put(FluidRegistry.getFluid((String)"ic2distilledwater").getID(), new short[]{30, 144, 255});
            DetravProPickPacket00.fluidColors.put(Materials.Deuterium.mGas.getID(), new short[]{255, 227, 159});
            DetravProPickPacket00.fluidColors.put(Materials.Iron.getMolten(0L).getFluid().getID(), new short[]{139, 136, 120});
            DetravProPickPacket00.fluidColors.put(Materials.Tin.getMolten(0L).getFluid().getID(), new short[]{231, 231, 228});
            DetravProPickPacket00.fluidColors.put(Materials.Copper.getMolten(0L).getFluid().getID(), new short[]{255, 127, 36});
            DetravProPickPacket00.fluidColors.put(FluidRegistry.getFluid((String)"fluorine").getID(), new short[]{153, 193, 173});
            DetravProPickPacket00.fluidColors.put(FluidRegistry.getFluid((String)"hydrofluoricacid").getID(), new short[]{0, 206, 209});
            DetravProPickPacket00.fluidColors.put(Materials.PhosphoricAcid.mFluid.getID(), new short[]{238, 118, 0});
            DetravProPickPacket00.fluidColors.put(Materials.LiquidAir.mFluid.getID(), new short[]{153, 153, 234});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static short[] convertColorInt(int color) {
        return new short[]{(short)(color << 16 & 0xFF), (short)(color << 8 & 0xFF), (short)(color & 0xFF)};
    }
}

