/*
 * Decompiled with CFR 0.152.
 */
package com.detrav.net;

import com.detrav.DetravScannerMod;
import com.detrav.gui.DetravGuiProPick;
import com.detrav.gui.textures.DetravMapTexture;
import com.detrav.net.DetravPacket;
import com.detrav.utils.GTppHelper;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.util.GT_LanguageManager;
import gtPlusPlus.core.material.Material;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class DetravProPickPacket00
extends DetravPacket {
    public int chunkX;
    public int chunkZ;
    public int size;
    public int ptype;
    private HashMap<Byte, Short>[][] map = null;
    public static HashMap<Integer, short[]> fluidColors = new HashMap();
    public int level = -1;
    private HashMap<String, Integer> ores = null;

    @Override
    public int getPacketID() {
        return 0;
    }

    @Override
    public byte[] encode() {
        ByteArrayDataOutput tOut = ByteStreams.newDataOutput((int)1);
        tOut.writeInt(this.ptype);
        tOut.writeInt(this.level);
        tOut.writeInt(this.chunkX);
        tOut.writeInt(this.chunkZ);
        tOut.writeInt(this.size);
        int aSize = (this.size * 2 + 1) * 16;
        int checkOut = 0;
        for (int i = 0; i < aSize; ++i) {
            for (int j = 0; j < aSize; ++j) {
                if (this.map[i][j] == null) {
                    tOut.writeByte(0);
                    continue;
                }
                tOut.writeByte(this.map[i][j].keySet().size());
                for (byte key : this.map[i][j].keySet()) {
                    tOut.writeByte((int)key);
                    tOut.writeShort((int)this.map[i][j].get(key).shortValue());
                    ++checkOut;
                }
            }
        }
        tOut.writeInt(checkOut);
        return tOut.toByteArray();
    }

    @Override
    public Object decode(ByteArrayDataInput aData) {
        DetravProPickPacket00 packet = new DetravProPickPacket00();
        packet.ptype = aData.readInt();
        packet.level = aData.readInt();
        packet.chunkX = aData.readInt();
        packet.chunkZ = aData.readInt();
        packet.size = aData.readInt();
        packet.map = new HashMap[(packet.size * 2 + 1) * 16][(packet.size * 2 + 1) * 16];
        int aSize = (packet.size * 2 + 1) * 16;
        int checkOut = 0;
        for (int i = 0; i < aSize; ++i) {
            for (int j = 0; j < aSize; ++j) {
                int kSize = aData.readByte();
                if (kSize == 0) continue;
                packet.map[i][j] = new HashMap();
                for (int k = 0; k < kSize; ++k) {
                    packet.map[i][j].put(aData.readByte(), aData.readShort());
                    ++checkOut;
                }
            }
        }
        int checkOut2 = aData.readInt();
        if (checkOut != checkOut2) {
            return new DetravProPickPacket00();
        }
        return packet;
    }

    @Override
    public void process() {
        DetravGuiProPick.newMap(new DetravMapTexture(this));
        DetravScannerMod.proxy.openProPickGui();
    }

    public void addBlock(int x, int y, int z, short metaData) {
        int aZ;
        int aX;
        if (this.map == null) {
            this.map = new HashMap[(this.size * 2 + 1) * 16][(this.size * 2 + 1) * 16];
        }
        if (this.map[aX = x - (this.chunkX - this.size) * 16][aZ = z - (this.chunkZ - this.size) * 16] == null) {
            this.map[aX][aZ] = new HashMap();
        }
        this.map[aX][aZ].put((byte)y, metaData);
    }

    public BufferedImage getImage(int posX, int posZ) {
        int wh = (this.size * 2 + 1) * 16;
        BufferedImage image = new BufferedImage(wh, wh, 2);
        WritableRaster raster = image.getRaster();
        int playerI = posX - (this.chunkX - this.size) * 16 - 1;
        int playerJ = posZ - (this.chunkZ - this.size) * 16 - 1;
        if (this.ores == null) {
            this.ores = new HashMap();
        }
        int exception = 0;
        switch (this.ptype) {
            case 0: 
            case 1: {
                for (int i = 0; i < wh; ++i) {
                    for (int j = 0; j < wh; ++j) {
                        if (this.map[i][j] == null) {
                            raster.setSample(i, j, 0, 255);
                            raster.setSample(i, j, 1, 255);
                            raster.setSample(i, j, 2, 255);
                            raster.setSample(i, j, 3, 255);
                        } else {
                            for (short meta : this.map[i][j].values()) {
                                String name;
                                short[] rgba;
                                Materials tMaterial = null;
                                Material pMaterial = null;
                                try {
                                    if (meta < 7000 || meta > 7500) {
                                        tMaterial = GregTech_API.sGeneratedMaterials[meta % 1000];
                                    } else {
                                        Short l = (short)(meta - 7000);
                                        pMaterial = GTppHelper.decodeoresGTpp.get(l);
                                    }
                                }
                                catch (Exception e) {
                                    tMaterial = null;
                                }
                                if (meta > 0 && meta < 7000 || meta > 7500) {
                                    if (tMaterial == null) {
                                        ++exception;
                                        continue;
                                    }
                                    rgba = tMaterial.getRGBA();
                                    name = DetravProPickPacket00.getLocalizedNameForItem(tMaterial.mDefaultLocalName, GT_LanguageManager.getTranslation((String)("gt.blockores." + meta + ".name")));
                                    raster.setSample(i, j, 0, rgba[0]);
                                    raster.setSample(i, j, 1, rgba[1]);
                                    raster.setSample(i, j, 2, rgba[2]);
                                    raster.setSample(i, j, 3, 255);
                                    if (this.ores.containsKey(name)) continue;
                                    this.ores.put(name, ((rgba[0] & 0xFF) << 16) + ((rgba[1] & 0xFF) << 8) + (rgba[2] & 0xFF));
                                    continue;
                                }
                                if (meta <= 0) {
                                    name = GT_LanguageManager.getTranslation((String)("bw.blockores.01." + meta * -1 + ".name"));
                                    rgba = new short[]{0, 0, 0, 0};
                                    try {
                                        rgba = ((Werkstoff)Werkstoff.werkstoffHashMap.get((short)(meta * -1))).getRGBA();
                                    }
                                    catch (Exception exception2) {
                                        // empty catch block
                                    }
                                    raster.setSample(i, j, 0, rgba[0]);
                                    raster.setSample(i, j, 1, rgba[1]);
                                    raster.setSample(i, j, 2, rgba[2]);
                                    raster.setSample(i, j, 3, 255);
                                    if (this.ores.containsKey(name)) continue;
                                    this.ores.put(name, ((rgba[0] & 0xFF) << 16) + ((rgba[1] & 0xFF) << 8) + (rgba[2] & 0xFF));
                                    continue;
                                }
                                if (pMaterial == null) {
                                    ++exception;
                                    continue;
                                }
                                rgba = pMaterial.getRGBA();
                                name = pMaterial.getLocalizedName() + " Ore";
                                raster.setSample(i, j, 0, rgba[0]);
                                raster.setSample(i, j, 1, rgba[1]);
                                raster.setSample(i, j, 2, rgba[2]);
                                raster.setSample(i, j, 3, 255);
                                if (this.ores.containsKey(name)) continue;
                                this.ores.put(name, ((rgba[0] & 0xFF) << 16) + ((rgba[1] & 0xFF) << 8) + (rgba[2] & 0xFF));
                            }
                        }
                        if (playerI == i || playerJ == j) {
                            raster.setSample(i, j, 0, (raster.getSample(i, j, 0) + 255) / 2);
                            raster.setSample(i, j, 1, raster.getSample(i, j, 1) / 2);
                            raster.setSample(i, j, 2, raster.getSample(i, j, 2) / 2);
                        }
                        if (i % 16 != 0 && j % 16 != 0) continue;
                        raster.setSample(i, j, 0, raster.getSample(i, j, 0) / 2);
                        raster.setSample(i, j, 1, raster.getSample(i, j, 1) / 2);
                        raster.setSample(i, j, 2, raster.getSample(i, j, 2) / 2);
                    }
                }
                break;
            }
            case 2: {
                short[] metas = new short[2];
                for (int i = 0; i < wh; ++i) {
                    for (int j = 0; j < wh; ++j) {
                        if (this.map[i][j] == null) {
                            raster.setSample(i, j, 0, 255);
                            raster.setSample(i, j, 1, 255);
                            raster.setSample(i, j, 2, 255);
                            raster.setSample(i, j, 3, 255);
                        } else {
                            int l;
                            int k;
                            metas[0] = this.map[i][j].get((byte)1);
                            metas[1] = this.map[i][j].get((byte)2);
                            String name = null;
                            short[] rgba = null;
                            rgba = fluidColors.get(metas[0]);
                            if (rgba == null) {
                                DetravScannerMod.proxy.sendPlayerExeption("Unknown fluid ID = " + metas[0] + " Please add to DetravProPickPacket00.java!");
                                rgba = new short[]{0, 255, 0};
                            }
                            if ((name = FluidRegistry.getFluid((int)metas[0]).getLocalizedName(new FluidStack(FluidRegistry.getFluid((int)metas[0]), 0))) == null) {
                                name = "Unknown Fluid name!";
                            }
                            if (!this.ores.containsKey(name)) {
                                this.ores.put(name, ((rgba[0] & 0xFF) << 16) + ((rgba[1] & 0xFF) << 8) + (rgba[2] & 0xFF));
                            }
                            if (((k = i % 16) + (l = j % 16) * 16) * 3 < metas[1] + 48) {
                                raster.setSample(i, j, 0, rgba[0]);
                                raster.setSample(i, j, 1, rgba[1]);
                                raster.setSample(i, j, 2, rgba[2]);
                                raster.setSample(i, j, 3, 255);
                            } else {
                                raster.setSample(i, j, 0, 255);
                                raster.setSample(i, j, 1, 255);
                                raster.setSample(i, j, 2, 255);
                                raster.setSample(i, j, 3, 255);
                            }
                        }
                        if (playerI == i || playerJ == j) {
                            raster.setSample(i, j, 0, (raster.getSample(i, j, 0) + 255) / 2);
                            raster.setSample(i, j, 1, raster.getSample(i, j, 1) / 2);
                            raster.setSample(i, j, 2, raster.getSample(i, j, 2) / 2);
                        }
                        if (i % 16 != 0 && j % 16 != 0) continue;
                        raster.setSample(i, j, 0, raster.getSample(i, j, 0) / 2);
                        raster.setSample(i, j, 1, raster.getSample(i, j, 1) / 2);
                        raster.setSample(i, j, 2, raster.getSample(i, j, 2) / 2);
                    }
                }
                break;
            }
            case 3: {
                this.ores.put("Pollution", 0);
                for (int i = 0; i < wh; ++i) {
                    for (int j = 0; j < wh; ++j) {
                        if (this.map[i][j] == null) {
                            raster.setSample(i, j, 0, 255);
                            raster.setSample(i, j, 1, 255);
                            raster.setSample(i, j, 2, 255);
                            raster.setSample(i, j, 3, 255);
                        } else {
                            for (short meta : this.map[i][j].values()) {
                                raster.setSample(i, j, 0, meta);
                                raster.setSample(i, j, 1, meta);
                                raster.setSample(i, j, 2, meta);
                                raster.setSample(i, j, 3, 255);
                            }
                        }
                        if (playerI == i || playerJ == j) {
                            raster.setSample(i, j, 0, (raster.getSample(i, j, 0) + 255) / 2);
                            raster.setSample(i, j, 1, raster.getSample(i, j, 1) / 2);
                            raster.setSample(i, j, 2, raster.getSample(i, j, 2) / 2);
                        }
                        if (i % 16 != 0 && j % 16 != 0) continue;
                        raster.setSample(i, j, 0, raster.getSample(i, j, 0) / 2);
                        raster.setSample(i, j, 1, raster.getSample(i, j, 1) / 2);
                        raster.setSample(i, j, 2, raster.getSample(i, j, 2) / 2);
                    }
                }
                break;
            }
            default: {
                DetravScannerMod.proxy.sendPlayerExeption("Not been realized YET!");
            }
        }
        if (exception > 0) {
            DetravScannerMod.proxy.sendPlayerExeption("null matertial exception: " + exception);
        }
        return image;
    }

    public HashMap<String, Integer> getOres() {
        if (this.ores == null) {
            return new HashMap<String, Integer>();
        }
        return this.ores;
    }

    private static String getLocalizedNameForItem(String mDefaultLocalName, String aFormat) {
        return String.format(aFormat.replace("%s", "%temp").replace("%material", "%s"), mDefaultLocalName).replace("%temp", "%s");
    }

    public int getSize() {
        return (this.size * 2 + 1) * 16;
    }
}

