/*
 * Decompiled with CFR 0.152.
 */
package com.detrav.net;

import com.detrav.net.DetravPacket;
import com.detrav.net.DetravProPickPacket00;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;

@ChannelHandler.Sharable
public class DetravNetwork
extends MessageToMessageCodec<FMLProxyPacket, DetravPacket> {
    public static DetravNetwork INSTANCE;
    private final EnumMap<Side, FMLEmbeddedChannel> mChannel;
    private DetravPacket[] mSubChannels;

    public DetravNetwork() {
        INSTANCE = this;
        this.mChannel = NetworkRegistry.INSTANCE.newChannel("DetravScanner", new ChannelHandler[]{this, new HandlerShared()});
        this.mSubChannels = new DetravPacket[]{new DetravProPickPacket00()};
    }

    protected void encode(ChannelHandlerContext ctx, DetravPacket msg, List<Object> out) throws Exception {
        out.add(new FMLProxyPacket(Unpooled.buffer().writeByte(msg.getPacketID()).writeBytes(msg.encode()).copy(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get()));
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        ByteArrayDataInput aData = ByteStreams.newDataInput((byte[])msg.payload().array());
        out.add(this.mSubChannels[aData.readByte()].decode(aData));
    }

    public void sendToPlayer(DetravPacket aPacket, EntityPlayerMP aPlayer) {
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)aPlayer);
        this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
    }

    public void sendToServer(DetravPacket aPacket) {
        this.mChannel.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.mChannel.get(Side.CLIENT).writeAndFlush((Object)aPacket);
    }

    @ChannelHandler.Sharable
    static final class HandlerShared
    extends SimpleChannelInboundHandler<DetravPacket> {
        HandlerShared() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, DetravPacket aPacket) throws Exception {
            aPacket.process();
        }
    }
}

