/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GT_Values;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.material.MaterialStack;
import gtPlusPlus.core.material.state.MaterialState;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGen_Base;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeGen_MaterialProcessing
extends RecipeGen_Base {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGen_MaterialProcessing(Material M) {
        this(M, false);
    }

    public RecipeGen_MaterialProcessing(Material M, boolean O) {
        this.toGenerate = M;
        this.disableOptional = O;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate, this.disableOptional);
    }

    /*
     * WARNING - void declaration
     */
    private void generateRecipes(Material material, boolean disableOptional) {
        block36: {
            if (disableOptional) {
                return;
            }
            if (material.getMaterialComposites().length > 1) {
                int[] mChances;
                ItemStack[] mInternalOutputs;
                Logger.MATERIALS("[Recipe Generator Debug] [" + material.getLocalizedName() + "]");
                int tVoltageMultiplier = material.vVoltageMultiplier;
                int[] partSizes = new int[99];
                if (material.vSmallestRatio != null) {
                    partSizes = new int[material.vSmallestRatio.length];
                    for (int hu = 0; hu < material.vSmallestRatio.length; ++hu) {
                        partSizes[hu] = (int)material.vSmallestRatio[hu];
                    }
                }
                AutoMap<Pair<Integer, Material>> componentMap = new AutoMap<Pair<Integer, Material>>();
                int alnsnfds = 0;
                for (MaterialStack r : material.getComposites()) {
                    if (r != null) {
                        componentMap.put(new Pair<Integer, Material>(partSizes[alnsnfds], r.getStackMaterial()));
                    }
                    ++alnsnfds;
                }
                if (componentMap.size() > 0 && componentMap.size() <= 6) {
                    ItemStack itemStack;
                    mInternalOutputs = new ItemStack[6];
                    mChances = new int[6];
                    int mCellCount = 0;
                    int mTotalCount = 0;
                    int mCounter = 0;
                    for (Pair pair : componentMap) {
                        if (((Material)pair.getValue()).getState() != MaterialState.SOLID) {
                            Logger.MATERIALS("[Centrifuge] Found Fluid Component, adding " + pair.getKey() + " cells of " + ((Material)pair.getValue()).getLocalizedName() + ".");
                            mInternalOutputs[mCounter++] = ((Material)pair.getValue()).getCell((Integer)pair.getKey());
                            mTotalCount += ((Integer)pair.getKey()).intValue();
                            Logger.MATERIALS("[Centrifuge] In total, adding " + (mCellCount += ((Integer)pair.getKey()).intValue()) + " cells for " + material.getLocalizedName() + " processing.");
                            continue;
                        }
                        Logger.MATERIALS("[Centrifuge] Found Solid Component, adding " + pair.getKey() + " dusts of " + ((Material)pair.getValue()).getLocalizedName() + ".");
                        mInternalOutputs[mCounter++] = ((Material)pair.getValue()).getDust((Integer)pair.getKey());
                        mTotalCount += ((Integer)pair.getKey()).intValue();
                    }
                    for (int g = 0; g < mInternalOutputs.length; ++g) {
                        Logger.MATERIALS("[Centrifuge] Is output[" + g + "] valid with a chance? " + (mInternalOutputs[g] != null ? 10000 : 0));
                        mChances[g] = mInternalOutputs[g] != null ? 10000 : 0;
                    }
                    ItemStack emptyCell = null;
                    if (mCellCount > 0) {
                        emptyCell = ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", mCellCount);
                        Logger.MATERIALS("[Centrifuge] Recipe now requires " + mCellCount + " empty cells as input.");
                    }
                    if ((itemStack = material.getDust(material.smallestStackSizeWhenProcessing)) != null) {
                        Logger.MATERIALS("[Centrifuge] Recipe now requires " + material.smallestStackSizeWhenProcessing + "x " + itemStack.func_82833_r() + " as input.");
                    } else {
                        ItemStack itemStack2 = material.getDust(mTotalCount);
                        Logger.MATERIALS("[Centrifuge] Could not find valid input dust, trying alternative.");
                        if (itemStack2 != null) {
                            Logger.MATERIALS("[Centrifuge] Recipe now requires " + mTotalCount + "x " + itemStack2.func_82833_r() + " as input.");
                        } else {
                            Logger.MATERIALS("[Centrifuge] Could not find valid input dust, exiting.");
                        }
                    }
                    for (int j = 0; j < mInternalOutputs.length; ++j) {
                        if (mInternalOutputs[j] == null) {
                            mInternalOutputs[j] = GT_Values.NI;
                            Logger.MATERIALS("[Centrifuge] Set slot " + j + "  to null.");
                            continue;
                        }
                        Logger.MATERIALS("[Centrifuge] Set slot " + j + " to " + mInternalOutputs[j].func_82833_r() + ".");
                    }
                    try {
                        void var13_25;
                        if (RecipeGen_MaterialProcessing.addCentrifgeRecipe((ItemStack)var13_25, emptyCell, null, null, mInternalOutputs[0], mInternalOutputs[1], mInternalOutputs[2], mInternalOutputs[3], mInternalOutputs[4], mInternalOutputs[5], mChances, 20 * (tVoltageMultiplier / 10), tVoltageMultiplier)) {
                            Logger.MATERIALS("[Centrifuge] Generated Centrifuge recipe for " + material.getDust(1).func_82833_r());
                            break block36;
                        }
                        Logger.MATERIALS("[Centrifuge] Failed to generate Centrifuge recipe for " + material.getDust(1).func_82833_r());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                } else if (componentMap.size() > 6 && componentMap.size() <= 9) {
                    ItemStack itemStack;
                    Logger.MATERIALS("[Issue][Electrolyzer] " + material.getLocalizedName() + " is composed of over 6 materials, so an electrolyzer recipe for processing cannot be generated. Trying to create one for the Dehydrator instead.");
                    mInternalOutputs = new ItemStack[9];
                    mChances = new int[9];
                    int mCellCount = 0;
                    int mTotalCount = 0;
                    int mCounter = 0;
                    for (Pair pair : componentMap) {
                        if (((Material)pair.getValue()).getState() != MaterialState.SOLID) {
                            Logger.MATERIALS("[Dehydrator] Found Fluid Component, adding " + pair.getKey() + " cells of " + ((Material)pair.getValue()).getLocalizedName() + ".");
                            mInternalOutputs[mCounter++] = ((Material)pair.getValue()).getCell((Integer)pair.getKey());
                            mTotalCount += ((Integer)pair.getKey()).intValue();
                            Logger.MATERIALS("[Dehydrator] In total, adding " + (mCellCount += ((Integer)pair.getKey()).intValue()) + " cells for " + material.getLocalizedName() + " processing.");
                            continue;
                        }
                        Logger.MATERIALS("[Dehydrator] Found Solid Component, adding " + pair.getKey() + " dusts of " + ((Material)pair.getValue()).getLocalizedName() + ".");
                        mInternalOutputs[mCounter++] = ((Material)pair.getValue()).getDust((Integer)pair.getKey());
                        mTotalCount += ((Integer)pair.getKey()).intValue();
                    }
                    for (int g = 0; g < mInternalOutputs.length; ++g) {
                        Logger.MATERIALS("[Dehydrator] Is output[" + g + "] valid with a chance? " + (mInternalOutputs[g] != null ? 10000 : 0));
                        mChances[g] = mInternalOutputs[g] != null ? 10000 : 0;
                    }
                    ItemStack emptyCell = null;
                    if (mCellCount > 0) {
                        emptyCell = CI.emptyCells(mCellCount);
                        Logger.MATERIALS("[Dehydrator] Recipe now requires " + mCellCount + " empty cells as input.");
                    }
                    if ((itemStack = material.getDust(material.smallestStackSizeWhenProcessing)) != null) {
                        Logger.MATERIALS("[Dehydrator] Recipe now requires " + material.smallestStackSizeWhenProcessing + "x " + itemStack.func_82833_r() + " as input.");
                    } else {
                        ItemStack itemStack3 = material.getDust(mTotalCount);
                        Logger.MATERIALS("[Dehydrator] Could not find valid input dust, trying alternative.");
                        if (itemStack3 != null) {
                            Logger.MATERIALS("[Dehydrator] Recipe now requires " + mTotalCount + "x " + itemStack3.func_82833_r() + " as input.");
                        } else {
                            Logger.MATERIALS("[Dehydrator] Could not find valid input dust, exiting.");
                        }
                    }
                    for (int j = 0; j < mInternalOutputs.length; ++j) {
                        if (mInternalOutputs[j] == null) {
                            mInternalOutputs[j] = GT_Values.NI;
                            Logger.MATERIALS("[Dehydrator] Set slot " + j + "  to null.");
                            continue;
                        }
                        Logger.MATERIALS("[Dehydrator] Set slot " + j + " to " + mInternalOutputs[j].func_82833_r() + ".");
                    }
                    try {
                        void var13_29;
                        if (CORE.RA.addDehydratorRecipe(new ItemStack[]{var13_29, emptyCell}, null, null, mInternalOutputs, mChances, 20 * (tVoltageMultiplier / 10), tVoltageMultiplier)) {
                            Logger.MATERIALS("[Dehydrator] Generated Dehydrator recipe for " + material.getDust(1).func_82833_r());
                        } else {
                            Logger.MATERIALS("[Dehydrator] Failed to generate Dehydrator recipe for " + material.getDust(1).func_82833_r());
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }

    public static boolean addCentrifgeRecipe(ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, ItemStack aOutput5, ItemStack aOutput6, int[] aChances, int aDuration, int aEUt) {
        return GT_Values.RA.addCentrifugeRecipe(aInput1, aInput2, aFluidInput, aFluidOutput, aOutput1, aOutput2, aOutput3, aOutput4, aOutput5, aOutput6, aChances, aDuration, aEUt);
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.put(mRecipeGenMap);
    }
}

