/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.mega;

import com.github.bartimaeusnek.bartworks.API.BorosilicateGlass;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_ExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class GregTechMetaTileEntity_MegaAlloyBlastSmelter
extends GT_MetaTileEntity_ExtendedPowerMultiBlockBase<GregTechMetaTileEntity_MegaAlloyBlastSmelter>
implements ISurvivalConstructable {
    private static final int MAX_PARALLELS = 256;
    private HeatingCoilLevel coilLevel;
    private byte glassTier = (byte)-1;
    private boolean hasNormalCoils;
    private static final IStructureDefinition<GregTechMetaTileEntity_MegaAlloyBlastSmelter> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", (String[][])new String[][]{{"           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "   DDDDD   ", "   CCCCC   ", "   AEEEA   ", "   AE~EA   ", "   AEEEA   ", "   CCCCC   ", "   ZZZZZ   "}, {"   DDDDD   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   DDDDD   ", "  D     D  ", "  C     C  ", "  A     A  ", "  A     A  ", "  A     A  ", "  C     C  ", "  ZZZZZZZ  "}, {"  DDDDDDD  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  DBBBBBD  ", " D BBBBB D ", " C BBBBB C ", " A BBBBB A ", " A BBBBB A ", " A BBBBB A ", " C BBBBB C ", " ZZZZZZZZZ "}, {" DDDDDDDDD ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " DB     BD ", "D B     B D", "C B     B C", "A B     B A", "A B     B A", "A B     B A", "C B     B C", "ZZZZZZZZZZZ"}, {" DDDDDDDDD ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " DB     BD ", "D B     B D", "C B     B C", "A B     B A", "A B     B A", "A B     B A", "C B     B C", "ZZZZZZZZZZZ"}, {" DDDDFDDDD ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " DB     BD ", "D B     B D", "C B     B C", "A B     B A", "A B     B A", "A B     B A", "C B     B C", "ZZZZZZZZZZZ"}, {" DDDDDDDDD ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " DB     BD ", "D B     B D", "C B     B C", "A B     B A", "A B     B A", "A B     B A", "C B     B C", "ZZZZZZZZZZZ"}, {" DDDDDDDDD ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " DB     BD ", "D B     B D", "C B     B C", "A B     B A", "A B     B A", "A B     B A", "C B     B C", "ZZZZZZZZZZZ"}, {"  DDDDDDD  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  DBBBBBD  ", " D BBBBB D ", " C BBBBB C ", " A BBBBB A ", " A BBBBB A ", " A BBBBB A ", " C BBBBB C ", " ZZZZZZZZZ "}, {"   DDDDD   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   DDDDD   ", "  D     D  ", "  C     C  ", "  A     A  ", "  A     A  ", "  A     A  ", "  C     C  ", "  ZZZZZZZ  "}, {"           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "   DDDDD   ", "   CCCCC   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   CCCCC   ", "   ZZZZZ   "}}).addElement('B', StructureUtility.withChannel((String)"coil", (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(te -> {
        te.hasNormalCoils = false;
    }, (IStructureElement)GT_StructureUtility.ofCoil(GregTechMetaTileEntity_MegaAlloyBlastSmelter::setCoilLevel, GregTechMetaTileEntity_MegaAlloyBlastSmelter::getCoilLevel)), StructureUtility.onElementPass(te -> {
        te.hasNormalCoils = true;
    }, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)14))}))).addElement('Z', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregTechMetaTileEntity_MegaAlloyBlastSmelter.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Energy, GT_HatchElement.ExoticEnergy}).casingIndex(TAE.GTPP_INDEX(15)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)15)})).addElement('E', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregTechMetaTileEntity_MegaAlloyBlastSmelter.class).atLeast(new IHatchElement[]{GT_HatchElement.Maintenance}).casingIndex(TAE.GTPP_INDEX(15)).dot(2).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)15)})).addElement('D', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)15)).addElement('C', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)14)).addElement('A', StructureUtility.withChannel((String)"glass", (IStructureElement)BorosilicateGlass.ofBoroGlass((byte)-1, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier))).addElement('F', GT_HatchElement.Muffler.newAny(TAE.GTPP_INDEX(15), 3)).build();

    public GregTechMetaTileEntity_MegaAlloyBlastSmelter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregTechMetaTileEntity_MegaAlloyBlastSmelter(String aName) {
        super(aName);
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GT_Recipe recipe) {
                if (GregTechMetaTileEntity_MegaAlloyBlastSmelter.this.glassTier < GT_Utility.getTier((long)recipe.mEUt)) {
                    return CheckRecipeResultRegistry.insufficientMachineTier((int)GT_Utility.getTier((long)recipe.mEUt));
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @NotNull
            protected GT_OverclockCalculator createOverclockCalculator(@NotNull GT_Recipe recipe) {
                return super.createOverclockCalculator(recipe).setSpeedBoost((float)(1.0 - GregTechMetaTileEntity_MegaAlloyBlastSmelter.this.getCoilDiscount(GregTechMetaTileEntity_MegaAlloyBlastSmelter.this.coilLevel)));
            }
        }.setMaxParallel(256);
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(this.getMaxInputEu());
        logic.setAvailableAmperage(1L);
    }

    public boolean addOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        boolean exotic = this.addExoticEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
        return super.addToMachineList(aTileEntity, aBaseCasingIndex) || exotic;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.glassTier = (byte)-1;
        this.coilLevel = HeatingCoilLevel.None;
        if (!this.checkPiece("main", 5, 16, 0)) {
            return false;
        }
        if (this.hasNormalCoils) {
            this.coilLevel = HeatingCoilLevel.None;
        }
        if (this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        if (this.mMufflerHatches.size() != 1) {
            return false;
        }
        if (this.glassTier < 10 && !this.getExoticAndNormalEnergyHatchList().isEmpty()) {
            for (GT_MetaTileEntity_Hatch hatchEnergy : this.getExoticAndNormalEnergyHatchList()) {
                if (this.glassTier >= hatchEnergy.mTier) continue;
                return false;
            }
        }
        if (this.glassTier < 8) {
            for (GT_MetaTileEntity_Hatch hatchEnergy : this.getExoticEnergyHatches()) {
                if (hatchEnergy.getConnectionType() != GT_MetaTileEntity_Hatch.ConnectionType.LASER) continue;
                return false;
            }
        }
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public double getCoilDiscount(HeatingCoilLevel lvl) {
        double unRounded = (double)(lvl != null ? lvl.getTier() : (byte)0) / 130.0;
        if (unRounded < 0.0) {
            return 1.0;
        }
        double rounded = Math.floor(unRounded * 1000.0) / 1000.0;
        return Math.max(0.0, rounded);
    }

    public void explodeMultiblock() {
        super.explodeMultiblock();
    }

    public List<GT_MetaTileEntity_Hatch> getExoticAndNormalEnergyHatchList() {
        ArrayList<GT_MetaTileEntity_Hatch> tHatches = new ArrayList<GT_MetaTileEntity_Hatch>();
        tHatches.addAll(this.mExoticEnergyHatches);
        tHatches.addAll(this.mEnergyHatches);
        return tHatches;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("main", stackSize, hintsOnly, 5, 16, 0);
    }

    public IStructureDefinition<GregTechMetaTileEntity_MegaAlloyBlastSmelter> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Fluid Alloy Cooker").addInfo("Controller block for the Mega Alloy Blast Smelter").addInfo("Runs the same recipes as the normal ABS, except with up to " + EnumChatFormatting.BOLD + EnumChatFormatting.UNDERLINE + 256 + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " parallels.").addInfo("Every coil tier above cupronickel grants a speed bonus, based on this function:").addInfo("Bonus = TIER / 150, rounded to the nearest thousandth.").addInfo(EnumChatFormatting.ITALIC + "Can also use normal ABS coils in their place instead, if you don't like the bonuses :)" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY).addInfo("The glass limits the tier of the energy hatch. UEV glass unlocks all tiers.").addInfo("UV glass required for TecTech laser hatches.").addInfo(EnumChatFormatting.ITALIC + "\"all it does is make metals hot\"" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY).beginStructureBlock(11, 20, 11, false).addStructureInfo("This structure is too complex! See schematic for details.").addMaintenanceHatch("Around the controller", new int[]{2}).addOtherStructurePart("Input Bus, Output Bus, Input Hatch, Output Bus, Energy Hatch", "Bottom Casing", new int[]{1}).addMufflerHatch("1 in the center of the top layer", new int[]{3}).toolTipFinisher(EnumChatFormatting.AQUA + "MadMan310 " + EnumChatFormatting.GRAY + "via " + EnumChatFormatting.RED + "GT++");
        return tt;
    }

    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        int paras = this.getBaseMetaTileEntity().isActive() ? this.processingLogic.getCurrentParallels() : 0;
        int discountP = (int)(this.getCoilDiscount(this.coilLevel) * 1000.0) / 10;
        for (GT_MetaTileEntity_Hatch tHatch : this.mExoticEnergyHatches) {
            if (!GregTechMetaTileEntity_MegaAlloyBlastSmelter.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{"------------ Critical Information ------------", StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)this.mProgresstime) + EnumChatFormatting.RESET + "t / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)this.mMaxProgresstime) + EnumChatFormatting.RESET + "t", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)(-this.lEUt)) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)this.getAverageInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*" + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)this.getMaxInputAmps()) + EnumChatFormatting.RESET + "A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier((long)this.getAverageInputVoltage())] + EnumChatFormatting.RESET, "Parallels: " + EnumChatFormatting.BLUE + paras + EnumChatFormatting.RESET, "Coil Discount: " + EnumChatFormatting.BLUE + discountP + "%" + EnumChatFormatting.RESET, "-----------------------------------------"};
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregTechMetaTileEntity_MegaAlloyBlastSmelter(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(15)), TextureFactory.builder().addIcon(new IIconContainer[]{TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active}).extFacing().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(15)), TextureFactory.builder().addIcon(new IIconContainer[]{TexturesGtBlock.Overlay_Machine_Controller_Advanced}).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(15))};
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GTPP_Recipe.GTPP_Recipe_Map.sAlloyBlastSmelterRecipes;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.coilLevel;
    }

    public void setCoilLevel(HeatingCoilLevel coilLevel) {
        this.coilLevel = coilLevel;
    }

    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
        } else {
            this.inputSeparation = !this.inputSeparation;
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.inputSeparation));
        }
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 102400;
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece("main", stackSize, 5, 16, 0, elementBudget, env, false, true);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.glassTier = aNBT.func_74771_c("glassTier");
        if (!aNBT.func_74764_b("inputSeparation")) {
            this.inputSeparation = aNBT.func_74767_n("separateBusses");
        }
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("glassTier", this.glassTier);
        super.saveNBTData(aNBT);
    }

    public boolean supportsInputSeparation() {
        return true;
    }
}

