/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.generators;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.energy.IEnergyStorage;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.power.IPowerContainer;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.storage.GregtechMetaEnergyBuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_RfConvertor
extends GregtechMetaEnergyBuffer
implements IEnergyReceiver {
    public GT_MetaTileEntity_RfConvertor(String aName, int aTier, String aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aDescription, aTextures, aSlotCount);
    }

    public GT_MetaTileEntity_RfConvertor(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aDescription, aSlotCount);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Use Screwdriver to change voltage", "Hold Shift while using Screwdriver to change amperage", EnumChatFormatting.DARK_AQUA + "Variable Output Voltage", CORE.GT_Tooltip.get()};
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[12][17][];
        GT_RenderedTexture aTex = new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_ZirconiumCarbide);
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            rTextures[0][i + 1] = new ITexture[]{aTex, Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
            rTextures[1][i + 1] = new ITexture[]{aTex, Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
            rTextures[2][i + 1] = new ITexture[]{aTex, Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
            rTextures[3][i + 1] = new ITexture[]{aTex, Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
            rTextures[4][i + 1] = new ITexture[]{aTex, Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
            rTextures[5][i + 1] = new ITexture[]{aTex, Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
            rTextures[6][i + 1] = new ITexture[]{aTex, Textures.BlockIcons.OVERLAYS_ENERGY_IN[this.mTier]};
            rTextures[7][i + 1] = new ITexture[]{aTex, Textures.BlockIcons.OVERLAYS_ENERGY_IN[this.mTier]};
            rTextures[8][i + 1] = new ITexture[]{aTex, Textures.BlockIcons.OVERLAYS_ENERGY_IN[this.mTier]};
            rTextures[9][i + 1] = new ITexture[]{aTex, Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
            rTextures[10][i + 1] = new ITexture[]{aTex, Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
            rTextures[11][i + 1] = new ITexture[]{aTex, Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[Math.min(2, side.ordinal()) + (side == facing ? 3 : 0) + (aActive ? 0 : 6)][aColorIndex + 1];
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_RfConvertor(this.mName, (int)this.mTier, this.mDescription, this.mTextures, this.mInventory.length);
    }

    @Override
    public long getMinimumStoredEU() {
        return 0L;
    }

    @Override
    public long maxEUStore() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long maxEUInput() {
        return 0L;
    }

    @Override
    public long maxEUOutput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxAmperesIn() {
        return 0L;
    }

    @Override
    public boolean isEnetInput() {
        return false;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return !this.isOutputFacing(side);
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (!aBaseMetaTileEntity.isActive()) {
                aBaseMetaTileEntity.setActive(true);
            }
            if (this.getEUVar() < this.maxEUStore()) {
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    if (aBaseMetaTileEntity.getStoredEU() >= aBaseMetaTileEntity.getEUCapacity()) break;
                    if (!this.isInputFacing(side)) continue;
                    this.receiveEnergy(side, Integer.MAX_VALUE, false);
                }
            }
            return;
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getInfoData() {
        String[] infoData = super.getInfoData();
        return new String[]{infoData[0], "Converts RF -> GTEU | Tier: " + this.mTier, infoData[1], infoData[2]};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("mTier", this.mTier);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mTier = aNBT.func_74771_c("mTier");
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            byte aTest = (byte)(this.aCurrentOutputAmperage + 1);
            if (aTest > 16 || aTest <= 0) {
                aTest = 1;
            }
            this.aCurrentOutputAmperage = aTest;
            PlayerUtils.messagePlayer(aPlayer, "Now handling " + this.maxAmperesOut() + " Amps.");
        } else {
            this.mTier = this.mTier < GT_Values.V.length ? (byte)(this.mTier + 1) : (byte)0;
            PlayerUtils.messagePlayer(aPlayer, "Now running at " + GT_Values.VOLTAGE_NAMES[this.mTier] + ".");
        }
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return !this.isOutputFacing(from);
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.canConnectEnergy(from) || this.isOutputFacing(from)) {
            return 0;
        }
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(from);
        if (tTileEntity == null) {
            return 0;
        }
        Logger.WARNING("Someone is trying to inject RF from " + from + ". Type:" + tTileEntity.getClass().getName());
        int aInputRF = MathUtils.safeInt(this.maxEUOutput() * (long)GregTech_API.mEUtoRF / 100L);
        if (aInputRF > maxReceive) {
            aInputRF = maxReceive;
        }
        int aInjectedRF = 0;
        boolean aVal = false;
        long aStoredEU = this.getEUVar();
        long aMaxEU = this.maxEUStore();
        Logger.WARNING("Stored: " + aStoredEU + ", Capacity: " + aMaxEU + "");
        if (aStoredEU < aMaxEU) {
            Logger.WARNING("StoredEU < MaxEU");
            long aRemainingSpace = aMaxEU - aStoredEU;
            if (aRemainingSpace > 0L) {
                long tEU = 0L;
                ForgeDirection toSide = from.getOpposite();
                byte aSide = (byte)from.ordinal();
                Logger.WARNING("Free: " + aRemainingSpace + "EU");
                if (tTileEntity instanceof IEnergyProvider && ((IEnergyProvider)tTileEntity).extractEnergy(toSide, 1, true) == 1) {
                    tEU = ((IEnergyProvider)tTileEntity).extractEnergy(toSide, (int)this.maxEUOutput() * 100 / GregTech_API.mRFtoEU, false);
                    Logger.WARNING("Drained from IEnergyProvider Tile: " + tEU * 100L / (long)GregTech_API.mRFtoEU + "");
                    tEU = tEU * (long)GregTech_API.mRFtoEU / 100L;
                } else if (tTileEntity instanceof IEnergyStorage && ((IEnergyStorage)tTileEntity).extractEnergy(1, true) == 1) {
                    tEU = ((IEnergyStorage)tTileEntity).extractEnergy((int)this.maxEUOutput() * 100 / GregTech_API.mRFtoEU, false);
                    Logger.WARNING("Drained from IEnergyStorage Tile: " + tEU * 100L / (long)GregTech_API.mRFtoEU + "");
                    tEU = tEU * (long)GregTech_API.mRFtoEU / 100L;
                } else if (GregTech_API.meIOLoaded && tTileEntity instanceof IPowerContainer && ((IPowerContainer)tTileEntity).getEnergyStored() > 0) {
                    int storedRF = ((IPowerContainer)tTileEntity).getEnergyStored();
                    int extractRF = (int)this.maxEUOutput() * 100 / GregTech_API.mRFtoEU;
                    tEU = 0L;
                    if (tTileEntity instanceof TileCapBank) {
                        ICapBankNetwork network = ((TileCapBank)tTileEntity).getNetwork();
                        if (network != null && network.getEnergyStoredL() > 0L) {
                            tEU = Math.min(Math.min(Math.min(network.getEnergyStoredL(), (long)(storedRF - extractRF)), (long)network.getMaxOutput()) * (long)GregTech_API.mRFtoEU / 100L, this.maxEUOutput());
                            Logger.WARNING("Drained from EIO CapBank Tile: " + tEU * 100L / (long)GregTech_API.mRFtoEU + "");
                            network.addEnergy((int)(-(tEU * 100L / (long)GregTech_API.mRFtoEU)));
                        }
                    } else if (storedRF > extractRF) {
                        ((IPowerContainer)tTileEntity).setEnergyStored(storedRF - extractRF);
                        tEU = this.maxEUOutput();
                        Logger.WARNING("Drained from EIO Tile: " + tEU * 100L / (long)GregTech_API.mRFtoEU + "");
                    } else {
                        ((IPowerContainer)tTileEntity).setEnergyStored(0);
                        tEU = storedRF * GregTech_API.mRFtoEU / 100;
                        Logger.WARNING("Drained from EIO Tile: " + tEU * 100L / (long)GregTech_API.mRFtoEU + "");
                    }
                }
                Logger.WARNING("EU to inject: " + tEU + "EU");
                if (!simulate) {
                    aVal = this.getBaseMetaTileEntity().increaseStoredEnergyUnits(tEU, true);
                }
                if (tEU > 0L) {
                    Logger.WARNING("Tried injecting " + tEU + " eu into self. Success? " + aVal);
                }
            }
        }
        return aInjectedRF;
    }

    public int getEnergyStored(ForgeDirection from) {
        long aRemainingSpace;
        long aStoredEU = this.getEUVar();
        long aMaxEU = this.maxEUStore();
        if (aStoredEU == 0L) {
            return 0;
        }
        if (aStoredEU < aMaxEU && (aRemainingSpace = aMaxEU - aStoredEU) > 0L && aRemainingSpace > this.maxEUOutput() / (long)(GregTech_API.mEUtoRF / 100)) {
            int aCalculatedFreeSpace = 0;
            int aRfPer10Eu = GregTech_API.mEUtoRF / 10;
            aCalculatedFreeSpace = (int)Math.floor(aRemainingSpace / 10L);
            return Integer.MAX_VALUE - MathUtils.balance(aCalculatedFreeSpace * aRfPer10Eu, 0, Integer.MAX_VALUE);
        }
        return Integer.MAX_VALUE;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return Integer.MAX_VALUE;
    }
}

