/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines.GregtechMetaTileEntity_LargerTurbineBase;
import java.util.Collection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class GT_MetaTileEntity_Hatch_Turbine
extends GT_MetaTileEntity_Hatch {
    public boolean mHasController = false;
    public boolean mUsingAnimation = true;
    private String mControllerLocation;
    public int mEUt = 0;

    public GT_MetaTileEntity_Hatch_Turbine(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 16, "Turbine Rotor holder for XL Turbines", new ITexture[0]);
    }

    public GT_MetaTileEntity_Hatch_Turbine(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch_Turbine(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription[0], aTextures);
    }

    public String[] getDescription() {
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"Right Click with a soldering iron to reset controller link", "Right Click with a wrench to remove turbine", "Right Click with a screwdriver for technical information", "Sneak + Right Click with a wrench to rotate", "Sneak + Right Click with a screwdriver to disable animations", CORE.GT_Tooltip.get()});
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, this.getFrontFacingTurbineTexture()};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, this.getFrontFacingTurbineTexture()};
    }

    public int getEU() {
        return this.mEUt;
    }

    public void setEU(int aEU) {
        this.mEUt = aEU;
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return facing.offsetY == 0;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public boolean hasTurbine() {
        ItemStack aStack = this.mInventory[0];
        boolean aIsValid = GregtechMetaTileEntity_LargerTurbineBase.isValidTurbine(aStack);
        return aIsValid;
    }

    public ItemStack getTurbine() {
        if (this.hasTurbine()) {
            return this.mInventory[0];
        }
        return null;
    }

    public boolean canWork() {
        return this.hasTurbine();
    }

    public boolean insertTurbine(ItemStack aTurbine) {
        if (GregtechMetaTileEntity_LargerTurbineBase.isValidTurbine(aTurbine)) {
            this.mInventory[0] = aTurbine;
            return true;
        }
        return false;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Turbine(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void damageTurbine(int aEUt, int damageFactorLow, float damageFactorHigh) {
        this.damageTurbine((long)aEUt, damageFactorLow, damageFactorHigh);
    }

    public void damageTurbine(long aEUt, int damageFactorLow, float damageFactorHigh) {
        if (this.hasTurbine() && MathUtils.randInt(0, 1) == 0) {
            ItemStack aTurbine = this.getTurbine();
            ((GT_MetaGenerated_Tool)aTurbine.func_77973_b()).doDamage(aTurbine, (long)this.getDamageToComponent(aTurbine) * (long)Math.min((double)((float)aEUt / (float)damageFactorLow), Math.pow(aEUt, damageFactorHigh)));
        }
    }

    private final int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mHasController", this.mHasController);
        aNBT.func_74757_a("mUsingAnimation", this.mUsingAnimation);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mHasController = aNBT.func_74767_n("mHasController");
        this.mUsingAnimation = aNBT.func_74767_n("mUsingAnimation");
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.mHasController) {
            if (aTick % 20L == 0L) {
                if (this.isControllerActive()) {
                    this.getBaseMetaTileEntity().setActive(true);
                } else {
                    this.getBaseMetaTileEntity().setActive(false);
                }
            }
        } else if (this.mHasController || this.mControllerLocation == null || this.setController(BlockPos.generateBlockPos(this.mControllerLocation))) {
            // empty if block
        }
        if (this.mInventory[0] != null && this.mInventory[0].field_77994_a <= 0) {
            this.mInventory[0] = null;
        }
    }

    public boolean isControllerActive() {
        GregtechMetaTileEntity_LargerTurbineBase x = this.getController();
        if (x != null) {
            return x.lEUt > 0L;
        }
        return false;
    }

    public GregtechMetaTileEntity_LargerTurbineBase getController() {
        BlockPos p;
        if (this.mHasController && this.mControllerLocation != null && this.mControllerLocation.length() > 0 && (p = BlockPos.generateBlockPos(this.mControllerLocation)) != null) {
            IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntity(p.xPos, p.yPos, p.zPos);
            if (tTileEntity != null && tTileEntity.getMetaTileEntity() instanceof GregtechMetaTileEntity_LargerTurbineBase) {
                return (GregtechMetaTileEntity_LargerTurbineBase)tTileEntity.getMetaTileEntity();
            }
            if (tTileEntity == null) {
                Logger.INFO("Controller MTE is null, somehow?");
            } else {
                Logger.INFO("Controller is a different MTE to expected");
            }
        }
        return null;
    }

    public boolean canSetNewController() {
        return (this.mControllerLocation == null || this.mControllerLocation.length() <= 0) && !this.mHasController;
    }

    public boolean setController(BlockPos aPos) {
        this.clearController();
        if (this.canSetNewController()) {
            this.mControllerLocation = aPos.getUniqueIdentifier();
            this.mHasController = true;
            Logger.INFO("Successfully injected controller into this Turbine Assembly Hatch.");
        }
        return this.mHasController;
    }

    public void clearController() {
        this.mControllerLocation = null;
        this.mHasController = false;
    }

    public boolean usingAnimations() {
        return this.mUsingAnimation;
    }

    private ITexture getFrontFacingTurbineTexture() {
        if (!this.mHasController) {
            return this.getBaseMetaTileEntity().isActive() ? new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.LARGETURBINE_ST_ACTIVE5) : new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.LARGETURBINE_ST5);
        }
        if (this.usingAnimations() && this.isControllerActive()) {
            return this.getController().frontFaceActive;
        }
        return this.getController().frontFace;
    }

    public long getMinimumStoredEU() {
        return 0L;
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        return false;
    }

    public int[] func_94128_d(int ordinalSide) {
        return new int[0];
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        return false;
    }

    public void setActive(boolean b) {
        this.getBaseMetaTileEntity().setActive(b);
    }

    public boolean allowCoverOnSide(ForgeDirection side, GT_ItemStack aStack) {
        return false;
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!aPlayer.func_70093_af()) {
            PlayerUtils.messagePlayer(aPlayer, "Using Animations? " + this.usingAnimations());
            PlayerUtils.messagePlayer(aPlayer, "Has Controller? " + this.mHasController);
            if (this.mHasController) {
                PlayerUtils.messagePlayer(aPlayer, "Controller Location: " + BlockPos.generateBlockPos(this.mControllerLocation).getLocationString());
                PlayerUtils.messagePlayer(aPlayer, "Controller Active? " + this.isControllerActive());
            }
            PlayerUtils.messagePlayer(aPlayer, "Active? " + this.getBaseMetaTileEntity().isActive());
            PlayerUtils.messagePlayer(aPlayer, "Has Turbine inserted? " + this.hasTurbine());
            if (this.hasTurbine()) {
                Materials aMat = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)this.getTurbine());
                String aSize = GregtechMetaTileEntity_LargerTurbineBase.getTurbineSizeString(GregtechMetaTileEntity_LargerTurbineBase.getTurbineSize(this.getTurbine()));
                PlayerUtils.messagePlayer(aPlayer, "Using: " + aMat.mLocalizedName + " " + aSize);
            }
        } else {
            this.mUsingAnimation = Utils.invertBoolean(this.mUsingAnimation);
            if (this.mUsingAnimation) {
                PlayerUtils.messagePlayer(aPlayer, "Using Animated Turbine Texture.");
            } else {
                PlayerUtils.messagePlayer(aPlayer, "Using Static Turbine Texture.");
            }
        }
    }

    public boolean onWrenchRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        ItemStack tCurrentItem;
        if (this.getBaseMetaTileEntity().isServerSide() && !aPlayer.func_70093_af() && (tCurrentItem = aPlayer.field_71071_by.func_70448_g()) != null && tCurrentItem.func_77973_b() instanceof GT_MetaGenerated_Tool) {
            return this.onToolClick(tCurrentItem, aPlayer, wrenchingSide);
        }
        return super.onWrenchRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ);
    }

    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        ItemStack tCurrentItem;
        if (this.getBaseMetaTileEntity().isServerSide() && (tCurrentItem = aPlayer.field_71071_by.func_70448_g()) != null && tCurrentItem.func_77973_b() instanceof GT_MetaGenerated_Tool) {
            return this.onToolClick(tCurrentItem, aPlayer, wrenchingSide);
        }
        return false;
    }

    public boolean onToolClick(ItemStack tCurrentItem, EntityPlayer aPlayer, ForgeDirection side) {
        if (GT_Utility.isStackInList((ItemStack)tCurrentItem, (Collection)GregTech_API.sWrenchList)) {
            boolean aHasTurbine = this.hasTurbine();
            if (aPlayer.field_71071_by.func_70447_i() >= 0 && aHasTurbine) {
                if (PlayerUtils.isCreative(aPlayer) || GT_ModHandler.damageOrDechargeItem((ItemStack)tCurrentItem, (int)1, (int)1000, (EntityLivingBase)aPlayer)) {
                    aPlayer.field_71071_by.func_70441_a(this.getTurbine());
                    this.mInventory[0] = null;
                    GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Removed turbine with wrench.");
                    return true;
                }
            } else {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(aHasTurbine ? "Cannot remove turbine, no free inventory space." : "No turbine to remove."));
            }
        } else if (GT_Utility.isStackInList((ItemStack)tCurrentItem, (Collection)GregTech_API.sSolderingToolList) && this.mControllerLocation != null && this.mControllerLocation.length() > 0 && this.setController(BlockPos.generateBlockPos(this.mControllerLocation)) && (PlayerUtils.isCreative(aPlayer) || GT_ModHandler.damageOrDechargeItem((ItemStack)tCurrentItem, (int)1, (int)1000, (EntityLivingBase)aPlayer))) {
            String tChat = "Trying to Reset linked Controller";
            IGregTechTileEntity g = this.getBaseMetaTileEntity();
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)tChat);
            GT_Utility.sendSoundToPlayers((World)g.getWorld(), (SoundResource)SoundResource.IC2_TOOLS_RUBBER_TRAMPOLINE, (float)1.0f, (float)-1.0f, (int)g.getXCoord(), (int)g.getYCoord(), (int)g.getZCoord());
            return true;
        }
        return false;
    }

    public boolean useModularUI() {
        return true;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setFilter(GregtechMetaTileEntity_LargerTurbineBase::isValidTurbine).setAccess(false, true).setPos(79, 34));
    }
}

